//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/coregui/Views/SimulationView.h
//! @brief     Defines class SimulationView
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_COREGUI_VIEWS_SIMULATIONVIEW_H
#define BORNAGAIN_GUI_COREGUI_VIEWS_SIMULATIONVIEW_H

#include <QWidget>

class MainWindow;
class SimulationSetupWidget;
class StyledToolBar;

class SimulationView : public QWidget {
    Q_OBJECT

public:
    SimulationView(MainWindow* mainWindow);

protected:
    void showEvent(QShowEvent*);

public slots:
    void onRunSimulationShortcut();

private:
    void updateSimulationViewElements();

    SimulationSetupWidget* m_simulationSetupWidget;
    StyledToolBar* m_toolBar;
};

#endif // BORNAGAIN_GUI_COREGUI_VIEWS_SIMULATIONVIEW_H
