
/**
 * To make a form auto submit, all you have to do is 3 things:
 *
 * ctools_add_js('auto-submit');
 *
 * On gadgets you want to auto-submit when changed, add the ctools-auto-submit
 * class. With FAPI, add:
 * @code
 *  '#attributes' => array('class' => 'ctools-auto-submit'),
 * @endcode
 *
 * If you want to have auto-submit for every form element,
 * add the ctools-auto-submit-full-form to the form. With FAPI, add:
 * @code
 *   '#attributes' => array('class' => 'ctools-auto-submit-full-form'),
 * @endcode
 *
 * Finally, you have to identify which button you want clicked for autosubmit.
 * The behavior of this button will be honored if it's ajaxy or not:
 * @code
 *  '#attributes' => array('class' => 'ctools-use-ajax ctools-auto-submit-click'),
 * @endcode
 *
 * Currently only 'select' and 'textfield' types are supported. We probably
 * could use additional support for radios and checkboxes.
 */

Drupal.behaviors.CToolsAutoSubmit = function() {
  var timeoutID = 0;

  // Bind to any select widgets that will be auto submitted.
  $('select.ctools-auto-submit:not(.ctools-auto-submit-processed),.ctools-auto-submit-full-form select:not(.ctools-auto-submit-processed)')
    .addClass('.ctools-auto-submit-processed')
    .change(function() {
      $(this.form).find('.ctools-auto-submit-click').click();
    });

  // Bind to any textfield widgets that will be auto submitted.
  $('input[type=text].ctools-auto-submit:not(.ctools-auto-submit-processed),.ctools-auto-submit-full-form input[type=text]:not(.ctools-auto-submit-processed)')
    .addClass('.ctools-auto-submit-processed')
    .keyup(function(e) {
      var form = this.form;
      switch (e.keyCode) {
        case 16: // shift
        case 17: // ctrl
        case 18: // alt
        case 20: // caps lock
        case 33: // page up
        case 34: // page down
        case 35: // end
        case 36: // home
        case 37: // left arrow
        case 38: // up arrow
        case 39: // right arrow
        case 40: // down arrow
        case 9:  // tab
        case 13: // enter
        case 27: // esc
          return false;
        default:
          if (!$(form).hasClass('ctools-ajaxing')) {
            if ((timeoutID)) {
              clearTimeout(timeoutID);
            }

            timeoutID = setTimeout(function() { $(form).find('.ctools-auto-submit-click').click(); }, 300);
        }
      }
    });
}
