/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.builder;

import com.claritysys.jvm.builder.ByteArray;
import com.claritysys.jvm.builder.CodeBuilder;
import com.claritysys.jvm.builder.Label;
import com.claritysys.jvm.classfile.CfMethod;
import com.claritysys.jvm.classfile.LocalVariable;

public class CodeBlock {
    protected int startPC;
    protected int endPC;
    protected CodeBuilder codeBuilder;
    protected ByteArray code;
    protected LocalVariable headVar;
    protected Label endLabel;
    protected CodeBlock surroundingBlock;
    protected LocalVariable undeclaredLocals;

    public CodeBlock(CodeBuilder cb) {
        this.setCodeBuilder(cb);
    }

    public void setCodeBuilder(CodeBuilder cb) {
        this.codeBuilder = cb;
        this.code = cb.getByteArray();
    }

    public CfMethod getMethod() {
        return this.codeBuilder.getMethod();
    }

    public CodeBlock getSurroundingBlock() {
        return this.surroundingBlock;
    }

    public void setSurroundingBlock(CodeBlock sb) {
        this.surroundingBlock = sb;
    }

    public Label getEndLabel() {
        if (this.endLabel == null) {
            this.endLabel = new Label(this.code);
        }
        return this.endLabel;
    }

    public void setEndLabel(Label end) {
        if (this.endLabel != null) {
            throw new IllegalStateException("Can't have two end labels!");
        }
        this.endLabel = end;
    }

    public void clearEndLabel() {
        this.endLabel = null;
    }

    public void start() {
        this.startPC = this.code.getPC();
        this.headVar = null;
    }

    public void end() {
        this.endPC = this.code.getPC();
        for (Label lbl = this.endLabel; lbl != null; lbl = lbl.next()) {
            lbl.setPC(this.endPC);
        }
        this.codeBuilder.defineLocals(this.undeclaredLocals, this.endPC);
    }

    public int getStartPC() {
        return this.startPC;
    }

    public int getEndPC() {
        return this.endPC;
    }

    public void addLocal(LocalVariable local) {
        local.setNext(this.undeclaredLocals);
        this.undeclaredLocals = local;
    }
}

