------------------------------------------------------------------------------
--                                                                          --
--                            GNAT2XML COMPONENTS                           --
--                                                                          --
--              G N A T 2 X M L . S T R I P _ C O M M E N T S               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                  Copyright (C) 2012-2013, AdaCore, Inc.                  --
--                                                                          --
-- Gnat2xml is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Gnat2xml is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
-- The gnat2xml tool was derived from the Avatox sources.                   --
------------------------------------------------------------------------------

pragma Ada_2012;

--  Utility for stripping the comments and blank lines out of Ada source code.
--  Useful for comparing code generated by xml2gnat. Reads from standard input
--  and writes to standard output. Switch --keep-blank-lines keeps blank lines.

with Text_IO;          use Text_IO;
with Ada.Command_Line; use Ada.Command_Line;

procedure Gnat2xml.Strip_Comments is
   Keep_Blank_Lines : Boolean;

begin
   if Argument_Count = 0 then
      Keep_Blank_Lines := False;

   elsif Argument_Count = 1 then
      if Argument (1) = "--keep-blank-lines" then
         Keep_Blank_Lines := True;

      else
         raise Program_Error with "unrecognized argument";
      end if;

   else
      raise Program_Error with "too many arguments";
   end if;

   while not End_Of_File loop
      declare
         Line       : constant String := Get_Line;
         J          : Natural         := Line'First;
         Blank_Line : Boolean         := True;

      begin
         loop
            if J > Line'Last then
               if not Blank_Line or else Keep_Blank_Lines then
                  Put_Line (Line);
               end if;
               exit;
            end if;

            if Line (J) = '-' then
               J := J + 1;
               if J > Line'Last or else Line (J) = '-' then
                  --  Found "--", which starts a comment. Print out the
                  --  previous part of the line, and skip to the next line.

                  if not Blank_Line then
                     Put_Line (Line (Line'First .. J - 2));
                  end if;
                  exit;
               end if;
            end if;

            if Line (J) /= ' ' then
               Blank_Line := False;
            end if;

            J := J + 1;
         end loop;
      end;
   end loop;

   Main_Done := True;
end Gnat2xml.Strip_Comments;
