/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 10:21:59 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PushbackReader;
import java.io.StringReader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.BlastM8ComparisonData;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class BlastM8ComparisonData_ESTest extends BlastM8ComparisonData_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      boolean boolean0 = BlastM8ComparisonData.formatCorrect("\"++UK$iLBe]64@");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      // Undeclared exception!
      try { 
        BlastM8ComparisonData.formatCorrect((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      char[] charArray0 = new char[9];
      charArray0[0] = ';';
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0, 0, 2893);
      PushbackReader pushbackReader0 = new PushbackReader(charArrayReader0, 2893);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pushbackReader0);
      BlastM8ComparisonData blastM8ComparisonData0 = null;
      try {
        blastM8ComparisonData0 = new BlastM8ComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // while reading blast -m 8 data: not enough fields in this line: ;\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000
         //
         verifyException("uk.ac.sanger.artemis.BlastM8ComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      BlastM8ComparisonData blastM8ComparisonData0 = null;
      try {
        blastM8ComparisonData0 = new BlastM8ComparisonData((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      BlastM8ComparisonData blastM8ComparisonData0 = null;
      try {
        blastM8ComparisonData0 = new BlastM8ComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      BlastM8ComparisonData blastM8ComparisonData0 = new BlastM8ComparisonData();
      // Undeclared exception!
      try { 
        blastM8ComparisonData0.makeMatchFromString((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.BlastM8ComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      boolean boolean0 = BlastM8ComparisonData.formatCorrect("# TBLASTX 2");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      boolean boolean0 = BlastM8ComparisonData.formatCorrect("# BLASTN 2");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      boolean boolean0 = BlastM8ComparisonData.formatCorrect("#~GiCf7+7,Ao2");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      StringReader stringReader0 = new StringReader("");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      BlastM8ComparisonData blastM8ComparisonData0 = new BlastM8ComparisonData(linePushBackReader0);
      try { 
        blastM8ComparisonData0.makeMatchFromString("ip1@,GXW&<N");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // while reading blast -m 8 data: not enough fields in this line: ip1@,GXW&<N
         //
         verifyException("uk.ac.sanger.artemis.BlastM8ComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      StringReader stringReader0 = new StringReader("");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      BlastM8ComparisonData blastM8ComparisonData0 = new BlastM8ComparisonData(linePushBackReader0);
      AlignMatch alignMatch0 = blastM8ComparisonData0.makeMatchFromString("");
      assertNull(alignMatch0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      StringReader stringReader0 = new StringReader("");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      BlastM8ComparisonData blastM8ComparisonData0 = new BlastM8ComparisonData(linePushBackReader0);
      SimpleComparisonData simpleComparisonData0 = blastM8ComparisonData0.getNewSimpleComparisonData();
      assertNotSame(simpleComparisonData0, blastM8ComparisonData0);
  }
}
