/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_RegisteredPCIProfile.h"
#include "OpenDRIM_RegisteredPCIProfileAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define PCI_OpenDRIM_RegisteredPCIProfileProviderSetInstance PCI_OpenDRIM_RegisteredPCIProfileProviderModifyInstance
#endif

int PCI_OpenDRIM_RegisteredPCIProfile_init(const CMPIBroker* broker);

int PCI_OpenDRIM_RegisteredPCIProfile_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus PCI_OpenDRIM_RegisteredPCIProfileProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = PCI_OpenDRIM_RegisteredPCIProfile_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_RegisteredPCIProfileProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_RegisteredPCIProfile> instances;
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_RegisteredPCIProfile_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = PCI_OpenDRIM_RegisteredPCIProfile_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_RegisteredPCIProfileProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_RegisteredPCIProfile> instances;
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_RegisteredPCIProfile_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = PCI_OpenDRIM_RegisteredPCIProfile_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_RegisteredPCIProfileProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RegisteredPCIProfile instance;
	PCI_OpenDRIM_RegisteredPCIProfile_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_RegisteredPCIProfile_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = PCI_OpenDRIM_RegisteredPCIProfile_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_RegisteredPCIProfileProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RegisteredPCIProfile newInstance, oldInstance;
	PCI_OpenDRIM_RegisteredPCIProfile_toCPP(_broker, ci, newInstance);
	PCI_OpenDRIM_RegisteredPCIProfile_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_RegisteredPCIProfile_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PCI_OpenDRIM_RegisteredPCIProfile_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_RegisteredPCIProfileProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RegisteredPCIProfile instance;
	PCI_OpenDRIM_RegisteredPCIProfile_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_RegisteredPCIProfile_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PCI_OpenDRIM_RegisteredPCIProfile_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PCI_OpenDRIM_RegisteredPCIProfile_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = PCI_OpenDRIM_RegisteredPCIProfile_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_RegisteredPCIProfileProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RegisteredPCIProfile instance;
	PCI_OpenDRIM_RegisteredPCIProfile_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = PCI_OpenDRIM_RegisteredPCIProfile_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PCI_OpenDRIM_RegisteredPCIProfile_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PCI_OpenDRIM_RegisteredPCIProfileProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int PCI_OpenDRIM_RegisteredPCIProfile_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = PCI_OpenDRIM_RegisteredPCIProfile_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "PCI_OpenDRIM_RegisteredPCIProfile_init FAILED: " + (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int PCI_OpenDRIM_RegisteredPCIProfile_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = PCI_OpenDRIM_RegisteredPCIProfile_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "PCI_OpenDRIM_RegisteredPCIProfile_unload FAILED: " + (string) OpenDRIM_RegisteredPCIProfile_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define PCI_OpenDRIM_RegisteredPCIProfile_INIT if (PCI_OpenDRIM_RegisteredPCIProfile_init(_broker) < 0) return NULL

CMInstanceMIStub(PCI_OpenDRIM_RegisteredPCIProfileProvider, PCI_OpenDRIM_RegisteredPCIProfileProvider, _broker, PCI_OpenDRIM_RegisteredPCIProfile_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
