/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_PCIPortGroup.h"

CMPIObjectPath* PCI_OpenDRIM_PCIPortGroup_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_PCIPortGroup& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_PCIPortGroup_classnames[0], OpenDRIM_PCIPortGroup_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* PCI_OpenDRIM_PCIPortGroup_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_PCIPortGroup& instance) {
	_E_;
	Objectpath op(broker, PCI_OpenDRIM_PCIPortGroup_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.Name_isNULL)
		ci.setProperty("Name", instance.Name);

	if (!instance.NameFormat_isNULL)
		ci.setProperty("NameFormat", instance.NameFormat);

	if (!instance.OtherNameFormat_isNULL)
		ci.setProperty("OtherNameFormat", instance.OtherNameFormat);

	if (!instance.BusNumber_isNULL)
		ci.setProperty("BusNumber", instance.BusNumber);

	_L_;
	return ci.getHdl();
}

void PCI_OpenDRIM_PCIPortGroup_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_PCIPortGroup& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void PCI_OpenDRIM_PCIPortGroup_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_PCIPortGroup& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("NameFormat", instance.NameFormat) == OK)
		instance.NameFormat_isNULL = false;

	if (inst.getProperty("OtherNameFormat", instance.OtherNameFormat) == OK)
		instance.OtherNameFormat_isNULL = false;

	if (inst.getProperty("BusNumber", instance.BusNumber) == OK)
		instance.BusNumber_isNULL = false;

	_L_;
}

