/*###############################################################################
# Linux Management Providers (LMP), EthernetPort provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_ETHERNETPORTCAPABILITIESACCESS_H_
#define OPENDRIM_ETHERNETPORTCAPABILITIESACCESS_H_

#include "EthernetPort_Common.h"

#include "OpenDRIM_EthernetPortCapabilities.h"
#include "assocOpenDRIM_EthernetPortCapabilities.h"

int EthernetPort_OpenDRIM_EthernetPortCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_unload(string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_EthernetPortCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_EthernetPortCapabilities& instance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPortCapabilities& newInstance, const OpenDRIM_EthernetPortCapabilities& oldInstance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPortCapabilities& instance, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPortCapabilities& instance, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_EthernetPortCapabilities>& OpenDRIM_EthernetPortCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_EthernetPortCapabilities>& OpenDRIM_EthernetPortCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPortCapabilities_populate(OpenDRIM_EthernetPortCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_ETHERNETPORTCAPABILITIESACCESS_H_*/
