/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class SubexponentialIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;
    private int k = 2;
    private boolean unaryBit = true;

    SubexponentialIntegerCodec(int offset, int k) {
        this.offset = offset;
        this.k = k;
        this.unaryBit = true;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int n;
        int u = 0;
        while (bitInputStream.readBit() == this.unaryBit) {
            ++u;
        }
        if (u == 0) {
            int b = this.k;
            n = bitInputStream.readBits(b);
        } else {
            int b = u + this.k - 1;
            n = 1 << b | bitInputStream.readBits(b);
        }
        return n - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer value) throws IOException {
        int u;
        int b;
        if (value + this.offset < 0) {
            throw new IllegalArgumentException("Value is less then offset: " + value);
        }
        long newValue = value + this.offset;
        if (newValue < 1L << this.k) {
            b = this.k;
            u = 0;
        } else {
            b = (int)(Math.log(newValue) / Math.log(2.0));
            u = b - this.k + 1;
        }
        bitOutputStream.write(this.unaryBit, (long)u);
        bitOutputStream.write(!this.unaryBit);
        bitOutputStream.write(newValue, b);
        return u + 1 + b;
    }

    @Override
    public final long numberOfBits(Integer value) {
        long u;
        long b;
        long newValue = value + this.offset;
        if (newValue < 1L << this.k) {
            b = this.k;
            u = 0L;
        } else {
            b = (long)Math.floor(Math.log(newValue) / Math.log(2.0));
            u = b - (long)this.k + 1L;
        }
        return u + 1L + b;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

