/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;

public class RenamedDataEntryWriter
implements DataEntryWriter {
    private final ClassPool classPool;
    private final Map packagePrefixMap;
    private final DataEntryWriter dataEntryWriter;

    public RenamedDataEntryWriter(ClassPool classPool, Map map, DataEntryWriter dataEntryWriter) {
        this.classPool = classPool;
        this.packagePrefixMap = map;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(this.renamedDataEntry(dataEntry));
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createOutputStream(this.renamedDataEntry(dataEntry));
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter printWriter, String string) {
        this.dataEntryWriter.println(printWriter, string);
    }

    private DataEntry renamedDataEntry(DataEntry dataEntry) {
        String string;
        String string2 = dataEntry.getName();
        for (int i = string2.length() - 1; i > 0; --i) {
            char c = string2.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            string = string2.substring(0, i);
            if (c == '/') break;
            Clazz clazz = this.classPool.getClass(string);
            if (clazz == null) continue;
            String string3 = clazz.getName();
            if (!string.equals(string3)) {
                String string4 = string3 + string2.substring(i);
                return new RenamedDataEntry(dataEntry, string4);
            }
            return dataEntry;
        }
        String string5 = string2;
        do {
            String string6;
            if ((string6 = (String)this.packagePrefixMap.get(string5 = ClassUtil.internalPackagePrefix(string5))) == null) continue;
            if (!string5.equals(string6)) {
                string = string6 + string2.substring(string5.length());
                return new RenamedDataEntry(dataEntry, string);
            }
            return dataEntry;
        } while (string5.length() > 0);
        return dataEntry;
    }
}

