/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAssert
extends GroupAssert<String> {
    protected StringAssert(String actual) {
        super(actual);
    }

    public StringAssert as(String description) {
        this.description(description);
        return this;
    }

    public StringAssert describedAs(String description) {
        return this.as(description);
    }

    public StringAssert as(Description description) {
        this.description(description);
        return this;
    }

    public StringAssert describedAs(Description description) {
        return this.as(description);
    }

    public StringAssert satisfies(Condition<String> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public StringAssert doesNotSatisfy(Condition<String> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public StringAssert is(Condition<String> condition) {
        this.assertIs(condition);
        return this;
    }

    public StringAssert isNot(Condition<String> condition) {
        this.assertIsNot(condition);
        return this;
    }

    @Override
    public void isEmpty() {
        this.isNotNull();
        if (Strings.isEmpty((String)((String)this.actual))) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"expecting empty String but was:", Formatting.inBrackets(this.actual)}));
    }

    @Override
    public final void isNullOrEmpty() {
        if (Strings.isEmpty((String)((String)this.actual))) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"expecting a null or empty String, but was:", Formatting.inBrackets(this.actual)}));
    }

    public StringAssert isNotEmpty() {
        this.isNotNull();
        if (!Strings.isEmpty((String)((String)this.actual))) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"expecting a non-empty String, but it was empty"}));
    }

    public StringAssert isEqualTo(String expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public StringAssert isNotEqualTo(String other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public StringAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public StringAssert isNotSameAs(String other) {
        this.assertNotSameAs(other);
        return this;
    }

    public StringAssert isSameAs(String expected) {
        this.assertSameAs(expected);
        return this;
    }

    public StringAssert hasSize(int expected) {
        int actualSize = this.actualGroupSize();
        if (actualSize == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actualSize), " for String:", this.actual()}));
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((String)this.actual).length();
    }

    public StringAssert contains(String expected) {
        this.isNotNull();
        if (((String)this.actual).indexOf(expected) != -1) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should contain the String:", Formatting.inBrackets(expected)}));
    }

    public StringAssert endsWith(String expected) {
        this.isNotNull();
        if (((String)this.actual).endsWith(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should end with:", Formatting.inBrackets(expected)}));
    }

    public StringAssert startsWith(String expected) {
        this.isNotNull();
        if (((String)this.actual).startsWith(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should start with:", Formatting.inBrackets(expected)}));
    }

    public StringAssert excludes(String s) {
        this.isNotNull();
        if (((String)this.actual).indexOf(s) == -1) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should not contain the String:", Formatting.inBrackets(s)}));
    }

    public StringAssert matches(String regex) {
        this.isNotNull();
        if (((String)this.actual).matches(regex)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should match the regular expression:", Formatting.inBrackets(regex)}));
    }

    public StringAssert doesNotMatch(String regex) {
        this.isNotNull();
        if (!((String)this.actual).matches(regex)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should not match the regular expression:", Formatting.inBrackets(regex)}));
    }

    private String actual() {
        return Formatting.inBrackets(this.actual);
    }

    public StringAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

