/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.policy;

import com.amazonaws.services.auth.identity.cli.policy.Effect;
import com.amazonaws.services.auth.identity.cli.policy.PrincipalProvider;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyBuilder {
    private static final String LEFT_CURLY = "{";
    private static final String RIGHT_CURLY = "}";
    private static final String VERSION = "\"Version\":\"2008-10-17\",";
    private static final String STATEMENT_START = "\"Statement\":[{";
    private static final String EFFECT = "\"Effect\":";
    private static final String PRINCIPAL = "\"Principal\":";
    private static final String ACTION = "\"Action\":";
    private static final String RESOURCE = "\"Resource\":";
    private static final String STATEMENT_END = "}]";
    private static final String SQUARE_LEFT_BRACE = "[";
    private static final String SQUARE_RIGHT_BRACE = "]";
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String STS_ASSUME_ROLE_ACTION = "sts:AssumeRole";

    public static String buildPolicy(Effect effect, List<String> actions, List<String> resources) {
        return PolicyBuilder.buildPolicy(effect, null, null, actions, resources);
    }

    public static String buildAssumeRolePolicy(String service) {
        return PolicyBuilder.buildPolicy(Effect.Allow, PrincipalProvider.Service, Collections.singletonList(service), Collections.singletonList(STS_ASSUME_ROLE_ACTION), null);
    }

    private static String buildPolicy(Effect effect, PrincipalProvider provider, List<String> principals, List<String> actions, List<String> resources) {
        StringBuilder pb = new StringBuilder();
        pb.append(LEFT_CURLY);
        pb.append(VERSION);
        pb.append(STATEMENT_START);
        pb.append(EFFECT).append(PolicyBuilder.wrapWithQuotes(effect.name()));
        if (principals != null && !principals.isEmpty()) {
            pb.append(COMMA).append(PRINCIPAL).append(LEFT_CURLY).append(PolicyBuilder.buildList(DOUBLE_QUOTE + provider.name() + DOUBLE_QUOTE + COLON, principals)).append(RIGHT_CURLY);
        }
        pb.append(COMMA).append(PolicyBuilder.buildList(ACTION, actions));
        if (resources != null && !resources.isEmpty()) {
            pb.append(COMMA).append(PolicyBuilder.buildList(RESOURCE, resources));
        }
        pb.append(STATEMENT_END);
        pb.append(RIGHT_CURLY);
        return pb.toString();
    }

    private static String buildList(String label, List<String> list) {
        StringBuilder sb = new StringBuilder();
        sb.append(label).append(SQUARE_LEFT_BRACE);
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(COMMA);
            }
            sb.append(PolicyBuilder.wrapWithQuotes(list.get(i)));
        }
        sb.append(SQUARE_RIGHT_BRACE);
        return sb.toString();
    }

    private static String wrapWithQuotes(String string) {
        StringBuilder sb = new StringBuilder();
        sb.append(DOUBLE_QUOTE).append(string).append(DOUBLE_QUOTE);
        return sb.toString();
    }
}

