/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserListPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetUserPolicyResult;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserListPoliciesDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserListPoliciesDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserListPoliciesRequest) {
            UserListPoliciesRequest req = (UserListPoliciesRequest)request;
            LOG.debug((Object)("list policies " + req));
            if (req.getPolicyName() == null) {
                LOG.debug((Object)"Listing all policies on an entity");
                ListUserPoliciesRequest listPoliciesRequest = new ListUserPoliciesRequest();
                GetUserPolicyRequest getPolicyRequest = new GetUserPolicyRequest();
                listPoliciesRequest.setUserName(req.getUserName());
                listPoliciesRequest.setMarker(req.getMarker());
                listPoliciesRequest.setMaxItems(req.getMaxItems());
                getPolicyRequest.setUserName(req.getUserName());
                LOG.debug((Object)"Listing policies");
                ListUserPoliciesResult listPoliciesResult = this.getClient().listUserPolicies(listPoliciesRequest);
                for (String policy : listPoliciesResult.getPolicyNames()) {
                    LOG.info((Object)policy);
                    if (!req.isVerbose()) continue;
                    getPolicyRequest.setPolicyName(policy);
                    LOG.debug((Object)"Getting single policy");
                    GetUserPolicyResult getPolicyResult = this.getClient().getUserPolicy(getPolicyRequest);
                    LOG.info((Object)this.urlDecodePolicy(getPolicyResult.getPolicyDocument()));
                }
                LOG.info((Object)("IsTruncated: " + listPoliciesResult.getIsTruncated()));
                if (listPoliciesResult.getIsTruncated().booleanValue()) {
                    LOG.info((Object)("Marker: " + listPoliciesResult.getMarker()));
                }
            } else {
                GetUserPolicyRequest getPolicyRequest = new GetUserPolicyRequest();
                getPolicyRequest.setPolicyName(req.getPolicyName());
                getPolicyRequest.setUserName(req.getUserName());
                LOG.debug((Object)"Getting single policy");
                GetUserPolicyResult getPolicyResult = this.getClient().getUserPolicy(getPolicyRequest);
                LOG.info((Object)this.urlDecodePolicy(getPolicyResult.getPolicyDocument()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

