/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.InstanceProfileCreateRequest;
import com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.GetRoleRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMInstanceProfileCreateDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMInstanceProfileCreateDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof InstanceProfileCreateRequest) {
            String iipPath;
            InstanceProfileCreateRequest createRequest = (InstanceProfileCreateRequest)request;
            LOG.debug((Object)("Creating Instance Profile: " + createRequest));
            if (createRequest.getInstanceProfileName() == null) {
                Utils.exit(1, "no Instance Profile name has been passed in.", null);
            }
            if (createRequest.getRoleName() != null) {
                GetRoleRequest getRoleRequest = new GetRoleRequest();
                getRoleRequest.setRoleName(createRequest.getRoleName());
                this.getClient().getRole(getRoleRequest);
            }
            if ((iipPath = this.verifyPathAndAddSlashSuffix(createRequest.getPath())) == null) {
                iipPath = "/";
            }
            CreateInstanceProfileRequest iipCreateRequest = new CreateInstanceProfileRequest();
            iipCreateRequest.setInstanceProfileName(createRequest.getInstanceProfileName());
            iipCreateRequest.setPath(iipPath);
            CreateInstanceProfileResult iipCreateResult = this.getClient().createInstanceProfile(iipCreateRequest);
            if (createRequest.getRoleName() != null) {
                AddRoleToInstanceProfileRequest roleAddRequest = new AddRoleToInstanceProfileRequest();
                roleAddRequest.setInstanceProfileName(createRequest.getInstanceProfileName());
                roleAddRequest.setRoleName(createRequest.getRoleName());
                this.getClient().addRoleToInstanceProfile(roleAddRequest);
            }
            LOG.info((Object)iipCreateResult.getInstanceProfile().getArn());
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

