/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import com.amazon.aes.webservices.client.EbsSnapshotDescription;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockDeviceMappingDescription {
    private static final Pattern BLOCK_DEVICE_MAPPING_PATTERN = Pattern.compile("^(.*?)=(.*?)(?:\\:(.*?))?(?:\\:(.*?))?(?:\\:(.*?))?(?:\\:(.*?))?");
    private final String deviceName;
    private final Type type;
    private final String virtualName;
    private final EbsSnapshotDescription snapshot;
    private final Integer maxIops;
    private final String volumeType;

    public static BlockDeviceMappingDescription valueOf(String blockDeviceMapping) throws Exception {
        Matcher matcher = BLOCK_DEVICE_MAPPING_PATTERN.matcher(blockDeviceMapping);
        if (!matcher.matches()) {
            throw new Exception("Invalid format; no match found.");
        }
        String deviceName = matcher.group(1).trim();
        String virtualName = matcher.group(2).trim();
        if (virtualName.equalsIgnoreCase("none")) {
            return new BlockDeviceMappingDescription(deviceName, Type.NO_DEVICE);
        }
        if (virtualName.length() == 0 || virtualName.toLowerCase().startsWith("snap")) {
            String snapshotId = null;
            if (matcher.group(2) != null && matcher.group(2).length() > 0) {
                snapshotId = matcher.group(2);
            }
            Integer volumeSize = null;
            if (matcher.group(3) != null && matcher.group(3).length() > 0) {
                volumeSize = Integer.valueOf(matcher.group(3));
            }
            Boolean deleteOnTermination = null;
            if (matcher.group(4) != null && matcher.group(4).length() > 0) {
                deleteOnTermination = Boolean.valueOf(matcher.group(4));
            }
            String ebsType = null;
            if (matcher.group(5) != null && matcher.group(5).length() > 0) {
                ebsType = matcher.group(5);
            }
            Integer maxIops = null;
            if (matcher.group(6) != null && matcher.group(6).length() > 0) {
                if (!ebsType.equals("io1")) {
                    throw new Exception("Invalid format; io1 can only be specified if volume type is iops .");
                }
                maxIops = Integer.valueOf(matcher.group(6));
            }
            return new BlockDeviceMappingDescription(deviceName, Type.EBS, new EbsSnapshotDescription(snapshotId, volumeSize, deleteOnTermination), ebsType, maxIops);
        }
        return new BlockDeviceMappingDescription(deviceName, Type.EPHEMERAL, virtualName);
    }

    public BlockDeviceMappingDescription(String deviceName, Type type) {
        this(deviceName, type, null, null, null, null);
    }

    public BlockDeviceMappingDescription(String deviceName, Type type, String virtualName) {
        this(deviceName, type, virtualName, null, null, null);
    }

    public BlockDeviceMappingDescription(String deviceName, Type type, EbsSnapshotDescription snapshot) {
        this(deviceName, type, null, snapshot, null, null);
    }

    public BlockDeviceMappingDescription(String deviceName, Type type, EbsSnapshotDescription snapshot, String volumeType, Integer maxIops) {
        this(deviceName, type, null, snapshot, volumeType, maxIops);
    }

    protected BlockDeviceMappingDescription(String deviceName, Type type, String virtualName, EbsSnapshotDescription snapshot, String volumeType, Integer maxIops) {
        this.type = type;
        this.deviceName = deviceName;
        this.virtualName = virtualName;
        this.snapshot = snapshot;
        this.volumeType = volumeType;
        this.maxIops = maxIops;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public Type getType() {
        return this.type;
    }

    public String getVolumeType() {
        return this.volumeType;
    }

    public String getVirtualName() {
        return this.virtualName;
    }

    public EbsSnapshotDescription getSnapshot() {
        return this.snapshot;
    }

    public Integer getMaxIops() {
        return this.maxIops;
    }

    public static enum Type {
        EBS,
        EPHEMERAL,
        NO_DEVICE;

    }
}

