/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "et" locale.
 */
public class LocalizedNamesImpl_et extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "US",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "MO",
        "AE",
        "AR",
        "AM",
        "AW",
        "AC",
        "AZ",
        "AU",
        "AT",
        "BS",
        "BH",
        "BD",
        "BB",
        "PW",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "EA",
        "CP",
        "CO",
        "CK",
        "CR",
        "CI",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EC",
        "EE",
        "EG",
        "GQ",
        "SV",
        "ER",
        "ET",
        "EU",
        "FK",
        "FJ",
        "PH",
        "FO",
        "GA",
        "GM",
        "GH",
        "GI",
        "GD",
        "GE",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "CN",
        "ES",
        "NL",
        "AN",
        "HN",
        "HK",
        "HR",
        "TL",
        "IE",
        "IL",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IS",
        "IT",
        "JP",
        "JM",
        "YE",
        "JE",
        "JO",
        "CX",
        "KY",
        "KH",
        "CM",
        "IC",
        "CA",
        "KZ",
        "QA",
        "KE",
        "CF",
        "KI",
        "KM",
        "CG",
        "CD",
        "CC",
        "GR",
        "CU",
        "KW",
        "KG",
        "CY",
        "LA",
        "LT",
        "LS",
        "LR",
        "LI",
        "LB",
        "LY",
        "LU",
        "ZA",
        "GS",
        "KR",
        "LV",
        "EH",
        "MG",
        "MK",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "IM",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NG",
        "NE",
        "NU",
        "NF",
        "NO",
        "QO",
        "OM",
        "PG",
        "PK",
        "PS",
        "PA",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "GF",
        "TF",
        "PF",
        "FR",
        "PR",
        "KP",
        "MP",
        "RE",
        "CV",
        "SE",
        "RO",
        "RW",
        "SB",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "DE",
        "ZM",
        "WS",
        "SM",
        "ST",
        "SA",
        "SC",
        "SN",
        "RS",
        "CS",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "FI",
        "LK",
        "SD",
        "SR",
        "GB",
        "SZ",
        "SJ",
        "SY",
        "CH",
        "ZW",
        "DK",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "CZ",
        "CL",
        "TN",
        "TC",
        "TV",
        "TR",
        "TM",
        "UG",
        "UA",
        "HU",
        "UY",
        "VI",
        "UZ",
        "NC",
        "NZ",
        "BY",
        "WF",
        "VU",
        "VA",
        "RU",
        "VE",
        "VN",
        "UM",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "maailm");
    namesMap.put("002", "Aafrika");
    namesMap.put("003", "Põhja-Ameerika");
    namesMap.put("005", "Lõuna-Ameerika");
    namesMap.put("009", "Okeaania");
    namesMap.put("011", "Lääne-Aafrika");
    namesMap.put("013", "Kesk-Ameerika");
    namesMap.put("014", "Ida-Aafrika");
    namesMap.put("015", "Põhja-Aafrika");
    namesMap.put("017", "Kesk-Aafrika");
    namesMap.put("018", "Lõuna-Aafrika");
    namesMap.put("019", "Ameerika maailmajagu");
    namesMap.put("021", "Ameerika põhjaosa");
    namesMap.put("029", "Kariibi meri");
    namesMap.put("030", "Ida-Aasia");
    namesMap.put("034", "Lõuna-Aasia");
    namesMap.put("035", "Kagu-Aasia");
    namesMap.put("039", "Lõuna-Euroopa");
    namesMap.put("053", "Austraalia ja Uus-Meremaa");
    namesMap.put("054", "Melaneesia");
    namesMap.put("057", "Mikroneesia");
    namesMap.put("061", "Polüneesia");
    namesMap.put("062", "Kesk-Aasia lõunaosa");
    namesMap.put("142", "Aasia");
    namesMap.put("143", "Kesk-Aasia");
    namesMap.put("145", "Lääne-Aasia");
    namesMap.put("150", "Euroopa");
    namesMap.put("151", "Ida-Euroopa");
    namesMap.put("154", "Põhja-Euroopa");
    namesMap.put("155", "Lääne-Euroopa");
    namesMap.put("172", "Sõltumatute Riikide Ühendus");
    namesMap.put("419", "Ladina-Ameerika ja Kariibi meri");
    namesMap.put("AC", "Ascensioni saar");
    namesMap.put("AE", "Araabia Ühendemiraadid");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua ja Barbuda");
    namesMap.put("AL", "Albaania");
    namesMap.put("AM", "Armeenia");
    namesMap.put("AN", "Hollandi Antillid");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AS", "Ameerika Samoa");
    namesMap.put("AU", "Austraalia");
    namesMap.put("AX", "Ahvenamaa");
    namesMap.put("AZ", "Aserbaidžaan");
    namesMap.put("BA", "Bosnia ja Hertsegoviina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BG", "Bulgaaria");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BO", "Boliivia");
    namesMap.put("BR", "Brasiilia");
    namesMap.put("BS", "Bahama");
    namesMap.put("BV", "Bouvet’ saar");
    namesMap.put("BY", "Valgevene");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kookossaared");
    namesMap.put("CD", "Kongo DV");
    namesMap.put("CF", "Kesk-Aafrika Vabariik");
    namesMap.put("CG", "Kongo-Brazzaville");
    namesMap.put("CH", "Šveits");
    namesMap.put("CI", "Côte d'Ivoire");
    namesMap.put("CK", "Cooki saared");
    namesMap.put("CL", "Tšiili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Hiina");
    namesMap.put("CP", "Clippertoni saar");
    namesMap.put("CS", "Serbia ja Montenegro");
    namesMap.put("CU", "Kuuba");
    namesMap.put("CV", "Roheneemesaared");
    namesMap.put("CX", "Jõulusaar");
    namesMap.put("CY", "Küpros");
    namesMap.put("CZ", "Tšehhi");
    namesMap.put("DE", "Saksamaa");
    namesMap.put("DK", "Taani");
    namesMap.put("DO", "Dominikaani Vabariik");
    namesMap.put("DZ", "Alžeeria");
    namesMap.put("EA", "Ceuta ja Melilla");
    namesMap.put("EE", "Eesti");
    namesMap.put("EG", "Egiptus");
    namesMap.put("EH", "Lääne-Sahara");
    namesMap.put("ES", "Hispaania");
    namesMap.put("ET", "Etioopia");
    namesMap.put("EU", "Euroopa Liit");
    namesMap.put("FI", "Soome");
    namesMap.put("FJ", "Fidži");
    namesMap.put("FK", "Falklandi saared");
    namesMap.put("FM", "Mikroneesia Liiduriigid");
    namesMap.put("FO", "Fääri saared");
    namesMap.put("FR", "Prantsusmaa");
    namesMap.put("GB", "Suurbritannia");
    namesMap.put("GE", "Gruusia");
    namesMap.put("GF", "Prantsuse Guajaana");
    namesMap.put("GL", "Gröönimaa");
    namesMap.put("GQ", "Ekvatoriaal-Guinea");
    namesMap.put("GR", "Kreeka");
    namesMap.put("GS", "Lõuna-Georgia ja Lõuna-Sandwichi saared");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "Heard ja McDonald saared");
    namesMap.put("HR", "Horvaatia");
    namesMap.put("HU", "Ungari");
    namesMap.put("IC", "Kanaari saared");
    namesMap.put("ID", "Indoneesia");
    namesMap.put("IE", "Iirimaa");
    namesMap.put("IL", "Iisrael");
    namesMap.put("IM", "Mani saar");
    namesMap.put("IO", "Briti India ookeani ala");
    namesMap.put("IQ", "Iraak");
    namesMap.put("IR", "Iraan");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Itaalia");
    namesMap.put("JO", "Jordaania");
    namesMap.put("JP", "Jaapan");
    namesMap.put("KG", "Kõrgõzstan");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KM", "Komoorid");
    namesMap.put("KN", "Saint Kitts ja Nevis");
    namesMap.put("KP", "Põhja-Korea");
    namesMap.put("KR", "Lõuna-Korea");
    namesMap.put("KW", "Kuveit");
    namesMap.put("KY", "Kaimanisaared");
    namesMap.put("KZ", "Kasahstan");
    namesMap.put("LB", "Liibanon");
    namesMap.put("LR", "Libeeria");
    namesMap.put("LT", "Leedu");
    namesMap.put("LU", "Luksemburg");
    namesMap.put("LV", "Läti");
    namesMap.put("LY", "Liibüa");
    namesMap.put("MA", "Maroko");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshalli saared");
    namesMap.put("MK", "Makedoonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MN", "Mongoolia");
    namesMap.put("MO", "Aomen");
    namesMap.put("MP", "Põhja-Mariaanid");
    namesMap.put("MR", "Mauritaania");
    namesMap.put("MV", "Maldiivid");
    namesMap.put("MX", "Mehhiko");
    namesMap.put("MY", "Malaisia");
    namesMap.put("MZ", "Mosambiik");
    namesMap.put("NA", "Namiibia");
    namesMap.put("NC", "Uus-Kaledoonia");
    namesMap.put("NF", "Norfolk");
    namesMap.put("NG", "Nigeeria");
    namesMap.put("NL", "Holland");
    namesMap.put("NO", "Norra");
    namesMap.put("NZ", "Uus-Meremaa");
    namesMap.put("OM", "Omaan");
    namesMap.put("PE", "Peruu");
    namesMap.put("PF", "Prantsuse Polüneesia");
    namesMap.put("PG", "Paapua Uus-Guinea");
    namesMap.put("PH", "Filipiinid");
    namesMap.put("PL", "Poola");
    namesMap.put("PM", "Saint Pierre ja Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestiina ala");
    namesMap.put("PW", "Belau");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Okeaania hajasaared");
    namesMap.put("RO", "Rumeenia");
    namesMap.put("RU", "Venemaa");
    namesMap.put("SA", "Saudi Araabia");
    namesMap.put("SB", "Saalomoni Saared");
    namesMap.put("SC", "Seišellid");
    namesMap.put("SD", "Sudaan");
    namesMap.put("SE", "Rootsi");
    namesMap.put("SG", "Singapur");
    namesMap.put("SI", "Sloveenia");
    namesMap.put("SJ", "Svalbard ja Jan Mayen");
    namesMap.put("SK", "Slovakkia");
    namesMap.put("SO", "Somaalia");
    namesMap.put("ST", "São Tomé ja Príncipe");
    namesMap.put("SY", "Süüria");
    namesMap.put("SZ", "Svaasimaa");
    namesMap.put("TC", "Turks ja Caicos");
    namesMap.put("TD", "Tšaad");
    namesMap.put("TF", "Prantsuse Lõunaalad");
    namesMap.put("TH", "Tai");
    namesMap.put("TJ", "Tadžikistan");
    namesMap.put("TL", "Ida-Timor");
    namesMap.put("TM", "Türkmenistan");
    namesMap.put("TN", "Tuneesia");
    namesMap.put("TR", "Türgi");
    namesMap.put("TT", "Trinidad ja Tobago");
    namesMap.put("TZ", "Tansaania");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Ühendriikide hajasaared");
    namesMap.put("US", "Ameerika Ühendriigid");
    namesMap.put("UZ", "Usbekistan");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Saint Vincent ja Grenadiinid");
    namesMap.put("VG", "Briti Neitsisaared");
    namesMap.put("VI", "USA Neitsisaared");
    namesMap.put("WF", "Wallis ja Futuna");
    namesMap.put("YE", "Jeemen");
    namesMap.put("ZA", "Lõuna-Aafrika Vabariik");
    namesMap.put("ZM", "Sambia");
    namesMap.put("ZZ", "määramata");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "maailm",
        "002": "Aafrika",
        "003": "Põhja-Ameerika",
        "005": "Lõuna-Ameerika",
        "009": "Okeaania",
        "011": "Lääne-Aafrika",
        "013": "Kesk-Ameerika",
        "014": "Ida-Aafrika",
        "015": "Põhja-Aafrika",
        "017": "Kesk-Aafrika",
        "018": "Lõuna-Aafrika",
        "019": "Ameerika maailmajagu",
        "021": "Ameerika põhjaosa",
        "029": "Kariibi meri",
        "030": "Ida-Aasia",
        "034": "Lõuna-Aasia",
        "035": "Kagu-Aasia",
        "039": "Lõuna-Euroopa",
        "053": "Austraalia ja Uus-Meremaa",
        "054": "Melaneesia",
        "057": "Mikroneesia",
        "061": "Polüneesia",
        "062": "Kesk-Aasia lõunaosa",
        "142": "Aasia",
        "143": "Kesk-Aasia",
        "145": "Lääne-Aasia",
        "150": "Euroopa",
        "151": "Ida-Euroopa",
        "154": "Põhja-Euroopa",
        "155": "Lääne-Euroopa",
        "172": "Sõltumatute Riikide Ühendus",
        "419": "Ladina-Ameerika ja Kariibi meri",
        "AC": "Ascensioni saar",
        "AE": "Araabia Ühendemiraadid",
        "AF": "Afganistan",
        "AG": "Antigua ja Barbuda",
        "AL": "Albaania",
        "AM": "Armeenia",
        "AN": "Hollandi Antillid",
        "AQ": "Antarktis",
        "AS": "Ameerika Samoa",
        "AU": "Austraalia",
        "AX": "Ahvenamaa",
        "AZ": "Aserbaidžaan",
        "BA": "Bosnia ja Hertsegoviina",
        "BE": "Belgia",
        "BG": "Bulgaaria",
        "BH": "Bahrein",
        "BO": "Boliivia",
        "BR": "Brasiilia",
        "BS": "Bahama",
        "BV": "Bouvet’ saar",
        "BY": "Valgevene",
        "CA": "Kanada",
        "CC": "Kookossaared",
        "CD": "Kongo DV",
        "CF": "Kesk-Aafrika Vabariik",
        "CG": "Kongo-Brazzaville",
        "CH": "Šveits",
        "CI": "Côte d'Ivoire",
        "CK": "Cooki saared",
        "CL": "Tšiili",
        "CM": "Kamerun",
        "CN": "Hiina",
        "CP": "Clippertoni saar",
        "CS": "Serbia ja Montenegro",
        "CU": "Kuuba",
        "CV": "Roheneemesaared",
        "CX": "Jõulusaar",
        "CY": "Küpros",
        "CZ": "Tšehhi",
        "DE": "Saksamaa",
        "DK": "Taani",
        "DO": "Dominikaani Vabariik",
        "DZ": "Alžeeria",
        "EA": "Ceuta ja Melilla",
        "EE": "Eesti",
        "EG": "Egiptus",
        "EH": "Lääne-Sahara",
        "ES": "Hispaania",
        "ET": "Etioopia",
        "EU": "Euroopa Liit",
        "FI": "Soome",
        "FJ": "Fidži",
        "FK": "Falklandi saared",
        "FM": "Mikroneesia Liiduriigid",
        "FO": "Fääri saared",
        "FR": "Prantsusmaa",
        "GB": "Suurbritannia",
        "GE": "Gruusia",
        "GF": "Prantsuse Guajaana",
        "GL": "Gröönimaa",
        "GQ": "Ekvatoriaal-Guinea",
        "GR": "Kreeka",
        "GS": "Lõuna-Georgia ja Lõuna-Sandwichi saared",
        "HK": "Hongkong",
        "HM": "Heard ja McDonald saared",
        "HR": "Horvaatia",
        "HU": "Ungari",
        "IC": "Kanaari saared",
        "ID": "Indoneesia",
        "IE": "Iirimaa",
        "IL": "Iisrael",
        "IM": "Mani saar",
        "IO": "Briti India ookeani ala",
        "IQ": "Iraak",
        "IR": "Iraan",
        "IS": "Island",
        "IT": "Itaalia",
        "JO": "Jordaania",
        "JP": "Jaapan",
        "KG": "Kõrgõzstan",
        "KH": "Kambodža",
        "KM": "Komoorid",
        "KN": "Saint Kitts ja Nevis",
        "KP": "Põhja-Korea",
        "KR": "Lõuna-Korea",
        "KW": "Kuveit",
        "KY": "Kaimanisaared",
        "KZ": "Kasahstan",
        "LB": "Liibanon",
        "LR": "Libeeria",
        "LT": "Leedu",
        "LU": "Luksemburg",
        "LV": "Läti",
        "LY": "Liibüa",
        "MA": "Maroko",
        "MG": "Madagaskar",
        "MH": "Marshalli saared",
        "MK": "Makedoonia",
        "MM": "Myanmar",
        "MN": "Mongoolia",
        "MO": "Aomen",
        "MP": "Põhja-Mariaanid",
        "MR": "Mauritaania",
        "MV": "Maldiivid",
        "MX": "Mehhiko",
        "MY": "Malaisia",
        "MZ": "Mosambiik",
        "NA": "Namiibia",
        "NC": "Uus-Kaledoonia",
        "NF": "Norfolk",
        "NG": "Nigeeria",
        "NL": "Holland",
        "NO": "Norra",
        "NZ": "Uus-Meremaa",
        "OM": "Omaan",
        "PE": "Peruu",
        "PF": "Prantsuse Polüneesia",
        "PG": "Paapua Uus-Guinea",
        "PH": "Filipiinid",
        "PL": "Poola",
        "PM": "Saint Pierre ja Miquelon",
        "PN": "Pitcairn",
        "PS": "Palestiina ala",
        "PW": "Belau",
        "QA": "Katar",
        "QO": "Okeaania hajasaared",
        "RO": "Rumeenia",
        "RU": "Venemaa",
        "SA": "Saudi Araabia",
        "SB": "Saalomoni Saared",
        "SC": "Seišellid",
        "SD": "Sudaan",
        "SE": "Rootsi",
        "SG": "Singapur",
        "SI": "Sloveenia",
        "SJ": "Svalbard ja Jan Mayen",
        "SK": "Slovakkia",
        "SO": "Somaalia",
        "ST": "São Tomé ja Príncipe",
        "SY": "Süüria",
        "SZ": "Svaasimaa",
        "TC": "Turks ja Caicos",
        "TD": "Tšaad",
        "TF": "Prantsuse Lõunaalad",
        "TH": "Tai",
        "TJ": "Tadžikistan",
        "TL": "Ida-Timor",
        "TM": "Türkmenistan",
        "TN": "Tuneesia",
        "TR": "Türgi",
        "TT": "Trinidad ja Tobago",
        "TZ": "Tansaania",
        "UA": "Ukraina",
        "UM": "Ühendriikide hajasaared",
        "US": "Ameerika Ühendriigid",
        "UZ": "Usbekistan",
        "VA": "Vatikan",
        "VC": "Saint Vincent ja Grenadiinid",
        "VG": "Briti Neitsisaared",
        "VI": "USA Neitsisaared",
        "WF": "Wallis ja Futuna",
        "YE": "Jeemen",
        "ZA": "Lõuna-Aafrika Vabariik",
        "ZM": "Sambia",
        "ZZ": "määramata"
    };
  }-*/;
}
