/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "gsw" locale.
 */
public class LocalizedNamesImpl_gsw extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "CH",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AX",
        "AF",
        "EG",
        "AL",
        "DZ",
        "VI",
        "AS",
        "UM",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "GQ",
        "AR",
        "ER",
        "AM",
        "AW",
        "AC",
        "AZ",
        "AU",
        "ET",
        "BH",
        "BS",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "VG",
        "IO",
        "BN",
        "BG",
        "BF",
        "BI",
        "IC",
        "EA",
        "CN",
        "CP",
        "CK",
        "CR",
        "KP",
        "DG",
        "JM",
        "JE",
        "EC",
        "EE",
        "CI",
        "SV",
        "EU",
        "FK",
        "FO",
        "FI",
        "FJ",
        "FR",
        "GF",
        "TF",
        "PF",
        "GH",
        "GG",
        "GA",
        "GM",
        "GE",
        "QA",
        "GI",
        "GN",
        "GW",
        "GD",
        "GR",
        "GL",
        "GP",
        "GY",
        "GU",
        "GT",
        "HT",
        "HN",
        "HK",
        "HM",
        "IS",
        "IN",
        "ID",
        "IM",
        "IQ",
        "IR",
        "IE",
        "IL",
        "IT",
        "JP",
        "YE",
        "JO",
        "KY",
        "KH",
        "CM",
        "CA",
        "CV",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "HR",
        "CU",
        "KW",
        "LA",
        "LS",
        "LV",
        "LI",
        "LB",
        "LR",
        "LT",
        "LY",
        "LU",
        "ML",
        "MO",
        "MG",
        "YT",
        "MW",
        "MY",
        "MV",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "MK",
        "MX",
        "FM",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NL",
        "AN",
        "NG",
        "NE",
        "NU",
        "NC",
        "NZ",
        "MP",
        "NF",
        "NO",
        "OM",
        "AT",
        "TL",
        "PK",
        "PS",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "KR",
        "MD",
        "RE",
        "RW",
        "RO",
        "RU",
        "SB",
        "ZM",
        "WS",
        "LC",
        "VC",
        "SM",
        "ST",
        "RS",
        "CS",
        "SA",
        "ES",
        "LK",
        "SE",
        "CH",
        "SC",
        "SN",
        "SL",
        "ZW",
        "SG",
        "SK",
        "SI",
        "SO",
        "BL",
        "SH",
        "KN",
        "MF",
        "PM",
        "SD",
        "SR",
        "ZA",
        "GS",
        "SY",
        "SJ",
        "SZ",
        "TJ",
        "TW",
        "DK",
        "TZ",
        "CD",
        "TH",
        "TK",
        "DM",
        "DO",
        "TO",
        "TG",
        "TC",
        "TT",
        "TA",
        "TD",
        "CZ",
        "DJ",
        "CL",
        "CY",
        "TN",
        "TR",
        "TM",
        "DE",
        "TV",
        "UG",
        "UA",
        "HU",
        "UY",
        "UZ",
        "QO",
        "VA",
        "VE",
        "AE",
        "US",
        "GB",
        "WF",
        "VU",
        "EH",
        "CX",
        "VN",
        "BY",
        "CF",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Wält");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Nordameerika");
    namesMap.put("005", "Süüdameerika");
    namesMap.put("009", "Ozeaanie");
    namesMap.put("011", "Weschtafrika");
    namesMap.put("013", "Mittelameerika");
    namesMap.put("014", "Oschtafrika");
    namesMap.put("015", "Nordafrika");
    namesMap.put("017", "Zentraalafrika");
    namesMap.put("018", "Süüdlichs Afrika");
    namesMap.put("019", "Nord-, Mittel- und Süüdameerika");
    namesMap.put("021", "Nördlichs Ameerika");
    namesMap.put("029", "Karibik");
    namesMap.put("030", "Oschtaasie");
    namesMap.put("034", "Süüdaasie");
    namesMap.put("035", "Süüdoschtaasie");
    namesMap.put("039", "Süüdeuropa");
    namesMap.put("053", "Auschtraalie und Nöiseeland");
    namesMap.put("054", "Melaneesie");
    namesMap.put("057", "Mikroneesischs Inselgebiet");
    namesMap.put("061", "Polineesie");
    namesMap.put("062", "Süüd-Zentraalaasie");
    namesMap.put("142", "Aasie");
    namesMap.put("143", "Zentraalaasie");
    namesMap.put("145", "Weschtaasie");
    namesMap.put("150", "Euroopa");
    namesMap.put("151", "Oschteuroopa");
    namesMap.put("154", "Nordeuroopa");
    namesMap.put("155", "Weschteuroopa");
    namesMap.put("172", "Gmäinschaft vo Unabhängige Schtaate");
    namesMap.put("419", "Latiinameerika und Karibik");
    namesMap.put("830", "Kanaalinsle");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Veräinigti Arabischi Emiräät");
    namesMap.put("AF", "Afganischtan");
    namesMap.put("AG", "Antigua und Barbuda");
    namesMap.put("AL", "Albaanie");
    namesMap.put("AM", "Armeenie");
    namesMap.put("AN", "Niderländischi Antille");
    namesMap.put("AO", "Angoola");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AR", "Argentiinie");
    namesMap.put("AS", "Amerikaanisch-Samoa");
    namesMap.put("AT", "Ööschtriich");
    namesMap.put("AU", "Auschtraalie");
    namesMap.put("AX", "Aaland-Insle");
    namesMap.put("AZ", "Aserbäidschan");
    namesMap.put("BA", "Bosnie und Herzegowina");
    namesMap.put("BD", "Bangladesch");
    namesMap.put("BE", "Belgie");
    namesMap.put("BF", "Burkina Faaso");
    namesMap.put("BG", "Bulgaarie");
    namesMap.put("BH", "Bachräin");
    namesMap.put("BL", "St. Barthelemi");
    namesMap.put("BM", "Bermuuda");
    namesMap.put("BN", "Brunäi Tarussalam");
    namesMap.put("BO", "Boliivie");
    namesMap.put("BR", "Brasilie");
    namesMap.put("BS", "Bahaamas");
    namesMap.put("BV", "Bouvet-Insle");
    namesMap.put("BY", "Wiissrussland");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokos-Insle");
    namesMap.put("CD", "Temokraatischi Republik Kongo");
    namesMap.put("CF", "Zentraalafrikaanischi Republik");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Schwiiz");
    namesMap.put("CI", "Elfebäiküschte");
    namesMap.put("CK", "Cook-Insle");
    namesMap.put("CL", "Tschile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Chiina");
    namesMap.put("CO", "Kolumbie");
    namesMap.put("CP", "Clipperton");
    namesMap.put("CR", "Coschta Rica");
    namesMap.put("CS", "Särbie und Monteneegro");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kap Verde");
    namesMap.put("CX", "Wienachts-Insle");
    namesMap.put("CY", "Tsüpere");
    namesMap.put("CZ", "Tschechischi Republik");
    namesMap.put("DE", "Tüütschland");
    namesMap.put("DJ", "Tschibuuti");
    namesMap.put("DK", "Tänemark");
    namesMap.put("DM", "Tominica");
    namesMap.put("DO", "Tominikaanischi Republik");
    namesMap.put("DZ", "Algeerie");
    namesMap.put("EA", "Ceuta und Melilla");
    namesMap.put("EE", "Eestland");
    namesMap.put("EG", "Ägüpte");
    namesMap.put("EH", "Weschtsahara");
    namesMap.put("ER", "Äritreea");
    namesMap.put("ES", "Schpanie");
    namesMap.put("ET", "Äzioopie");
    namesMap.put("EU", "Europääischi Unioon");
    namesMap.put("FI", "Finnland");
    namesMap.put("FJ", "Fitschi");
    namesMap.put("FK", "Falkland-Insle");
    namesMap.put("FM", "Mikroneesie");
    namesMap.put("FO", "Färöer");
    namesMap.put("FR", "Frankriich");
    namesMap.put("GA", "Gabun");
    namesMap.put("GB", "Veräinigts Chönigriich");
    namesMap.put("GE", "Geoorgie");
    namesMap.put("GF", "Französisch-Guäjaana");
    namesMap.put("GG", "Gäärnsi");
    namesMap.put("GH", "Gaana");
    namesMap.put("GL", "Gröönland");
    namesMap.put("GN", "Gineea");
    namesMap.put("GP", "Guadälup");
    namesMap.put("GQ", "Äquatoriaalgineea");
    namesMap.put("GR", "Griecheland");
    namesMap.put("GS", "Süüdgeorgie und d’süüdlichi Sändwitsch-Insle");
    namesMap.put("GT", "Guatemaala");
    namesMap.put("GW", "Gineea-Bissau");
    namesMap.put("GY", "Guäjaana");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "Höörd- und MäcDonald-Insle");
    namesMap.put("HR", "Kroaazie");
    namesMap.put("HU", "Ungarn");
    namesMap.put("IC", "Canarische Eilanden");
    namesMap.put("ID", "Indoneesie");
    namesMap.put("IE", "Irland");
    namesMap.put("IM", "Insle vo Män");
    namesMap.put("IN", "Indie");
    namesMap.put("IO", "Britischs Territoorium im Indische Oozean");
    namesMap.put("IQ", "Iraak");
    namesMap.put("IR", "Iraan");
    namesMap.put("IS", "Iisland");
    namesMap.put("IT", "Itaalie");
    namesMap.put("JE", "Dschörsi");
    namesMap.put("JM", "Dschamäika");
    namesMap.put("JO", "Jordaanie");
    namesMap.put("KE", "Keenia");
    namesMap.put("KG", "Kirgiisischtan");
    namesMap.put("KH", "Kambodscha");
    namesMap.put("KI", "Kiribaati");
    namesMap.put("KM", "Komoore");
    namesMap.put("KN", "St. Kitts und Niuwis");
    namesMap.put("KP", "Demokraatischi Volksrepublik Koreea");
    namesMap.put("KR", "Republik Koreea");
    namesMap.put("KW", "Kuwäit");
    namesMap.put("KY", "Käimän-Insle");
    namesMap.put("KZ", "Kasachschtan");
    namesMap.put("LA", "Laaos");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "Sankta Lutschiia");
    namesMap.put("LI", "Liächteschtäi");
    namesMap.put("LK", "Schri Lanka");
    namesMap.put("LR", "Libeeria");
    namesMap.put("LS", "Lesooto");
    namesMap.put("LT", "Littaue");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("LV", "Lettland");
    namesMap.put("LY", "Lüübie");
    namesMap.put("MA", "Marokko");
    namesMap.put("MD", "Republik Moldau");
    namesMap.put("ME", "Monteneegro");
    namesMap.put("MF", "St. Martin");
    namesMap.put("MG", "Madagaschkar");
    namesMap.put("MH", "Marshallinsle");
    namesMap.put("MK", "Mazedoonie");
    namesMap.put("ML", "Maali");
    namesMap.put("MM", "Müanmar");
    namesMap.put("MN", "Mongolei");
    namesMap.put("MO", "Macao");
    namesMap.put("MP", "Nördlichi Mariaane");
    namesMap.put("MQ", "Martinigg");
    namesMap.put("MR", "Mauretaanie");
    namesMap.put("MS", "Moosörrat");
    namesMap.put("MU", "Mauriizius");
    namesMap.put("MV", "Malediiwe");
    namesMap.put("MW", "Malaawi");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MY", "Malaisia");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NA", "Namiibia");
    namesMap.put("NC", "Nöikaledoonie");
    namesMap.put("NF", "Norfolk-Insle");
    namesMap.put("NG", "Nigeeria");
    namesMap.put("NI", "Nicaraagua");
    namesMap.put("NL", "Niderland");
    namesMap.put("NO", "Norweege");
    namesMap.put("NP", "Neepal");
    namesMap.put("NZ", "Nöiseeland");
    namesMap.put("OM", "Omaan");
    namesMap.put("PF", "Französisch-Polineesie");
    namesMap.put("PG", "Papua-Neuguinea");
    namesMap.put("PH", "Philippiine");
    namesMap.put("PK", "Pakischtan");
    namesMap.put("PL", "Poole");
    namesMap.put("PM", "St. Pierr und Miggelo");
    namesMap.put("PN", "Pitggäärn");
    namesMap.put("PR", "Puerto Riggo");
    namesMap.put("PS", "Paläschtinänsischi Gebiet");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QA", "Ggatar");
    namesMap.put("QO", "Üssers Ozeaanie");
    namesMap.put("RE", "Reünioon");
    namesMap.put("RO", "Rumäänie");
    namesMap.put("RS", "Särbie");
    namesMap.put("RU", "Russischi Föderazioon");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudi-Araabie");
    namesMap.put("SB", "Salomoone");
    namesMap.put("SC", "Seischälle");
    namesMap.put("SE", "Schweede");
    namesMap.put("SG", "Singapuur");
    namesMap.put("SH", "St. Helena");
    namesMap.put("SI", "Sloweenie");
    namesMap.put("SJ", "Svalbard und Jaan Määie");
    namesMap.put("SK", "Slowakäi");
    namesMap.put("SL", "Sierra Leoone");
    namesMap.put("SM", "San Mariino");
    namesMap.put("SO", "Somaalia");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sao Tome und Prinssipe");
    namesMap.put("SY", "Süürie");
    namesMap.put("SZ", "Swasiland");
    namesMap.put("TC", "Törks- und Gaiggos-Insle");
    namesMap.put("TD", "Tschad");
    namesMap.put("TF", "Französischi Süüd- und Antarktisgebiet");
    namesMap.put("TG", "Toogo");
    namesMap.put("TJ", "Tadschikischtan");
    namesMap.put("TL", "Oschttimor");
    namesMap.put("TM", "Turkmeenischtan");
    namesMap.put("TN", "Tuneesie");
    namesMap.put("TR", "Türggei");
    namesMap.put("TT", "Trinidad und Tobaago");
    namesMap.put("TZ", "Tansaniia");
    namesMap.put("UA", "Ukraiine");
    namesMap.put("UM", "Amerikanisch-Ozeaanie");
    namesMap.put("US", "Veräinigti Schtaate");
    namesMap.put("UZ", "Uschbeekischtan");
    namesMap.put("VA", "Vatikanstadt");
    namesMap.put("VC", "Sankt Wässä und d’Grönadiine");
    namesMap.put("VE", "Venezueela");
    namesMap.put("VG", "Britischi Jungfere-Insle");
    namesMap.put("VI", "Amerikaanischi Jungfere-Insle");
    namesMap.put("VN", "Wietnam");
    namesMap.put("VU", "Wanuatu");
    namesMap.put("WF", "Wallis und Futuuna");
    namesMap.put("WS", "Samooa");
    namesMap.put("YE", "Jeeme");
    namesMap.put("YT", "Majott");
    namesMap.put("ZA", "Süüdafrika");
    namesMap.put("ZM", "Sambia");
    namesMap.put("ZW", "Simbabwe");
    namesMap.put("ZZ", "Unbekannti oder ungültigi Regioon");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Wält",
        "002": "Afrika",
        "003": "Nordameerika",
        "005": "Süüdameerika",
        "009": "Ozeaanie",
        "011": "Weschtafrika",
        "013": "Mittelameerika",
        "014": "Oschtafrika",
        "015": "Nordafrika",
        "017": "Zentraalafrika",
        "018": "Süüdlichs Afrika",
        "019": "Nord-, Mittel- und Süüdameerika",
        "021": "Nördlichs Ameerika",
        "029": "Karibik",
        "030": "Oschtaasie",
        "034": "Süüdaasie",
        "035": "Süüdoschtaasie",
        "039": "Süüdeuropa",
        "053": "Auschtraalie und Nöiseeland",
        "054": "Melaneesie",
        "057": "Mikroneesischs Inselgebiet",
        "061": "Polineesie",
        "062": "Süüd-Zentraalaasie",
        "142": "Aasie",
        "143": "Zentraalaasie",
        "145": "Weschtaasie",
        "150": "Euroopa",
        "151": "Oschteuroopa",
        "154": "Nordeuroopa",
        "155": "Weschteuroopa",
        "172": "Gmäinschaft vo Unabhängige Schtaate",
        "419": "Latiinameerika und Karibik",
        "830": "Kanaalinsle",
        "AC": "Ascension",
        "AE": "Veräinigti Arabischi Emiräät",
        "AF": "Afganischtan",
        "AG": "Antigua und Barbuda",
        "AL": "Albaanie",
        "AM": "Armeenie",
        "AN": "Niderländischi Antille",
        "AO": "Angoola",
        "AQ": "Antarktis",
        "AR": "Argentiinie",
        "AS": "Amerikaanisch-Samoa",
        "AT": "Ööschtriich",
        "AU": "Auschtraalie",
        "AX": "Aaland-Insle",
        "AZ": "Aserbäidschan",
        "BA": "Bosnie und Herzegowina",
        "BD": "Bangladesch",
        "BE": "Belgie",
        "BF": "Burkina Faaso",
        "BG": "Bulgaarie",
        "BH": "Bachräin",
        "BL": "St. Barthelemi",
        "BM": "Bermuuda",
        "BN": "Brunäi Tarussalam",
        "BO": "Boliivie",
        "BR": "Brasilie",
        "BS": "Bahaamas",
        "BV": "Bouvet-Insle",
        "BY": "Wiissrussland",
        "CA": "Kanada",
        "CC": "Kokos-Insle",
        "CD": "Temokraatischi Republik Kongo",
        "CF": "Zentraalafrikaanischi Republik",
        "CG": "Kongo",
        "CH": "Schwiiz",
        "CI": "Elfebäiküschte",
        "CK": "Cook-Insle",
        "CL": "Tschile",
        "CM": "Kamerun",
        "CN": "Chiina",
        "CO": "Kolumbie",
        "CP": "Clipperton",
        "CR": "Coschta Rica",
        "CS": "Särbie und Monteneegro",
        "CU": "Kuba",
        "CV": "Kap Verde",
        "CX": "Wienachts-Insle",
        "CY": "Tsüpere",
        "CZ": "Tschechischi Republik",
        "DE": "Tüütschland",
        "DJ": "Tschibuuti",
        "DK": "Tänemark",
        "DM": "Tominica",
        "DO": "Tominikaanischi Republik",
        "DZ": "Algeerie",
        "EA": "Ceuta und Melilla",
        "EE": "Eestland",
        "EG": "Ägüpte",
        "EH": "Weschtsahara",
        "ER": "Äritreea",
        "ES": "Schpanie",
        "ET": "Äzioopie",
        "EU": "Europääischi Unioon",
        "FI": "Finnland",
        "FJ": "Fitschi",
        "FK": "Falkland-Insle",
        "FM": "Mikroneesie",
        "FO": "Färöer",
        "FR": "Frankriich",
        "GA": "Gabun",
        "GB": "Veräinigts Chönigriich",
        "GE": "Geoorgie",
        "GF": "Französisch-Guäjaana",
        "GG": "Gäärnsi",
        "GH": "Gaana",
        "GL": "Gröönland",
        "GN": "Gineea",
        "GP": "Guadälup",
        "GQ": "Äquatoriaalgineea",
        "GR": "Griecheland",
        "GS": "Süüdgeorgie und d’süüdlichi Sändwitsch-Insle",
        "GT": "Guatemaala",
        "GW": "Gineea-Bissau",
        "GY": "Guäjaana",
        "HK": "Hongkong",
        "HM": "Höörd- und MäcDonald-Insle",
        "HR": "Kroaazie",
        "HU": "Ungarn",
        "IC": "Canarische Eilanden",
        "ID": "Indoneesie",
        "IE": "Irland",
        "IM": "Insle vo Män",
        "IN": "Indie",
        "IO": "Britischs Territoorium im Indische Oozean",
        "IQ": "Iraak",
        "IR": "Iraan",
        "IS": "Iisland",
        "IT": "Itaalie",
        "JE": "Dschörsi",
        "JM": "Dschamäika",
        "JO": "Jordaanie",
        "KE": "Keenia",
        "KG": "Kirgiisischtan",
        "KH": "Kambodscha",
        "KI": "Kiribaati",
        "KM": "Komoore",
        "KN": "St. Kitts und Niuwis",
        "KP": "Demokraatischi Volksrepublik Koreea",
        "KR": "Republik Koreea",
        "KW": "Kuwäit",
        "KY": "Käimän-Insle",
        "KZ": "Kasachschtan",
        "LA": "Laaos",
        "LB": "Libanon",
        "LC": "Sankta Lutschiia",
        "LI": "Liächteschtäi",
        "LK": "Schri Lanka",
        "LR": "Libeeria",
        "LS": "Lesooto",
        "LT": "Littaue",
        "LU": "Luxemburg",
        "LV": "Lettland",
        "LY": "Lüübie",
        "MA": "Marokko",
        "MD": "Republik Moldau",
        "ME": "Monteneegro",
        "MF": "St. Martin",
        "MG": "Madagaschkar",
        "MH": "Marshallinsle",
        "MK": "Mazedoonie",
        "ML": "Maali",
        "MM": "Müanmar",
        "MN": "Mongolei",
        "MO": "Macao",
        "MP": "Nördlichi Mariaane",
        "MQ": "Martinigg",
        "MR": "Mauretaanie",
        "MS": "Moosörrat",
        "MU": "Mauriizius",
        "MV": "Malediiwe",
        "MW": "Malaawi",
        "MX": "Mexiko",
        "MY": "Malaisia",
        "MZ": "Mosambik",
        "NA": "Namiibia",
        "NC": "Nöikaledoonie",
        "NF": "Norfolk-Insle",
        "NG": "Nigeeria",
        "NI": "Nicaraagua",
        "NL": "Niderland",
        "NO": "Norweege",
        "NP": "Neepal",
        "NZ": "Nöiseeland",
        "OM": "Omaan",
        "PF": "Französisch-Polineesie",
        "PG": "Papua-Neuguinea",
        "PH": "Philippiine",
        "PK": "Pakischtan",
        "PL": "Poole",
        "PM": "St. Pierr und Miggelo",
        "PN": "Pitggäärn",
        "PR": "Puerto Riggo",
        "PS": "Paläschtinänsischi Gebiet",
        "PY": "Paraguai",
        "QA": "Ggatar",
        "QO": "Üssers Ozeaanie",
        "RE": "Reünioon",
        "RO": "Rumäänie",
        "RS": "Särbie",
        "RU": "Russischi Föderazioon",
        "RW": "Ruanda",
        "SA": "Saudi-Araabie",
        "SB": "Salomoone",
        "SC": "Seischälle",
        "SE": "Schweede",
        "SG": "Singapuur",
        "SH": "St. Helena",
        "SI": "Sloweenie",
        "SJ": "Svalbard und Jaan Määie",
        "SK": "Slowakäi",
        "SL": "Sierra Leoone",
        "SM": "San Mariino",
        "SO": "Somaalia",
        "SR": "Surinam",
        "ST": "Sao Tome und Prinssipe",
        "SY": "Süürie",
        "SZ": "Swasiland",
        "TC": "Törks- und Gaiggos-Insle",
        "TD": "Tschad",
        "TF": "Französischi Süüd- und Antarktisgebiet",
        "TG": "Toogo",
        "TJ": "Tadschikischtan",
        "TL": "Oschttimor",
        "TM": "Turkmeenischtan",
        "TN": "Tuneesie",
        "TR": "Türggei",
        "TT": "Trinidad und Tobaago",
        "TZ": "Tansaniia",
        "UA": "Ukraiine",
        "UM": "Amerikanisch-Ozeaanie",
        "US": "Veräinigti Schtaate",
        "UZ": "Uschbeekischtan",
        "VA": "Vatikanstadt",
        "VC": "Sankt Wässä und d’Grönadiine",
        "VE": "Venezueela",
        "VG": "Britischi Jungfere-Insle",
        "VI": "Amerikaanischi Jungfere-Insle",
        "VN": "Wietnam",
        "VU": "Wanuatu",
        "WF": "Wallis und Futuuna",
        "WS": "Samooa",
        "YE": "Jeeme",
        "YT": "Majott",
        "ZA": "Süüdafrika",
        "ZM": "Sambia",
        "ZW": "Simbabwe",
        "ZZ": "Unbekannti oder ungültigi Regioon"
    };
  }-*/;
}
