/* Properties.c generated by valac 0.40.4, the Vala compiler
 * generated from Properties.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <time.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>


#define TYPE_PROPERTIES (properties_get_type ())
#define PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES, Properties))
#define PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTIES, PropertiesClass))
#define IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES))
#define IS_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTIES))
#define PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTIES, PropertiesClass))

typedef struct _Properties Properties;
typedef struct _PropertiesClass PropertiesClass;
typedef struct _PropertiesPrivate PropertiesPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
enum  {
	PROPERTIES_0_PROPERTY,
	PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* properties_properties[PROPERTIES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_BASIC_PROPERTIES (basic_properties_get_type ())
#define BASIC_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASIC_PROPERTIES, BasicProperties))
#define BASIC_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASIC_PROPERTIES, BasicPropertiesClass))
#define IS_BASIC_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASIC_PROPERTIES))
#define IS_BASIC_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASIC_PROPERTIES))
#define BASIC_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASIC_PROPERTIES, BasicPropertiesClass))

typedef struct _BasicProperties BasicProperties;
typedef struct _BasicPropertiesClass BasicPropertiesClass;
typedef struct _BasicPropertiesPrivate BasicPropertiesPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
enum  {
	BASIC_PROPERTIES_0_PROPERTY,
	BASIC_PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* basic_properties_properties[BASIC_PROPERTIES_NUM_PROPERTIES];

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_IMPORT_SOURCE (import_source_get_type ())
#define IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPORT_SOURCE, ImportSource))
#define IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPORT_SOURCE, ImportSourceClass))
#define IS_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPORT_SOURCE))
#define IS_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPORT_SOURCE))
#define IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPORT_SOURCE, ImportSourceClass))

typedef struct _ImportSource ImportSource;
typedef struct _ImportSourceClass ImportSourceClass;

#define TYPE_PHOTO_IMPORT_SOURCE (photo_import_source_get_type ())
#define PHOTO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource))
#define PHOTO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSourceClass))
#define IS_PHOTO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_SOURCE))
#define IS_PHOTO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_SOURCE))
#define PHOTO_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSourceClass))

typedef struct _PhotoImportSource PhotoImportSource;
typedef struct _PhotoImportSourceClass PhotoImportSourceClass;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _dimensions_free0(var) ((var == NULL) ? NULL : (var = (dimensions_free (var), NULL)))

#define TYPE_ORIENTATION (orientation_get_type ())

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO_IMPORT_SOURCE (video_import_source_get_type ())
#define VIDEO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource))
#define VIDEO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSourceClass))
#define IS_VIDEO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_IMPORT_SOURCE))
#define IS_VIDEO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_IMPORT_SOURCE))
#define VIDEO_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSourceClass))

typedef struct _VideoImportSource VideoImportSource;
typedef struct _VideoImportSourceClass VideoImportSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_CHECKERBOARD_PAGE (checkerboard_page_get_type ())
#define CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPage))
#define CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))
#define IS_CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_PAGE))
#define IS_CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_PAGE))
#define CHECKERBOARD_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))

typedef struct _CheckerboardPage CheckerboardPage;
typedef struct _CheckerboardPageClass CheckerboardPageClass;

#define TYPE_MEDIA_PAGE (media_page_get_type ())
#define MEDIA_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_PAGE, MediaPage))
#define MEDIA_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_PAGE, MediaPageClass))
#define IS_MEDIA_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_PAGE))
#define IS_MEDIA_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_PAGE))
#define MEDIA_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_PAGE, MediaPageClass))

typedef struct _MediaPage MediaPage;
typedef struct _MediaPageClass MediaPageClass;

#define TYPE_COLLECTION_PAGE (collection_page_get_type ())
#define COLLECTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_PAGE, CollectionPage))
#define COLLECTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_PAGE, CollectionPageClass))
#define IS_COLLECTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_PAGE))
#define IS_COLLECTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_PAGE))
#define COLLECTION_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_PAGE, CollectionPageClass))

typedef struct _CollectionPage CollectionPage;
typedef struct _CollectionPageClass CollectionPageClass;

#define TYPE_TAG_PAGE (tag_page_get_type ())
#define TAG_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_PAGE, TagPage))
#define TAG_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_PAGE, TagPageClass))
#define IS_TAG_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_PAGE))
#define IS_TAG_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_PAGE))
#define TAG_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_PAGE, TagPageClass))

typedef struct _TagPage TagPage;
typedef struct _TagPageClass TagPageClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_EXTENDED_PROPERTIES_WINDOW (extended_properties_window_get_type ())
#define EXTENDED_PROPERTIES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindow))
#define EXTENDED_PROPERTIES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindowClass))
#define IS_EXTENDED_PROPERTIES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTENDED_PROPERTIES_WINDOW))
#define IS_EXTENDED_PROPERTIES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTENDED_PROPERTIES_WINDOW))
#define EXTENDED_PROPERTIES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindowClass))

typedef struct _ExtendedPropertiesWindow ExtendedPropertiesWindow;
typedef struct _ExtendedPropertiesWindowClass ExtendedPropertiesWindowClass;
typedef struct _ExtendedPropertiesWindowPrivate ExtendedPropertiesWindowPrivate;

#define EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES (extended_properties_window_extended_properties_get_type ())
#define EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedProperties))
#define EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedPropertiesClass))
#define EXTENDED_PROPERTIES_WINDOW_IS_EXTENDED_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES))
#define EXTENDED_PROPERTIES_WINDOW_IS_EXTENDED_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES))
#define EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedPropertiesClass))

typedef struct _ExtendedPropertiesWindowExtendedProperties ExtendedPropertiesWindowExtendedProperties;
typedef struct _ExtendedPropertiesWindowExtendedPropertiesClass ExtendedPropertiesWindowExtendedPropertiesClass;
enum  {
	EXTENDED_PROPERTIES_WINDOW_0_PROPERTY,
	EXTENDED_PROPERTIES_WINDOW_NUM_PROPERTIES
};
static GParamSpec* extended_properties_window_properties[EXTENDED_PROPERTIES_WINDOW_NUM_PROPERTIES];

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef struct _ExtendedPropertiesWindowExtendedPropertiesPrivate ExtendedPropertiesWindowExtendedPropertiesPrivate;
enum  {
	EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_0_PROPERTY,
	EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* extended_properties_window_extended_properties_properties[EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_EVENTS_DIRECTORY_PAGE (events_directory_page_get_type ())
#define EVENTS_DIRECTORY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENTS_DIRECTORY_PAGE, EventsDirectoryPage))
#define EVENTS_DIRECTORY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENTS_DIRECTORY_PAGE, EventsDirectoryPageClass))
#define IS_EVENTS_DIRECTORY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENTS_DIRECTORY_PAGE))
#define IS_EVENTS_DIRECTORY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENTS_DIRECTORY_PAGE))
#define EVENTS_DIRECTORY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENTS_DIRECTORY_PAGE, EventsDirectoryPageClass))

typedef struct _EventsDirectoryPage EventsDirectoryPage;
typedef struct _EventsDirectoryPageClass EventsDirectoryPageClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _Properties {
	GtkGrid parent_instance;
	PropertiesPrivate * priv;
};

struct _PropertiesClass {
	GtkGridClass parent_class;
	void (*get_single_properties) (Properties* self, DataView* view);
	void (*get_multiple_properties) (Properties* self, GeeIterable* iter);
	void (*get_properties) (Properties* self, Page* current_page);
	void (*clear_properties) (Properties* self);
	void (*internal_update_properties) (Properties* self, Page* page);
};

struct _PropertiesPrivate {
	guint line_count;
};

struct _BasicProperties {
	Properties parent_instance;
	BasicPropertiesPrivate * priv;
};

struct _BasicPropertiesClass {
	PropertiesClass parent_class;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _BasicPropertiesPrivate {
	gchar* title;
	time_t start_time;
	time_t end_time;
	Dimensions dimensions;
	gint photo_count;
	gint event_count;
	gint video_count;
	gchar* exposure;
	gchar* aperture;
	gchar* iso;
	gdouble clip_duration;
	gchar* raw_developer;
	gchar* raw_assoc;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _ExtendedPropertiesWindow {
	GtkDialog parent_instance;
	ExtendedPropertiesWindowPrivate * priv;
};

struct _ExtendedPropertiesWindowClass {
	GtkDialogClass parent_class;
};

struct _ExtendedPropertiesWindowPrivate {
	ExtendedPropertiesWindowExtendedProperties* properties;
};

struct _ExtendedPropertiesWindowExtendedProperties {
	Properties parent_instance;
	ExtendedPropertiesWindowExtendedPropertiesPrivate * priv;
};

struct _ExtendedPropertiesWindowExtendedPropertiesClass {
	PropertiesClass parent_class;
};

struct _ExtendedPropertiesWindowExtendedPropertiesPrivate {
	gchar* file_path;
	guint64 filesize;
	Dimensions* original_dim;
	gchar* camera_make;
	gchar* camera_model;
	gchar* flash;
	gchar* focal_length;
	gdouble gps_lat;
	gchar* gps_lat_ref;
	gdouble gps_long;
	gchar* gps_long_ref;
	gdouble gps_alt;
	gchar* artist;
	gchar* copyright;
	gchar* software;
	gchar* exposure_bias;
	gchar* exposure_date;
	gchar* exposure_time;
	gboolean is_raw;
	gchar* development_path;
	gchar* comment;
};

typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;


static gpointer properties_parent_class = NULL;
static gpointer basic_properties_parent_class = NULL;
static gpointer extended_properties_window_parent_class = NULL;
static gpointer extended_properties_window_extended_properties_parent_class = NULL;

GType properties_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType page_get_type (void) G_GNUC_CONST;
#define PROPERTIES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROPERTIES, PropertiesPrivate))
Properties* properties_construct (GType object_type);
void properties_add_line (Properties* self,
                          const gchar* label_text,
                          const gchar* info_text,
                          gboolean multi_line);
gboolean is_string_empty (const gchar* s);
gchar* properties_get_prettyprint_time (Properties* self,
                                        struct tm* time);
gchar* resources_get_hh_mm_format_string (void);
gchar* properties_get_prettyprint_time_with_seconds (Properties* self,
                                                     struct tm* time);
gchar* resources_get_hh_mm_ss_format_string (void);
gchar* properties_get_prettyprint_date (Properties* self,
                                        struct tm* date);
gchar* format_local_date (struct tm* date);
void properties_get_single_properties (Properties* self,
                                       DataView* view);
static void properties_real_get_single_properties (Properties* self,
                                            DataView* view);
void properties_get_multiple_properties (Properties* self,
                                         GeeIterable* iter);
static void properties_real_get_multiple_properties (Properties* self,
                                              GeeIterable* iter);
void properties_get_properties (Properties* self,
                                Page* current_page);
static void properties_real_get_properties (Properties* self,
                                     Page* current_page);
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType view_collection_get_type (void) G_GNUC_CONST;
ViewCollection* page_get_view (Page* self);
gint view_collection_get_selected_count (ViewCollection* self);
GeeList* view_collection_get_selected (ViewCollection* self);
gint data_collection_get_count (DataCollection* self);
GeeCollection* data_collection_get_all (DataCollection* self);
void properties_clear_properties (Properties* self);
static void properties_real_clear_properties (Properties* self);
void properties_update_properties (Properties* self,
                                   Page* page);
void properties_internal_update_properties (Properties* self,
                                            Page* page);
static void properties_real_internal_update_properties (Properties* self,
                                                 Page* page);
void properties_unselect_text (Properties* self);
static void properties_finalize (GObject * obj);
GType basic_properties_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
#define BASIC_PROPERTIES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BASIC_PROPERTIES, BasicPropertiesPrivate))
BasicProperties* basic_properties_new (void);
BasicProperties* basic_properties_construct (GType object_type);
static void basic_properties_real_clear_properties (Properties* base);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
static void basic_properties_real_get_single_properties (Properties* base,
                                                  DataView* view);
GType data_source_get_type (void) G_GNUC_CONST;
DataSource* data_view_get_source (DataView* self);
gchar* data_object_get_name (DataObject* self);
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType import_source_get_type (void) G_GNUC_CONST;
GType photo_import_source_get_type (void) G_GNUC_CONST;
time_t media_source_get_exposure_time (MediaSource* self);
time_t import_source_get_exposure_time (ImportSource* self);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
PhotoMetadata* photo_import_source_get_metadata (PhotoImportSource* self);
gchar* photo_metadata_get_exposure_string (PhotoMetadata* self);
gchar* photo_metadata_get_aperture_string (PhotoMetadata* self,
                                           gboolean pango_formatted);
gchar* photo_metadata_get_iso_string (PhotoMetadata* self);
Dimensions* photo_metadata_get_pixel_dimensions (PhotoMetadata* self);
GType orientation_get_type (void) G_GNUC_CONST;
Orientation photo_metadata_get_orientation (PhotoMetadata* self);
void orientation_rotate_dimensions (Orientation self,
                                    Dimensions* dim,
                                    Dimensions* result);
GType photo_exception_get_type (void) G_GNUC_CONST;
void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
GType photo_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_get_master_file_format (Photo* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
RawDeveloper photo_get_raw_developer (Photo* self);
gchar* raw_developer_get_label (RawDeveloper self);
gboolean photo_is_raw_developer_available (Photo* self,
                                           RawDeveloper d);
GType event_source_get_type (void) G_GNUC_CONST;
time_t event_source_get_start_time (EventSource* self);
time_t event_source_get_end_time (EventSource* self);
void media_source_collection_count_media (GeeCollection* media,
                                          gint* photo_count,
                                          gint* video_count);
GeeCollection* event_source_get_media (EventSource* self);
GType video_source_get_type (void) G_GNUC_CONST;
GType video_import_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
gdouble video_get_clip_duration (Video* self);
gboolean video_get_is_interpretable (Video* self);
void video_get_frame_dimensions (Video* self,
                                 Dimensions* result);
static void basic_properties_real_get_multiple_properties (Properties* base,
                                                    GeeIterable* iter);
static void basic_properties_real_get_properties (Properties* base,
                                           Page* current_page);
static void basic_properties_real_internal_update_properties (Properties* base,
                                                       Page* page);
GType checkerboard_page_get_type (void) G_GNUC_CONST;
GType media_page_get_type (void) G_GNUC_CONST;
GType collection_page_get_type (void) G_GNUC_CONST;
GType tag_page_get_type (void) G_GNUC_CONST;
GType tag_get_type (void) G_GNUC_CONST;
Tag* tag_page_get_tag (TagPage* self);
gchar* tag_get_user_visible_name (Tag* self);
gchar* guarded_markup_escape_text (const gchar* plain);
gboolean dimensions_has_area (Dimensions *self);
static void basic_properties_finalize (GObject * obj);
GType extended_properties_window_get_type (void) G_GNUC_CONST;
static GType extended_properties_window_extended_properties_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define EXTENDED_PROPERTIES_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindowPrivate))
ExtendedPropertiesWindow* extended_properties_window_new (GtkWindow* owner);
ExtendedPropertiesWindow* extended_properties_window_construct (GType object_type,
                                                                GtkWindow* owner);
gint resources_use_header_bar (void);
static gboolean _gtk_widget_hide_on_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                             GdkEventAny* event,
                                                             gpointer self);
static ExtendedPropertiesWindowExtendedProperties* extended_properties_window_extended_properties_new (void);
static ExtendedPropertiesWindowExtendedProperties* extended_properties_window_extended_properties_construct (GType object_type);
static gboolean extended_properties_window_real_button_press_event (GtkWidget* base,
                                                             GdkEventButton* event);
static gboolean extended_properties_window_real_key_press_event (GtkWidget* base,
                                                          GdkEventKey* event);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void extended_properties_window_update_properties (ExtendedPropertiesWindow* self,
                                                   Page* page);
static void extended_properties_window_real_show_all (GtkWidget* base);
#define EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedPropertiesPrivate))
#define EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE ""
static void extended_properties_window_extended_properties_real_clear_properties (Properties* base);
static void extended_properties_window_extended_properties_real_get_single_properties (Properties* base,
                                                                                DataView* view);
GFile* media_source_get_master_file (MediaSource* self);
GFile* media_source_get_file (MediaSource* self);
guint64 media_source_get_master_filesize (MediaSource* self);
PhotoMetadata* photo_get_master_metadata (Photo* self,
                                          GError** error);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_metadata_date_time (GValue* value,
                                   gpointer v_object);
void value_take_metadata_date_time (GValue* value,
                                    gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
GType photo_metadata_set_option_get_type (void) G_GNUC_CONST;
void photo_metadata_set_exposure_date_time (PhotoMetadata* self,
                                            MetadataDateTime* date_time,
                                            PhotoMetadataSetOption option);
time_t media_source_get_timestamp (MediaSource* self);
MetadataDateTime* metadata_date_time_new (time_t timestamp);
MetadataDateTime* metadata_date_time_construct (GType object_type,
                                                time_t timestamp);
gchar* photo_metadata_get_camera_make (PhotoMetadata* self);
gchar* photo_metadata_get_camera_model (PhotoMetadata* self);
gchar* photo_metadata_get_flash_string (PhotoMetadata* self);
gchar* photo_metadata_get_focal_length_string (PhotoMetadata* self);
gboolean photo_metadata_get_gps (PhotoMetadata* self,
                                 gdouble* longitude,
                                 gchar* * long_ref,
                                 gdouble* latitude,
                                 gchar* * lat_ref,
                                 gdouble* altitude);
gchar* photo_metadata_get_artist (PhotoMetadata* self);
gchar* photo_metadata_get_copyright (PhotoMetadata* self);
gchar* photo_metadata_get_software (PhotoMetadata* self);
gchar* photo_metadata_get_exposure_bias (PhotoMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
gchar* media_source_get_comment (MediaSource* self);
GType event_get_type (void) G_GNUC_CONST;
gchar* event_source_get_comment (EventSource* self);
static void extended_properties_window_extended_properties_real_internal_update_properties (Properties* base,
                                                                                     Page* page);
GType events_directory_page_get_type (void) G_GNUC_CONST;
static void extended_properties_window_extended_properties_finalize (GObject * obj);
static void extended_properties_window_finalize (GObject * obj);


Properties*
properties_construct (GType object_type)
{
	Properties * self = NULL;
#line 10 "/home/jens/Source/shotwell/src/Properties.vala"
	self = (Properties*) g_object_new (object_type, NULL);
#line 11 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_grid_set_row_spacing (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), 0);
#line 12 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_grid_set_column_spacing (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), 6);
#line 10 "/home/jens/Source/shotwell/src/Properties.vala"
	return self;
#line 780 "Properties.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 31 "/home/jens/Source/shotwell/src/Properties.vala"
	return self ? g_object_ref (self) : NULL;
#line 789 "Properties.c"
}


void
properties_add_line (Properties* self,
                     const gchar* label_text,
                     const gchar* info_text,
                     gboolean multi_line)
{
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkWidget* info = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp38_;
	guint _tmp39_;
	guint _tmp44_;
#line 15 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 15 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (label_text != NULL);
#line 15 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (info_text != NULL);
#line 16 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
#line 16 "/home/jens/Source/shotwell/src/Properties.vala"
	g_object_ref_sink (_tmp0_);
#line 16 "/home/jens/Source/shotwell/src/Properties.vala"
	label = _tmp0_;
#line 19 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = label;
#line 19 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_label_set_justify (_tmp1_, GTK_JUSTIFY_RIGHT);
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = label;
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = g_markup_printf_escaped ("<span font_weight=\"bold\">%s</span>", label_text);
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = _tmp3_;
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_label_set_markup (_tmp2_, _tmp4_);
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (_tmp4_);
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
	if (multi_line) {
#line 837 "Properties.c"
		GtkScrolledWindow* info_scroll = NULL;
		GtkScrolledWindow* _tmp5_;
		GtkScrolledWindow* _tmp6_;
		GtkTextView* view = NULL;
		GtkTextView* _tmp7_;
		GtkStyleContext* context = NULL;
		GtkScrolledWindow* _tmp8_;
		GtkStyleContext* _tmp9_;
		GtkStyleContext* _tmp10_;
		GtkTextView* _tmp11_;
		GtkStyleContext* _tmp12_;
		GdkRGBA _tmp13_ = {0};
		GtkTextView* _tmp14_;
		GtkTextView* _tmp15_;
		GtkTextView* _tmp16_;
		const gchar* _tmp17_ = NULL;
		GtkTextView* _tmp18_;
		GtkTextBuffer* _tmp19_;
		GtkTextBuffer* _tmp20_;
		GtkScrolledWindow* _tmp21_;
		GtkTextView* _tmp22_;
		GtkLabel* _tmp23_;
		GtkLabel* _tmp24_;
		GtkScrolledWindow* _tmp25_;
		GtkWidget* _tmp26_;
#line 24 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp5_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 24 "/home/jens/Source/shotwell/src/Properties.vala"
		g_object_ref_sink (_tmp5_);
#line 24 "/home/jens/Source/shotwell/src/Properties.vala"
		info_scroll = _tmp5_;
#line 25 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = info_scroll;
#line 25 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_scrolled_window_set_shadow_type (_tmp6_, GTK_SHADOW_ETCHED_IN);
#line 26 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = (GtkTextView*) gtk_text_view_new ();
#line 26 "/home/jens/Source/shotwell/src/Properties.vala"
		g_object_ref_sink (_tmp7_);
#line 26 "/home/jens/Source/shotwell/src/Properties.vala"
		view = _tmp7_;
#line 31 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp8_ = info_scroll;
#line 31 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
#line 31 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 31 "/home/jens/Source/shotwell/src/Properties.vala"
		context = _tmp10_;
#line 32 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = view;
#line 32 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = context;
#line 32 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_style_context_get_background_color (_tmp12_, GTK_STATE_FLAG_NORMAL, &_tmp13_);
#line 32 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_widget_override_background_color (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_NORMAL, &_tmp13_);
#line 34 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp14_ = view;
#line 34 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_text_view_set_wrap_mode (_tmp14_, GTK_WRAP_WORD);
#line 35 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp15_ = view;
#line 35 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_text_view_set_cursor_visible (_tmp15_, FALSE);
#line 36 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp16_ = view;
#line 36 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_text_view_set_editable (_tmp16_, FALSE);
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		if (is_string_empty (info_text)) {
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp17_ = "";
#line 911 "Properties.c"
		} else {
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp17_ = info_text;
#line 915 "Properties.c"
		}
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp18_ = view;
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp19_ = gtk_text_view_get_buffer (_tmp18_);
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp20_ = _tmp19_;
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		g_object_set (_tmp20_, "text", _tmp17_, NULL);
#line 38 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp21_ = info_scroll;
#line 38 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp22_ = view;
#line 38 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
#line 39 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp23_ = label;
#line 39 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_xalign (_tmp23_, 1.0f);
#line 40 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp24_ = label;
#line 40 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_yalign (_tmp24_, 0.0f);
#line 41 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp25_ = info_scroll;
#line 41 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
#line 41 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (info);
#line 41 "/home/jens/Source/shotwell/src/Properties.vala"
		info = _tmp26_;
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (context);
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (view);
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (info_scroll);
#line 953 "Properties.c"
	} else {
		GtkLabel* info_label = NULL;
		GtkLabel* _tmp27_;
		const gchar* _tmp28_ = NULL;
		GtkLabel* _tmp29_;
		GtkLabel* _tmp30_;
		GtkLabel* _tmp31_;
		GtkLabel* _tmp32_;
		GtkLabel* _tmp33_;
		GtkLabel* _tmp34_;
		GtkLabel* _tmp35_;
		GtkLabel* _tmp36_;
		GtkWidget* _tmp37_;
#line 43 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp27_ = (GtkLabel*) gtk_label_new ("");
#line 43 "/home/jens/Source/shotwell/src/Properties.vala"
		g_object_ref_sink (_tmp27_);
#line 43 "/home/jens/Source/shotwell/src/Properties.vala"
		info_label = _tmp27_;
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
		if (is_string_empty (info_text)) {
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp28_ = "";
#line 977 "Properties.c"
		} else {
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp28_ = info_text;
#line 981 "Properties.c"
		}
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp29_ = info_label;
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_markup (_tmp29_, _tmp28_);
#line 45 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp30_ = info_label;
#line 45 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_ellipsize (_tmp30_, PANGO_ELLIPSIZE_END);
#line 46 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp31_ = info_label;
#line 46 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_xalign (_tmp31_, 0.0f);
#line 47 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp32_ = info_label;
#line 47 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_yalign (_tmp32_, 0.5f);
#line 48 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp33_ = info_label;
#line 48 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_selectable (_tmp33_, TRUE);
#line 49 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp34_ = label;
#line 49 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_xalign (_tmp34_, 1.0f);
#line 50 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp35_ = label;
#line 50 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_yalign (_tmp35_, 0.5f);
#line 51 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp36_ = info_label;
#line 51 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
#line 51 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (info);
#line 51 "/home/jens/Source/shotwell/src/Properties.vala"
		info = _tmp37_;
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (info_label);
#line 1021 "Properties.c"
	}
#line 54 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp38_ = label;
#line 54 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp39_ = self->priv->line_count;
#line 54 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_grid_attach (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget), 0, (gint) _tmp39_, 1, 1);
#line 56 "/home/jens/Source/shotwell/src/Properties.vala"
	if (multi_line) {
#line 1031 "Properties.c"
		GtkWidget* _tmp40_;
		guint _tmp41_;
#line 57 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp40_ = info;
#line 57 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp41_ = self->priv->line_count;
#line 57 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_grid_attach (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), _tmp40_, 1, (gint) _tmp41_, 1, 2);
#line 1040 "Properties.c"
	} else {
		GtkWidget* _tmp42_;
		guint _tmp43_;
#line 59 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp42_ = info;
#line 59 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp43_ = self->priv->line_count;
#line 59 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_grid_attach (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), _tmp42_, 1, (gint) _tmp43_, 1, 1);
#line 1050 "Properties.c"
	}
#line 62 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp44_ = self->priv->line_count;
#line 62 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->line_count = _tmp44_ + 1;
#line 15 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (info);
#line 15 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (label);
#line 1060 "Properties.c"
}


static gchar*
g_time_format (struct tm *self,
               const gchar* format)
{
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
#line 2874 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2876 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2876 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2876 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, format, &(*self));
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2_ = buffer;
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2__length1 = buffer_length1;
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp3_;
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1106 "Properties.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1124 "Properties.c"
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1148 "Properties.c"
	} else {
		gchar* _tmp2_;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1157 "Properties.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1178 "Properties.c"
	} else {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1182 "Properties.c"
	}
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1188 "Properties.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1198 "Properties.c"
	}
#line 1356 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1202 "Properties.c"
		glong _tmp3_;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1210 "Properties.c"
	} else {
		glong _tmp4_;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 1217 "Properties.c"
	}
#line 1362 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1221 "Properties.c"
		glong _tmp5_;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 1227 "Properties.c"
	}
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1239 "Properties.c"
}


gchar*
properties_get_prettyprint_time (Properties* self,
                                 struct tm* time)
{
	gchar* result = NULL;
	gchar* timestring = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
#line 65 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (IS_PROPERTIES (self), NULL);
#line 65 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (time != NULL, NULL);
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = resources_get_hh_mm_format_string ();
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = _tmp0_;
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = g_time_format (time, _tmp1_);
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = _tmp2_;
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (_tmp1_);
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	timestring = _tmp3_;
#line 68 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = timestring;
#line 68 "/home/jens/Source/shotwell/src/Properties.vala"
	if (string_get (_tmp4_, (glong) 0) == '0') {
#line 1274 "Properties.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 69 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp5_ = timestring;
#line 69 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
#line 69 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (timestring);
#line 69 "/home/jens/Source/shotwell/src/Properties.vala"
		timestring = _tmp6_;
#line 1285 "Properties.c"
	}
#line 71 "/home/jens/Source/shotwell/src/Properties.vala"
	result = timestring;
#line 71 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 1291 "Properties.c"
}


gchar*
properties_get_prettyprint_time_with_seconds (Properties* self,
                                              struct tm* time)
{
	gchar* result = NULL;
	gchar* timestring = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
#line 74 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (IS_PROPERTIES (self), NULL);
#line 74 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (time != NULL, NULL);
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = resources_get_hh_mm_ss_format_string ();
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = _tmp0_;
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = g_time_format (time, _tmp1_);
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = _tmp2_;
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (_tmp1_);
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	timestring = _tmp3_;
#line 77 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = timestring;
#line 77 "/home/jens/Source/shotwell/src/Properties.vala"
	if (string_get (_tmp4_, (glong) 0) == '0') {
#line 1326 "Properties.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 78 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp5_ = timestring;
#line 78 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
#line 78 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (timestring);
#line 78 "/home/jens/Source/shotwell/src/Properties.vala"
		timestring = _tmp6_;
#line 1337 "Properties.c"
	}
#line 80 "/home/jens/Source/shotwell/src/Properties.vala"
	result = timestring;
#line 80 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 1343 "Properties.c"
}


static void
g_time_local (time_t time,
              struct tm* result)
{
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2866 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 2866 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2867 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2867 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return;
#line 1361 "Properties.c"
}


gchar*
properties_get_prettyprint_date (Properties* self,
                                 struct tm* date)
{
	gchar* result = NULL;
	gchar* date_string = NULL;
	struct tm today = {0};
	time_t _tmp0_;
	struct tm _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	struct tm _tmp3_;
	gint _tmp4_;
	struct tm _tmp5_;
	gint _tmp6_;
#line 83 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (IS_PROPERTIES (self), NULL);
#line 83 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (date != NULL, NULL);
#line 84 "/home/jens/Source/shotwell/src/Properties.vala"
	date_string = NULL;
#line 85 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = time (NULL);
#line 85 "/home/jens/Source/shotwell/src/Properties.vala"
	g_time_local (_tmp0_, &_tmp1_);
#line 85 "/home/jens/Source/shotwell/src/Properties.vala"
	today = _tmp1_;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = *date;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = _tmp3_.tm_yday;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = today;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp6_ = _tmp5_.tm_yday;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp4_ == _tmp6_) {
#line 1401 "Properties.c"
		struct tm _tmp7_;
		gint _tmp8_;
		struct tm _tmp9_;
		gint _tmp10_;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = *date;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp8_ = _tmp7_.tm_year;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = today;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp10_ = _tmp9_.tm_year;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp2_ = _tmp8_ == _tmp10_;
#line 1416 "Properties.c"
	} else {
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp2_ = FALSE;
#line 1420 "Properties.c"
	}
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp2_) {
#line 1424 "Properties.c"
		gchar* _tmp11_;
#line 87 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = g_strdup (_ ("Today"));
#line 87 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (date_string);
#line 87 "/home/jens/Source/shotwell/src/Properties.vala"
		date_string = _tmp11_;
#line 1432 "Properties.c"
	} else {
		gboolean _tmp12_ = FALSE;
		struct tm _tmp13_;
		gint _tmp14_;
		struct tm _tmp15_;
		gint _tmp16_;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp13_ = *date;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp14_ = _tmp13_.tm_yday;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp15_ = today;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp16_ = _tmp15_.tm_yday;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp14_ == (_tmp16_ - 1)) {
#line 1449 "Properties.c"
			struct tm _tmp17_;
			gint _tmp18_;
			struct tm _tmp19_;
			gint _tmp20_;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp17_ = *date;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp18_ = _tmp17_.tm_year;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = today;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = _tmp19_.tm_year;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp12_ = _tmp18_ == _tmp20_;
#line 1464 "Properties.c"
		} else {
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp12_ = FALSE;
#line 1468 "Properties.c"
		}
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp12_) {
#line 1472 "Properties.c"
			gchar* _tmp21_;
#line 89 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp21_ = g_strdup (_ ("Yesterday"));
#line 89 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (date_string);
#line 89 "/home/jens/Source/shotwell/src/Properties.vala"
			date_string = _tmp21_;
#line 1480 "Properties.c"
		} else {
			struct tm _tmp22_;
			gchar* _tmp23_;
#line 91 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp22_ = *date;
#line 91 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp23_ = format_local_date (&_tmp22_);
#line 91 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (date_string);
#line 91 "/home/jens/Source/shotwell/src/Properties.vala"
			date_string = _tmp23_;
#line 1492 "Properties.c"
		}
	}
#line 94 "/home/jens/Source/shotwell/src/Properties.vala"
	result = date_string;
#line 94 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 1499 "Properties.c"
}


static void
properties_real_get_single_properties (Properties* self,
                                       DataView* view)
{
#line 97 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 1509 "Properties.c"
}


void
properties_get_single_properties (Properties* self,
                                  DataView* view)
{
#line 97 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 97 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_GET_CLASS (self)->get_single_properties (self, view);
#line 1521 "Properties.c"
}


static void
properties_real_get_multiple_properties (Properties* self,
                                         GeeIterable* iter)
{
#line 100 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail ((iter == NULL) || GEE_IS_ITERABLE (iter));
#line 1531 "Properties.c"
}


void
properties_get_multiple_properties (Properties* self,
                                    GeeIterable* iter)
{
#line 100 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 100 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_GET_CLASS (self)->get_multiple_properties (self, iter);
#line 1543 "Properties.c"
}


static void
properties_real_get_properties (Properties* self,
                                Page* current_page)
{
	ViewCollection* view = NULL;
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	gint count = 0;
	ViewCollection* _tmp2_;
	GeeIterable* iter = NULL;
	gint _tmp3_;
	gboolean _tmp9_ = FALSE;
	GeeIterable* _tmp10_;
	gint _tmp12_;
#line 103 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (current_page));
#line 104 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = page_get_view (current_page);
#line 104 "/home/jens/Source/shotwell/src/Properties.vala"
	view = _tmp0_;
#line 105 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = view;
#line 105 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp1_ == NULL) {
#line 106 "/home/jens/Source/shotwell/src/Properties.vala"
		_data_collection_unref0 (view);
#line 106 "/home/jens/Source/shotwell/src/Properties.vala"
		return;
#line 1575 "Properties.c"
	}
#line 109 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = view;
#line 109 "/home/jens/Source/shotwell/src/Properties.vala"
	count = view_collection_get_selected_count (_tmp2_);
#line 110 "/home/jens/Source/shotwell/src/Properties.vala"
	iter = NULL;
#line 111 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = count;
#line 111 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp3_ != 0) {
#line 1587 "Properties.c"
		ViewCollection* _tmp4_;
		GeeList* _tmp5_;
#line 112 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp4_ = view;
#line 112 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp5_ = view_collection_get_selected (_tmp4_);
#line 112 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (iter);
#line 112 "/home/jens/Source/shotwell/src/Properties.vala"
		iter = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable);
#line 1598 "Properties.c"
	} else {
		ViewCollection* _tmp6_;
		ViewCollection* _tmp7_;
		GeeCollection* _tmp8_;
#line 114 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = view;
#line 114 "/home/jens/Source/shotwell/src/Properties.vala"
		count = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection));
#line 115 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = view;
#line 115 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp8_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_COLLECTION, DataCollection));
#line 115 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (iter);
#line 115 "/home/jens/Source/shotwell/src/Properties.vala"
		iter = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable);
#line 1615 "Properties.c"
	}
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp10_ = iter;
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp10_ == NULL) {
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = TRUE;
#line 1623 "Properties.c"
	} else {
		gint _tmp11_;
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = count;
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = _tmp11_ == 0;
#line 1630 "Properties.c"
	}
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp9_) {
#line 119 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (iter);
#line 119 "/home/jens/Source/shotwell/src/Properties.vala"
		_data_collection_unref0 (view);
#line 119 "/home/jens/Source/shotwell/src/Properties.vala"
		return;
#line 1640 "Properties.c"
	}
#line 121 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp12_ = count;
#line 121 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp12_ == 1) {
#line 1646 "Properties.c"
		{
			GeeIterator* _item_it = NULL;
			GeeIterable* _tmp13_;
			GeeIterator* _tmp14_;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp13_ = iter;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp14_ = gee_iterable_iterator (_tmp13_);
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
			_item_it = _tmp14_;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
			while (TRUE) {
#line 1659 "Properties.c"
				GeeIterator* _tmp15_;
				DataView* item = NULL;
				GeeIterator* _tmp16_;
				gpointer _tmp17_;
				DataView* _tmp18_;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp15_ = _item_it;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				if (!gee_iterator_next (_tmp15_)) {
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
					break;
#line 1671 "Properties.c"
				}
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp16_ = _item_it;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp17_ = gee_iterator_get (_tmp16_);
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				item = (DataView*) _tmp17_;
#line 123 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp18_ = item;
#line 123 "/home/jens/Source/shotwell/src/Properties.vala"
				properties_get_single_properties (self, _tmp18_);
#line 124 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_object_unref0 (item);
#line 124 "/home/jens/Source/shotwell/src/Properties.vala"
				break;
#line 1687 "Properties.c"
			}
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (_item_it);
#line 1691 "Properties.c"
		}
	} else {
		GeeIterable* _tmp19_;
#line 127 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp19_ = iter;
#line 127 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_get_multiple_properties (self, _tmp19_);
#line 1699 "Properties.c"
	}
#line 103 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (iter);
#line 103 "/home/jens/Source/shotwell/src/Properties.vala"
	_data_collection_unref0 (view);
#line 1705 "Properties.c"
}


void
properties_get_properties (Properties* self,
                           Page* current_page)
{
#line 103 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 103 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_GET_CLASS (self)->get_properties (self, current_page);
#line 1717 "Properties.c"
}


static void
properties_real_clear_properties (Properties* self)
{
	GList* _tmp0_;
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
#line 1727 "Properties.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
		child_collection = _tmp0_;
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 1735 "Properties.c"
			GtkWidget* _tmp1_;
			GtkWidget* child = NULL;
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
			child = _tmp1_;
#line 1742 "Properties.c"
			{
				GtkWidget* _tmp2_;
#line 133 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp2_ = child;
#line 133 "/home/jens/Source/shotwell/src/Properties.vala"
				gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp2_);
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_object_unref0 (child);
#line 1751 "Properties.c"
			}
		}
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_list_free0 (child_collection);
#line 1756 "Properties.c"
	}
#line 135 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->line_count = (guint) 0;
#line 1760 "Properties.c"
}


void
properties_clear_properties (Properties* self)
{
#line 131 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 131 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_GET_CLASS (self)->clear_properties (self);
#line 1771 "Properties.c"
}


void
properties_update_properties (Properties* self,
                              Page* page)
{
#line 138 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 138 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (page));
#line 139 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_clear_properties (self);
#line 140 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_internal_update_properties (self, page);
#line 141 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1789 "Properties.c"
}


static void
properties_real_internal_update_properties (Properties* self,
                                            Page* page)
{
#line 144 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (page));
#line 145 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_get_properties (self, page);
#line 1801 "Properties.c"
}


void
properties_internal_update_properties (Properties* self,
                                       Page* page)
{
#line 144 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 144 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_GET_CLASS (self)->internal_update_properties (self, page);
#line 1813 "Properties.c"
}


void
properties_unselect_text (Properties* self)
{
	GList* _tmp0_;
#line 148 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
#line 1825 "Properties.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
		child_collection = _tmp0_;
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 1833 "Properties.c"
			GtkWidget* _tmp1_;
			GtkWidget* child = NULL;
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
			child = _tmp1_;
#line 1840 "Properties.c"
			{
				GtkWidget* _tmp2_;
#line 150 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp2_ = child;
#line 150 "/home/jens/Source/shotwell/src/Properties.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_label_get_type ())) {
#line 1847 "Properties.c"
					GtkWidget* _tmp3_;
#line 151 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp3_ = child;
#line 151 "/home/jens/Source/shotwell/src/Properties.vala"
					gtk_label_select_region (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel), 0, 0);
#line 1853 "Properties.c"
				}
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_object_unref0 (child);
#line 1857 "Properties.c"
			}
		}
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_list_free0 (child_collection);
#line 1862 "Properties.c"
	}
}


static void
properties_class_init (PropertiesClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	g_type_class_add_private (klass, sizeof (PropertiesPrivate));
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_single_properties = (void (*) (Properties *, DataView*)) properties_real_get_single_properties;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_multiple_properties = (void (*) (Properties *, GeeIterable*)) properties_real_get_multiple_properties;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_properties = (void (*) (Properties *, Page*)) properties_real_get_properties;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->clear_properties = (void (*) (Properties *)) properties_real_clear_properties;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->internal_update_properties = (void (*) (Properties *, Page*)) properties_real_internal_update_properties;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (klass)->finalize = properties_finalize;
#line 1886 "Properties.c"
}


static void
properties_instance_init (Properties * self)
{
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv = PROPERTIES_GET_PRIVATE (self);
#line 8 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->line_count = (guint) 0;
#line 1897 "Properties.c"
}


static void
properties_finalize (GObject * obj)
{
	Properties * self;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROPERTIES, Properties);
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (properties_parent_class)->finalize (obj);
#line 1909 "Properties.c"
}


GType
properties_get_type (void)
{
	static volatile gsize properties_type_id__volatile = 0;
	if (g_once_init_enter (&properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Properties), 0, (GInstanceInitFunc) properties_instance_init, NULL };
		GType properties_type_id;
		properties_type_id = g_type_register_static (gtk_grid_get_type (), "Properties", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&properties_type_id__volatile, properties_type_id);
	}
	return properties_type_id__volatile;
}


BasicProperties*
basic_properties_construct (GType object_type)
{
	BasicProperties * self = NULL;
#line 171 "/home/jens/Source/shotwell/src/Properties.vala"
	self = (BasicProperties*) properties_construct (object_type);
#line 171 "/home/jens/Source/shotwell/src/Properties.vala"
	return self;
#line 1935 "Properties.c"
}


BasicProperties*
basic_properties_new (void)
{
#line 171 "/home/jens/Source/shotwell/src/Properties.vala"
	return basic_properties_construct (TYPE_BASIC_PROPERTIES);
#line 1944 "Properties.c"
}


static void
basic_properties_real_clear_properties (Properties* base)
{
	BasicProperties * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 174 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 175 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (basic_properties_parent_class)->clear_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties));
#line 176 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = g_strdup ("");
#line 176 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->title);
#line 176 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->title = _tmp0_;
#line 177 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->start_time = (time_t) 0;
#line 178 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->end_time = (time_t) 0;
#line 179 "/home/jens/Source/shotwell/src/Properties.vala"
	dimensions_init (&self->priv->dimensions, 0, 0);
#line 180 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->photo_count = -1;
#line 181 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->event_count = -1;
#line 182 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->video_count = -1;
#line 183 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = g_strdup ("");
#line 183 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure);
#line 183 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->exposure = _tmp1_;
#line 184 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = g_strdup ("");
#line 184 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->aperture);
#line 184 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->aperture = _tmp2_;
#line 185 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = g_strdup ("");
#line 185 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->iso);
#line 185 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->iso = _tmp3_;
#line 186 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->clip_duration = 0.0;
#line 187 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = g_strdup ("");
#line 187 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->raw_developer);
#line 187 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->raw_developer = _tmp4_;
#line 188 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = g_strdup ("");
#line 188 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->raw_assoc);
#line 188 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->raw_assoc = _tmp5_;
#line 2012 "Properties.c"
}


static gpointer
_media_metadata_ref0 (gpointer self)
{
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
	return self ? media_metadata_ref (self) : NULL;
#line 2021 "Properties.c"
}


static void
basic_properties_real_get_single_properties (Properties* base,
                                             DataView* view)
{
	BasicProperties * self;
	DataSource* source = NULL;
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	DataSource* _tmp4_;
#line 191 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 191 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 192 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (basic_properties_parent_class)->get_single_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), view);
#line 194 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = data_view_get_source (view);
#line 194 "/home/jens/Source/shotwell/src/Properties.vala"
	source = _tmp0_;
#line 196 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = source;
#line 196 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_OBJECT, DataObject));
#line 196 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->title);
#line 196 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->title = _tmp2_;
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = source;
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_PHOTO_SOURCE)) {
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp3_ = TRUE;
#line 2060 "Properties.c"
	} else {
		DataSource* _tmp5_;
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp5_ = source;
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_PHOTO_IMPORT_SOURCE);
#line 2067 "Properties.c"
	}
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp3_) {
#line 2071 "Properties.c"
		time_t _tmp6_ = 0;
		DataSource* _tmp7_;
		time_t _tmp10_;
		PhotoMetadata* _tmp11_ = NULL;
		DataSource* _tmp12_;
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp17_;
		PhotoMetadata* _tmp18_;
		DataSource* _tmp42_;
		gboolean _tmp45_ = FALSE;
		DataSource* _tmp46_;
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = source;
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_PHOTO_SOURCE)) {
#line 2087 "Properties.c"
			DataSource* _tmp8_;
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp8_ = source;
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp6_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_MEDIA_SOURCE, MediaSource));
#line 2093 "Properties.c"
		} else {
			DataSource* _tmp9_;
#line 200 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp9_ = source;
#line 200 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp6_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
#line 2100 "Properties.c"
		}
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->start_time = _tmp6_;
#line 201 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp10_ = self->priv->start_time;
#line 201 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->end_time = _tmp10_;
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = source;
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_PHOTO_SOURCE)) {
#line 2112 "Properties.c"
			DataSource* _tmp13_;
			PhotoMetadata* _tmp14_;
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp13_ = source;
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp14_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO_SOURCE, PhotoSource));
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (_tmp11_);
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp11_ = _tmp14_;
#line 2123 "Properties.c"
		} else {
			DataSource* _tmp15_;
			PhotoMetadata* _tmp16_;
#line 204 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp15_ = source;
#line 204 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp16_ = photo_import_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
#line 204 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (_tmp11_);
#line 204 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp11_ = _tmp16_;
#line 2135 "Properties.c"
		}
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp17_ = _media_metadata_ref0 (_tmp11_);
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
		metadata = _tmp17_;
#line 206 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp18_ = metadata;
#line 206 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp18_ != NULL) {
#line 2145 "Properties.c"
			PhotoMetadata* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			PhotoMetadata* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			PhotoMetadata* _tmp27_;
			gchar* _tmp28_;
			const gchar* _tmp29_;
			Dimensions _tmp31_ = {0};
			PhotoMetadata* _tmp32_;
			Dimensions* _tmp33_;
			Dimensions* _tmp34_;
			gboolean _tmp35_;
#line 207 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = metadata;
#line 207 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = photo_metadata_get_exposure_string (_tmp19_);
#line 207 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->exposure);
#line 207 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->exposure = _tmp20_;
#line 208 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp21_ = self->priv->exposure;
#line 208 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp21_ == NULL) {
#line 2172 "Properties.c"
				gchar* _tmp22_;
#line 209 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp22_ = g_strdup ("");
#line 209 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (self->priv->exposure);
#line 209 "/home/jens/Source/shotwell/src/Properties.vala"
				self->priv->exposure = _tmp22_;
#line 2180 "Properties.c"
			}
#line 211 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp23_ = metadata;
#line 211 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp24_ = photo_metadata_get_aperture_string (_tmp23_, TRUE);
#line 211 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->aperture);
#line 211 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->aperture = _tmp24_;
#line 212 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp25_ = self->priv->aperture;
#line 212 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp25_ == NULL) {
#line 2194 "Properties.c"
				gchar* _tmp26_;
#line 213 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp26_ = g_strdup ("");
#line 213 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (self->priv->aperture);
#line 213 "/home/jens/Source/shotwell/src/Properties.vala"
				self->priv->aperture = _tmp26_;
#line 2202 "Properties.c"
			}
#line 215 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp27_ = metadata;
#line 215 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp28_ = photo_metadata_get_iso_string (_tmp27_);
#line 215 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->iso);
#line 215 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->iso = _tmp28_;
#line 216 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp29_ = self->priv->iso;
#line 216 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp29_ == NULL) {
#line 2216 "Properties.c"
				gchar* _tmp30_;
#line 217 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp30_ = g_strdup ("");
#line 217 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (self->priv->iso);
#line 217 "/home/jens/Source/shotwell/src/Properties.vala"
				self->priv->iso = _tmp30_;
#line 2224 "Properties.c"
			}
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp32_ = metadata;
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp33_ = photo_metadata_get_pixel_dimensions (_tmp32_);
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp34_ = _tmp33_;
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp35_ = _tmp34_ != NULL;
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			_dimensions_free0 (_tmp34_);
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp35_) {
#line 2238 "Properties.c"
				PhotoMetadata* _tmp36_;
				PhotoMetadata* _tmp37_;
				Dimensions* _tmp38_;
				Dimensions* _tmp39_;
				Dimensions _tmp40_;
				Dimensions _tmp41_ = {0};
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp36_ = metadata;
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp37_ = metadata;
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp38_ = photo_metadata_get_pixel_dimensions (_tmp37_);
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp39_ = _tmp38_;
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp40_ = *_tmp39_;
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				orientation_rotate_dimensions (photo_metadata_get_orientation (_tmp36_), &_tmp40_, &_tmp41_);
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp31_ = _tmp41_;
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_dimensions_free0 (_tmp39_);
#line 2261 "Properties.c"
			} else {
#line 221 "/home/jens/Source/shotwell/src/Properties.vala"
				dimensions_init (&_tmp31_, 0, 0);
#line 2265 "Properties.c"
			}
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->dimensions = _tmp31_;
#line 2269 "Properties.c"
		}
#line 224 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp42_ = source;
#line 224 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, TYPE_PHOTO_SOURCE)) {
#line 2275 "Properties.c"
			DataSource* _tmp43_;
			Dimensions _tmp44_ = {0};
#line 225 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp43_ = source;
#line 225 "/home/jens/Source/shotwell/src/Properties.vala"
			media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp44_);
#line 225 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->dimensions = _tmp44_;
#line 2284 "Properties.c"
		}
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp46_ = source;
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, TYPE_PHOTO)) {
#line 2290 "Properties.c"
			DataSource* _tmp47_;
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp47_ = source;
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp45_ = photo_get_master_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_PHOTO, Photo)) == PHOTO_FILE_FORMAT_RAW;
#line 2296 "Properties.c"
		} else {
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp45_ = FALSE;
#line 2300 "Properties.c"
		}
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp45_) {
#line 2304 "Properties.c"
			Photo* photo = NULL;
			DataSource* _tmp48_;
			Photo* _tmp49_;
			Photo* _tmp50_;
			gchar* _tmp51_;
			const gchar* _tmp52_ = NULL;
			Photo* _tmp53_;
			gchar* _tmp54_;
#line 228 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp48_ = source;
#line 228 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, TYPE_PHOTO) ? ((Photo*) _tmp48_) : NULL);
#line 228 "/home/jens/Source/shotwell/src/Properties.vala"
			photo = _tmp49_;
#line 229 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp50_ = photo;
#line 229 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp51_ = raw_developer_get_label (photo_get_raw_developer (_tmp50_));
#line 229 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->raw_developer);
#line 229 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->raw_developer = _tmp51_;
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp53_ = photo;
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			if (photo_is_raw_developer_available (_tmp53_, RAW_DEVELOPER_CAMERA)) {
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp52_ = _ ("RAW+JPEG");
#line 2333 "Properties.c"
			} else {
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp52_ = "";
#line 2337 "Properties.c"
			}
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp54_ = g_strdup (_tmp52_);
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->raw_assoc);
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->raw_assoc = _tmp54_;
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (photo);
#line 2347 "Properties.c"
		}
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
		_media_metadata_unref0 (metadata);
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
		_media_metadata_unref0 (_tmp11_);
#line 2353 "Properties.c"
	} else {
		DataSource* _tmp55_;
#line 232 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp55_ = source;
#line 232 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, TYPE_EVENT_SOURCE)) {
#line 2360 "Properties.c"
			EventSource* event_source = NULL;
			DataSource* _tmp56_;
			EventSource* _tmp57_;
			EventSource* _tmp58_;
			EventSource* _tmp59_;
			gint event_photo_count = 0;
			gint event_video_count = 0;
			EventSource* _tmp60_;
			GeeCollection* _tmp61_;
			GeeCollection* _tmp62_;
			gint _tmp63_ = 0;
			gint _tmp64_ = 0;
			gint _tmp65_;
			gint _tmp66_;
#line 233 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp56_ = source;
#line 233 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, TYPE_EVENT_SOURCE, EventSource));
#line 233 "/home/jens/Source/shotwell/src/Properties.vala"
			event_source = _tmp57_;
#line 235 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp58_ = event_source;
#line 235 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->start_time = event_source_get_start_time (_tmp58_);
#line 236 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp59_ = event_source;
#line 236 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->end_time = event_source_get_end_time (_tmp59_);
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp60_ = event_source;
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp61_ = event_source_get_media (_tmp60_);
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp62_ = _tmp61_;
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			media_source_collection_count_media (_tmp62_, &_tmp63_, &_tmp64_);
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			event_photo_count = _tmp63_;
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			event_video_count = _tmp64_;
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (_tmp62_);
#line 243 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp65_ = event_photo_count;
#line 243 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->photo_count = _tmp65_;
#line 244 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp66_ = event_video_count;
#line 244 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->video_count = _tmp66_;
#line 232 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (event_source);
#line 2413 "Properties.c"
		} else {
			gboolean _tmp67_ = FALSE;
			DataSource* _tmp68_;
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp68_ = source;
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, TYPE_VIDEO_SOURCE)) {
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp67_ = TRUE;
#line 2423 "Properties.c"
			} else {
				DataSource* _tmp69_;
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp69_ = source;
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp67_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, TYPE_VIDEO_IMPORT_SOURCE);
#line 2430 "Properties.c"
			}
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp67_) {
#line 2434 "Properties.c"
				DataSource* _tmp70_;
				time_t _tmp79_;
#line 246 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp70_ = source;
#line 246 "/home/jens/Source/shotwell/src/Properties.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, TYPE_VIDEO_SOURCE)) {
#line 2441 "Properties.c"
					Video* video = NULL;
					DataSource* _tmp71_;
					Video* _tmp72_;
					Video* _tmp73_;
					Video* _tmp74_;
					Video* _tmp77_;
#line 247 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp71_ = source;
#line 247 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, TYPE_VIDEO, Video));
#line 247 "/home/jens/Source/shotwell/src/Properties.vala"
					video = _tmp72_;
#line 248 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp73_ = video;
#line 248 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->clip_duration = video_get_clip_duration (_tmp73_);
#line 250 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp74_ = video;
#line 250 "/home/jens/Source/shotwell/src/Properties.vala"
					if (video_get_is_interpretable (_tmp74_)) {
#line 2462 "Properties.c"
						Video* _tmp75_;
						Dimensions _tmp76_ = {0};
#line 251 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp75_ = video;
#line 251 "/home/jens/Source/shotwell/src/Properties.vala"
						video_get_frame_dimensions (_tmp75_, &_tmp76_);
#line 251 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->dimensions = _tmp76_;
#line 2471 "Properties.c"
					}
#line 253 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp77_ = video;
#line 253 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->start_time = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, TYPE_MEDIA_SOURCE, MediaSource));
#line 246 "/home/jens/Source/shotwell/src/Properties.vala"
					_g_object_unref0 (video);
#line 2479 "Properties.c"
				} else {
					DataSource* _tmp78_;
#line 255 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp78_ = source;
#line 255 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->start_time = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
#line 2486 "Properties.c"
				}
#line 257 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp79_ = self->priv->start_time;
#line 257 "/home/jens/Source/shotwell/src/Properties.vala"
				self->priv->end_time = _tmp79_;
#line 2492 "Properties.c"
			}
		}
	}
#line 191 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (source);
#line 2498 "Properties.c"
}


static void
basic_properties_real_get_multiple_properties (Properties* base,
                                               GeeIterable* iter)
{
	BasicProperties * self;
#line 261 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 261 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail ((iter == NULL) || GEE_IS_ITERABLE (iter));
#line 262 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (basic_properties_parent_class)->get_multiple_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), iter);
#line 264 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->photo_count = 0;
#line 265 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->video_count = 0;
#line 2517 "Properties.c"
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp0_;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp0_ = gee_iterable_iterator (iter);
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
		_view_it = _tmp0_;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
		while (TRUE) {
#line 2527 "Properties.c"
			GeeIterator* _tmp1_;
			DataView* view = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataSource* source = NULL;
			DataView* _tmp4_;
			DataSource* _tmp5_;
			gboolean _tmp6_ = FALSE;
			DataSource* _tmp7_;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp1_ = _view_it;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
				break;
#line 2543 "Properties.c"
			}
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp2_ = _view_it;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			view = (DataView*) _tmp3_;
#line 267 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp4_ = view;
#line 267 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp5_ = data_view_get_source (_tmp4_);
#line 267 "/home/jens/Source/shotwell/src/Properties.vala"
			source = _tmp5_;
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp7_ = source;
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_PHOTO_SOURCE)) {
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp6_ = TRUE;
#line 2563 "Properties.c"
			} else {
				DataSource* _tmp8_;
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp8_ = source;
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_PHOTO_IMPORT_SOURCE);
#line 2570 "Properties.c"
			}
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp6_) {
#line 2574 "Properties.c"
				time_t _tmp9_ = 0;
				DataSource* _tmp10_;
				time_t exposure_time = 0;
				time_t _tmp13_;
				gint _tmp24_;
#line 270 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp10_ = source;
#line 270 "/home/jens/Source/shotwell/src/Properties.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, TYPE_PHOTO_SOURCE)) {
#line 2584 "Properties.c"
					DataSource* _tmp11_;
#line 271 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp11_ = source;
#line 271 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp9_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_MEDIA_SOURCE, MediaSource));
#line 2590 "Properties.c"
				} else {
					DataSource* _tmp12_;
#line 272 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp12_ = source;
#line 272 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp9_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
#line 2597 "Properties.c"
				}
#line 270 "/home/jens/Source/shotwell/src/Properties.vala"
				exposure_time = _tmp9_;
#line 274 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp13_ = exposure_time;
#line 274 "/home/jens/Source/shotwell/src/Properties.vala"
				if (_tmp13_ != ((time_t) 0)) {
#line 2605 "Properties.c"
					gboolean _tmp14_ = FALSE;
					time_t _tmp15_;
					gboolean _tmp19_ = FALSE;
					time_t _tmp20_;
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp15_ = self->priv->start_time;
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp15_ == ((time_t) 0)) {
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp14_ = TRUE;
#line 2616 "Properties.c"
					} else {
						time_t _tmp16_;
						time_t _tmp17_;
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp16_ = exposure_time;
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp17_ = self->priv->start_time;
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp14_ = _tmp16_ < _tmp17_;
#line 2626 "Properties.c"
					}
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp14_) {
#line 2630 "Properties.c"
						time_t _tmp18_;
#line 276 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp18_ = exposure_time;
#line 276 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->start_time = _tmp18_;
#line 2636 "Properties.c"
					}
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp20_ = self->priv->end_time;
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp20_ == ((time_t) 0)) {
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp19_ = TRUE;
#line 2644 "Properties.c"
					} else {
						time_t _tmp21_;
						time_t _tmp22_;
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp21_ = exposure_time;
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp22_ = self->priv->end_time;
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp19_ = _tmp21_ > _tmp22_;
#line 2654 "Properties.c"
					}
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp19_) {
#line 2658 "Properties.c"
						time_t _tmp23_;
#line 279 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp23_ = exposure_time;
#line 279 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->end_time = _tmp23_;
#line 2664 "Properties.c"
					}
				}
#line 282 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp24_ = self->priv->photo_count;
#line 282 "/home/jens/Source/shotwell/src/Properties.vala"
				self->priv->photo_count = _tmp24_ + 1;
#line 2671 "Properties.c"
			} else {
				DataSource* _tmp25_;
#line 283 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp25_ = source;
#line 283 "/home/jens/Source/shotwell/src/Properties.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, TYPE_EVENT_SOURCE)) {
#line 2678 "Properties.c"
					EventSource* event_source = NULL;
					DataSource* _tmp26_;
					EventSource* _tmp27_;
					gint _tmp28_;
					gboolean _tmp29_ = FALSE;
					gboolean _tmp30_ = FALSE;
					time_t _tmp31_;
					gboolean _tmp36_ = FALSE;
					gboolean _tmp37_ = FALSE;
					time_t _tmp38_;
					gint event_photo_count = 0;
					gint event_video_count = 0;
					EventSource* _tmp48_;
					GeeCollection* _tmp49_;
					GeeCollection* _tmp50_;
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
					gint _tmp53_;
					gint _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					gint _tmp57_;
#line 284 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp26_ = source;
#line 284 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_EVENT_SOURCE, EventSource));
#line 284 "/home/jens/Source/shotwell/src/Properties.vala"
					event_source = _tmp27_;
#line 286 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp28_ = self->priv->event_count;
#line 286 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp28_ == -1) {
#line 287 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->event_count = 0;
#line 2713 "Properties.c"
					}
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp31_ = self->priv->start_time;
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp31_ == ((time_t) 0)) {
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp30_ = TRUE;
#line 2721 "Properties.c"
					} else {
						EventSource* _tmp32_;
						time_t _tmp33_;
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp32_ = event_source;
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp33_ = self->priv->start_time;
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp30_ = event_source_get_start_time (_tmp32_) < _tmp33_;
#line 2731 "Properties.c"
					}
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp30_) {
#line 2735 "Properties.c"
						EventSource* _tmp34_;
#line 290 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp34_ = event_source;
#line 290 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp29_ = event_source_get_start_time (_tmp34_) != ((time_t) 0);
#line 2741 "Properties.c"
					} else {
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp29_ = FALSE;
#line 2745 "Properties.c"
					}
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp29_) {
#line 2749 "Properties.c"
						EventSource* _tmp35_;
#line 291 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp35_ = event_source;
#line 291 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->start_time = event_source_get_start_time (_tmp35_);
#line 2755 "Properties.c"
					}
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp38_ = self->priv->end_time;
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp38_ == ((time_t) 0)) {
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp37_ = TRUE;
#line 2763 "Properties.c"
					} else {
						EventSource* _tmp39_;
						time_t _tmp40_;
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp39_ = event_source;
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp40_ = self->priv->end_time;
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp37_ = event_source_get_end_time (_tmp39_) > _tmp40_;
#line 2773 "Properties.c"
					}
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp37_) {
#line 2777 "Properties.c"
						EventSource* _tmp41_;
#line 294 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp41_ = event_source;
#line 294 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp36_ = event_source_get_end_time (_tmp41_) != ((time_t) 0);
#line 2783 "Properties.c"
					} else {
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp36_ = FALSE;
#line 2787 "Properties.c"
					}
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp36_) {
#line 2791 "Properties.c"
						EventSource* _tmp42_;
#line 295 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp42_ = event_source;
#line 295 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->end_time = event_source_get_end_time (_tmp42_);
#line 2797 "Properties.c"
					} else {
						gboolean _tmp43_ = FALSE;
						time_t _tmp44_;
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp44_ = self->priv->end_time;
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
						if (_tmp44_ == ((time_t) 0)) {
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp43_ = TRUE;
#line 2807 "Properties.c"
						} else {
							EventSource* _tmp45_;
							time_t _tmp46_;
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp45_ = event_source;
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp46_ = self->priv->end_time;
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp43_ = event_source_get_start_time (_tmp45_) > _tmp46_;
#line 2817 "Properties.c"
						}
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
						if (_tmp43_) {
#line 2821 "Properties.c"
							EventSource* _tmp47_;
#line 297 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp47_ = event_source;
#line 297 "/home/jens/Source/shotwell/src/Properties.vala"
							self->priv->end_time = event_source_get_start_time (_tmp47_);
#line 2827 "Properties.c"
						}
					}
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp48_ = event_source;
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp49_ = event_source_get_media (_tmp48_);
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp50_ = _tmp49_;
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					media_source_collection_count_media (_tmp50_, &_tmp51_, &_tmp52_);
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					event_photo_count = _tmp51_;
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					event_video_count = _tmp52_;
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					_g_object_unref0 (_tmp50_);
#line 305 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp53_ = self->priv->photo_count;
#line 305 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp54_ = event_photo_count;
#line 305 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->photo_count = _tmp53_ + _tmp54_;
#line 306 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp55_ = self->priv->video_count;
#line 306 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp56_ = event_video_count;
#line 306 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->video_count = _tmp55_ + _tmp56_;
#line 307 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp57_ = self->priv->event_count;
#line 307 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->event_count = _tmp57_ + 1;
#line 283 "/home/jens/Source/shotwell/src/Properties.vala"
					_g_object_unref0 (event_source);
#line 2862 "Properties.c"
				} else {
					gboolean _tmp58_ = FALSE;
					DataSource* _tmp59_;
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp59_ = source;
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, TYPE_VIDEO_SOURCE)) {
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp58_ = TRUE;
#line 2872 "Properties.c"
					} else {
						DataSource* _tmp60_;
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp60_ = source;
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp58_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, TYPE_VIDEO_IMPORT_SOURCE);
#line 2879 "Properties.c"
					}
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp58_) {
#line 2883 "Properties.c"
						time_t _tmp61_ = 0;
						DataSource* _tmp62_;
						time_t exposure_time = 0;
						time_t _tmp65_;
						gint _tmp76_;
#line 309 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp62_ = source;
#line 309 "/home/jens/Source/shotwell/src/Properties.vala"
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, TYPE_VIDEO_SOURCE)) {
#line 2893 "Properties.c"
							DataSource* _tmp63_;
#line 310 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp63_ = source;
#line 310 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp61_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, TYPE_VIDEO_SOURCE, VideoSource), TYPE_MEDIA_SOURCE, MediaSource));
#line 2899 "Properties.c"
						} else {
							DataSource* _tmp64_;
#line 311 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp64_ = source;
#line 311 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp61_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
#line 2906 "Properties.c"
						}
#line 309 "/home/jens/Source/shotwell/src/Properties.vala"
						exposure_time = _tmp61_;
#line 313 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp65_ = exposure_time;
#line 313 "/home/jens/Source/shotwell/src/Properties.vala"
						if (_tmp65_ != ((time_t) 0)) {
#line 2914 "Properties.c"
							gboolean _tmp66_ = FALSE;
							time_t _tmp67_;
							gboolean _tmp71_ = FALSE;
							time_t _tmp72_;
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp67_ = self->priv->start_time;
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
							if (_tmp67_ == ((time_t) 0)) {
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp66_ = TRUE;
#line 2925 "Properties.c"
							} else {
								time_t _tmp68_;
								time_t _tmp69_;
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp68_ = exposure_time;
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp69_ = self->priv->start_time;
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp66_ = _tmp68_ < _tmp69_;
#line 2935 "Properties.c"
							}
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
							if (_tmp66_) {
#line 2939 "Properties.c"
								time_t _tmp70_;
#line 315 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp70_ = exposure_time;
#line 315 "/home/jens/Source/shotwell/src/Properties.vala"
								self->priv->start_time = _tmp70_;
#line 2945 "Properties.c"
							}
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp72_ = self->priv->end_time;
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
							if (_tmp72_ == ((time_t) 0)) {
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp71_ = TRUE;
#line 2953 "Properties.c"
							} else {
								time_t _tmp73_;
								time_t _tmp74_;
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp73_ = exposure_time;
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp74_ = self->priv->end_time;
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp71_ = _tmp73_ > _tmp74_;
#line 2963 "Properties.c"
							}
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
							if (_tmp71_) {
#line 2967 "Properties.c"
								time_t _tmp75_;
#line 318 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp75_ = exposure_time;
#line 318 "/home/jens/Source/shotwell/src/Properties.vala"
								self->priv->end_time = _tmp75_;
#line 2973 "Properties.c"
							}
						}
#line 321 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp76_ = self->priv->video_count;
#line 321 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->video_count = _tmp76_ + 1;
#line 2980 "Properties.c"
					}
				}
			}
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (source);
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (view);
#line 2988 "Properties.c"
		}
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (_view_it);
#line 2992 "Properties.c"
	}
}


static void
basic_properties_real_get_properties (Properties* base,
                                      Page* current_page)
{
	BasicProperties * self;
	time_t _tmp0_;
	time_t _tmp2_;
#line 326 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 326 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (current_page));
#line 327 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (basic_properties_parent_class)->get_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), current_page);
#line 329 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = self->priv->end_time;
#line 329 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp0_ == ((time_t) 0)) {
#line 3014 "Properties.c"
		time_t _tmp1_;
#line 330 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp1_ = self->priv->start_time;
#line 330 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->end_time = _tmp1_;
#line 3020 "Properties.c"
	}
#line 331 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = self->priv->start_time;
#line 331 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp2_ == ((time_t) 0)) {
#line 3026 "Properties.c"
		time_t _tmp3_;
#line 332 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp3_ = self->priv->end_time;
#line 332 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->start_time = _tmp3_;
#line 3032 "Properties.c"
	}
}


static void
basic_properties_real_internal_update_properties (Properties* base,
                                                  Page* page)
{
	BasicProperties * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	time_t _tmp35_;
	gdouble _tmp67_;
	const gchar* _tmp71_;
	const gchar* _tmp73_;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	const gchar* _tmp77_;
#line 335 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 335 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (page));
#line 336 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (basic_properties_parent_class)->internal_update_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), page);
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = self->priv->title;
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp1_, "") == 0) {
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (page, TYPE_TAG_PAGE);
#line 3066 "Properties.c"
	} else {
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp0_ = FALSE;
#line 3070 "Properties.c"
	}
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp0_) {
#line 3074 "Properties.c"
		Tag* _tmp2_;
		Tag* _tmp3_;
		gchar* _tmp4_;
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp2_ = tag_page_get_tag (G_TYPE_CHECK_INSTANCE_CAST (page, TYPE_TAG_PAGE, TagPage));
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp3_ = _tmp2_;
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp4_ = tag_get_user_visible_name (_tmp3_);
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->title);
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->title = _tmp4_;
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (_tmp3_);
#line 3090 "Properties.c"
	}
#line 342 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = self->priv->title;
#line 342 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp5_, "") != 0) {
#line 3096 "Properties.c"
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = self->priv->title;
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = guarded_markup_escape_text (_tmp6_);
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp8_ = _tmp7_;
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Title:"), _tmp8_, FALSE);
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp8_);
#line 3110 "Properties.c"
	}
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp10_ = self->priv->photo_count;
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp10_ >= 0) {
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = TRUE;
#line 3118 "Properties.c"
	} else {
		gint _tmp11_;
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = self->priv->video_count;
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = _tmp11_ >= 0;
#line 3125 "Properties.c"
	}
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp9_) {
#line 3129 "Properties.c"
		gchar* label = NULL;
		gchar* _tmp12_;
		gint _tmp13_;
		gchar* photo_num_string = NULL;
		gint _tmp20_;
		gint _tmp21_;
		gchar* _tmp22_;
		gchar* video_num_string = NULL;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gint _tmp27_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gint _tmp33_;
#line 346 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = g_strdup (_ ("Items:"));
#line 346 "/home/jens/Source/shotwell/src/Properties.vala"
		label = _tmp12_;
#line 348 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp13_ = self->priv->event_count;
#line 348 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp13_ >= 0) {
#line 3154 "Properties.c"
			gchar* event_num_string = NULL;
			gint _tmp14_;
			gint _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
#line 349 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp14_ = self->priv->event_count;
#line 349 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp15_ = self->priv->event_count;
#line 349 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp16_ = g_strdup_printf (ngettext ("%d Event", "%d Events", (gulong) _tmp14_), _tmp15_);
#line 349 "/home/jens/Source/shotwell/src/Properties.vala"
			event_num_string = _tmp16_;
#line 352 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp17_ = label;
#line 352 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp18_ = event_num_string;
#line 352 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp17_, _tmp18_, FALSE);
#line 353 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = g_strdup ("");
#line 353 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (label);
#line 353 "/home/jens/Source/shotwell/src/Properties.vala"
			label = _tmp19_;
#line 348 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (event_num_string);
#line 3184 "Properties.c"
		}
#line 356 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp20_ = self->priv->photo_count;
#line 356 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp21_ = self->priv->photo_count;
#line 356 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp22_ = g_strdup_printf (ngettext ("%d Photo", "%d Photos", (gulong) _tmp20_), _tmp21_);
#line 356 "/home/jens/Source/shotwell/src/Properties.vala"
		photo_num_string = _tmp22_;
#line 358 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp23_ = self->priv->video_count;
#line 358 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp24_ = self->priv->video_count;
#line 358 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp25_ = g_strdup_printf (ngettext ("%d Video", "%d Videos", (gulong) _tmp23_), _tmp24_);
#line 358 "/home/jens/Source/shotwell/src/Properties.vala"
		video_num_string = _tmp25_;
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp27_ = self->priv->photo_count;
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp27_ == 0) {
#line 3206 "Properties.c"
			gint _tmp28_;
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp28_ = self->priv->video_count;
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp26_ = _tmp28_ > 0;
#line 3212 "Properties.c"
		} else {
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp26_ = FALSE;
#line 3216 "Properties.c"
		}
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp26_) {
#line 3220 "Properties.c"
			const gchar* _tmp29_;
			const gchar* _tmp30_;
#line 362 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp29_ = label;
#line 362 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp30_ = video_num_string;
#line 362 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp29_, _tmp30_, FALSE);
#line 363 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (video_num_string);
#line 363 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (photo_num_string);
#line 363 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (label);
#line 363 "/home/jens/Source/shotwell/src/Properties.vala"
			return;
#line 3237 "Properties.c"
		}
#line 366 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp31_ = label;
#line 366 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp32_ = photo_num_string;
#line 366 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp31_, _tmp32_, FALSE);
#line 368 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp33_ = self->priv->video_count;
#line 368 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp33_ > 0) {
#line 3249 "Properties.c"
			const gchar* _tmp34_;
#line 369 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp34_ = video_num_string;
#line 369 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), "", _tmp34_, FALSE);
#line 3255 "Properties.c"
		}
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (video_num_string);
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (photo_num_string);
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (label);
#line 3263 "Properties.c"
	}
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp35_ = self->priv->start_time;
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp35_ != ((time_t) 0)) {
#line 3269 "Properties.c"
		gchar* start_date = NULL;
		time_t _tmp36_;
		struct tm _tmp37_ = {0};
		gchar* _tmp38_;
		gchar* start_time = NULL;
		time_t _tmp39_;
		struct tm _tmp40_ = {0};
		gchar* _tmp41_;
		gchar* end_date = NULL;
		time_t _tmp42_;
		struct tm _tmp43_ = {0};
		gchar* _tmp44_;
		gchar* end_time = NULL;
		time_t _tmp45_;
		struct tm _tmp46_ = {0};
		gchar* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
#line 373 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp36_ = self->priv->start_time;
#line 373 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp36_, &_tmp37_);
#line 373 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp38_ = properties_get_prettyprint_date (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp37_);
#line 373 "/home/jens/Source/shotwell/src/Properties.vala"
		start_date = _tmp38_;
#line 374 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp39_ = self->priv->start_time;
#line 374 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp39_, &_tmp40_);
#line 374 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp41_ = properties_get_prettyprint_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp40_);
#line 374 "/home/jens/Source/shotwell/src/Properties.vala"
		start_time = _tmp41_;
#line 375 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp42_ = self->priv->end_time;
#line 375 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp42_, &_tmp43_);
#line 375 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp44_ = properties_get_prettyprint_date (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp43_);
#line 375 "/home/jens/Source/shotwell/src/Properties.vala"
		end_date = _tmp44_;
#line 376 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp45_ = self->priv->end_time;
#line 376 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp45_, &_tmp46_);
#line 376 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp47_ = properties_get_prettyprint_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp46_);
#line 376 "/home/jens/Source/shotwell/src/Properties.vala"
		end_time = _tmp47_;
#line 378 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp48_ = start_date;
#line 378 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp49_ = end_date;
#line 378 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp48_, _tmp49_) == 0) {
#line 3326 "Properties.c"
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
#line 380 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp50_ = start_date;
#line 380 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Date:"), _tmp50_, FALSE);
#line 382 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp51_ = start_time;
#line 382 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp52_ = end_time;
#line 382 "/home/jens/Source/shotwell/src/Properties.vala"
			if (g_strcmp0 (_tmp51_, _tmp52_) == 0) {
#line 3340 "Properties.c"
				const gchar* _tmp53_;
#line 384 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp53_ = start_time;
#line 384 "/home/jens/Source/shotwell/src/Properties.vala"
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Time:"), _tmp53_, FALSE);
#line 3346 "Properties.c"
			} else {
				const gchar* _tmp54_;
				const gchar* _tmp55_;
#line 387 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp54_ = start_time;
#line 387 "/home/jens/Source/shotwell/src/Properties.vala"
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("From:"), _tmp54_, FALSE);
#line 388 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp55_ = end_time;
#line 388 "/home/jens/Source/shotwell/src/Properties.vala"
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("To:"), _tmp55_, FALSE);
#line 3358 "Properties.c"
			}
		} else {
			const gchar* _tmp56_;
			const gchar* _tmp57_;
#line 392 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp56_ = start_date;
#line 392 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("From:"), _tmp56_, FALSE);
#line 393 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp57_ = end_date;
#line 393 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("To:"), _tmp57_, FALSE);
#line 3371 "Properties.c"
		}
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (end_time);
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (end_date);
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (start_time);
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (start_date);
#line 3381 "Properties.c"
	}
#line 397 "/home/jens/Source/shotwell/src/Properties.vala"
	if (dimensions_has_area (&self->priv->dimensions)) {
#line 3385 "Properties.c"
		gchar* label = NULL;
		gchar* _tmp58_;
#line 398 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp58_ = g_strdup (_ ("Size:"));
#line 398 "/home/jens/Source/shotwell/src/Properties.vala"
		label = _tmp58_;
#line 400 "/home/jens/Source/shotwell/src/Properties.vala"
		if (dimensions_has_area (&self->priv->dimensions)) {
#line 3394 "Properties.c"
			const gchar* _tmp59_;
			Dimensions _tmp60_;
			gint _tmp61_;
			Dimensions _tmp62_;
			gint _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp59_ = label;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp60_ = self->priv->dimensions;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp61_ = _tmp60_.width;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp62_ = self->priv->dimensions;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp63_ = _tmp62_.height;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp64_ = g_strdup_printf ("%d &#215; %d", _tmp61_, _tmp63_);
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp65_ = _tmp64_;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp59_, _tmp65_, FALSE);
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp65_);
#line 402 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp66_ = g_strdup ("");
#line 402 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (label);
#line 402 "/home/jens/Source/shotwell/src/Properties.vala"
			label = _tmp66_;
#line 3427 "Properties.c"
		}
#line 397 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (label);
#line 3431 "Properties.c"
	}
#line 406 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp67_ = self->priv->clip_duration;
#line 406 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp67_ > 0.0) {
#line 3437 "Properties.c"
		gdouble _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp68_ = self->priv->clip_duration;
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp69_ = g_strdup_printf (_ ("%.1f seconds"), _tmp68_);
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp70_ = _tmp69_;
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Duration:"), _tmp70_, FALSE);
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp70_);
#line 3451 "Properties.c"
	}
#line 410 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp71_ = self->priv->raw_developer;
#line 410 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp71_, "") != 0) {
#line 3457 "Properties.c"
		const gchar* _tmp72_;
#line 411 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp72_ = self->priv->raw_developer;
#line 411 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Developer:"), _tmp72_, FALSE);
#line 3463 "Properties.c"
	}
#line 415 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp73_ = self->priv->raw_assoc;
#line 415 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp73_, "") != 0) {
#line 3469 "Properties.c"
		const gchar* _tmp74_;
#line 416 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp74_ = self->priv->raw_assoc;
#line 416 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), "", _tmp74_, FALSE);
#line 3475 "Properties.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp77_ = self->priv->exposure;
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp77_, "") != 0) {
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp76_ = TRUE;
#line 3483 "Properties.c"
	} else {
		const gchar* _tmp78_;
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp78_ = self->priv->aperture;
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp76_ = g_strcmp0 (_tmp78_, "") != 0;
#line 3490 "Properties.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp76_) {
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp75_ = TRUE;
#line 3496 "Properties.c"
	} else {
		const gchar* _tmp79_;
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp79_ = self->priv->iso;
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp75_ = g_strcmp0 (_tmp79_, "") != 0;
#line 3503 "Properties.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp75_) {
#line 3507 "Properties.c"
		gchar* line = NULL;
		const gchar* _tmp80_;
		const gchar* _tmp83_;
		gboolean _tmp92_ = FALSE;
		gboolean _tmp93_ = FALSE;
		const gchar* _tmp94_;
#line 419 "/home/jens/Source/shotwell/src/Properties.vala"
		line = NULL;
#line 422 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp80_ = self->priv->exposure;
#line 422 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp80_, "") != 0) {
#line 3520 "Properties.c"
			const gchar* _tmp81_;
			gchar* _tmp82_;
#line 423 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp81_ = self->priv->exposure;
#line 423 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp82_ = g_strdup (_tmp81_);
#line 423 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (line);
#line 423 "/home/jens/Source/shotwell/src/Properties.vala"
			line = _tmp82_;
#line 3531 "Properties.c"
		}
#line 425 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp83_ = self->priv->aperture;
#line 425 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp83_, "") != 0) {
#line 3537 "Properties.c"
			const gchar* _tmp84_;
#line 426 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp84_ = line;
#line 426 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp84_ != NULL) {
#line 3543 "Properties.c"
				const gchar* _tmp85_;
				const gchar* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp85_ = line;
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp86_ = self->priv->aperture;
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp87_ = g_strconcat (", ", _tmp86_, NULL);
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp88_ = _tmp87_;
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp89_ = g_strconcat (_tmp85_, _tmp88_, NULL);
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (line);
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				line = _tmp89_;
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (_tmp88_);
#line 3565 "Properties.c"
			} else {
				const gchar* _tmp90_;
				gchar* _tmp91_;
#line 429 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp90_ = self->priv->aperture;
#line 429 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp91_ = g_strdup (_tmp90_);
#line 429 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (line);
#line 429 "/home/jens/Source/shotwell/src/Properties.vala"
				line = _tmp91_;
#line 3577 "Properties.c"
			}
		}
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp94_ = self->priv->exposure;
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp94_, "") == 0) {
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp93_ = TRUE;
#line 3586 "Properties.c"
		} else {
			const gchar* _tmp95_;
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp95_ = self->priv->aperture;
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp93_ = g_strcmp0 (_tmp95_, "") == 0;
#line 3593 "Properties.c"
		}
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp93_) {
#line 3597 "Properties.c"
			const gchar* _tmp96_;
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp96_ = self->priv->iso;
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp92_ = g_strcmp0 (_tmp96_, "") != 0;
#line 3603 "Properties.c"
		} else {
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp92_ = FALSE;
#line 3607 "Properties.c"
		}
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp92_) {
#line 3611 "Properties.c"
			const gchar* _tmp97_;
			const gchar* _tmp105_;
#line 434 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp97_ = line;
#line 434 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp97_ != NULL) {
#line 3618 "Properties.c"
				const gchar* _tmp98_;
				const gchar* _tmp99_;
				gchar* _tmp100_;
				gchar* _tmp101_;
				gchar* _tmp102_;
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp98_ = line;
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp99_ = self->priv->iso;
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp100_ = g_strconcat (", " "ISO ", _tmp99_, NULL);
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp101_ = _tmp100_;
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp102_ = g_strconcat (_tmp98_, _tmp101_, NULL);
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (line);
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				line = _tmp102_;
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (_tmp101_);
#line 3640 "Properties.c"
			} else {
				const gchar* _tmp103_;
				gchar* _tmp104_;
#line 437 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp103_ = self->priv->iso;
#line 437 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp104_ = g_strconcat ("ISO ", _tmp103_, NULL);
#line 437 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (line);
#line 437 "/home/jens/Source/shotwell/src/Properties.vala"
				line = _tmp104_;
#line 3652 "Properties.c"
			}
#line 439 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp105_ = line;
#line 439 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure:"), _tmp105_, FALSE);
#line 3658 "Properties.c"
		} else {
			const gchar* _tmp106_;
			const gchar* _tmp108_;
#line 442 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp106_ = line;
#line 442 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp106_ != NULL) {
#line 3666 "Properties.c"
				const gchar* _tmp107_;
#line 443 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp107_ = line;
#line 443 "/home/jens/Source/shotwell/src/Properties.vala"
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure:"), _tmp107_, FALSE);
#line 3672 "Properties.c"
			}
#line 446 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp108_ = self->priv->iso;
#line 446 "/home/jens/Source/shotwell/src/Properties.vala"
			if (g_strcmp0 (_tmp108_, "") != 0) {
#line 3678 "Properties.c"
				const gchar* _tmp109_;
#line 447 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp109_ = line;
#line 447 "/home/jens/Source/shotwell/src/Properties.vala"
				if (_tmp109_ != NULL) {
#line 3684 "Properties.c"
					const gchar* _tmp110_;
					gchar* _tmp111_;
					gchar* _tmp112_;
#line 448 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp110_ = self->priv->iso;
#line 448 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp111_ = g_strconcat ("ISO ", _tmp110_, NULL);
#line 448 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp112_ = _tmp111_;
#line 448 "/home/jens/Source/shotwell/src/Properties.vala"
					properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), "", _tmp112_, FALSE);
#line 448 "/home/jens/Source/shotwell/src/Properties.vala"
					_g_free0 (_tmp112_);
#line 3698 "Properties.c"
				} else {
					const gchar* _tmp113_;
					gchar* _tmp114_;
					gchar* _tmp115_;
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp113_ = self->priv->iso;
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp114_ = g_strconcat ("ISO ", _tmp113_, NULL);
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp115_ = _tmp114_;
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure:"), _tmp115_, FALSE);
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					_g_free0 (_tmp115_);
#line 3713 "Properties.c"
				}
			}
		}
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (line);
#line 3719 "Properties.c"
	}
}


static void
basic_properties_class_init (BasicPropertiesClass * klass)
{
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	basic_properties_parent_class = g_type_class_peek_parent (klass);
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	g_type_class_add_private (klass, sizeof (BasicPropertiesPrivate));
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->clear_properties = (void (*) (Properties *)) basic_properties_real_clear_properties;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_single_properties = (void (*) (Properties *, DataView*)) basic_properties_real_get_single_properties;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_multiple_properties = (void (*) (Properties *, GeeIterable*)) basic_properties_real_get_multiple_properties;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_properties = (void (*) (Properties *, Page*)) basic_properties_real_get_properties;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->internal_update_properties = (void (*) (Properties *, Page*)) basic_properties_real_internal_update_properties;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (klass)->finalize = basic_properties_finalize;
#line 3743 "Properties.c"
}


static void
basic_properties_instance_init (BasicProperties * self)
{
	time_t _tmp0_;
	time_t _tmp1_;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv = BASIC_PROPERTIES_GET_PRIVATE (self);
#line 158 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = time (NULL);
#line 158 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->start_time = _tmp0_;
#line 159 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = time (NULL);
#line 159 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->end_time = _tmp1_;
#line 3762 "Properties.c"
}


static void
basic_properties_finalize (GObject * obj)
{
	BasicProperties * self;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 157 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->title);
#line 164 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure);
#line 165 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->aperture);
#line 166 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->iso);
#line 168 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->raw_developer);
#line 169 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->raw_assoc);
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (basic_properties_parent_class)->finalize (obj);
#line 3786 "Properties.c"
}


GType
basic_properties_get_type (void)
{
	static volatile gsize basic_properties_type_id__volatile = 0;
	if (g_once_init_enter (&basic_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BasicPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) basic_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BasicProperties), 0, (GInstanceInitFunc) basic_properties_instance_init, NULL };
		GType basic_properties_type_id;
		basic_properties_type_id = g_type_register_static (TYPE_PROPERTIES, "BasicProperties", &g_define_type_info, 0);
		g_once_init_leave (&basic_properties_type_id__volatile, basic_properties_type_id);
	}
	return basic_properties_type_id__volatile;
}


static gboolean
_gtk_widget_hide_on_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                    GdkEventAny* event,
                                                    gpointer self)
{
	gboolean result;
	result = gtk_widget_hide_on_delete ((GtkWidget*) self);
#line 647 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 3813 "Properties.c"
}


ExtendedPropertiesWindow*
extended_properties_window_construct (GType object_type,
                                      GtkWindow* owner)
{
	ExtendedPropertiesWindow * self = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp0_;
	ExtendedPropertiesWindowExtendedProperties* _tmp1_;
	ExtendedPropertiesWindowExtendedProperties* _tmp2_;
	ExtendedPropertiesWindowExtendedProperties* _tmp3_;
	ExtendedPropertiesWindowExtendedProperties* _tmp4_;
	ExtendedPropertiesWindowExtendedProperties* _tmp5_;
	ExtendedPropertiesWindowExtendedProperties* _tmp6_;
	ExtendedPropertiesWindowExtendedProperties* _tmp7_;
	ExtendedPropertiesWindowExtendedProperties* _tmp8_;
	GtkBox* _tmp9_;
	ExtendedPropertiesWindowExtendedProperties* _tmp10_;
#line 635 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (GTK_IS_WINDOW (owner), NULL);
#line 636 "/home/jens/Source/shotwell/src/Properties.vala"
	self = (ExtendedPropertiesWindow*) g_object_new (object_type, "use-header-bar", resources_use_header_bar (), NULL);
#line 638 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) (GDK_BUTTON_PRESS_MASK | GDK_KEY_PRESS_MASK));
#line 639 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_focus_on_map (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), TRUE);
#line 640 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_accept_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), TRUE);
#line 641 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_can_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
#line 642 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _ ("Extended Information"));
#line 643 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_position (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GTK_WIN_POS_CENTER);
#line 644 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), owner);
#line 645 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_type_hint (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
#line 647 "/home/jens/Source/shotwell/src/Properties.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "delete-event", (GCallback) _gtk_widget_hide_on_delete_gtk_widget_delete_event, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 0);
#line 649 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = extended_properties_window_extended_properties_new ();
#line 649 "/home/jens/Source/shotwell/src/Properties.vala"
	g_object_ref_sink (_tmp0_);
#line 649 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (self->priv->properties);
#line 649 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->properties = _tmp0_;
#line 650 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = self->priv->properties;
#line 650 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
#line 651 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = self->priv->properties;
#line 651 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
#line 652 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = self->priv->properties;
#line 652 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 653 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = self->priv->properties;
#line 653 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 654 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = self->priv->properties;
#line 654 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), 3);
#line 655 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp6_ = self->priv->properties;
#line 655 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), 3);
#line 656 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp7_ = self->priv->properties;
#line 656 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), 3);
#line 657 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp8_ = self->priv->properties;
#line 657 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), 3);
#line 658 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp9_ = gtk_dialog_get_content_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
#line 658 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp10_ = self->priv->properties;
#line 658 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_box_get_type (), GtkBox), gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
#line 635 "/home/jens/Source/shotwell/src/Properties.vala"
	return self;
#line 3903 "Properties.c"
}


ExtendedPropertiesWindow*
extended_properties_window_new (GtkWindow* owner)
{
#line 635 "/home/jens/Source/shotwell/src/Properties.vala"
	return extended_properties_window_construct (TYPE_EXTENDED_PROPERTIES_WINDOW, owner);
#line 3912 "Properties.c"
}


static gboolean
extended_properties_window_real_button_press_event (GtkWidget* base,
                                                    GdkEventButton* event)
{
	ExtendedPropertiesWindow * self;
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	guint32 _tmp5_;
#line 661 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindow);
#line 661 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 663 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = event->button;
#line 663 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp0_ != ((guint) 1)) {
#line 3935 "Properties.c"
		gboolean _tmp1_ = FALSE;
#line 664 "/home/jens/Source/shotwell/src/Properties.vala"
		if (GTK_WIDGET_CLASS (extended_properties_window_parent_class)->button_press_event != NULL) {
#line 664 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp1_ = GTK_WIDGET_CLASS (extended_properties_window_parent_class)->button_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), gtk_widget_get_type (), GtkWidget), event);
#line 3941 "Properties.c"
		} else {
#line 664 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp1_ = TRUE;
#line 3945 "Properties.c"
		}
#line 664 "/home/jens/Source/shotwell/src/Properties.vala"
		result = _tmp1_;
#line 664 "/home/jens/Source/shotwell/src/Properties.vala"
		return result;
#line 3951 "Properties.c"
	}
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = event->button;
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = event->x_root;
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = event->y_root;
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = event->time;
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_begin_move_drag (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), (gint) _tmp2_, (gint) _tmp3_, (gint) _tmp4_, _tmp5_);
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	result = TRUE;
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 3967 "Properties.c"
}


static gboolean
extended_properties_window_real_key_press_event (GtkWidget* base,
                                                 GdkEventKey* event)
{
	ExtendedPropertiesWindow * self;
	gboolean result = FALSE;
	guint _tmp0_;
	const gchar* _tmp1_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
#line 671 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindow);
#line 671 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 673 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = event->keyval;
#line 673 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = gdk_keyval_name (_tmp0_);
#line 673 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp1_, "Escape") == 0) {
#line 674 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 675 "/home/jens/Source/shotwell/src/Properties.vala"
		result = TRUE;
#line 675 "/home/jens/Source/shotwell/src/Properties.vala"
		return result;
#line 3999 "Properties.c"
	}
#line 678 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = app_window_get_instance ();
#line 678 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = _tmp2_;
#line 678 "/home/jens/Source/shotwell/src/Properties.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), "key-press-event", event, &_tmp4_);
#line 678 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = _tmp4_;
#line 678 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (_tmp3_);
#line 678 "/home/jens/Source/shotwell/src/Properties.vala"
	result = _tmp5_;
#line 678 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 4015 "Properties.c"
}


void
extended_properties_window_update_properties (ExtendedPropertiesWindow* self,
                                              Page* page)
{
	ExtendedPropertiesWindowExtendedProperties* _tmp0_;
#line 681 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_EXTENDED_PROPERTIES_WINDOW (self));
#line 681 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (page));
#line 682 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = self->priv->properties;
#line 682 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_update_properties (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PROPERTIES, Properties), page);
#line 4032 "Properties.c"
}


static void
extended_properties_window_real_show_all (GtkWidget* base)
{
	ExtendedPropertiesWindow * self;
	ExtendedPropertiesWindowExtendedProperties* _tmp0_;
#line 685 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindow);
#line 686 "/home/jens/Source/shotwell/src/Properties.vala"
	GTK_WIDGET_CLASS (extended_properties_window_parent_class)->show_all (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), gtk_widget_get_type (), GtkWidget));
#line 687 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = self->priv->properties;
#line 687 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_unselect_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PROPERTIES, Properties));
#line 688 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 4051 "Properties.c"
}


static gpointer
_dimensions_dup0 (gpointer self)
{
#line 498 "/home/jens/Source/shotwell/src/Properties.vala"
	return self ? dimensions_dup (self) : NULL;
#line 4060 "Properties.c"
}


static void
extended_properties_window_extended_properties_real_clear_properties (Properties* base)
{
	ExtendedPropertiesWindowExtendedProperties * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	Dimensions _tmp2_ = {0};
	Dimensions* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
#line 491 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedProperties);
#line 492 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (extended_properties_window_extended_properties_parent_class)->clear_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties));
#line 494 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = g_strdup ("");
#line 494 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->file_path);
#line 494 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->file_path = _tmp0_;
#line 495 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = g_strdup ("");
#line 495 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->development_path);
#line 495 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->development_path = _tmp1_;
#line 496 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->is_raw = FALSE;
#line 497 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->filesize = (guint64) 0;
#line 498 "/home/jens/Source/shotwell/src/Properties.vala"
	dimensions_init (&_tmp2_, 0, 0);
#line 498 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = _dimensions_dup0 (&_tmp2_);
#line 498 "/home/jens/Source/shotwell/src/Properties.vala"
	_dimensions_free0 (self->priv->original_dim);
#line 498 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->original_dim = _tmp3_;
#line 499 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = g_strdup ("");
#line 499 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->camera_make);
#line 499 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->camera_make = _tmp4_;
#line 500 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = g_strdup ("");
#line 500 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->camera_model);
#line 500 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->camera_model = _tmp5_;
#line 501 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp6_ = g_strdup ("");
#line 501 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->flash);
#line 501 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->flash = _tmp6_;
#line 502 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp7_ = g_strdup ("");
#line 502 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->focal_length);
#line 502 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->focal_length = _tmp7_;
#line 503 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->gps_lat = (gdouble) -1;
#line 504 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp8_ = g_strdup ("");
#line 504 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->gps_lat_ref);
#line 504 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->gps_lat_ref = _tmp8_;
#line 505 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->gps_long = (gdouble) -1;
#line 506 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp9_ = g_strdup ("");
#line 506 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->gps_long_ref);
#line 506 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->gps_long_ref = _tmp9_;
#line 507 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp10_ = g_strdup ("");
#line 507 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->artist);
#line 507 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->artist = _tmp10_;
#line 508 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp11_ = g_strdup ("");
#line 508 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->copyright);
#line 508 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->copyright = _tmp11_;
#line 509 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp12_ = g_strdup ("");
#line 509 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->software);
#line 509 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->software = _tmp12_;
#line 510 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp13_ = g_strdup ("");
#line 510 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_bias);
#line 510 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->exposure_bias = _tmp13_;
#line 511 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp14_ = g_strdup ("");
#line 511 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_date);
#line 511 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->exposure_date = _tmp14_;
#line 512 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp15_ = g_strdup ("");
#line 512 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_time);
#line 512 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->exposure_time = _tmp15_;
#line 513 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp16_ = g_strdup ("");
#line 513 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->comment);
#line 513 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->comment = _tmp16_;
#line 4195 "Properties.c"
}


static void
extended_properties_window_extended_properties_real_get_single_properties (Properties* base,
                                                                           DataView* view)
{
	ExtendedPropertiesWindowExtendedProperties * self;
	DataSource* source = NULL;
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	DataSource* _tmp2_;
	GError * _inner_error_ = NULL;
#line 516 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedProperties);
#line 516 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 517 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (extended_properties_window_extended_properties_parent_class)->get_single_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), view);
#line 519 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = data_view_get_source (view);
#line 519 "/home/jens/Source/shotwell/src/Properties.vala"
	source = _tmp0_;
#line 520 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = source;
#line 520 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp1_ == NULL) {
#line 521 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (source);
#line 521 "/home/jens/Source/shotwell/src/Properties.vala"
		return;
#line 4227 "Properties.c"
	}
#line 523 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = source;
#line 523 "/home/jens/Source/shotwell/src/Properties.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_MEDIA_SOURCE)) {
#line 4233 "Properties.c"
		MediaSource* media = NULL;
		DataSource* _tmp3_;
		MediaSource* _tmp4_;
		MediaSource* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		MediaSource* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		gchar* _tmp12_;
		MediaSource* _tmp13_;
		Photo* photo = NULL;
		MediaSource* _tmp14_;
		Photo* _tmp15_;
		Photo* _tmp16_;
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp23_;
		PhotoMetadata* _tmp24_;
		MetadataDateTime* _tmp25_;
		MetadataDateTime* _tmp26_;
		gboolean _tmp27_;
		Photo* _tmp32_;
		PhotoMetadata* _tmp33_;
		Dimensions* _tmp34_;
		PhotoMetadata* _tmp35_;
		gchar* _tmp36_;
		PhotoMetadata* _tmp37_;
		gchar* _tmp38_;
		PhotoMetadata* _tmp39_;
		gchar* _tmp40_;
		PhotoMetadata* _tmp41_;
		gchar* _tmp42_;
		PhotoMetadata* _tmp43_;
		gdouble _tmp44_ = 0.0;
		gchar* _tmp45_ = NULL;
		gdouble _tmp46_ = 0.0;
		gchar* _tmp47_ = NULL;
		gdouble _tmp48_ = 0.0;
		PhotoMetadata* _tmp49_;
		gchar* _tmp50_;
		PhotoMetadata* _tmp51_;
		gchar* _tmp52_;
		PhotoMetadata* _tmp53_;
		gchar* _tmp54_;
		PhotoMetadata* _tmp55_;
		gchar* _tmp56_;
		time_t exposure_time_obj = 0;
		PhotoMetadata* _tmp57_;
		MetadataDateTime* _tmp58_;
		MetadataDateTime* _tmp59_;
		time_t _tmp60_;
		time_t _tmp61_;
		struct tm _tmp62_ = {0};
		gchar* _tmp63_;
		time_t _tmp64_;
		struct tm _tmp65_ = {0};
		gchar* _tmp66_;
		MediaSource* _tmp67_;
		gchar* _tmp68_;
#line 524 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp3_ = source;
#line 524 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MEDIA_SOURCE, MediaSource));
#line 524 "/home/jens/Source/shotwell/src/Properties.vala"
		media = _tmp4_;
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp5_ = media;
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = media_source_get_master_file (_tmp5_);
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = _tmp6_;
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp8_ = g_file_get_path (_tmp7_);
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->file_path);
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->file_path = _tmp8_;
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (_tmp7_);
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = media;
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp10_ = media_source_get_file (_tmp9_);
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = _tmp10_;
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = g_file_get_path (_tmp11_);
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->development_path);
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->development_path = _tmp12_;
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (_tmp11_);
#line 527 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp13_ = media;
#line 527 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->filesize = media_source_get_master_filesize (_tmp13_);
#line 532 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp14_ = media;
#line 532 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, TYPE_PHOTO) ? ((Photo*) _tmp14_) : NULL);
#line 532 "/home/jens/Source/shotwell/src/Properties.vala"
		photo = _tmp15_;
#line 533 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp16_ = photo;
#line 533 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp16_ == NULL) {
#line 534 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (photo);
#line 534 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (media);
#line 534 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (source);
#line 534 "/home/jens/Source/shotwell/src/Properties.vala"
			return;
#line 4350 "Properties.c"
		}
		{
			PhotoMetadata* _tmp17_ = NULL;
			Photo* _tmp18_;
			PhotoMetadata* _tmp19_;
			PhotoMetadata* _tmp20_;
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp18_ = photo;
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = photo_get_master_metadata (_tmp18_, &_inner_error_);
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp17_ = _tmp19_;
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4365 "Properties.c"
				goto __catch442_g_error;
			}
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = _tmp17_;
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp17_ = NULL;
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (metadata);
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			metadata = _tmp20_;
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (_tmp17_);
#line 4378 "Properties.c"
		}
		goto __finally442;
		__catch442_g_error:
		{
			GError* e = NULL;
			Photo* _tmp21_;
			PhotoMetadata* _tmp22_;
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			e = _inner_error_;
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_inner_error_ = NULL;
#line 545 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp21_ = photo;
#line 545 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp22_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_PHOTO_SOURCE, PhotoSource));
#line 545 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (metadata);
#line 545 "/home/jens/Source/shotwell/src/Properties.vala"
			metadata = _tmp22_;
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_error_free0 (e);
#line 4400 "Properties.c"
		}
		__finally442:
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (metadata);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (photo);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (media);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (source);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			g_clear_error (&_inner_error_);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			return;
#line 4419 "Properties.c"
		}
#line 548 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp23_ = metadata;
#line 548 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp23_ == NULL) {
#line 549 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (metadata);
#line 549 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (photo);
#line 549 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (media);
#line 549 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (source);
#line 549 "/home/jens/Source/shotwell/src/Properties.vala"
			return;
#line 4435 "Properties.c"
		}
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp24_ = metadata;
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp25_ = photo_metadata_get_exposure_date_time (_tmp24_);
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp26_ = _tmp25_;
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp27_ = _tmp26_ == NULL;
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		_metadata_date_time_unref0 (_tmp26_);
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp27_) {
#line 4449 "Properties.c"
			PhotoMetadata* _tmp28_;
			Photo* _tmp29_;
			MetadataDateTime* _tmp30_;
			MetadataDateTime* _tmp31_;
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp28_ = metadata;
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp29_ = photo;
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp30_ = metadata_date_time_new (media_source_get_timestamp (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_MEDIA_SOURCE, MediaSource)));
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp31_ = _tmp30_;
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			photo_metadata_set_exposure_date_time (_tmp28_, _tmp31_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_metadata_date_time_unref0 (_tmp31_);
#line 4466 "Properties.c"
		}
#line 559 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp32_ = photo;
#line 559 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->is_raw = photo_get_master_file_format (_tmp32_) == PHOTO_FILE_FORMAT_RAW;
#line 560 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp33_ = metadata;
#line 560 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp34_ = photo_metadata_get_pixel_dimensions (_tmp33_);
#line 560 "/home/jens/Source/shotwell/src/Properties.vala"
		_dimensions_free0 (self->priv->original_dim);
#line 560 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->original_dim = _tmp34_;
#line 561 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp35_ = metadata;
#line 561 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp36_ = photo_metadata_get_camera_make (_tmp35_);
#line 561 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->camera_make);
#line 561 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->camera_make = _tmp36_;
#line 562 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp37_ = metadata;
#line 562 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp38_ = photo_metadata_get_camera_model (_tmp37_);
#line 562 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->camera_model);
#line 562 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->camera_model = _tmp38_;
#line 563 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp39_ = metadata;
#line 563 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp40_ = photo_metadata_get_flash_string (_tmp39_);
#line 563 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->flash);
#line 563 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->flash = _tmp40_;
#line 564 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp41_ = metadata;
#line 564 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp42_ = photo_metadata_get_focal_length_string (_tmp41_);
#line 564 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->focal_length);
#line 564 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->focal_length = _tmp42_;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp43_ = metadata;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		photo_metadata_get_gps (_tmp43_, &_tmp44_, &_tmp45_, &_tmp46_, &_tmp47_, &_tmp48_);
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->gps_long = _tmp44_;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->gps_long_ref);
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->gps_long_ref = _tmp45_;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->gps_lat = _tmp46_;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->gps_lat_ref);
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->gps_lat_ref = _tmp47_;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->gps_alt = _tmp48_;
#line 566 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp49_ = metadata;
#line 566 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp50_ = photo_metadata_get_artist (_tmp49_);
#line 566 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->artist);
#line 566 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->artist = _tmp50_;
#line 567 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp51_ = metadata;
#line 567 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp52_ = photo_metadata_get_copyright (_tmp51_);
#line 567 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->copyright);
#line 567 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->copyright = _tmp52_;
#line 568 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp53_ = metadata;
#line 568 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp54_ = photo_metadata_get_software (_tmp53_);
#line 568 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->software);
#line 568 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->software = _tmp54_;
#line 569 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp55_ = metadata;
#line 569 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp56_ = photo_metadata_get_exposure_bias (_tmp55_);
#line 569 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->exposure_bias);
#line 569 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->exposure_bias = _tmp56_;
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp57_ = metadata;
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp58_ = photo_metadata_get_exposure_date_time (_tmp57_);
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp59_ = _tmp58_;
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp60_ = metadata_date_time_get_timestamp (_tmp59_);
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_metadata_date_time_unref0 (_tmp59_);
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		exposure_time_obj = _tmp60_;
#line 571 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp61_ = exposure_time_obj;
#line 571 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp61_, &_tmp62_);
#line 571 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp63_ = properties_get_prettyprint_date (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp62_);
#line 571 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->exposure_date);
#line 571 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->exposure_date = _tmp63_;
#line 572 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp64_ = exposure_time_obj;
#line 572 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp64_, &_tmp65_);
#line 572 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp66_ = properties_get_prettyprint_time_with_seconds (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp65_);
#line 572 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->exposure_time);
#line 572 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->exposure_time = _tmp66_;
#line 573 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp67_ = media;
#line 573 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp68_ = media_source_get_comment (_tmp67_);
#line 573 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->comment);
#line 573 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->comment = _tmp68_;
#line 523 "/home/jens/Source/shotwell/src/Properties.vala"
		_media_metadata_unref0 (metadata);
#line 523 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (photo);
#line 523 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (media);
#line 4608 "Properties.c"
	} else {
		DataSource* _tmp69_;
#line 574 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp69_ = source;
#line 574 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, TYPE_EVENT_SOURCE)) {
#line 4615 "Properties.c"
			Event* event = NULL;
			DataSource* _tmp70_;
			Event* _tmp71_;
			Event* _tmp72_;
			gchar* _tmp73_;
#line 575 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp70_ = source;
#line 575 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, TYPE_EVENT, Event));
#line 575 "/home/jens/Source/shotwell/src/Properties.vala"
			event = _tmp71_;
#line 576 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp72_ = event;
#line 576 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp73_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, TYPE_EVENT_SOURCE, EventSource));
#line 576 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->comment);
#line 576 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->comment = _tmp73_;
#line 574 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (event);
#line 4637 "Properties.c"
		}
	}
#line 516 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (source);
#line 4642 "Properties.c"
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 4665 "Properties.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 4669 "Properties.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 4675 "Properties.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 4679 "Properties.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 4683 "Properties.c"
		gchar* _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 4691 "Properties.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		regex = _tmp6_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4719 "Properties.c"
				goto __catch443_g_regex_error;
			}
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 4728 "Properties.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp8_ = regex;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4742 "Properties.c"
				goto __catch443_g_regex_error;
			}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 4753 "Properties.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp10_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 4767 "Properties.c"
	}
	goto __finally443;
	__catch443_g_regex_error:
	{
		GError* e = NULL;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1429 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 4781 "Properties.c"
	}
	__finally443:
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return NULL;
#line 4792 "Properties.c"
	}
}


static void
extended_properties_window_extended_properties_real_internal_update_properties (Properties* base,
                                                                                Page* page)
{
	ExtendedPropertiesWindowExtendedProperties * self;
	gboolean _tmp94_ = FALSE;
	const gchar* _tmp95_;
	gboolean has_comment = FALSE;
	const gchar* _tmp97_ = NULL;
	gboolean _tmp98_;
	gboolean _tmp100_;
#line 580 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedProperties);
#line 580 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (page));
#line 581 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (extended_properties_window_extended_properties_parent_class)->internal_update_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), page);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (page, TYPE_EVENTS_DIRECTORY_PAGE)) {
#line 4816 "Properties.c"
	} else {
		gchar* _tmp0_ = NULL;
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		gchar* _tmp7_ = NULL;
		guint64 _tmp8_;
		gboolean _tmp12_;
		gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		Dimensions* _tmp16_;
		const gchar* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		const gchar* _tmp26_;
		const gchar* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp31_;
		const gchar* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_;
		const gchar* _tmp39_ = NULL;
		gboolean _tmp40_ = FALSE;
		const gchar* _tmp41_;
		const gchar* _tmp44_ = NULL;
		gboolean _tmp45_ = FALSE;
		const gchar* _tmp46_;
		const gchar* _tmp49_ = NULL;
		gboolean _tmp50_ = FALSE;
		const gchar* _tmp51_;
		const gchar* _tmp54_ = NULL;
		gboolean _tmp55_ = FALSE;
		const gchar* _tmp56_;
		gchar* _tmp59_ = NULL;
		gboolean _tmp60_ = FALSE;
		gboolean _tmp61_ = FALSE;
		gdouble _tmp62_;
		gchar* _tmp69_ = NULL;
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		gdouble _tmp72_;
		const gchar* _tmp79_ = NULL;
		gboolean _tmp80_ = FALSE;
		const gchar* _tmp81_;
		const gchar* _tmp84_ = NULL;
		gboolean _tmp85_ = FALSE;
		const gchar* _tmp86_;
		const gchar* _tmp89_ = NULL;
		gboolean _tmp90_ = FALSE;
		const gchar* _tmp91_;
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp2_ = self->priv->file_path;
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp2_, "") != 0) {
#line 4869 "Properties.c"
			const gchar* _tmp3_;
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp3_ = self->priv->file_path;
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp1_ = _tmp3_ != NULL;
#line 4875 "Properties.c"
		} else {
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp1_ = FALSE;
#line 4879 "Properties.c"
		}
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp1_) {
#line 4883 "Properties.c"
			const gchar* _tmp4_;
			gchar* _tmp5_;
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp4_ = self->priv->file_path;
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp5_ = string_replace (_tmp4_, "&", "&amp;");
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp0_);
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp0_ = _tmp5_;
#line 4894 "Properties.c"
		} else {
			gchar* _tmp6_;
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp6_ = g_strdup (EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE);
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp0_);
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp0_ = _tmp6_;
#line 4903 "Properties.c"
		}
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Location:"), _tmp0_, FALSE);
#line 589 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp8_ = self->priv->filesize;
#line 589 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp8_ > ((guint64) 0)) {
#line 4911 "Properties.c"
			guint64 _tmp9_;
			gchar* _tmp10_;
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp9_ = self->priv->filesize;
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp10_ = g_format_size_full ((guint64) ((gint64) _tmp9_), G_FORMAT_SIZE_DEFAULT);
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp7_);
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp7_ = _tmp10_;
#line 4922 "Properties.c"
		} else {
			gchar* _tmp11_;
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp11_ = g_strdup (EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE);
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp7_);
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp7_ = _tmp11_;
#line 4931 "Properties.c"
		}
#line 589 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("File size:"), _tmp7_, FALSE);
#line 592 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = self->priv->is_raw;
#line 592 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp12_) {
#line 4939 "Properties.c"
			const gchar* _tmp13_;
#line 593 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp13_ = self->priv->development_path;
#line 593 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Current Development:"), _tmp13_, FALSE);
#line 4945 "Properties.c"
		}
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp16_ = self->priv->original_dim;
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp16_ != NULL) {
#line 4951 "Properties.c"
			Dimensions* _tmp17_;
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp17_ = self->priv->original_dim;
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp15_ = dimensions_has_area (_tmp17_);
#line 4957 "Properties.c"
		} else {
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp15_ = FALSE;
#line 4961 "Properties.c"
		}
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp15_) {
#line 4965 "Properties.c"
			Dimensions* _tmp18_;
			gint _tmp19_;
			Dimensions* _tmp20_;
			gint _tmp21_;
			gchar* _tmp22_;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp18_ = self->priv->original_dim;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = (*_tmp18_).width;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = self->priv->original_dim;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp21_ = (*_tmp20_).height;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp22_ = g_strdup_printf ("%d &#215; %d", _tmp19_, _tmp21_);
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp14_);
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp14_ = _tmp22_;
#line 4985 "Properties.c"
		} else {
			gchar* _tmp23_;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp23_ = g_strdup (EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE);
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp14_);
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp14_ = _tmp23_;
#line 4994 "Properties.c"
		}
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Original dimensions:"), _tmp14_, FALSE);
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp26_ = self->priv->camera_make;
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp26_, "") != 0) {
#line 5002 "Properties.c"
			const gchar* _tmp27_;
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp27_ = self->priv->camera_make;
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp25_ = _tmp27_ != NULL;
#line 5008 "Properties.c"
		} else {
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp25_ = FALSE;
#line 5012 "Properties.c"
		}
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp25_) {
#line 5016 "Properties.c"
			const gchar* _tmp28_;
#line 599 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp28_ = self->priv->camera_make;
#line 599 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp24_ = _tmp28_;
#line 5022 "Properties.c"
		} else {
#line 599 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp24_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5026 "Properties.c"
		}
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Camera make:"), _tmp24_, FALSE);
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp31_ = self->priv->camera_model;
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp31_, "") != 0) {
#line 5034 "Properties.c"
			const gchar* _tmp32_;
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp32_ = self->priv->camera_model;
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp30_ = _tmp32_ != NULL;
#line 5040 "Properties.c"
		} else {
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp30_ = FALSE;
#line 5044 "Properties.c"
		}
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp30_) {
#line 5048 "Properties.c"
			const gchar* _tmp33_;
#line 602 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp33_ = self->priv->camera_model;
#line 602 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp29_ = _tmp33_;
#line 5054 "Properties.c"
		} else {
#line 602 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp29_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5058 "Properties.c"
		}
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Camera model:"), _tmp29_, FALSE);
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp36_ = self->priv->flash;
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp36_, "") != 0) {
#line 5066 "Properties.c"
			const gchar* _tmp37_;
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp37_ = self->priv->flash;
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp35_ = _tmp37_ != NULL;
#line 5072 "Properties.c"
		} else {
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp35_ = FALSE;
#line 5076 "Properties.c"
		}
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp35_) {
#line 5080 "Properties.c"
			const gchar* _tmp38_;
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp38_ = self->priv->flash;
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp34_ = _tmp38_;
#line 5086 "Properties.c"
		} else {
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp34_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5090 "Properties.c"
		}
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Flash:"), _tmp34_, FALSE);
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp41_ = self->priv->focal_length;
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp41_, "") != 0) {
#line 5098 "Properties.c"
			const gchar* _tmp42_;
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp42_ = self->priv->focal_length;
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp40_ = _tmp42_ != NULL;
#line 5104 "Properties.c"
		} else {
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp40_ = FALSE;
#line 5108 "Properties.c"
		}
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp40_) {
#line 5112 "Properties.c"
			const gchar* _tmp43_;
#line 607 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp43_ = self->priv->focal_length;
#line 607 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp39_ = _tmp43_;
#line 5118 "Properties.c"
		} else {
#line 607 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp39_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5122 "Properties.c"
		}
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Focal length:"), _tmp39_, FALSE);
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp46_ = self->priv->exposure_date;
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp46_, "") != 0) {
#line 5130 "Properties.c"
			const gchar* _tmp47_;
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp47_ = self->priv->exposure_date;
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp45_ = _tmp47_ != NULL;
#line 5136 "Properties.c"
		} else {
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp45_ = FALSE;
#line 5140 "Properties.c"
		}
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp45_) {
#line 5144 "Properties.c"
			const gchar* _tmp48_;
#line 610 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp48_ = self->priv->exposure_date;
#line 610 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp44_ = _tmp48_;
#line 5150 "Properties.c"
		} else {
#line 610 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp44_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5154 "Properties.c"
		}
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure date:"), _tmp44_, FALSE);
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp51_ = self->priv->exposure_time;
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp51_, "") != 0) {
#line 5162 "Properties.c"
			const gchar* _tmp52_;
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp52_ = self->priv->exposure_time;
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp50_ = _tmp52_ != NULL;
#line 5168 "Properties.c"
		} else {
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp50_ = FALSE;
#line 5172 "Properties.c"
		}
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp50_) {
#line 5176 "Properties.c"
			const gchar* _tmp53_;
#line 613 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp53_ = self->priv->exposure_time;
#line 613 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp49_ = _tmp53_;
#line 5182 "Properties.c"
		} else {
#line 613 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp49_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5186 "Properties.c"
		}
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure time:"), _tmp49_, FALSE);
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp56_ = self->priv->exposure_bias;
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp56_, "") != 0) {
#line 5194 "Properties.c"
			const gchar* _tmp57_;
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp57_ = self->priv->exposure_bias;
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp55_ = _tmp57_ != NULL;
#line 5200 "Properties.c"
		} else {
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp55_ = FALSE;
#line 5204 "Properties.c"
		}
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp55_) {
#line 5208 "Properties.c"
			const gchar* _tmp58_;
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp58_ = self->priv->exposure_bias;
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp54_ = _tmp58_;
#line 5214 "Properties.c"
		} else {
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp54_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5218 "Properties.c"
		}
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Exposure bias:"), _tmp54_, FALSE);
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp62_ = self->priv->gps_lat;
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp62_ != ((gdouble) -1)) {
#line 5226 "Properties.c"
			const gchar* _tmp63_;
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp63_ = self->priv->gps_lat_ref;
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp61_ = g_strcmp0 (_tmp63_, "") != 0;
#line 5232 "Properties.c"
		} else {
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp61_ = FALSE;
#line 5236 "Properties.c"
		}
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp61_) {
#line 5240 "Properties.c"
			const gchar* _tmp64_;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp64_ = self->priv->gps_lat_ref;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp60_ = _tmp64_ != NULL;
#line 5246 "Properties.c"
		} else {
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp60_ = FALSE;
#line 5250 "Properties.c"
		}
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp60_) {
#line 5254 "Properties.c"
			gdouble _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp65_ = self->priv->gps_lat;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp66_ = self->priv->gps_lat_ref;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp67_ = g_strdup_printf ("%f °%s", _tmp65_, _tmp66_);
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp59_);
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp59_ = _tmp67_;
#line 5268 "Properties.c"
		} else {
			gchar* _tmp68_;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp68_ = g_strdup (EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE);
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp59_);
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp59_ = _tmp68_;
#line 5277 "Properties.c"
		}
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("GPS latitude:"), _tmp59_, FALSE);
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp72_ = self->priv->gps_long;
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp72_ != ((gdouble) -1)) {
#line 5285 "Properties.c"
			const gchar* _tmp73_;
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp73_ = self->priv->gps_long_ref;
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp71_ = g_strcmp0 (_tmp73_, "") != 0;
#line 5291 "Properties.c"
		} else {
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp71_ = FALSE;
#line 5295 "Properties.c"
		}
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp71_) {
#line 5299 "Properties.c"
			const gchar* _tmp74_;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp74_ = self->priv->gps_long_ref;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp70_ = _tmp74_ != NULL;
#line 5305 "Properties.c"
		} else {
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp70_ = FALSE;
#line 5309 "Properties.c"
		}
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp70_) {
#line 5313 "Properties.c"
			gdouble _tmp75_;
			const gchar* _tmp76_;
			gchar* _tmp77_;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp75_ = self->priv->gps_long;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp76_ = self->priv->gps_long_ref;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp77_ = g_strdup_printf ("%f °%s", _tmp75_, _tmp76_);
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp69_);
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp69_ = _tmp77_;
#line 5327 "Properties.c"
		} else {
			gchar* _tmp78_;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp78_ = g_strdup (EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE);
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp69_);
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp69_ = _tmp78_;
#line 5336 "Properties.c"
		}
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("GPS longitude:"), _tmp69_, FALSE);
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp81_ = self->priv->artist;
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp81_, "") != 0) {
#line 5344 "Properties.c"
			const gchar* _tmp82_;
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp82_ = self->priv->artist;
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp80_ = _tmp82_ != NULL;
#line 5350 "Properties.c"
		} else {
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp80_ = FALSE;
#line 5354 "Properties.c"
		}
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp80_) {
#line 5358 "Properties.c"
			const gchar* _tmp83_;
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp83_ = self->priv->artist;
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp79_ = _tmp83_;
#line 5364 "Properties.c"
		} else {
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp79_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5368 "Properties.c"
		}
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Artist:"), _tmp79_, FALSE);
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp86_ = self->priv->copyright;
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp86_, "") != 0) {
#line 5376 "Properties.c"
			const gchar* _tmp87_;
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp87_ = self->priv->copyright;
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp85_ = _tmp87_ != NULL;
#line 5382 "Properties.c"
		} else {
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp85_ = FALSE;
#line 5386 "Properties.c"
		}
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp85_) {
#line 5390 "Properties.c"
			const gchar* _tmp88_;
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp88_ = self->priv->copyright;
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp84_ = _tmp88_;
#line 5396 "Properties.c"
		} else {
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp84_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5400 "Properties.c"
		}
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Copyright:"), _tmp84_, FALSE);
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp91_ = self->priv->software;
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp91_, "") != 0) {
#line 5408 "Properties.c"
			const gchar* _tmp92_;
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp92_ = self->priv->software;
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp90_ = _tmp92_ != NULL;
#line 5414 "Properties.c"
		} else {
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp90_ = FALSE;
#line 5418 "Properties.c"
		}
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp90_) {
#line 5422 "Properties.c"
			const gchar* _tmp93_;
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp93_ = self->priv->software;
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp89_ = _tmp93_;
#line 5428 "Properties.c"
		} else {
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp89_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5432 "Properties.c"
		}
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Software:"), _tmp89_, FALSE);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp69_);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp59_);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp14_);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp7_);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp0_);
#line 5446 "Properties.c"
	}
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp95_ = self->priv->comment;
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp95_, "") != 0) {
#line 5452 "Properties.c"
		const gchar* _tmp96_;
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp96_ = self->priv->comment;
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp94_ = _tmp96_ != NULL;
#line 5458 "Properties.c"
	} else {
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp94_ = FALSE;
#line 5462 "Properties.c"
	}
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
	has_comment = _tmp94_;
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp98_ = has_comment;
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp98_) {
#line 5470 "Properties.c"
		const gchar* _tmp99_;
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp99_ = self->priv->comment;
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp97_ = _tmp99_;
#line 5476 "Properties.c"
	} else {
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp97_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5480 "Properties.c"
	}
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp100_ = has_comment;
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _ ("Comment:"), _tmp97_, _tmp100_);
#line 5486 "Properties.c"
}


static ExtendedPropertiesWindowExtendedProperties*
extended_properties_window_extended_properties_construct (GType object_type)
{
	ExtendedPropertiesWindowExtendedProperties * self = NULL;
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	self = (ExtendedPropertiesWindowExtendedProperties*) properties_construct (object_type);
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	return self;
#line 5498 "Properties.c"
}


static ExtendedPropertiesWindowExtendedProperties*
extended_properties_window_extended_properties_new (void)
{
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	return extended_properties_window_extended_properties_construct (EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES);
#line 5507 "Properties.c"
}


static void
extended_properties_window_extended_properties_class_init (ExtendedPropertiesWindowExtendedPropertiesClass * klass)
{
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	extended_properties_window_extended_properties_parent_class = g_type_class_peek_parent (klass);
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	g_type_class_add_private (klass, sizeof (ExtendedPropertiesWindowExtendedPropertiesPrivate));
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->clear_properties = (void (*) (Properties *)) extended_properties_window_extended_properties_real_clear_properties;
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_single_properties = (void (*) (Properties *, DataView*)) extended_properties_window_extended_properties_real_get_single_properties;
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->internal_update_properties = (void (*) (Properties *, Page*)) extended_properties_window_extended_properties_real_internal_update_properties;
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (klass)->finalize = extended_properties_window_extended_properties_finalize;
#line 5526 "Properties.c"
}


static void
extended_properties_window_extended_properties_instance_init (ExtendedPropertiesWindowExtendedProperties * self)
{
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_GET_PRIVATE (self);
#line 5535 "Properties.c"
}


static void
extended_properties_window_extended_properties_finalize (GObject * obj)
{
	ExtendedPropertiesWindowExtendedProperties * self;
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedProperties);
#line 463 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->file_path);
#line 465 "/home/jens/Source/shotwell/src/Properties.vala"
	_dimensions_free0 (self->priv->original_dim);
#line 466 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->camera_make);
#line 467 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->camera_model);
#line 468 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->flash);
#line 469 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->focal_length);
#line 471 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->gps_lat_ref);
#line 473 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->gps_long_ref);
#line 475 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->artist);
#line 476 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->copyright);
#line 477 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->software);
#line 478 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_bias);
#line 479 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_date);
#line 480 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_time);
#line 482 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->development_path);
#line 489 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->comment);
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (extended_properties_window_extended_properties_parent_class)->finalize (obj);
#line 5579 "Properties.c"
}


static GType
extended_properties_window_extended_properties_get_type (void)
{
	static volatile gsize extended_properties_window_extended_properties_type_id__volatile = 0;
	if (g_once_init_enter (&extended_properties_window_extended_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExtendedPropertiesWindowExtendedPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) extended_properties_window_extended_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExtendedPropertiesWindowExtendedProperties), 0, (GInstanceInitFunc) extended_properties_window_extended_properties_instance_init, NULL };
		GType extended_properties_window_extended_properties_type_id;
		extended_properties_window_extended_properties_type_id = g_type_register_static (TYPE_PROPERTIES, "ExtendedPropertiesWindowExtendedProperties", &g_define_type_info, 0);
		g_once_init_leave (&extended_properties_window_extended_properties_type_id__volatile, extended_properties_window_extended_properties_type_id);
	}
	return extended_properties_window_extended_properties_type_id__volatile;
}


static void
extended_properties_window_class_init (ExtendedPropertiesWindowClass * klass)
{
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	extended_properties_window_parent_class = g_type_class_peek_parent (klass);
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	g_type_class_add_private (klass, sizeof (ExtendedPropertiesWindowPrivate));
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) extended_properties_window_real_button_press_event;
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget *, GdkEventKey*)) extended_properties_window_real_key_press_event;
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	((GtkWidgetClass *) klass)->show_all = (void (*) (GtkWidget *)) extended_properties_window_real_show_all;
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (klass)->finalize = extended_properties_window_finalize;
#line 5612 "Properties.c"
}


static void
extended_properties_window_instance_init (ExtendedPropertiesWindow * self)
{
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv = EXTENDED_PROPERTIES_WINDOW_GET_PRIVATE (self);
#line 458 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->properties = NULL;
#line 5623 "Properties.c"
}


static void
extended_properties_window_finalize (GObject * obj)
{
	ExtendedPropertiesWindow * self;
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindow);
#line 458 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (self->priv->properties);
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (extended_properties_window_parent_class)->finalize (obj);
#line 5637 "Properties.c"
}


GType
extended_properties_window_get_type (void)
{
	static volatile gsize extended_properties_window_type_id__volatile = 0;
	if (g_once_init_enter (&extended_properties_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExtendedPropertiesWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) extended_properties_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExtendedPropertiesWindow), 0, (GInstanceInitFunc) extended_properties_window_instance_init, NULL };
		GType extended_properties_window_type_id;
		extended_properties_window_type_id = g_type_register_static (gtk_dialog_get_type (), "ExtendedPropertiesWindow", &g_define_type_info, 0);
		g_once_init_leave (&extended_properties_window_type_id__volatile, extended_properties_window_type_id);
	}
	return extended_properties_window_type_id__volatile;
}



