/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:4
let $0 = instantiate(`(module
  (func (export "i16x8.extmul_low_i8x16_s") (param v128 v128) (result v128) (i16x8.extmul_low_i8x16_s (local.get 0) (local.get 1)))
  (func (export "i16x8.extmul_high_i8x16_s") (param v128 v128) (result v128) (i16x8.extmul_high_i8x16_s (local.get 0) (local.get 1)))
  (func (export "i16x8.extmul_low_i8x16_u") (param v128 v128) (result v128) (i16x8.extmul_low_i8x16_u (local.get 0) (local.get 1)))
  (func (export "i16x8.extmul_high_i8x16_u") (param v128 v128) (result v128) (i16x8.extmul_high_i8x16_u (local.get 0) (local.get 1)))
)`);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:13
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:16
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:19
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:22
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:25
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:28
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:31
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i16x8([0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:34
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i16x8([0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:37
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:40
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:43
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0x1040, 0x1040, 0x1040, 0x1040, 0x1040, 0x1040, 0x1040, 0x1040])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:46
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:49
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:52
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:55
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:58
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:61
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:64
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i16x8([0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:67
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:70
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
    ]),
  [i16x8([0x3f80, 0x3f80, 0x3f80, 0x3f80, 0x3f80, 0x3f80, 0x3f80, 0x3f80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:73
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:76
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:79
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:82
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i16x8([0xff81, 0xff81, 0xff81, 0xff81, 0xff81, 0xff81, 0xff81, 0xff81])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:85
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:88
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:93
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:96
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:99
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:102
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:105
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:108
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:111
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i16x8([0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:114
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i16x8([0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:117
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:120
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:123
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0x1040, 0x1040, 0x1040, 0x1040, 0x1040, 0x1040, 0x1040, 0x1040])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:126
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:129
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:132
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80, 0xff80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:135
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:138
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:141
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:144
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i16x8([0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:147
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:150
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
    ]),
  [i16x8([0x3f80, 0x3f80, 0x3f80, 0x3f80, 0x3f80, 0x3f80, 0x3f80, 0x3f80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:153
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:156
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:159
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:162
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i16x8([0xff81, 0xff81, 0xff81, 0xff81, 0xff81, 0xff81, 0xff81, 0xff81])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:165
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:168
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_s`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:173
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:176
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:179
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:182
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:185
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:188
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:191
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i16x8([0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:194
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i16x8([0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:197
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0x90c0, 0x90c0, 0x90c0, 0x90c0, 0x90c0, 0x90c0, 0x90c0, 0x90c0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:200
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0x9000, 0x9000, 0x9000, 0x9000, 0x9000, 0x9000, 0x9000, 0x9000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:203
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0x8f40, 0x8f40, 0x8f40, 0x8f40, 0x8f40, 0x8f40, 0x8f40, 0x8f40])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:206
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:209
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:212
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:215
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x817e, 0x817e, 0x817e, 0x817e, 0x817e, 0x817e, 0x817e, 0x817e])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:218
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x807f, 0x807f, 0x807f, 0x807f, 0x807f, 0x807f, 0x807f, 0x807f])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:221
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:224
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i16x8([0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:227
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:230
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
    ]),
  [i16x8([0x4080, 0x4080, 0x4080, 0x4080, 0x4080, 0x4080, 0x4080, 0x4080])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:233
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:236
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:239
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:242
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i16x8([0x7e81, 0x7e81, 0x7e81, 0x7e81, 0x7e81, 0x7e81, 0x7e81, 0x7e81])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:245
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i16x8([0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:248
assert_return(
  () =>
    invoke($0, `i16x8.extmul_low_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:253
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:256
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:259
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:262
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:265
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:268
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:271
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i16x8([0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0, 0xfc0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:274
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i16x8([0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:277
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0x90c0, 0x90c0, 0x90c0, 0x90c0, 0x90c0, 0x90c0, 0x90c0, 0x90c0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:280
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0x9000, 0x9000, 0x9000, 0x9000, 0x9000, 0x9000, 0x9000, 0x9000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:283
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i16x8([0x8f40, 0x8f40, 0x8f40, 0x8f40, 0x8f40, 0x8f40, 0x8f40, 0x8f40])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:286
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:289
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:292
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:295
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x817e, 0x817e, 0x817e, 0x817e, 0x817e, 0x817e, 0x817e, 0x817e])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:298
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x807f, 0x807f, 0x807f, 0x807f, 0x807f, 0x807f, 0x807f, 0x807f])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:301
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:304
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i16x8([0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01, 0x3f01])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:307
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:310
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
    ]),
  [i16x8([0x4080, 0x4080, 0x4080, 0x4080, 0x4080, 0x4080, 0x4080, 0x4080])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:313
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:316
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i16x8([0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:319
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:322
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i16x8([0x7e81, 0x7e81, 0x7e81, 0x7e81, 0x7e81, 0x7e81, 0x7e81, 0x7e81])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:325
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i16x8([0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80, 0x7f80])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:328
assert_return(
  () =>
    invoke($0, `i16x8.extmul_high_i8x16_u`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i16x8([0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01, 0xfe01])],
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:333
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.extmul_low_i8x16_s (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:334
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.extmul_high_i8x16_s (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:335
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.extmul_low_i8x16_u (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:336
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.extmul_high_i8x16_u (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:340
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.extmul_low_i8x16_s-1st-arg-empty (result v128)
      (i16x8.extmul_low_i8x16_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:348
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.extmul_low_i8x16_s-arg-empty (result v128)
      (i16x8.extmul_low_i8x16_s)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:356
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.extmul_high_i8x16_s-1st-arg-empty (result v128)
      (i16x8.extmul_high_i8x16_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:364
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.extmul_high_i8x16_s-arg-empty (result v128)
      (i16x8.extmul_high_i8x16_s)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:372
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.extmul_low_i8x16_u-1st-arg-empty (result v128)
      (i16x8.extmul_low_i8x16_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:380
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.extmul_low_i8x16_u-arg-empty (result v128)
      (i16x8.extmul_low_i8x16_u)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:388
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.extmul_high_i8x16_u-1st-arg-empty (result v128)
      (i16x8.extmul_high_i8x16_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_extmul_i8x16.wast:396
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.extmul_high_i8x16_u-arg-empty (result v128)
      (i16x8.extmul_high_i8x16_u)
    )
  )`), `type mismatch`);
