/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.beans;

import java.lang.reflect.Method;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoableEdit;

public class PropertyChangeEdit
extends AbstractUndoableEdit {
    private Object source;
    private String propertyName;
    private Object oldValue;
    private Object newValue;
    private Class type;
    private String presentationName;

    public <T> PropertyChangeEdit(Object object, String string, Class<T> clazz, T t, T t2) {
        this.source = object;
        this.propertyName = this.presentationName = string;
        this.type = clazz;
        this.oldValue = t;
        this.newValue = t2;
    }

    public PropertyChangeEdit(Object object, String string, boolean bl, boolean bl2) {
        this(object, string, Boolean.TYPE, bl, bl2);
    }

    public PropertyChangeEdit(Object object, String string, int n, int n2) {
        this(object, string, Integer.TYPE, n, n2);
    }

    public PropertyChangeEdit(Object object, String string, long l, long l2) {
        this(object, string, Long.TYPE, l, l2);
    }

    public PropertyChangeEdit(Object object, String string, float f, float f2) {
        this(object, string, Float.TYPE, Float.valueOf(f), Float.valueOf(f2));
    }

    public PropertyChangeEdit(Object object, String string, double d, double d2) {
        this(object, string, Double.TYPE, d, d2);
    }

    public PropertyChangeEdit(Object object, String string, char c, char c2) {
        this(object, string, Character.TYPE, Character.valueOf(c), Character.valueOf(c2));
    }

    public PropertyChangeEdit(Object object, String string, String string2, String string3) {
        this(object, string, String.class, string2, string3);
    }

    protected Method getSetter() {
        try {
            return this.source.getClass().getMethod("set" + Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1), this.type);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Couldn't find setter for property \"" + this.propertyName + "\" in " + this.source);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    @Override
    public void undo() throws CannotRedoException {
        super.undo();
        try {
            this.getSetter().invoke(this.source, this.oldValue);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Couldn't invoke setter for property \"" + this.propertyName + "\" in " + this.source);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.getSetter().invoke(this.source, this.newValue);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Couldn't invoke setter for property \"" + this.propertyName + "\" in " + this.source);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    @Override
    public String getPresentationName() {
        return this.presentationName;
    }

    public void setPresentationName(String string) {
        this.presentationName = string;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof PropertyChangeEdit) {
            PropertyChangeEdit propertyChangeEdit = (PropertyChangeEdit)undoableEdit;
            if (propertyChangeEdit.source == this.source && propertyChangeEdit.propertyName.equals(this.propertyName)) {
                this.newValue = propertyChangeEdit.newValue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.propertyName + "," + this.oldValue + "," + this.newValue + "]";
    }
}

