/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef FB2BINARYCONTEXT_H_INCLUDED
#define FB2BINARYCONTEXT_H_INCLUDED

#include <string>

#include "FB2ParserContext.h"

namespace libebook
{

class FB2BinaryContext : public FB2NodeContextBase
{
public:
  FB2BinaryContext(FB2ParserContext *parentContext, FB2Collector *collector);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void endOfElement();
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *text);

private:
  std::string m_id;
  std::string m_contentType;
};

}

#endif // FB2BINARYCONTEXT_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
