/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IExtendedAnnotation;
import org.eclipse.jdt.core.util.IRuntimeInvisibleTypeAnnotationsAttribute;
import org.eclipse.jdt.internal.core.util.ClassFileAttribute;
import org.eclipse.jdt.internal.core.util.ExtendedAnnotation;

public class RuntimeInvisibleTypeAnnotationsAttribute
extends ClassFileAttribute
implements IRuntimeInvisibleTypeAnnotationsAttribute {
    private static final IExtendedAnnotation[] NO_ENTRIES = new IExtendedAnnotation[0];
    private int extendedAnnotationsNumber;
    private IExtendedAnnotation[] extendedAnnotations;

    public RuntimeInvisibleTypeAnnotationsAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.extendedAnnotationsNumber = length = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.extendedAnnotations = new IExtendedAnnotation[length];
            for (int i = 0; i < length; ++i) {
                ExtendedAnnotation extendedAnnotation = new ExtendedAnnotation(classFileBytes, constantPool, offset + readOffset);
                this.extendedAnnotations[i] = extendedAnnotation;
                readOffset += extendedAnnotation.sizeInBytes();
            }
        } else {
            this.extendedAnnotations = NO_ENTRIES;
        }
    }

    @Override
    public IExtendedAnnotation[] getExtendedAnnotations() {
        return this.extendedAnnotations;
    }

    @Override
    public int getExtendedAnnotationsNumber() {
        return this.extendedAnnotationsNumber;
    }
}

