/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.INestMemberAttributeEntry;
import org.eclipse.jdt.core.util.INestMembersAttribute;
import org.eclipse.jdt.internal.core.util.ClassFileAttribute;
import org.eclipse.jdt.internal.core.util.NestMembersAttributeEntry;

public class NestMembersAttribute
extends ClassFileAttribute
implements INestMembersAttribute {
    private static final INestMemberAttributeEntry[] NO_ENTRIES = new INestMemberAttributeEntry[0];
    private int nestMembers;
    private INestMemberAttributeEntry[] entries;

    public NestMembersAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length = this.nestMembers = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.entries = new INestMemberAttributeEntry[length];
            for (int i = 0; i < length; ++i) {
                this.entries[i] = new NestMembersAttributeEntry(classFileBytes, constantPool, offset + readOffset);
                readOffset += 2;
            }
        } else {
            this.entries = NO_ENTRIES;
        }
    }

    @Override
    public int getNumberOfNestMembers() {
        return this.nestMembers;
    }

    @Override
    public INestMemberAttributeEntry[] getNestMemberAttributesEntries() {
        return this.entries;
    }
}

