/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.LambdaFactory;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.search.AbstractJavaSearchScope;
import org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.jdt.internal.core.util.Util;

public class HandleFactory {
    private String lastPkgFragmentRootPath;
    private PackageFragmentRoot lastPkgFragmentRoot;
    private HashtableOfArrayToObject packageHandles;
    private JavaModel javaModel;
    private HashtableOfObjectToInt localOccurrenceCounts = new HashtableOfObjectToInt(5);

    public HandleFactory() {
        this.javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
    }

    public Openable createOpenable(String resourcePath, IJavaSearchScope scope) {
        String simpleName;
        Object[] pkgName;
        String[] simpleNames;
        int length;
        int separatorIndex = resourcePath.indexOf("|");
        if (separatorIndex > -1) {
            Object[] pkgName2;
            String classFilePath;
            int rootPathLength;
            PackageFragmentRoot root = null;
            if (this.lastPkgFragmentRootPath == null || (rootPathLength = this.lastPkgFragmentRootPath.length()) != resourcePath.length() || !resourcePath.regionMatches(0, this.lastPkgFragmentRootPath, 0, rootPathLength)) {
                String jarPath = resourcePath.substring(0, separatorIndex);
                root = this.getJarPkgFragmentRoot(resourcePath, separatorIndex, jarPath, scope);
                if (root == null) {
                    return null;
                }
                this.lastPkgFragmentRootPath = jarPath;
                this.lastPkgFragmentRoot = root;
                this.packageHandles = new HashtableOfArrayToObject(5);
            }
            String module = null;
            String rootPath = this.lastPkgFragmentRoot.getPath().toOSString();
            if (org.eclipse.jdt.internal.compiler.util.Util.isJrt(rootPath)) {
                int n = separatorIndex + 1;
                separatorIndex = resourcePath.lastIndexOf("|");
                module = resourcePath.substring(n, separatorIndex);
            }
            if ((classFilePath = resourcePath.substring(separatorIndex + 1)).endsWith("Automatic-Module-Name")) {
                return root;
            }
            String[] simpleNames2 = new Path(classFilePath).segments();
            int length2 = simpleNames2.length - 1;
            if (length2 > 0) {
                pkgName2 = new String[length2];
                System.arraycopy(simpleNames2, 0, pkgName2, 0, length2);
            } else {
                pkgName2 = CharOperation.NO_STRINGS;
            }
            IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName2);
            if (pkgFragment == null) {
                pkgFragment = this.lastPkgFragmentRoot.getPackageFragment((String[])pkgName2, module);
                this.packageHandles.put(pkgName2, pkgFragment);
            }
            IClassFile classFile = pkgFragment.getClassFile(simpleNames2[length2]);
            return (Openable)((Object)classFile);
        }
        int rootPathLength = -1;
        if (this.lastPkgFragmentRootPath == null || !resourcePath.startsWith(this.lastPkgFragmentRootPath) || org.eclipse.jdt.internal.compiler.util.Util.isExcluded(resourcePath.toCharArray(), this.lastPkgFragmentRoot.fullInclusionPatternChars(), this.lastPkgFragmentRoot.fullExclusionPatternChars(), false) || (rootPathLength = this.lastPkgFragmentRootPath.length()) <= 0 || resourcePath.charAt(rootPathLength) != '/') {
            PackageFragmentRoot root = this.getPkgFragmentRoot(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRoot = root;
            this.lastPkgFragmentRootPath = this.lastPkgFragmentRoot.internalPath().toString();
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        if ((length = (simpleNames = new Path(resourcePath = resourcePath.substring(this.lastPkgFragmentRootPath.length() + 1)).segments()).length - 1) > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = this.lastPkgFragmentRoot.getPackageFragment((String[])pkgName);
            this.packageHandles.put(pkgName, pkgFragment);
        }
        if (Util.isJavaLikeFileName(simpleName = simpleNames[length])) {
            ICompilationUnit unit = pkgFragment.getCompilationUnit(simpleName);
            return (Openable)((Object)unit);
        }
        if (org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(simpleName)) {
            IClassFile classFile = pkgFragment.getClassFile(simpleName);
            return (Openable)((Object)classFile);
        }
        return null;
    }

    public IJavaElement createElement(ClassScope scope, ICompilationUnit unit, HashSet existingElements, HashMap knownScopes) {
        return this.createElement(scope, scope.referenceContext.sourceStart, unit, existingElements, knownScopes);
    }

    public IJavaElement createLambdaTypeElement(LambdaExpression expression, ICompilationUnit unit, HashSet existingElements, HashMap knownScopes) {
        return this.createElement(expression.scope, expression.sourceStart(), unit, existingElements, knownScopes).getParent();
    }

    protected void resolveDuplicates(IJavaElement handle) {
        if (handle instanceof SourceType && ((SourceType)handle).isAnonymous()) {
            IJavaElement key = handle.getParent().getAncestor(7);
            int occurenceCount = this.localOccurrenceCounts.get(key);
            if (occurenceCount == -1) {
                this.localOccurrenceCounts.put(key, 1);
            } else {
                this.localOccurrenceCounts.put(key, ++occurenceCount);
                ((SourceType)handle).localOccurrenceCount = occurenceCount;
            }
        }
    }

    public IJavaElement createElement(Scope scope, int elementPosition, ICompilationUnit unit, HashSet existingElements, HashMap knownScopes) {
        IJavaElement newElement = (IJavaElement)knownScopes.get(scope);
        if (newElement != null) {
            return newElement;
        }
        block0 : switch (scope.kind) {
            case 4: {
                newElement = unit;
                break;
            }
            case 3: {
                IJavaElement parentElement = this.createElement(scope.parent, elementPosition, unit, existingElements, knownScopes);
                switch (parentElement.getElementType()) {
                    case 5: {
                        newElement = ((ICompilationUnit)parentElement).getType(new String(scope.enclosingSourceType().sourceName));
                        break;
                    }
                    case 7: {
                        newElement = ((IType)parentElement).getType(new String(scope.enclosingSourceType().sourceName));
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        IMember member = (IMember)parentElement;
                        if (member.isBinary()) {
                            return null;
                        }
                        newElement = member.getType(new String(scope.enclosingSourceType().sourceName), 1);
                        if (newElement == null) break;
                        while (!existingElements.add(newElement)) {
                            ++((SourceRefElement)newElement).occurrenceCount;
                        }
                        break;
                    }
                }
                if (newElement == null) break;
                knownScopes.put(scope, newElement);
                break;
            }
            case 2: {
                if (scope.isLambdaScope()) {
                    IJavaElement parentElement = this.createElement(scope.parent, elementPosition, unit, existingElements, knownScopes);
                    LambdaExpression expression = (LambdaExpression)scope.originalReferenceContext();
                    if (expression.resolvedType != null && expression.resolvedType.isValidBinding() && !(expression.descriptor instanceof ProblemMethodBinding)) {
                        newElement = LambdaFactory.createLambdaExpression((JavaElement)parentElement, expression).getMethod();
                        knownScopes.put(scope, newElement);
                        return newElement;
                    }
                    return parentElement;
                }
                IType parentType = (IType)this.createElement(scope.parent, elementPosition, unit, existingElements, knownScopes);
                MethodScope methodScope = (MethodScope)scope;
                if (methodScope.isInsideInitializer()) {
                    TypeDeclaration type = methodScope.referenceType();
                    int occurenceCount = 1;
                    int length = type.fields == null ? 0 : type.fields.length;
                    for (int i = 0; i < length; ++i) {
                        FieldDeclaration field = type.fields[i];
                        if (field.declarationSourceStart <= elementPosition && elementPosition <= field.declarationSourceEnd) {
                            switch (field.getKind()) {
                                case 1: 
                                case 3: {
                                    newElement = parentType.getField(new String(field.name));
                                    break;
                                }
                                case 2: {
                                    newElement = parentType.getInitializer(occurenceCount);
                                }
                            }
                            break block0;
                        }
                        if (field.getKind() != 2) continue;
                        ++occurenceCount;
                    }
                    break;
                }
                AbstractMethodDeclaration method = methodScope.referenceMethod();
                newElement = parentType.getMethod(new String(method.selector), Util.typeParameterSignatures(method));
                if (newElement == null) break;
                knownScopes.put(scope, newElement);
                break;
            }
            case 1: {
                newElement = this.createElement(scope.parent, elementPosition, unit, existingElements, knownScopes);
            }
        }
        this.resolveDuplicates(newElement);
        return newElement;
    }

    private PackageFragmentRoot getJarPkgFragmentRoot(String resourcePathString, int jarSeparatorIndex, String jarPathString, IJavaSearchScope scope) {
        IJavaProject[] projects;
        Path jarPath = new Path(jarPathString);
        Object target = JavaModel.getTarget((IPath)jarPath, false);
        if (target instanceof IFile) {
            IFile jarFile = (IFile)target;
            JavaProject javaProject = (JavaProject)this.javaModel.getJavaProject((IResource)jarFile);
            try {
                IClasspathEntry entry = javaProject.getClasspathEntryFor((IPath)jarPath);
                if (entry != null) {
                    return (PackageFragmentRoot)javaProject.getPackageFragmentRoot((IResource)jarFile);
                }
            }
            catch (JavaModelException entry) {
                // empty catch block
            }
        }
        if (scope != null) {
            if (scope instanceof AbstractJavaSearchScope) {
                PackageFragmentRoot root = (PackageFragmentRoot)((AbstractJavaSearchScope)scope).packageFragmentRoot(resourcePathString, jarSeparatorIndex, jarPathString);
                if (root != null) {
                    return root;
                }
            } else {
                PackageFragmentRoot root;
                IPath[] enclosingProjectsAndJars = scope.enclosingProjectsAndJars();
                int length = enclosingProjectsAndJars.length;
                projects = new IJavaProject[length];
                int index = 0;
                for (int i = 0; i < length; ++i) {
                    IPath path = enclosingProjectsAndJars[i];
                    if (path.segmentCount() != 1) continue;
                    projects[index++] = this.javaModel.getJavaProject(path.segment(0));
                }
                if (index < length) {
                    IJavaProject[] iJavaProjectArray = projects;
                    projects = new IJavaProject[index];
                    System.arraycopy(iJavaProjectArray, 0, projects, 0, index);
                }
                if ((root = this.getJarPkgFragmentRoot((IPath)jarPath, target, projects)) != null) {
                    return root;
                }
            }
        }
        try {
            projects = this.javaModel.getJavaProjects();
        }
        catch (JavaModelException e) {
            return null;
        }
        return this.getJarPkgFragmentRoot((IPath)jarPath, target, projects);
    }

    private PackageFragmentRoot getJarPkgFragmentRoot(IPath jarPath, Object target, IJavaProject[] projects) {
        int projectCount = projects.length;
        for (int i = 0; i < projectCount; ++i) {
            try {
                JavaProject javaProject = (JavaProject)projects[i];
                IClasspathEntry classpathEnty = javaProject.getClasspathEntryFor(jarPath);
                if (classpathEnty == null) continue;
                if (target instanceof IFile) {
                    return (PackageFragmentRoot)javaProject.getPackageFragmentRoot((IResource)((IFile)target), null, classpathEnty.getExtraAttributes());
                }
                return (PackageFragmentRoot)javaProject.getPackageFragmentRoot0(jarPath, classpathEnty.getExtraAttributes());
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    private PackageFragmentRoot getPkgFragmentRoot(String pathString) {
        Path path = new Path(pathString);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int max = projects.length;
        for (int i = 0; i < max; ++i) {
            try {
                IProject project = projects[i];
                if (!project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) continue;
                IJavaProject javaProject = this.javaModel.getJavaProject((IResource)project);
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                int rootCount = roots.length;
                for (int j = 0; j < rootCount; ++j) {
                    PackageFragmentRoot root = (PackageFragmentRoot)roots[j];
                    if (!root.internalPath().isPrefixOf((IPath)path) || Util.isExcluded((IPath)path, root.fullInclusionPatternChars(), root.fullExclusionPatternChars(), false)) continue;
                    return root;
                }
                continue;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }
}

