/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;

public abstract class IntersectingPattern
extends JavaSearchPattern {
    public IntersectingPattern(int patternKind, int matchRule) {
        super(patternKind, matchRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.resetQuery();
        SimpleSet intersectedNames = null;
        try {
            index.startQuery();
            do {
                SearchPattern pattern;
                EntryResult[] entries;
                if ((entries = (pattern = this.currentPattern()).queryIn(index)) == null) {
                    return;
                }
                SearchPattern decodedResult = pattern.getBlankPattern();
                SimpleSet newIntersectedNames = new SimpleSet(3);
                int l = entries.length;
                for (int i = 0; i < l; ++i) {
                    int j;
                    int n;
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    EntryResult entry = entries[i];
                    decodedResult.decodeIndexKey(entry.getWord());
                    if (!pattern.matchesDecodedKey(decodedResult)) continue;
                    String[] names = entry.getDocumentNames(index);
                    if (intersectedNames != null) {
                        n = names.length;
                        for (j = 0; j < n; ++j) {
                            if (!intersectedNames.includes(names[j])) continue;
                            newIntersectedNames.add(names[j]);
                        }
                        continue;
                    }
                    n = names.length;
                    for (j = 0; j < n; ++j) {
                        newIntersectedNames.add(names[j]);
                    }
                }
                if (newIntersectedNames.elementSize == 0) {
                    return;
                }
                intersectedNames = newIntersectedNames;
            } while (this.hasNextQuery());
        }
        finally {
            index.stopQuery();
        }
        String containerPath = index.containerPath;
        char separator = index.separator;
        Object[] names = intersectedNames.values;
        int l = names.length;
        for (int i = 0; i < l; ++i) {
            if (names[i] == null) continue;
            this.acceptMatch((String)names[i], containerPath, separator, null, requestor, participant, scope, progressMonitor);
        }
    }

    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, boolean resolveDocumentName, IProgressMonitor progressMonitor) throws IOException {
        this.findIndexMatches(index, requestor, participant, scope, progressMonitor);
    }

    protected abstract boolean hasNextQuery();

    protected abstract void resetQuery();
}

