/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class IndexNamesRegistry {
    private final File savedIndexNamesFile;
    private final Job writeJob;
    private final IPath javaPluginWorkingLocation;
    private final Object queueMutex = new Object();
    private char[][] pendingWrite;

    public IndexNamesRegistry(File savedIndexNamesFile, IPath javaPluginWorkingLocation) {
        this.savedIndexNamesFile = savedIndexNamesFile;
        this.writeJob = Job.create((String)"Updating index names", this::save);
        this.writeJob.setSystem(true);
        this.javaPluginWorkingLocation = javaPluginWorkingLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[][] newContents) {
        Object object = this.queueMutex;
        synchronized (object) {
            this.pendingWrite = newContents;
        }
        this.writeJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[][] read(IProgressMonitor monitor) {
        block7: {
            char[][] newContents;
            Object object = this.queueMutex;
            synchronized (object) {
                newContents = this.pendingWrite;
            }
            if (newContents != null) {
                return newContents;
            }
            try {
                String savedSignature;
                char[][] names;
                char[] savedIndexNames = Util.getFileCharContent(this.savedIndexNamesFile, null);
                if (savedIndexNames.length > 0 && (names = CharOperation.splitOn('\n', savedIndexNames)).length > 1 && (savedSignature = "INDEX VERSION 1.131+" + this.javaPluginWorkingLocation.toOSString()).equals(new String(names[0]))) {
                    return names;
                }
            }
            catch (IOException ignored) {
                if (!JobManager.VERBOSE) break block7;
                org.eclipse.jdt.internal.core.util.Util.verbose("Failed to read saved index file names");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(IProgressMonitor monitor) {
        char[][] newContents;
        Object object;
        block16: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            object = this.queueMutex;
            synchronized (object) {
                newContents = this.pendingWrite;
            }
            if (newContents == null) {
                return;
            }
            subMonitor.setWorkRemaining(newContents.length);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.savedIndexNamesFile));){
                writer.write("INDEX VERSION 1.131");
                writer.write(43);
                writer.write(this.javaPluginWorkingLocation.toOSString());
                writer.write(10);
                for (char[] next : newContents) {
                    subMonitor.split(1);
                    writer.write(next);
                    writer.write(10);
                }
            }
            catch (IOException ignored) {
                if (!JobManager.VERBOSE) break block16;
                org.eclipse.jdt.internal.core.util.Util.verbose("Failed to write saved index file names", System.err);
            }
        }
        object = this.queueMutex;
        synchronized (object) {
            if (this.pendingWrite == newContents) {
                this.pendingWrite = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Object object = this.queueMutex;
        synchronized (object) {
            this.pendingWrite = null;
        }
        this.writeJob.cancel();
        try {
            this.writeJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        object = this.queueMutex;
        synchronized (object) {
            this.pendingWrite = null;
        }
        this.savedIndexNamesFile.delete();
    }
}

