/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SimpleDelta;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;

public class ChangeCollector {
    HashMap changes = new HashMap();
    TypeHierarchy hierarchy;

    public ChangeCollector(TypeHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    private void addAffectedChildren(IJavaElementDelta delta) throws JavaModelException {
        block6: for (IJavaElementDelta child : delta.getAffectedChildren()) {
            IJavaElement childElement = child.getElement();
            switch (childElement.getElementType()) {
                case 12: {
                    this.addChange((IImportContainer)childElement, child);
                    continue block6;
                }
                case 13: {
                    this.addChange((IImportDeclaration)childElement, child);
                    continue block6;
                }
                case 7: {
                    this.addChange((IType)childElement, child);
                    continue block6;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.addChange((IMember)childElement, child);
                }
            }
        }
    }

    public void addChange(ICompilationUnit cu, IJavaElementDelta newDelta) throws JavaModelException {
        int newKind = newDelta.getKind();
        switch (newKind) {
            case 1: {
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromElement(cu, allTypes);
                int length = allTypes.size();
                for (int i = 0; i < length; ++i) {
                    IType type = (IType)allTypes.get(i);
                    this.addTypeAddition(type, (SimpleDelta)this.changes.get(type));
                }
                break;
            }
            case 2: {
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromHierarchy((JavaElement)((Object)cu), allTypes);
                int length = allTypes.size();
                for (int i = 0; i < length; ++i) {
                    IType type = (IType)allTypes.get(i);
                    this.addTypeRemoval(type, (SimpleDelta)this.changes.get(type));
                }
                break;
            }
            case 4: {
                this.addAffectedChildren(newDelta);
            }
        }
    }

    private void addChange(IImportContainer importContainer, IJavaElementDelta newDelta) throws JavaModelException {
        int newKind = newDelta.getKind();
        if (newKind == 4) {
            this.addAffectedChildren(newDelta);
            return;
        }
        SimpleDelta existingDelta = (SimpleDelta)this.changes.get(importContainer);
        if (existingDelta != null) {
            switch (newKind) {
                case 1: {
                    if (existingDelta.getKind() != 2) break;
                    this.changes.remove(importContainer);
                    break;
                }
                case 2: {
                    if (existingDelta.getKind() != 1) break;
                    this.changes.remove(importContainer);
                }
            }
        } else {
            SimpleDelta delta = new SimpleDelta();
            switch (newKind) {
                case 1: {
                    delta.added();
                    break;
                }
                case 2: {
                    delta.removed();
                }
            }
            this.changes.put(importContainer, delta);
        }
    }

    private void addChange(IImportDeclaration importDecl, IJavaElementDelta newDelta) {
        SimpleDelta existingDelta = (SimpleDelta)this.changes.get(importDecl);
        int newKind = newDelta.getKind();
        if (existingDelta != null) {
            switch (newKind) {
                case 1: {
                    if (existingDelta.getKind() != 2) break;
                    this.changes.remove(importDecl);
                    break;
                }
                case 2: {
                    if (existingDelta.getKind() != 1) break;
                    this.changes.remove(importDecl);
                }
            }
        } else {
            SimpleDelta delta = new SimpleDelta();
            switch (newKind) {
                case 1: {
                    delta.added();
                    break;
                }
                case 2: {
                    delta.removed();
                }
            }
            this.changes.put(importDecl, delta);
        }
    }

    private void addChange(IMember member, IJavaElementDelta newDelta) throws JavaModelException {
        int newKind = newDelta.getKind();
        switch (newKind) {
            case 1: {
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromElement(member, allTypes);
                int length = allTypes.size();
                for (int i = 0; i < length; ++i) {
                    IType innerType = (IType)allTypes.get(i);
                    this.addTypeAddition(innerType, (SimpleDelta)this.changes.get(innerType));
                }
                break;
            }
            case 2: {
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromHierarchy((JavaElement)((Object)member), allTypes);
                int length = allTypes.size();
                for (int i = 0; i < length; ++i) {
                    IType type = (IType)allTypes.get(i);
                    this.addTypeRemoval(type, (SimpleDelta)this.changes.get(type));
                }
                break;
            }
            case 4: {
                this.addAffectedChildren(newDelta);
            }
        }
    }

    private void addChange(IType type, IJavaElementDelta newDelta) throws JavaModelException {
        int newKind = newDelta.getKind();
        SimpleDelta existingDelta = (SimpleDelta)this.changes.get(type);
        switch (newKind) {
            case 1: {
                this.addTypeAddition(type, existingDelta);
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromElement(type, allTypes);
                int length = allTypes.size();
                for (int i = 0; i < length; ++i) {
                    IType innerType = (IType)allTypes.get(i);
                    this.addTypeAddition(innerType, (SimpleDelta)this.changes.get(innerType));
                }
                break;
            }
            case 2: {
                this.addTypeRemoval(type, existingDelta);
                ArrayList allTypes = new ArrayList();
                this.getAllTypesFromHierarchy((JavaElement)((Object)type), allTypes);
                int length = allTypes.size();
                for (int i = 0; i < length; ++i) {
                    IType innerType = (IType)allTypes.get(i);
                    this.addTypeRemoval(innerType, (SimpleDelta)this.changes.get(innerType));
                }
                break;
            }
            case 4: {
                this.addTypeChange(type, newDelta.getFlags(), existingDelta);
                this.addAffectedChildren(newDelta);
            }
        }
    }

    private void addTypeAddition(IType type, SimpleDelta existingDelta) throws JavaModelException {
        if (existingDelta != null) {
            switch (existingDelta.getKind()) {
                case 2: {
                    boolean hasChange = false;
                    if (this.hasSuperTypeChange(type)) {
                        existingDelta.superTypes();
                        hasChange = true;
                    }
                    if (this.hasVisibilityChange(type)) {
                        existingDelta.modifiers();
                        hasChange = true;
                    }
                    if (hasChange) break;
                    this.changes.remove(type);
                }
            }
        } else {
            String typeName = type.getElementName();
            if (this.hierarchy.hasSupertype(typeName) || this.hierarchy.subtypesIncludeSupertypeOf(type) || this.hierarchy.missingTypes.contains(typeName)) {
                SimpleDelta delta = new SimpleDelta();
                delta.added();
                this.changes.put(type, delta);
            }
        }
    }

    private void addTypeChange(IType type, int newFlags, SimpleDelta existingDelta) throws JavaModelException {
        if (existingDelta != null) {
            switch (existingDelta.getKind()) {
                case 4: {
                    int existingFlags = existingDelta.getFlags();
                    boolean hasChange = false;
                    if ((existingFlags & 0x800) != 0 && this.hasSuperTypeChange(type)) {
                        existingDelta.superTypes();
                        hasChange = true;
                    }
                    if ((existingFlags & 2) != 0 && this.hasVisibilityChange(type)) {
                        existingDelta.modifiers();
                        hasChange = true;
                    }
                    if (hasChange) break;
                    this.changes.remove(type);
                }
            }
        } else {
            SimpleDelta typeDelta = null;
            if ((newFlags & 0x800) != 0 && this.hierarchy.includesTypeOrSupertype(type)) {
                typeDelta = new SimpleDelta();
                typeDelta.superTypes();
            }
            if ((newFlags & 2) != 0 && (this.hierarchy.hasSupertype(type.getElementName()) || type.equals(this.hierarchy.focusType))) {
                if (typeDelta == null) {
                    typeDelta = new SimpleDelta();
                }
                typeDelta.modifiers();
            }
            if (typeDelta != null) {
                this.changes.put(type, typeDelta);
            }
        }
    }

    private void addTypeRemoval(IType type, SimpleDelta existingDelta) {
        if (existingDelta != null) {
            switch (existingDelta.getKind()) {
                case 1: {
                    this.changes.remove(type);
                    break;
                }
                case 4: {
                    existingDelta.removed();
                }
            }
        } else if (this.hierarchy.contains(type)) {
            SimpleDelta typeDelta = new SimpleDelta();
            typeDelta.removed();
            this.changes.put(type, typeDelta);
        }
    }

    private void getAllTypesFromElement(IJavaElement element, ArrayList allTypes) throws JavaModelException {
        switch (element.getElementType()) {
            case 5: {
                for (IType type : ((ICompilationUnit)element).getTypes()) {
                    allTypes.add(type);
                    this.getAllTypesFromElement(type, allTypes);
                }
                break;
            }
            case 7: {
                for (IType type : ((IType)element).getTypes()) {
                    allTypes.add(type);
                    this.getAllTypesFromElement(type, allTypes);
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                IJavaElement[] children = ((IMember)element).getChildren();
                int length = children.length;
                for (int i = 0; i < length; ++i) {
                    IType type = (IType)children[i];
                    allTypes.add(type);
                    this.getAllTypesFromElement(type, allTypes);
                }
                break;
            }
        }
    }

    private void getAllTypesFromHierarchy(JavaElement element, ArrayList allTypes) {
        switch (element.getElementType()) {
            case 5: {
                IOpenable o = (IOpenable)((Object)element);
                ArrayList<IType> types = this.hierarchy.files.get(o);
                if (types == null) break;
                allTypes.addAll(types);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                ArrayList<IType> types = this.hierarchy.files.get(((IMember)((Object)element)).getCompilationUnit());
                if (types == null) break;
                int length = types.size();
                for (int i = 0; i < length; ++i) {
                    IType type = types.get(i);
                    if (!element.isAncestorOf(type)) continue;
                    allTypes.add(type);
                }
                break;
            }
        }
    }

    private boolean hasSuperTypeChange(IType type) throws JavaModelException {
        String[] newSuperInterfaces;
        IType superclass = this.hierarchy.getSuperclass(type);
        String existingSuperclassName = superclass == null ? null : superclass.getElementName();
        String newSuperclassName = type.getSuperclassName();
        if (existingSuperclassName != null && !existingSuperclassName.equals(newSuperclassName)) {
            return true;
        }
        IType[] existingSuperInterfaces = this.hierarchy.getSuperInterfaces(type);
        if (existingSuperInterfaces.length != (newSuperInterfaces = type.getSuperInterfaceNames()).length) {
            return true;
        }
        int length = newSuperInterfaces.length;
        for (int i = 0; i < length; ++i) {
            String superInterfaceName = newSuperInterfaces[i];
            if (superInterfaceName.equals(newSuperInterfaces[i])) continue;
            return true;
        }
        return false;
    }

    private boolean hasVisibilityChange(IType type) throws JavaModelException {
        int newFlags;
        int existingFlags = this.hierarchy.getCachedFlags(type);
        return existingFlags != (newFlags = type.getFlags());
    }

    public boolean needsRefresh() {
        return this.changes.size() != 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator iterator = this.changes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            buffer.append(((JavaElement)entry.getKey()).toDebugString());
            buffer.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

