/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.AdditionalTypeCollection;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.builder.ClasspathJrtWithReleaseOption;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.CompressedReader;
import org.eclipse.jdt.internal.core.builder.CompressedWriter;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.jdt.internal.core.util.Util;

public class State {
    String javaProjectName;
    public ClasspathMultiDirectory[] sourceLocations;
    public ClasspathMultiDirectory[] testSourceLocations;
    public ClasspathLocation[] binaryLocations;
    public ClasspathLocation[] testBinaryLocations;
    Map<String, ReferenceCollection> references;
    public Map<String, String> typeLocators;
    int buildNumber;
    long lastStructuralBuildTime;
    SimpleLookupTable structuralBuildTimes;
    private String[] knownPackageNames;
    private long previousStructuralBuildTime;
    private StringSet structurallyChangedTypes;
    public static int MaxStructurallyChangedTypes = 100;
    public static final byte VERSION = 38;
    static final byte SOURCE_FOLDER = 1;
    static final byte BINARY_FOLDER = 2;
    static final byte EXTERNAL_JAR = 3;
    static final byte INTERNAL_JAR = 4;
    private static final int[] PROBLEM_IDS = new int[]{0, 0x1000133, 0x1000118, 0x3000133, 50331928};

    State() {
    }

    protected State(JavaBuilder javaBuilder) {
        this.knownPackageNames = null;
        this.previousStructuralBuildTime = -1L;
        this.structurallyChangedTypes = null;
        this.javaProjectName = javaBuilder.currentProject.getName();
        this.sourceLocations = javaBuilder.nameEnvironment.sourceLocations;
        this.binaryLocations = javaBuilder.nameEnvironment.binaryLocations;
        this.testSourceLocations = javaBuilder.testNameEnvironment.sourceLocations;
        this.testBinaryLocations = javaBuilder.testNameEnvironment.binaryLocations;
        this.references = new LinkedHashMap<String, ReferenceCollection>(7);
        this.typeLocators = new LinkedHashMap<String, String>(7);
        this.buildNumber = 0;
        this.lastStructuralBuildTime = this.computeStructuralBuildTime(javaBuilder.lastState == null ? 0L : javaBuilder.lastState.lastStructuralBuildTime);
        this.structuralBuildTimes = new SimpleLookupTable(3);
    }

    long computeStructuralBuildTime(long previousTime) {
        long newTime = System.currentTimeMillis();
        if (newTime <= previousTime) {
            newTime = previousTime + 1L;
        }
        return newTime;
    }

    void copyFrom(State lastState) {
        this.knownPackageNames = null;
        this.previousStructuralBuildTime = lastState.previousStructuralBuildTime;
        this.structurallyChangedTypes = lastState.structurallyChangedTypes;
        this.buildNumber = lastState.buildNumber + 1;
        this.lastStructuralBuildTime = lastState.lastStructuralBuildTime;
        this.structuralBuildTimes = lastState.structuralBuildTimes;
        this.references = new LinkedHashMap<String, ReferenceCollection>(lastState.references);
        this.typeLocators = new LinkedHashMap<String, String>(lastState.typeLocators);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof State)) {
            return false;
        }
        State other = (State)obj;
        return this.buildNumber == other.buildNumber && this.lastStructuralBuildTime == other.lastStructuralBuildTime && Objects.equals(this.javaProjectName, other.javaProjectName) && Arrays.equals(this.sourceLocations, other.sourceLocations) && Arrays.equals(this.binaryLocations, other.binaryLocations) && Arrays.equals(this.testSourceLocations, other.testSourceLocations) && Arrays.equals(this.testBinaryLocations, other.testBinaryLocations) && Objects.equals(this.typeLocators, other.typeLocators) && Objects.equals(this.references, other.references);
    }

    public int hashCode() {
        return 31 + Objects.hash(this.javaProjectName);
    }

    public char[][] getDefinedTypeNamesFor(String typeLocator) {
        ReferenceCollection c = this.references.get(typeLocator);
        if (c instanceof AdditionalTypeCollection) {
            return ((AdditionalTypeCollection)c).definedTypeNames;
        }
        return null;
    }

    public Map<String, ReferenceCollection> getReferences() {
        return this.references;
    }

    StringSet getStructurallyChangedTypes(State prereqState) {
        if (prereqState != null && prereqState.previousStructuralBuildTime > 0L) {
            long previous;
            Object o = this.structuralBuildTimes.get(prereqState.javaProjectName);
            long l = previous = o == null ? 0L : (Long)o;
            if (previous == prereqState.previousStructuralBuildTime) {
                return prereqState.structurallyChangedTypes;
            }
        }
        return null;
    }

    public boolean isDuplicateLocator(String qualifiedTypeName, String typeLocator) {
        String existing = this.typeLocators.get(qualifiedTypeName);
        return existing != null && !existing.equals(typeLocator);
    }

    public boolean isKnownPackage(String qualifiedPackageName) {
        int result;
        if (this.knownPackageNames == null) {
            LinkedHashSet<String> names = new LinkedHashSet<String>(this.typeLocators.size());
            Set<Map.Entry<String, String>> keyTable = this.typeLocators.entrySet();
            for (Map.Entry<String, String> entry : keyTable) {
                String packageName = entry.getKey();
                int last = packageName.lastIndexOf(47);
                String string = packageName = last == -1 ? null : packageName.substring(0, last);
                while (packageName != null && !names.contains(packageName)) {
                    names.add(packageName);
                    last = packageName.lastIndexOf(47);
                    packageName = last == -1 ? null : packageName.substring(0, last);
                }
            }
            this.knownPackageNames = new String[names.size()];
            names.toArray(this.knownPackageNames);
            Arrays.sort(this.knownPackageNames);
        }
        return (result = Arrays.binarySearch(this.knownPackageNames, qualifiedPackageName)) >= 0;
    }

    public boolean isKnownType(String qualifiedTypeName) {
        return this.typeLocators.containsKey(qualifiedTypeName);
    }

    boolean isSourceFolderEmpty(IContainer sourceFolder) {
        String sourceFolderName = sourceFolder.getProjectRelativePath().addTrailingSeparator().toString();
        for (String value : this.typeLocators.values()) {
            if (!value.startsWith(sourceFolderName)) continue;
            return false;
        }
        return true;
    }

    void record(String typeLocator, char[][][] qualifiedRefs, char[][] simpleRefs, char[][] rootRefs, char[] mainTypeName, ArrayList typeNames) {
        if (typeNames.size() == 1 && CharOperation.equals(mainTypeName, (char[])typeNames.get(0))) {
            this.references.put(typeLocator, new ReferenceCollection(qualifiedRefs, simpleRefs, rootRefs));
        } else {
            char[][] definedTypeNames = new char[typeNames.size()][];
            typeNames.toArray((T[])definedTypeNames);
            this.references.put(typeLocator, new AdditionalTypeCollection(definedTypeNames, qualifiedRefs, simpleRefs, rootRefs));
        }
    }

    void recordLocatorForType(String qualifiedTypeName, String typeLocator) {
        this.knownPackageNames = null;
        int start = typeLocator.indexOf(qualifiedTypeName, 0);
        if (start > 0) {
            qualifiedTypeName = typeLocator.substring(start, start + qualifiedTypeName.length());
        }
        this.typeLocators.put(qualifiedTypeName, typeLocator);
    }

    void recordStructuralDependency(IProject prereqProject, State prereqState) {
        if (prereqState != null && prereqState.lastStructuralBuildTime > 0L) {
            this.structuralBuildTimes.put(prereqProject.getName(), prereqState.lastStructuralBuildTime);
        }
    }

    void removeLocator(String typeLocatorToRemove) {
        this.knownPackageNames = null;
        this.references.remove(typeLocatorToRemove);
        this.typeLocators.values().removeIf(v -> typeLocatorToRemove.equals(v));
    }

    void removePackage(IResourceDelta sourceDelta) {
        IResource resource = sourceDelta.getResource();
        switch (resource.getType()) {
            case 2: {
                IResourceDelta[] children = sourceDelta.getAffectedChildren();
                int l = children.length;
                for (int i = 0; i < l; ++i) {
                    this.removePackage(children[i]);
                }
                return;
            }
            case 1: {
                IPath typeLocatorPath = resource.getProjectRelativePath();
                if (!Util.isJavaLikeFileName(typeLocatorPath.lastSegment())) break;
                this.removeLocator(typeLocatorPath.toString());
            }
        }
    }

    void removeQualifiedTypeName(String qualifiedTypeNameToRemove) {
        this.knownPackageNames = null;
        this.typeLocators.remove(qualifiedTypeNameToRemove);
    }

    static State read(IProject project, DataInputStream input) throws IOException, CoreException {
        int i;
        int i2;
        CompressedReader in = new CompressedReader(input);
        if (JavaBuilder.DEBUG) {
            System.out.println("About to read state " + project.getName());
        }
        if (38 != in.readByte()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Found non-compatible state version... answered null for " + project.getName());
            }
            return null;
        }
        State newState = new State();
        newState.javaProjectName = in.readStringUsingDictionary();
        if (!project.getName().equals(newState.javaProjectName)) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Project's name does not match... answered null");
            }
            return null;
        }
        newState.buildNumber = in.readInt();
        newState.lastStructuralBuildTime = in.readLong();
        ArrayList<ClasspathLocation> allLocationsForEEA = null;
        if ("enabled".equals(JavaCore.create(project).getOption("org.eclipse.jdt.core.builder.annotationPath.allLocations", true))) {
            allLocationsForEEA = new ArrayList<ClasspathLocation>();
        }
        newState.sourceLocations = State.readSourceLocations(project, in, allLocationsForEEA);
        newState.binaryLocations = State.readBinaryLocations(project, in, newState.sourceLocations, allLocationsForEEA);
        newState.testSourceLocations = State.readSourceLocations(project, in, allLocationsForEEA);
        newState.testBinaryLocations = State.readBinaryLocations(project, in, newState.testSourceLocations, allLocationsForEEA);
        int length = in.readInt();
        newState.structuralBuildTimes = new SimpleLookupTable(length);
        for (int i3 = 0; i3 < length; ++i3) {
            newState.structuralBuildTimes.put(in.readStringUsingDictionary(), in.readLong());
        }
        length = in.readInt();
        String[] internedTypeLocators = new String[length];
        for (i2 = 0; i2 < length; ++i2) {
            internedTypeLocators[i2] = in.readStringUsingLast();
        }
        length = in.readInt();
        newState.typeLocators = new LinkedHashMap<String, String>((int)((double)length / 0.75 + 1.0));
        for (i2 = 0; i2 < length; ++i2) {
            newState.recordLocatorForType(in.readStringUsingLast(), internedTypeLocators[in.readIntInRange(internedTypeLocators.length)]);
        }
        char[][] internedRootNames = ReferenceCollection.internSimpleNames(State.readNames(in), false, false);
        char[][] internedSimpleNames = ReferenceCollection.internSimpleNames(State.readNames(in), false, false);
        length = in.readInt();
        Object internedQualifiedNames = new char[length][][];
        for (i = 0; i < length; ++i) {
            int qLength = in.readInt();
            char[][] qName = new char[qLength][];
            for (int j = 0; j < qLength; ++j) {
                qName[j] = internedSimpleNames[in.readIntInRange(internedSimpleNames.length)];
            }
            internedQualifiedNames[i] = qName;
        }
        internedQualifiedNames = ReferenceCollection.internQualifiedNames(internedQualifiedNames, false, false);
        length = in.readInt();
        newState.references = new LinkedHashMap<String, ReferenceCollection>((int)((double)length / 0.75 + 1.0));
        for (i = 0; i < length; ++i) {
            String typeLocator = internedTypeLocators[in.readInt()];
            ReferenceCollection collection = null;
            switch (in.readByte()) {
                case 1: {
                    char[][] additionalTypeNames = State.readNames(in);
                    char[][][] qualifiedNames = new char[in.readInt()][][];
                    int m = qualifiedNames.length;
                    for (int j = 0; j < m; ++j) {
                        qualifiedNames[j] = internedQualifiedNames[in.readIntInRange(((char[][][])internedQualifiedNames).length)];
                    }
                    char[][] simpleNames = new char[in.readInt()][];
                    int m2 = simpleNames.length;
                    for (int j = 0; j < m2; ++j) {
                        simpleNames[j] = internedSimpleNames[in.readIntInRange(internedSimpleNames.length)];
                    }
                    char[][] rootNames = new char[in.readInt()][];
                    int m3 = rootNames.length;
                    for (int j = 0; j < m3; ++j) {
                        rootNames[j] = internedRootNames[in.readIntInRange(internedRootNames.length)];
                    }
                    collection = new AdditionalTypeCollection(additionalTypeNames, qualifiedNames, simpleNames, rootNames);
                    break;
                }
                case 2: {
                    char[][][] qNames = new char[in.readInt()][][];
                    int m = qNames.length;
                    for (int j = 0; j < m; ++j) {
                        qNames[j] = internedQualifiedNames[in.readIntInRange(((char[][][])internedQualifiedNames).length)];
                    }
                    char[][] sNames = new char[in.readInt()][];
                    int m4 = sNames.length;
                    for (int j = 0; j < m4; ++j) {
                        sNames[j] = internedSimpleNames[in.readIntInRange(internedSimpleNames.length)];
                    }
                    char[][] rNames = new char[in.readInt()][];
                    int m5 = rNames.length;
                    for (int j = 0; j < m5; ++j) {
                        rNames[j] = internedRootNames[in.readIntInRange(internedRootNames.length)];
                    }
                    collection = new ReferenceCollection(qNames, sNames, rNames);
                }
            }
            newState.references.put(typeLocator, collection);
        }
        if (JavaBuilder.DEBUG) {
            System.out.println("Successfully read state for " + newState.javaProjectName);
        }
        return newState;
    }

    private static ClasspathMultiDirectory[] readSourceLocations(IProject project, CompressedReader in, List<ClasspathLocation> allLocationsForEEA) throws IOException {
        int length = in.readInt();
        ClasspathMultiDirectory[] sourceLocations = new ClasspathMultiDirectory[length];
        for (int i = 0; i < length; ++i) {
            IProject sourceFolder = project;
            IProject outputFolder = project;
            String folderName = in.readStringUsingDictionary();
            if (folderName.length() > 0) {
                sourceFolder = project.getFolder(folderName);
            }
            if ((folderName = in.readStringUsingDictionary()).length() > 0) {
                outputFolder = project.getFolder(folderName);
            }
            ClasspathMultiDirectory md = (ClasspathMultiDirectory)ClasspathLocation.forSourceFolder((IContainer)sourceFolder, (IContainer)outputFolder, State.readNames(in), State.readNames(in), in.readBoolean(), State.readNullablePath(in));
            if (in.readBoolean()) {
                md.hasIndependentOutputFolder = true;
            }
            sourceLocations[i] = md;
            if (allLocationsForEEA == null) continue;
            md.connectAllLocationsForEEA(allLocationsForEEA, true);
        }
        return sourceLocations;
    }

    private static ClasspathLocation[] readBinaryLocations(IProject project, CompressedReader in, ClasspathMultiDirectory[] sourceLocations, ArrayList<ClasspathLocation> allLocationsForEEA) throws IOException, CoreException {
        int length = in.readInt();
        ClasspathLocation[] locations = new ClasspathLocation[length];
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        for (int i = 0; i < length; ++i) {
            char[] patchName;
            byte kind = in.readByte();
            switch (kind) {
                case 1: {
                    locations[i] = sourceLocations[in.readInt()];
                    break;
                }
                case 2: {
                    Path path = new Path(in.readStringUsingDictionary());
                    IFolder outputFolder = path.segmentCount() == 1 ? root.getProject(path.toString()) : root.getFolder((IPath)path);
                    locations[i] = ClasspathLocation.forBinaryFolder((IContainer)outputFolder, in.readBoolean(), State.readRestriction(in), (IPath)new Path(in.readStringUsingDictionary()), in.readBoolean());
                    break;
                }
                case 3: {
                    String jarPath = in.readStringUsingDictionary();
                    if (org.eclipse.jdt.internal.compiler.util.Util.isJrt(jarPath)) {
                        locations[i] = ClasspathLocation.forJrtSystem(jarPath, State.readRestriction(in), (IPath)new Path(in.readStringUsingDictionary()), in.readStringUsingDictionary());
                        break;
                    }
                    locations[i] = ClasspathLocation.forLibrary(jarPath, in.readLong(), State.readRestriction(in), (IPath)new Path(in.readStringUsingDictionary()), in.readBoolean(), in.readStringUsingDictionary());
                    break;
                }
                case 4: {
                    locations[i] = ClasspathLocation.forLibrary(root.getFile((IPath)new Path(in.readStringUsingDictionary())), State.readRestriction(in), (IPath)new Path(in.readStringUsingDictionary()), in.readBoolean(), in.readStringUsingDictionary());
                }
            }
            ClasspathLocation loc = locations[i];
            if (allLocationsForEEA != null) {
                loc.connectAllLocationsForEEA(allLocationsForEEA, true);
            }
            loc.patchModuleName = (patchName = in.readChars()).length > 0 ? new String(patchName) : null;
            int limitSize = in.readInt();
            if (limitSize != 0) {
                loc.limitModuleNames = new LinkedHashSet<String>(limitSize);
                for (int j = 0; j < limitSize; ++j) {
                    loc.limitModuleNames.add(in.readStringUsingDictionary());
                }
            } else {
                loc.limitModuleNames = null;
            }
            IUpdatableModule.UpdatesByKind updates = new IUpdatableModule.UpdatesByKind();
            List<Consumer<IUpdatableModule>> packageUpdates = null;
            int packageUpdatesSize = in.readInt();
            if (packageUpdatesSize != 0) {
                packageUpdates = updates.getList(IUpdatableModule.UpdateKind.PACKAGE, true);
                for (int j = 0; j < packageUpdatesSize; ++j) {
                    char[] pkgName = in.readChars();
                    char[][] targets = State.readNames(in);
                    packageUpdates.add(new IUpdatableModule.AddExports(pkgName, targets));
                }
            }
            List<Consumer<IUpdatableModule>> moduleUpdates = null;
            int moduleUpdatesSize = in.readInt();
            if (moduleUpdatesSize != 0) {
                moduleUpdates = updates.getList(IUpdatableModule.UpdateKind.MODULE, true);
                char[] modName = in.readChars();
                moduleUpdates.add(new IUpdatableModule.AddReads(modName));
            }
            if (packageUpdates == null && moduleUpdates == null) continue;
            loc.updates = updates;
        }
        return locations;
    }

    private static IPath readNullablePath(CompressedReader in) throws IOException {
        String path = in.readStringUsingDictionary();
        if (!path.isEmpty()) {
            return new Path(path);
        }
        return null;
    }

    private static AccessRuleSet readRestriction(CompressedReader in) throws IOException {
        int length = in.readInt();
        if (length == 0) {
            return null;
        }
        AccessRule[] accessRules = new AccessRule[length];
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        for (int i = 0; i < length; ++i) {
            char[] pattern = in.readCharsUsingLast();
            int problemId = in.readIntWithHint(PROBLEM_IDS);
            accessRules[i] = manager.getAccessRuleForProblemId(pattern, problemId);
        }
        return new AccessRuleSet(accessRules, in.readByte(), manager.intern(in.readStringUsingDictionary()));
    }

    void tagAsNoopBuild() {
        this.buildNumber = -1;
    }

    boolean wasNoopBuild() {
        return this.buildNumber == -1;
    }

    void tagAsStructurallyChanged() {
        this.previousStructuralBuildTime = this.lastStructuralBuildTime;
        this.structurallyChangedTypes = new StringSet(7);
        this.lastStructuralBuildTime = this.computeStructuralBuildTime(this.previousStructuralBuildTime);
    }

    boolean wasStructurallyChanged(IProject prereqProject, State prereqState) {
        if (prereqState != null) {
            long previous;
            Object o = this.structuralBuildTimes.get(prereqProject.getName());
            long l = previous = o == null ? 0L : (Long)o;
            if (previous == prereqState.lastStructuralBuildTime) {
                return false;
            }
        }
        return true;
    }

    void wasStructurallyChanged(String typeName) {
        if (this.structurallyChangedTypes != null) {
            if (this.structurallyChangedTypes.elementSize > MaxStructurallyChangedTypes) {
                this.structurallyChangedTypes = null;
            } else {
                this.structurallyChangedTypes.add(typeName);
            }
        }
    }

    void write(DataOutputStream output) throws IOException {
        CompressedWriter out = new CompressedWriter(output);
        out.writeByte(38);
        out.writeStringUsingDictionary(this.javaProjectName);
        out.writeInt(this.buildNumber);
        out.writeLong(this.lastStructuralBuildTime);
        this.writeSourceLocations(out, this.sourceLocations);
        this.writeBinaryLocations(out, this.binaryLocations, this.sourceLocations);
        this.writeSourceLocations(out, this.testSourceLocations);
        this.writeBinaryLocations(out, this.testBinaryLocations, this.testSourceLocations);
        int length = this.structuralBuildTimes.elementSize;
        out.writeInt(length);
        if (length > 0) {
            Object[] keyTable = this.structuralBuildTimes.keyTable;
            Object[] valueTable = this.structuralBuildTimes.valueTable;
            int l = keyTable.length;
            for (int i = 0; i < l; ++i) {
                if (keyTable[i] == null) continue;
                --length;
                out.writeStringUsingDictionary((String)keyTable[i]);
                out.writeLong((Long)valueTable[i]);
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("structuralBuildNumbers table is inconsistent");
            }
        }
        length = this.references.size();
        out.writeInt(length);
        SimpleLookupTable internedTypeLocators = new SimpleLookupTable(length);
        if (length > 0) {
            Set<String> keys = this.references.keySet();
            for (String string : keys) {
                if (string == null) continue;
                --length;
                out.writeStringUsingLast(string);
                internedTypeLocators.put(string, internedTypeLocators.elementSize);
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("references table is inconsistent");
            }
        }
        length = this.typeLocators.size();
        out.writeInt(length);
        if (length > 0) {
            Set<Map.Entry<String, String>> entries = this.typeLocators.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key == null) continue;
                --length;
                out.writeStringUsingLast(key);
                Integer index = (Integer)internedTypeLocators.get(value);
                out.writeIntInRange(index, internedTypeLocators.elementSize);
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("typeLocators table is inconsistent");
            }
        }
        SimpleLookupTable internedRootNames = new SimpleLookupTable(3);
        SimpleLookupTable internedQualifiedNames = new SimpleLookupTable(31);
        SimpleLookupTable simpleLookupTable = new SimpleLookupTable(31);
        for (ReferenceCollection collection : this.references.values()) {
            for (char[] rName : collection.rootReferences) {
                if (internedRootNames.containsKey(rName)) continue;
                internedRootNames.put(rName, internedRootNames.elementSize);
            }
            for (char[][] qName : collection.qualifiedNameReferences) {
                if (internedQualifiedNames.containsKey(qName)) continue;
                internedQualifiedNames.put(qName, internedQualifiedNames.elementSize);
                int n = qName.length;
                for (int k = 0; k < n; ++k) {
                    char[] sName = qName[k];
                    if (simpleLookupTable.containsKey(sName)) continue;
                    simpleLookupTable.put(sName, simpleLookupTable.elementSize);
                }
            }
            for (char[] sName : collection.simpleNameReferences) {
                if (simpleLookupTable.containsKey(sName)) continue;
                simpleLookupTable.put(sName, simpleLookupTable.elementSize);
            }
        }
        char[][] internedArray = new char[internedRootNames.elementSize][];
        Object[] rootNames = internedRootNames.keyTable;
        Object[] positions = internedRootNames.valueTable;
        int i = positions.length;
        while (--i >= 0) {
            if (positions[i] == null) continue;
            int index = (Integer)positions[i];
            internedArray[index] = (char[])rootNames[i];
        }
        this.writeNames(internedArray, out);
        internedArray = new char[simpleLookupTable.elementSize][];
        Object[] simpleNames = simpleLookupTable.keyTable;
        positions = simpleLookupTable.valueTable;
        int i2 = positions.length;
        while (--i2 >= 0) {
            if (positions[i2] == null) continue;
            int index = (Integer)positions[i2];
            internedArray[index] = (char[])simpleNames[i2];
        }
        this.writeNames(internedArray, out);
        char[][][] internedQArray = new char[internedQualifiedNames.elementSize][][];
        Object[] qualifiedNames = internedQualifiedNames.keyTable;
        positions = internedQualifiedNames.valueTable;
        int i3 = positions.length;
        while (--i3 >= 0) {
            if (positions[i3] == null) continue;
            int index = (Integer)positions[i3];
            internedQArray[index] = (char[][])qualifiedNames[i3];
        }
        length = internedQArray.length;
        out.writeInt(length);
        for (int i4 = 0; i4 < length; ++i4) {
            char[][] qName = internedQArray[i4];
            int qLength = qName.length;
            out.writeInt(qLength);
            for (int j = 0; j < qLength; ++j) {
                Integer index = (Integer)simpleLookupTable.get(qName[j]);
                out.writeIntInRange(index, simpleLookupTable.elementSize);
            }
        }
        length = this.references.size();
        out.writeInt(length);
        if (length > 0) {
            for (Map.Entry<String, ReferenceCollection> entry : this.references.entrySet()) {
                String key = entry.getKey();
                --length;
                Integer index = (Integer)internedTypeLocators.get(key);
                out.writeInt(index);
                ReferenceCollection collection = entry.getValue();
                if (collection instanceof AdditionalTypeCollection) {
                    out.writeByte(1);
                    AdditionalTypeCollection atc = (AdditionalTypeCollection)collection;
                    this.writeNames(atc.definedTypeNames, out);
                } else {
                    out.writeByte(2);
                }
                char[][][] qNames = collection.qualifiedNameReferences;
                int qLength = qNames.length;
                out.writeInt(qLength);
                for (int j = 0; j < qLength; ++j) {
                    index = (Integer)internedQualifiedNames.get(qNames[j]);
                    out.writeIntInRange(index, internedQualifiedNames.elementSize);
                }
                char[][] sNames = collection.simpleNameReferences;
                int sLength = sNames.length;
                out.writeInt(sLength);
                for (int j = 0; j < sLength; ++j) {
                    index = (Integer)simpleLookupTable.get(sNames[j]);
                    out.writeIntInRange(index, simpleLookupTable.elementSize);
                }
                char[][] rNames = collection.rootReferences;
                int rLength = rNames.length;
                out.writeInt(rLength);
                for (int j = 0; j < rLength; ++j) {
                    index = (Integer)internedRootNames.get(rNames[j]);
                    out.writeIntInRange(index, internedRootNames.elementSize);
                }
            }
            if (JavaBuilder.DEBUG && length != 0) {
                System.out.println("references table is inconsistent");
            }
        }
    }

    private void writeSourceLocations(CompressedWriter out, ClasspathMultiDirectory[] srcLocations) throws IOException {
        int length = srcLocations.length;
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            ClasspathMultiDirectory md = srcLocations[i];
            out.writeStringUsingDictionary(md.sourceFolder.getProjectRelativePath().toString());
            out.writeStringUsingDictionary(md.binaryFolder.getProjectRelativePath().toString());
            this.writeNames(md.inclusionPatterns, out);
            this.writeNames(md.exclusionPatterns, out);
            out.writeBoolean(md.ignoreOptionalProblems);
            this.writeNullablePath(md.externalAnnotationPath, out);
            out.writeBoolean(md.hasIndependentOutputFolder);
        }
    }

    private void writeBinaryLocations(CompressedWriter out, ClasspathLocation[] locations, ClasspathMultiDirectory[] srcLocations) throws IOException {
        out.writeInt(locations.length);
        for (int i = 0; i < locations.length; ++i) {
            ClasspathLocation c = locations[i];
            if (c instanceof ClasspathMultiDirectory) {
                out.writeByte(1);
                int m = srcLocations.length;
                for (int j = 0; j < m; ++j) {
                    if (srcLocations[j] != c) continue;
                    out.writeInt(j);
                }
            } else if (c instanceof ClasspathDirectory) {
                out.writeByte(2);
                ClasspathDirectory cd = (ClasspathDirectory)c;
                out.writeStringUsingDictionary(cd.binaryFolder.getFullPath().toString());
                out.writeBoolean(cd.isOutputFolder);
                this.writeRestriction(cd.accessRuleSet, out);
                this.writeNullablePath(cd.externalAnnotationPath, out);
                out.writeBoolean(cd.isOnModulePath);
            } else if (c instanceof ClasspathJar) {
                ClasspathJar jar = (ClasspathJar)c;
                if (jar.resource == null) {
                    out.writeByte(3);
                    out.writeStringUsingDictionary(jar.zipFilename);
                    out.writeLong(jar.lastModified());
                } else {
                    out.writeByte(4);
                    out.writeStringUsingDictionary(jar.resource.getFullPath().toString());
                }
                this.writeRestriction(jar.accessRuleSet, out);
                this.writeNullablePath(jar.externalAnnotationPath, out);
                out.writeBoolean(jar.isOnModulePath);
                out.writeStringUsingDictionary(jar.compliance == null ? "" : jar.compliance);
            } else if (c instanceof ClasspathJrt) {
                ClasspathJrt jrt = (ClasspathJrt)c;
                out.writeByte(3);
                out.writeStringUsingDictionary(jrt.zipFilename);
                this.writeRestriction(jrt.accessRuleSet, out);
                this.writeNullablePath(jrt.externalAnnotationPath, out);
                if (jrt instanceof ClasspathJrtWithReleaseOption) {
                    out.writeStringUsingDictionary(((ClasspathJrtWithReleaseOption)jrt).release);
                } else {
                    out.writeStringUsingDictionary("");
                }
            }
            char[] patchName = c.patchModuleName == null ? CharOperation.NO_CHAR : c.patchModuleName.toCharArray();
            out.writeChars(patchName);
            if (c.limitModuleNames != null) {
                out.writeInt(c.limitModuleNames.size());
                for (String name : c.limitModuleNames) {
                    out.writeStringUsingDictionary(name);
                }
            } else {
                out.writeInt(0);
            }
            if (c.updates != null) {
                List<Consumer<IUpdatableModule>> pu = c.updates.getList(IUpdatableModule.UpdateKind.PACKAGE, false);
                if (pu != null) {
                    Map<String, List<IUpdatableModule.AddExports>> map = pu.stream().filter(IUpdatableModule.AddExports.class::isInstance).map(IUpdatableModule.AddExports.class::cast).collect(Collectors.groupingBy(addExport -> CharOperation.charToString(addExport.getName())));
                    out.writeInt(map.size());
                    map.entrySet().stream().forEach(entry -> {
                        String pkgName = (String)entry.getKey();
                        try {
                            out.writeChars(pkgName.toCharArray());
                            char[][] targetModules = ((List)entry.getValue()).stream().map(addExport -> addExport.getTargetModules()).filter(targets -> targets != null).reduce((f, s) -> CharOperation.arrayConcat(f, s)).orElse(null);
                            this.writeNames(targetModules, out);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                } else {
                    out.writeInt(0);
                }
                List<Consumer<IUpdatableModule>> mu = c.updates.getList(IUpdatableModule.UpdateKind.MODULE, false);
                if (mu != null) {
                    List allReads = mu.stream().filter(IUpdatableModule.AddReads.class::isInstance).map(IUpdatableModule.AddReads.class::cast).collect(Collectors.toList());
                    out.writeInt(allReads.size());
                    for (IUpdatableModule.AddReads m : allReads) {
                        out.writeChars(m.getTarget());
                    }
                    continue;
                }
                out.writeInt(0);
                continue;
            }
            out.writeInt(0);
            out.writeInt(0);
        }
    }

    private void writeNames(char[][] names, CompressedWriter out) throws IOException {
        int length = names == null ? 0 : names.length;
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            out.writeChars(names[i]);
        }
    }

    private static char[][] readNames(CompressedReader in) throws IOException {
        int length = in.readInt();
        char[][] names = new char[length][];
        for (int i = 0; i < length; ++i) {
            names[i] = in.readChars();
        }
        return names;
    }

    private void writeNullablePath(String path, CompressedWriter out) throws IOException {
        out.writeStringUsingDictionary(path != null ? path : "");
    }

    private void writeRestriction(AccessRuleSet accessRuleSet, CompressedWriter out) throws IOException {
        if (accessRuleSet == null) {
            out.writeInt(0);
        } else {
            AccessRule[] accessRules = accessRuleSet.getAccessRules();
            int length = accessRules.length;
            out.writeInt(length);
            if (length != 0) {
                for (int i = 0; i < length; ++i) {
                    AccessRule accessRule = accessRules[i];
                    out.writeCharsUsingLast(accessRule.pattern);
                    out.writeIntWithHint(accessRule.problemId, PROBLEM_IDS);
                }
                out.writeByte(accessRuleSet.classpathEntryType);
                out.writeStringUsingDictionary(accessRuleSet.classpathEntryName);
            }
        }
    }

    public String toString() {
        return "State for " + this.javaProjectName + " (#" + this.buildNumber + " @ " + new Date(this.lastStructuralBuildTime) + ")";
    }
}

