/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.SortedCharArrays;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.NameSet;
import org.eclipse.jdt.internal.core.builder.QualifiedNameSet;
import org.eclipse.jdt.internal.core.builder.StringSet;

public class ReferenceCollection {
    char[][][] qualifiedNameReferences;
    char[][] simpleNameReferences;
    char[][] rootReferences;
    static final char[][][] WellKnownQualifiedNames;
    static final char[][] WellKnownSimpleNames;
    static final char[][][] EmptyQualifiedNames;
    static final char[][] EmptySimpleNames;
    static final int MaxQualifiedNames = 7;
    static QualifiedNameSet[] InternedQualifiedNames;
    static final int MaxSimpleNames = 30;
    static NameSet[] InternedSimpleNames;
    public static boolean REFERENCE_COLLECTION_DEBUG;

    protected ReferenceCollection(char[][][] qualifiedNameReferences, char[][] simpleNameReferences, char[][] rootReferences) {
        this.qualifiedNameReferences = ReferenceCollection.internQualifiedNames(qualifiedNameReferences, false);
        this.simpleNameReferences = ReferenceCollection.internSimpleNames(simpleNameReferences, true);
        this.rootReferences = ReferenceCollection.internSimpleNames(rootReferences, false);
    }

    public void addDependencies(String[] typeNameDependencies) {
        block0: for (String typeNameDependency : typeNameDependencies) {
            int idx;
            char[][] qualifiedTypeName = CharOperation.splitOn('.', typeNameDependency.toCharArray());
            if (ReferenceCollection.isWellKnownQualifiedName(qualifiedTypeName)) continue;
            int qLength = qualifiedTypeName.length;
            QualifiedNameSet internedNames = InternedQualifiedNames[qLength <= 7 ? qLength - 1 : 0];
            qualifiedTypeName = ReferenceCollection.internSimpleNames(qualifiedTypeName, false, false);
            qualifiedTypeName = internedNames.add(qualifiedTypeName);
            while ((idx = Arrays.binarySearch(this.qualifiedNameReferences, qualifiedTypeName, SortedCharArrays.CHAR_CHAR_ARR_COMPARATOR)) < 0) {
                this.simpleNameReferences = ReferenceCollection.ensureContainedInSortedOrder(this.simpleNameReferences, qualifiedTypeName[qualifiedTypeName.length - 1]);
                this.rootReferences = ReferenceCollection.ensureContainedInSortedOrder(this.rootReferences, qualifiedTypeName[0]);
                int length = this.qualifiedNameReferences.length;
                idx = -(idx + 1);
                this.qualifiedNameReferences = SortedCharArrays.insertIntoArray(this.qualifiedNameReferences, new char[length + 1][][], qualifiedTypeName, idx, this.qualifiedNameReferences.length);
                char[][][] temp = ReferenceCollection.internQualifiedNames(new char[][][]{qualifiedTypeName = CharOperation.subarray(qualifiedTypeName, 0, qualifiedTypeName.length - 1)}, false);
                if (temp == EmptyQualifiedNames) continue block0;
                qualifiedTypeName = temp[0];
            }
        }
    }

    public boolean includes(char[] simpleName) {
        boolean result = ReferenceCollection.sortedArrayContains(this.simpleNameReferences, simpleName, SortedCharArrays.CHAR_ARR_COMPARATOR);
        if (REFERENCE_COLLECTION_DEBUG) {
            this.assertIncludes(result, simpleName);
        }
        return result;
    }

    public boolean includes(char[][] qualifiedName) {
        boolean result = ReferenceCollection.sortedArrayContains(this.qualifiedNameReferences, qualifiedName, SortedCharArrays.CHAR_CHAR_ARR_COMPARATOR);
        if (REFERENCE_COLLECTION_DEBUG) {
            this.assertIncludes(result, qualifiedName);
        }
        return result;
    }

    private static String qualifiedNamesToString(char[][][] qualifiedNames) {
        if (qualifiedNames == null) {
            return "null";
        }
        return Arrays.stream(qualifiedNames).map(CharOperation::toString).collect(Collectors.joining(","));
    }

    public boolean includes(char[][][] qualifiedNames, char[][] simpleNames) {
        return this.includes(qualifiedNames, simpleNames, null);
    }

    public boolean includes(char[][][] qualifiedNames, char[][] simpleNames, char[][] rootNames) {
        boolean result = this.doIncludes(qualifiedNames, simpleNames, rootNames);
        if (REFERENCE_COLLECTION_DEBUG) {
            this.assertIncludes(result, qualifiedNames, simpleNames, rootNames);
        }
        return result;
    }

    private boolean doIncludes(char[][][] qualifiedNames, char[][] simpleNames, char[][] rootNames) {
        if (rootNames != null && !this.includesRootName(rootNames)) {
            return false;
        }
        if (simpleNames == null || qualifiedNames == null) {
            if (simpleNames == null && qualifiedNames == null) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Found well known match");
                }
                return true;
            }
            if (qualifiedNames == null) {
                return this.includesSimpleName(simpleNames);
            }
            return this.includesQualifiedName(qualifiedNames);
        }
        if (simpleNames.length <= qualifiedNames.length) {
            return this.includesSimpleName(simpleNames) && this.includesQualifiedName(qualifiedNames);
        }
        return this.includesQualifiedName(qualifiedNames) && this.includesSimpleName(simpleNames);
    }

    public boolean insideRoot(char[] rootName) {
        boolean result = ReferenceCollection.sortedArrayContains(this.rootReferences, rootName, SortedCharArrays.CHAR_ARR_COMPARATOR);
        if (REFERENCE_COLLECTION_DEBUG && result != this.debugIncludes(rootName)) {
            String message = "Mismatch: " + String.valueOf(rootName) + (result ? " should not " : " should ") + " be included in " + Arrays.asList(CharOperation.toStrings(this.rootReferences));
            throw new IllegalStateException(message);
        }
        return result;
    }

    private static <T> boolean sortedArrayContains(T[] array, T element, Comparator<? super T> comparator) {
        int l = array.length;
        if (l < 16) {
            for (int i = 0; i < l; ++i) {
                if (element != array[i]) continue;
                return true;
            }
            return false;
        }
        return Arrays.binarySearch(array, element, comparator) >= 0;
    }

    private boolean includesSimpleName(char[][] simpleNames) {
        return ReferenceCollection.intersects(simpleNames, this.simpleNameReferences, SortedCharArrays.CHAR_ARR_COMPARATOR);
    }

    private boolean includesQualifiedName(char[][][] qualifiedNames) {
        char[][] maybeSimpleName;
        if (ReferenceCollection.intersects(qualifiedNames, this.qualifiedNameReferences, SortedCharArrays.CHAR_CHAR_ARR_COMPARATOR)) {
            return true;
        }
        for (int i = qualifiedNames.length - 1; i >= 0 && (maybeSimpleName = qualifiedNames[i]).length == 1; --i) {
            if (!this.includes(maybeSimpleName[0])) continue;
            return true;
        }
        return false;
    }

    private boolean includesRootName(char[][] rootNames) {
        return ReferenceCollection.intersects(rootNames, this.rootReferences, SortedCharArrays.CHAR_ARR_COMPARATOR);
    }

    private static <T> boolean intersects(T[] firstSortedArr, T[] secondSortedArr, Comparator<? super T> comparator) {
        int i = 0;
        int l = firstSortedArr.length;
        int j = 0;
        int k = secondSortedArr.length;
        while (i < l && j < k) {
            T firstElement = firstSortedArr[i];
            T secondElement = secondSortedArr[j];
            int compare = comparator.compare(firstElement, secondElement);
            if (compare == 0) {
                return true;
            }
            if (compare < 0) {
                if (l - ++i <= 16) continue;
                if ((i = Arrays.binarySearch(firstSortedArr, i, l, secondElement, comparator)) >= 0) {
                    return true;
                }
                i = -(i + 1);
                continue;
            }
            if (k - ++j <= 16) continue;
            if ((j = Arrays.binarySearch(secondSortedArr, j, k, firstElement, comparator)) >= 0) {
                return true;
            }
            j = -(j + 1);
        }
        return false;
    }

    private static char[][] ensureContainedInSortedOrder(char[][] sortedArray, char[] entry) {
        int idx = Arrays.binarySearch(sortedArray, entry, SortedCharArrays.CHAR_ARR_COMPARATOR);
        if (idx < 0) {
            idx = -(idx + 1);
            char[][] result = SortedCharArrays.insertIntoArray(sortedArray, new char[sortedArray.length + 1][], entry, idx, sortedArray.length);
            return result;
        }
        return sortedArray;
    }

    private static boolean isWellKnownQualifiedName(char[][] qualifiedName) {
        char[][] wellKnownName;
        int m = WellKnownQualifiedNames.length;
        int qLength = qualifiedName.length;
        for (int i = 0; i < m && qLength <= (wellKnownName = WellKnownQualifiedNames[i]).length; ++i) {
            if (!CharOperation.equals(qualifiedName, wellKnownName)) continue;
            return true;
        }
        return false;
    }

    public static char[][][] internQualifiedNames(Set<String> qualifiedStrings) {
        if (qualifiedStrings == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedStrings.size();
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] result = new char[length][][];
        for (String qualifiedString : qualifiedStrings) {
            if (qualifiedString == null) continue;
            result[--length] = CharOperation.splitOn('/', qualifiedString.toCharArray());
        }
        return ReferenceCollection.internQualifiedNames(result, false);
    }

    public static char[][][] internQualifiedNames(StringSet qualifiedStrings) {
        if (qualifiedStrings == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedStrings.elementSize;
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] result = new char[length][][];
        String[] strings = qualifiedStrings.values;
        int l = strings.length;
        for (int i = 0; i < l; ++i) {
            if (strings[i] == null) continue;
            result[--length] = CharOperation.splitOn('/', strings[i].toCharArray());
        }
        return ReferenceCollection.internQualifiedNames(result, false);
    }

    public static char[][][] internQualifiedNames(char[][][] qualifiedNames) {
        return ReferenceCollection.internQualifiedNames(qualifiedNames, false);
    }

    public static char[][][] internQualifiedNames(char[][][] qualifiedNames, boolean keepWellKnown) {
        return ReferenceCollection.internQualifiedNames(qualifiedNames, keepWellKnown, true);
    }

    static char[][][] internQualifiedNames(char[][][] qualifiedNames, boolean keepWellKnown, boolean doSort) {
        if (qualifiedNames == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedNames.length;
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] keepers = new char[length][][];
        char[][] prev = null;
        boolean isSorted = true;
        int index = 0;
        block0: for (int i = 0; i < length; ++i) {
            char[][] qualifiedName = qualifiedNames[i];
            int qLength = qualifiedName.length;
            for (char[][] wellKnownName : WellKnownQualifiedNames) {
                if (qLength > wellKnownName.length) break;
                if (!CharOperation.equals(qualifiedName, wellKnownName)) continue;
                if (!keepWellKnown) continue block0;
                if (doSort && isSorted) {
                    if (prev != null && SortedCharArrays.compareCharCharArray(prev, qualifiedName) > 0) {
                        isSorted = false;
                    }
                    prev = qualifiedName;
                }
                keepers[index++] = wellKnownName;
                continue block0;
            }
            QualifiedNameSet internedNames = InternedQualifiedNames[qLength <= 7 ? qLength - 1 : 0];
            qualifiedName = ReferenceCollection.internSimpleNames(qualifiedName, false, false);
            if (doSort && isSorted) {
                if (prev != null && SortedCharArrays.compareCharCharArray(prev, qualifiedName) > 0) {
                    isSorted = false;
                }
                prev = qualifiedName;
            }
            keepers[index++] = internedNames.add(qualifiedName);
        }
        if (length > index) {
            if (index == 0) {
                return EmptyQualifiedNames;
            }
            char[][][] cArrayArray = keepers;
            keepers = new char[index][][];
            System.arraycopy(cArrayArray, 0, keepers, 0, index);
        }
        if (doSort && !isSorted) {
            Arrays.sort(keepers, SortedCharArrays.CHAR_CHAR_ARR_COMPARATOR);
        }
        return keepers;
    }

    public static char[][] internSimpleNames(Set<String> simpleStrings) {
        return ReferenceCollection.internSimpleNames(simpleStrings, true);
    }

    public static char[][] internSimpleNames(Set<String> simpleStrings, boolean removeWellKnown) {
        if (simpleStrings == null) {
            return EmptySimpleNames;
        }
        int length = simpleStrings.size();
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] result = new char[length][];
        for (String simpleString : simpleStrings) {
            if (simpleString == null) continue;
            result[--length] = simpleString.toCharArray();
        }
        return ReferenceCollection.internSimpleNames(result, removeWellKnown);
    }

    public static char[][] internSimpleNames(StringSet simpleStrings, boolean removeWellKnown) {
        if (simpleStrings == null) {
            return EmptySimpleNames;
        }
        int length = simpleStrings.elementSize;
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] result = new char[length][];
        String[] strings = simpleStrings.values;
        int l = strings.length;
        for (int i = 0; i < l; ++i) {
            if (strings[i] == null) continue;
            result[--length] = strings[i].toCharArray();
        }
        return ReferenceCollection.internSimpleNames(result, removeWellKnown);
    }

    public static char[][] internSimpleNames(char[][] simpleNames, boolean removeWellKnown) {
        return ReferenceCollection.internSimpleNames(simpleNames, removeWellKnown, true);
    }

    static char[][] internSimpleNames(char[][] simpleNames, boolean removeWellKnown, boolean doSort) {
        if (simpleNames == null) {
            return EmptySimpleNames;
        }
        int length = simpleNames.length;
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] keepers = new char[length][];
        char[] prev = null;
        boolean isSorted = true;
        int index = 0;
        block0: for (int i = 0; i < length; ++i) {
            char[] name = simpleNames[i];
            int sLength = name.length;
            for (char[] wellKnownName : WellKnownSimpleNames) {
                if (sLength > wellKnownName.length) break;
                if (!CharOperation.equals(name, wellKnownName)) continue;
                if (removeWellKnown) continue block0;
                keepers[index++] = wellKnownName;
                if (!doSort || !isSorted) continue block0;
                if (prev != null && SortedCharArrays.compareCharArray(prev, name) > 0) {
                    isSorted = false;
                }
                prev = name;
                continue block0;
            }
            NameSet internedNames = InternedSimpleNames[sLength < 30 ? sLength : 0];
            keepers[index++] = internedNames.add(name);
            if (!doSort || !isSorted) continue;
            if (prev != null && SortedCharArrays.compareCharArray(prev, name) > 0) {
                isSorted = false;
            }
            prev = name;
        }
        if (length > index) {
            if (index == 0) {
                return EmptySimpleNames;
            }
            char[][] cArrayArray = keepers;
            keepers = new char[index][];
            System.arraycopy(cArrayArray, 0, keepers, 0, index);
        }
        if (doSort && !isSorted) {
            Arrays.sort(keepers, SortedCharArrays.CHAR_ARR_COMPARATOR);
        }
        return keepers;
    }

    private void assertIncludes(boolean expectation, char[] simpleName) {
        if (expectation != this.debugIncludes(simpleName)) {
            String message = "Mismatch: " + String.valueOf(simpleName) + (expectation ? " should not " : " should ") + " be included in " + Arrays.asList(CharOperation.toStrings(this.simpleNameReferences));
            throw new IllegalStateException(message);
        }
    }

    private void assertIncludes(boolean expectation, char[][] qualifiedName) {
        if (expectation != this.debugIncludes(qualifiedName)) {
            String message = "Mismatch: " + CharOperation.toString(qualifiedName) + (expectation ? " should not " : " should ") + " be included in " + ReferenceCollection.qualifiedNamesToString(this.qualifiedNameReferences);
            throw new IllegalStateException(message);
        }
    }

    private void assertIncludes(boolean expectation, char[][][] qualifiedNames, char[][] simpleNames, char[][] rootNames) {
        if (expectation != this.debugIncludes(qualifiedNames, simpleNames, rootNames)) {
            String message = String.format("Mismatched includes(..): ReferenceCollection([%s], %s, %s).includes([%s], %s, %s)", ReferenceCollection.qualifiedNamesToString(this.qualifiedNameReferences), Arrays.toString(CharOperation.toStrings(this.simpleNameReferences)), Arrays.toString(CharOperation.toStrings(this.rootReferences)), ReferenceCollection.qualifiedNamesToString(qualifiedNames), Arrays.toString(CharOperation.toStrings(simpleNames)), Arrays.toString(CharOperation.toStrings(rootNames)));
            throw new IllegalStateException(message);
        }
    }

    private boolean debugIncludes(char[][][] qualifiedNames, char[][] simpleNames, char[][] rootNames) {
        int i;
        if (rootNames != null) {
            boolean foundRoot = false;
            int l = rootNames.length;
            for (int i2 = 0; !foundRoot && i2 < l; ++i2) {
                foundRoot = this.debugInsideRoot(rootNames[i2]);
            }
            if (!foundRoot) {
                return false;
            }
        }
        if (simpleNames == null || qualifiedNames == null) {
            if (simpleNames == null && qualifiedNames == null) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Found well known match");
                }
                return true;
            }
            if (qualifiedNames == null) {
                int l = simpleNames.length;
                for (int i3 = 0; i3 < l; ++i3) {
                    if (!this.debugIncludes(simpleNames[i3])) continue;
                    if (JavaBuilder.DEBUG) {
                        System.out.println("Found match in well known package to " + new String(simpleNames[i3]));
                    }
                    return true;
                }
            } else {
                for (char[][] qualifiedName : qualifiedNames) {
                    if (!(qualifiedName.length == 1 ? this.debugIncludes(qualifiedName[0]) : this.debugIncludes(qualifiedName))) continue;
                    if (JavaBuilder.DEBUG) {
                        System.out.println("Found well known match in " + CharOperation.toString(qualifiedName));
                    }
                    return true;
                }
            }
            return false;
        }
        int sLength = simpleNames.length;
        int qLength = qualifiedNames.length;
        if (sLength <= qLength) {
            for (i = 0; i < sLength; ++i) {
                if (!this.debugIncludes(simpleNames[i])) continue;
                for (int j = 0; j < qLength; ++j) {
                    char[][] qualifiedName = qualifiedNames[j];
                    if (!(qualifiedName.length == 1 ? this.debugIncludes(qualifiedName[0]) : this.debugIncludes(qualifiedName))) continue;
                    if (JavaBuilder.DEBUG) {
                        System.out.println("Found match in " + CharOperation.toString(qualifiedName) + " to " + new String(simpleNames[i]));
                    }
                    return true;
                }
                return false;
            }
        } else {
            for (i = 0; i < qLength; ++i) {
                char[][] qualifiedName = qualifiedNames[i];
                if (!(qualifiedName.length == 1 ? this.debugIncludes(qualifiedName[0]) : this.debugIncludes(qualifiedName))) continue;
                for (int j = 0; j < sLength; ++j) {
                    if (!this.debugIncludes(simpleNames[j])) continue;
                    if (JavaBuilder.DEBUG) {
                        System.out.println("Found match in " + CharOperation.toString(qualifiedName) + " to " + new String(simpleNames[j]));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean debugInsideRoot(char[] rootName) {
        int l = this.rootReferences.length;
        for (int i = 0; i < l; ++i) {
            if (rootName != this.rootReferences[i]) continue;
            return true;
        }
        return false;
    }

    private boolean debugIncludes(char[] simpleName) {
        int l = this.simpleNameReferences.length;
        for (int i = 0; i < l; ++i) {
            if (simpleName != this.simpleNameReferences[i]) continue;
            return true;
        }
        return false;
    }

    private boolean debugIncludes(char[][] qualifiedName) {
        int l = this.qualifiedNameReferences.length;
        for (int i = 0; i < l; ++i) {
            if (qualifiedName != this.qualifiedNameReferences[i]) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReferenceCollection)) {
            return false;
        }
        ReferenceCollection other = (ReferenceCollection)obj;
        return Arrays.deepEquals((Object[])this.qualifiedNameReferences, (Object[])other.qualifiedNameReferences) && Arrays.deepEquals((Object[])this.rootReferences, (Object[])other.rootReferences) && Arrays.deepEquals((Object[])this.simpleNameReferences, (Object[])other.simpleNameReferences);
    }

    static {
        int i;
        WellKnownQualifiedNames = new char[][][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, TypeConstants.JAVA_LANG_THROWABLE, TypeConstants.JAVA_LANG_OBJECT, TypeConstants.JAVA_LANG, new char[][]{TypeConstants.JAVA}, new char[][]{{'o', 'r', 'g'}}, new char[][]{{'c', 'o', 'm'}}, CharOperation.NO_CHAR_CHAR};
        WellKnownSimpleNames = new char[][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION[2], TypeConstants.JAVA_LANG_THROWABLE[2], TypeConstants.JAVA_LANG_OBJECT[2], TypeConstants.JAVA, TypeConstants.LANG, {'o', 'r', 'g'}, {'c', 'o', 'm'}};
        EmptyQualifiedNames = new char[0][][];
        EmptySimpleNames = CharOperation.NO_CHAR_CHAR;
        InternedQualifiedNames = new QualifiedNameSet[7];
        InternedSimpleNames = new NameSet[30];
        for (i = 0; i < 7; ++i) {
            ReferenceCollection.InternedQualifiedNames[i] = new QualifiedNameSet(37);
        }
        for (i = 0; i < 30; ++i) {
            ReferenceCollection.InternedSimpleNames[i] = new NameSet(37);
        }
        REFERENCE_COLLECTION_DEBUG = false;
    }
}

