/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.ChangeClasspathOperation;
import org.eclipse.jdt.internal.core.ClasspathChange;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Util;

public class SetContainerOperation
extends ChangeClasspathOperation {
    IPath containerPath;
    IJavaProject[] affectedProjects;
    IClasspathContainer[] respectiveContainers;

    public SetContainerOperation(IPath containerPath, IJavaProject[] affectedProjects, IClasspathContainer[] respectiveContainers) {
        super(new IJavaElement[]{JavaModelManager.getJavaModelManager().getJavaModel()}, !ResourcesPlugin.getWorkspace().isTreeLocked());
        this.containerPath = containerPath;
        this.affectedProjects = affectedProjects;
        this.respectiveContainers = respectiveContainers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeOperation() throws JavaModelException {
        this.checkCanceled();
        try {
            JavaProject affectedProject;
            int i;
            JavaModelManager manager;
            this.beginTask("", 1);
            if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                this.verbose_set_container();
            }
            if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                this.verbose_set_container_invocation_trace();
            }
            if ((manager = JavaModelManager.getJavaModelManager()).containerPutIfInitializingWithSameEntries(this.containerPath, this.affectedProjects, this.respectiveContainers)) {
                return;
            }
            int projectLength = this.affectedProjects.length;
            IJavaProject[] modifiedProjects = new IJavaProject[projectLength];
            System.arraycopy(this.affectedProjects, 0, modifiedProjects, 0, projectLength);
            int remaining = 0;
            for (i = 0; i < projectLength; ++i) {
                if (this.isCanceled()) {
                    return;
                }
                affectedProject = (JavaProject)this.affectedProjects[i];
                IClasspathContainer newContainer = this.respectiveContainers[i];
                if (newContainer == null) {
                    newContainer = JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS;
                }
                boolean found = false;
                if (JavaProject.hasJavaNature(affectedProject.getProject())) {
                    for (IClasspathEntry entry : affectedProject.getRawClasspath()) {
                        if (entry.getEntryKind() != 5 || !entry.getPath().equals((Object)this.containerPath)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    modifiedProjects[i] = null;
                    manager.containerPut(affectedProject, this.containerPath, newContainer);
                    continue;
                }
                IClasspathContainer oldContainer = manager.containerGet(affectedProject, this.containerPath);
                if (oldContainer == JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
                    oldContainer = null;
                }
                if (oldContainer != null && oldContainer.equals(this.respectiveContainers[i]) || oldContainer == this.respectiveContainers[i]) {
                    modifiedProjects[i] = null;
                    continue;
                }
                ++remaining;
                manager.containerPut(affectedProject, this.containerPath, newContainer);
            }
            if (remaining == 0) {
                return;
            }
            try {
                for (i = 0; i < projectLength; ++i) {
                    this.progressMonitor.setWorkRemaining(projectLength - i);
                    if (this.isCanceled()) {
                        return;
                    }
                    affectedProject = (JavaProject)modifiedProjects[i];
                    if (affectedProject == null) continue;
                    if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                        this.verbose_update_project(affectedProject);
                    }
                    ClasspathChange classpathChange = affectedProject.getPerProjectInfo().resetResolvedClasspath();
                    this.classpathChanged(classpathChange, i == 0);
                    if (!this.canChangeResources) continue;
                    try {
                        affectedProject.getProject().touch((IProgressMonitor)this.progressMonitor.split(1));
                        continue;
                    }
                    catch (CoreException e) {
                        if (" ".equals(affectedProject.getElementName())) continue;
                        throw e;
                    }
                    catch (OperationCanceledException ex) {
                        throw new JavaModelException(ex, 992);
                    }
                }
            }
            catch (CoreException e) {
                if (JavaModelManager.CP_RESOLVE_VERBOSE || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
                    this.verbose_failure(e);
                }
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
            finally {
                for (int i2 = 0; i2 < projectLength; ++i2) {
                    if (this.respectiveContainers[i2] != null) continue;
                    manager.containerPut(this.affectedProjects[i2], this.containerPath, null);
                }
            }
        }
        finally {
            this.done();
        }
    }

    private void verbose_failure(CoreException e) {
        Util.verbose("CPContainer SET  - FAILED DUE TO EXCEPTION\n\tcontainer path: " + this.containerPath, System.err);
        e.printStackTrace();
    }

    private void verbose_update_project(JavaProject affectedProject) {
        Util.verbose("CPContainer SET  - updating affected project due to setting container\n\tproject: " + affectedProject.getElementName() + "\n\tcontainer path: " + this.containerPath);
    }

    private void verbose_set_container() {
        Util.verbose("CPContainer SET  - setting container\n\tcontainer path: " + this.containerPath + "\n\tprojects: {" + org.eclipse.jdt.internal.compiler.util.Util.toString(this.affectedProjects, new Util.Displayable(){

            @Override
            public String displayString(Object o) {
                return ((IJavaProject)o).getElementName();
            }
        }) + "}\n\tvalues: {\n" + org.eclipse.jdt.internal.compiler.util.Util.toString(this.respectiveContainers, new Util.Displayable(){

            @Override
            public String displayString(Object o) {
                StringBuilder buffer = new StringBuilder("\t\t");
                if (o == null) {
                    buffer.append("<null>");
                    return buffer.toString();
                }
                IClasspathContainer container = (IClasspathContainer)o;
                buffer.append(container.getDescription());
                buffer.append(" {\n");
                IClasspathEntry[] entries = container.getClasspathEntries();
                if (entries != null) {
                    for (int i = 0; i < entries.length; ++i) {
                        buffer.append(" \t\t\t");
                        buffer.append(entries[i]);
                        buffer.append('\n');
                    }
                }
                buffer.append(" \t\t}");
                return buffer.toString();
            }
        }) + "\n\t}");
    }

    private void verbose_set_container_invocation_trace() {
        Util.verbose("CPContainer SET  - setting container\n\tinvocation stack trace:");
        new Exception("<Fake exception>").printStackTrace(System.out);
    }
}

