/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;

public class ProjectEntry
implements IModulePathEntry {
    JavaProject project;

    static boolean representsProject(IModulePathEntry entry, IJavaProject otherProject) {
        if (entry instanceof ProjectEntry) {
            return ((ProjectEntry)entry).project.equals(otherProject);
        }
        return false;
    }

    public ProjectEntry(JavaProject project) {
        this.project = project;
    }

    @Override
    public IModule getModule() {
        try {
            IModuleDescription module = this.project.getModuleDescription();
            if (module != null) {
                return (IModule)((JavaElement)((Object)module)).getElementInfo();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isAutomaticModule() {
        return false;
    }

    @Override
    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        IModule mod = this.getModule();
        if (mod == null ? moduleName != null : !String.valueOf(mod.name()).equals(moduleName)) {
            return null;
        }
        try {
            IJavaElement element = this.project.findElement((IPath)new Path(qualifiedPackageName.replace('.', '/')));
            if (element instanceof IPackageFragment) {
                Object object;
                if (mod != null) {
                    char[][] cArrayArray = new char[1][];
                    object = cArrayArray;
                    cArrayArray[0] = mod.name();
                } else {
                    object = CharOperation.NO_CHAR_CHAR;
                }
                return object;
            }
        }
        catch (JavaModelException e) {
            return null;
        }
        return null;
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        try {
            for (IPackageFragmentRoot root : this.project.getPackageFragmentRoots()) {
                if (!(root instanceof PackageFragmentRoot) || !((PackageFragmentRoot)root).hasCompilationUnit(qualifiedPackageName, moduleName)) continue;
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }
}

