/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.util.HashSetOfArray;
import org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.jdt.internal.core.util.Util;

class JavaProjectElementInfo
extends OpenableElementInfo {
    static final IPackageFragmentRoot[] NO_ROOTS = new IPackageFragmentRoot[0];
    ProjectCache projectCache;
    ProjectCache mainProjectCache;

    static void addSuperPackageNames(String[] pkgName, HashtableOfArrayToObject packageFragments) {
        for (int i = pkgName.length - 1; i > 0; --i) {
            if (packageFragments.getKey(pkgName, i) != null) continue;
            String[] stringArray = pkgName;
            pkgName = new String[i];
            System.arraycopy(stringArray, 0, pkgName, 0, i);
            packageFragments.put(pkgName, NO_ROOTS);
        }
    }

    public JavaProjectElementInfo() {
        this.nonJavaResources = null;
    }

    private Object[] computeNonJavaResources(JavaProject project) {
        IPath projectPath = project.getProject().getFullPath();
        boolean srcIsProject = false;
        boolean binIsProject = false;
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = null;
        IPath projectOutput = null;
        boolean isClasspathResolved = true;
        try {
            IClasspathEntry entry = project.getClasspathEntryFor(projectPath);
            if (entry != null) {
                srcIsProject = true;
                inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
                exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
            }
            projectOutput = project.getOutputLocation();
            binIsProject = projectPath.equals((Object)projectOutput);
        }
        catch (JavaModelException e) {
            isClasspathResolved = false;
        }
        Object[] resources = new IResource[5];
        int resourcesCounter = 0;
        try {
            IResource[] members = ((IContainer)project.getResource()).members();
            int length = members.length;
            if (length > 0) {
                String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
                String complianceLevel = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
                IClasspathEntry[] classpath = project.getResolvedClasspath();
                block8: for (int i = 0; i < length; ++i) {
                    IResource res = members[i];
                    switch (res.getType()) {
                        case 1: {
                            IPath resFullPath = res.getFullPath();
                            String resName = res.getName();
                            if (isClasspathResolved && this.isClasspathEntryOrOutputLocation(resFullPath, res.getLocation(), classpath, projectOutput) || srcIsProject && Util.isValidCompilationUnitName(resName, sourceLevel, complianceLevel) && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) || binIsProject && Util.isValidClassFileName(resName, sourceLevel, complianceLevel)) continue block8;
                            if (resources.length == resourcesCounter) {
                                Object[] objectArray = resources;
                                resources = new IResource[resourcesCounter * 2];
                                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                            }
                            resources[resourcesCounter++] = res;
                            continue block8;
                        }
                        case 2: {
                            IPath resFullPath = res.getFullPath();
                            if (srcIsProject && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) && Util.isValidFolderNameForPackage(res.getName(), sourceLevel, complianceLevel) || isClasspathResolved && this.isClasspathEntryOrOutputLocation(resFullPath, res.getLocation(), classpath, projectOutput)) continue block8;
                            if (resources.length == resourcesCounter) {
                                Object[] objectArray = resources;
                                resources = new IResource[resourcesCounter * 2];
                                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                            }
                            resources[resourcesCounter++] = res;
                        }
                    }
                }
            }
            if (resources.length != resourcesCounter) {
                Object[] objectArray = resources;
                resources = new IResource[resourcesCounter];
                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
            }
        }
        catch (CoreException e) {
            resources = NO_NON_JAVA_RESOURCES;
            resourcesCounter = 0;
        }
        return resources;
    }

    ProjectCache getProjectCache(JavaProject project, boolean excludeTestCode) {
        ProjectCache cache;
        ProjectCache projectCache = cache = excludeTestCode ? this.mainProjectCache : this.projectCache;
        if (cache != null) {
            for (IPackageFragmentRoot root : cache.allPkgFragmentRootsCache) {
                IJavaProject rootProject = root.getJavaProject();
                if (rootProject == project || rootProject.exists()) continue;
                cache = null;
                break;
            }
        }
        if (cache == null) {
            IPackageFragmentRoot[] roots;
            HashMap<IPackageFragmentRoot, IClasspathEntry> reverseMap = new HashMap<IPackageFragmentRoot, IClasspathEntry>(3);
            try {
                roots = project.getAllPackageFragmentRoots(reverseMap, excludeTestCode);
            }
            catch (JavaModelException e) {
                roots = new IPackageFragmentRoot[]{};
                reverseMap.clear();
            }
            Map<IPath, DeltaProcessor.RootInfo> rootInfos = JavaModelManager.getJavaModelManager().deltaState.roots;
            HashMap<IPackageFragmentRoot, HashSetOfArray> pkgFragmentsCaches = new HashMap<IPackageFragmentRoot, HashSetOfArray>();
            int length = roots.length;
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            for (int i = 0; i < length; ++i) {
                IPackageFragmentRoot root = roots[i];
                DeltaProcessor.RootInfo rootInfo = rootInfos.get(root.getPath());
                if (rootInfo != null && !rootInfo.project.equals(project)) continue;
                roots[i] = root = (IPackageFragmentRoot)manager.getExistingElement(root);
                HashSetOfArray fragmentsCache = new HashSetOfArray();
                this.initializePackageNames(root, fragmentsCache);
                pkgFragmentsCaches.put(root, fragmentsCache);
            }
            cache = new ProjectCache(roots, reverseMap, pkgFragmentsCaches);
            if (excludeTestCode) {
                this.mainProjectCache = cache;
            } else {
                this.projectCache = cache;
            }
        }
        return cache;
    }

    Object[] getNonJavaResources(JavaProject project) {
        Object[] resources = this.nonJavaResources;
        if (resources == null) {
            resources = this.computeNonJavaResources(project);
            this.nonJavaResources = resources;
        }
        return resources;
    }

    private void initializePackageNames(IPackageFragmentRoot root, HashSetOfArray fragmentsCache) {
        IJavaElement[] frags = null;
        try {
            if (!root.isOpen()) {
                PackageFragmentRootInfo info = root.isArchive() ? new JarPackageFragmentRootInfo() : new PackageFragmentRootInfo();
                ((PackageFragmentRoot)root).computeChildren(info, ((JavaElement)((Object)root)).resource());
                frags = info.children;
            } else {
                frags = root.getChildren();
            }
        }
        catch (JavaModelException e) {
            return;
        }
        int length = frags.length;
        for (int j = 0; j < length; ++j) {
            if (!(frags[j] instanceof PackageFragment)) continue;
            fragmentsCache.add(((PackageFragment)frags[j]).names);
        }
    }

    private boolean isClasspathEntryOrOutputLocation(IPath path, IPath location, IClasspathEntry[] resolvedClasspath, IPath projectOutput) {
        if (projectOutput.equals((Object)path)) {
            return true;
        }
        for (IClasspathEntry entry : resolvedClasspath) {
            IPath entryPath = entry.getPath();
            if (entryPath.equals((Object)path) || entryPath.equals((Object)location)) {
                return true;
            }
            IPath output = entry.getOutputLocation();
            if (output == null || !output.equals((Object)path)) continue;
            return true;
        }
        return false;
    }

    NameLookup newNameLookup(JavaProject project, ICompilationUnit[] workingCopies, boolean excludeTestCode) {
        ProjectCache cache = this.getProjectCache(project, excludeTestCode);
        HashtableOfArrayToObject allPkgFragmentsCache = cache.allPkgFragmentsCache;
        if (allPkgFragmentsCache == null) {
            Map<IPath, DeltaProcessor.RootInfo> rootInfos = JavaModelManager.getJavaModelManager().deltaState.roots;
            IPackageFragmentRoot[] allRoots = cache.allPkgFragmentRootsCache;
            int length = allRoots.length;
            allPkgFragmentsCache = new HashtableOfArrayToObject();
            for (int i = 0; i < length; ++i) {
                HashSetOfArray fragmentsCache;
                JavaProject rootProject;
                IPackageFragmentRoot root = allRoots[i];
                DeltaProcessor.RootInfo rootInfo = rootInfos.get(root.getPath());
                JavaProject javaProject = rootProject = rootInfo == null ? project : rootInfo.project;
                if (rootProject.equals(project)) {
                    fragmentsCache = cache.pkgFragmentsCaches.get(root);
                } else {
                    ProjectCache rootProjectCache;
                    try {
                        rootProjectCache = rootProject.getProjectCache(excludeTestCode);
                    }
                    catch (JavaModelException e) {
                        continue;
                    }
                    fragmentsCache = rootProjectCache.pkgFragmentsCaches.get(root);
                }
                if (fragmentsCache == null) {
                    fragmentsCache = new HashSetOfArray();
                    this.initializePackageNames(root, fragmentsCache);
                }
                Object[][] set = fragmentsCache.set;
                int length2 = set.length;
                for (int j = 0; j < length2; ++j) {
                    Object[] pkgName = (String[])set[j];
                    if (pkgName == null) continue;
                    Object existing = allPkgFragmentsCache.get(pkgName);
                    if (existing == null || existing == NO_ROOTS) {
                        allPkgFragmentsCache.put(pkgName, root);
                        JavaProjectElementInfo.addSuperPackageNames((String[])pkgName, allPkgFragmentsCache);
                        continue;
                    }
                    if (existing instanceof PackageFragmentRoot) {
                        allPkgFragmentsCache.put(pkgName, new IPackageFragmentRoot[]{(PackageFragmentRoot)existing, root});
                        continue;
                    }
                    IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])existing;
                    int rootLength = roots.length;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                    roots = new IPackageFragmentRoot[rootLength + 1];
                    System.arraycopy(iPackageFragmentRootArray, 0, roots, 0, rootLength);
                    roots[rootLength] = root;
                    allPkgFragmentsCache.put(pkgName, roots);
                }
            }
            cache.allPkgFragmentsCache = allPkgFragmentsCache;
        }
        return new NameLookup(project, cache.allPkgFragmentRootsCache, cache.allPkgFragmentsCache, workingCopies, cache.rootToResolvedEntries);
    }

    void resetCaches() {
        this.projectCache = null;
        this.mainProjectCache = null;
    }

    static class ProjectCache {
        public IPackageFragmentRoot[] allPkgFragmentRootsCache;
        public HashtableOfArrayToObject allPkgFragmentsCache;
        public Map<IPackageFragmentRoot, HashSetOfArray> pkgFragmentsCaches;
        public Map<IPackageFragmentRoot, IClasspathEntry> rootToResolvedEntries;

        ProjectCache(IPackageFragmentRoot[] allPkgFragmentRootsCache, Map<IPackageFragmentRoot, IClasspathEntry> rootToResolvedEntries, Map<IPackageFragmentRoot, HashSetOfArray> pkgFragmentsCaches) {
            this.allPkgFragmentRootsCache = allPkgFragmentRootsCache;
            this.rootToResolvedEntries = rootToResolvedEntries;
            this.pkgFragmentsCaches = pkgFragmentsCaches;
        }
    }
}

