/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JarEntryResource;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.jdt.internal.core.util.Util;

public class JarPackageFragmentRoot
extends PackageFragmentRoot {
    protected static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath jarPath;
    boolean knownToBeModuleLess;
    private boolean multiVersion;
    protected final IClasspathAttribute[] extraAttributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarPackageFragmentRoot(IResource resource, IPath externalJarPath, JavaProject project, IClasspathAttribute[] attributes) {
        super(resource, project);
        this.jarPath = externalJarPath;
        if (attributes == null) {
            try {
                JavaModelManager.PerProjectInfo perProjectInfo;
                JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo = project.getPerProjectInfo();
                synchronized (perProjectInfo2) {
                    IClasspathEntry classpathEntry;
                    if (perProjectInfo.resolvedClasspath != null && perProjectInfo.unresolvedEntryStatus == JavaModelStatus.VERIFIED_OK && (classpathEntry = project.getClasspathEntryFor(externalJarPath)) != null) {
                        attributes = classpathEntry.getExtraAttributes();
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        this.extraAttributes = attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean computeChildren(OpenableElementInfo info, IResource underlyingResource) throws JavaModelException {
        HashtableOfArrayToObject rawPackageInfo = new HashtableOfArrayToObject();
        HashMap<String, String> overridden = new HashMap<String, String>();
        IJavaElement[] children = NO_ELEMENTS;
        try {
            rawPackageInfo.put(CharOperation.NO_STRINGS, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
            Object file = JavaModel.getTarget(this.getPath(), true);
            long classLevel = Util.getJdkLevel(file);
            String projectCompliance = this.getJavaProject().getOption("org.eclipse.jdt.core.compiler.compliance", true);
            long projectLevel = CompilerOptions.versionToJdkLevel(projectCompliance);
            ZipFile jar = null;
            try {
                String[] supportedVersions;
                Object versionPath;
                jar = this.getJar();
                String version = "META-INF/versions/";
                ArrayList<CallSite> versions = new ArrayList<CallSite>();
                if (projectLevel >= 0x350000L && jar.getEntry(version) != null) {
                    int latestJavaVer;
                    int earliestJavaVersion = 53;
                    long latestJDK = CompilerOptions.versionToJdkLevel(projectCompliance);
                    for (int i = latestJavaVer = (int)(latestJDK >> 16); i >= earliestJavaVersion; --i) {
                        String s = "" + (i - 44);
                        versionPath = version + s;
                        if (jar.getEntry((String)versionPath) == null) continue;
                        versions.add((CallSite)((Object)s));
                    }
                }
                if ((supportedVersions = versions.toArray(new String[versions.size()])).length > 0) {
                    this.multiVersion = true;
                }
                int length = version.length();
                Enumeration<? extends ZipEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    ZipEntry member = e.nextElement();
                    String name = member.getName();
                    if (this.multiVersion && name.length() > length + 2 && name.startsWith(version)) {
                        int end = name.indexOf(47, length);
                        if (end >= name.length()) continue;
                        versionPath = name.substring(0, end);
                        String ver = name.substring(length, end);
                        if (versions.contains(ver) && org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(name)) {
                            name = name.substring(end + 1);
                            overridden.put(name, (String)versionPath);
                        }
                    }
                    this.initRawPackageInfo(rawPackageInfo, name, member.isDirectory(), CompilerOptions.versionFromJdkLevel(classLevel));
                }
            }
            finally {
                JavaModelManager.getJavaModelManager().closeZipFile(jar);
            }
            children = new IJavaElement[rawPackageInfo.size()];
            int index = 0;
            int length = rawPackageInfo.keyTable.length;
            for (int i = 0; i < length; ++i) {
                String[] pkgName = (String[])rawPackageInfo.keyTable[i];
                if (pkgName == null) continue;
                children[index++] = this.getPackageFragment(pkgName);
            }
        }
        catch (CoreException e) {
            if (e.getCause() instanceof ZipException) {
                Util.log(4, "Invalid ZIP archive: " + this.toStringWithAncestors());
                children = NO_ELEMENTS;
            }
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
        info.setChildren(children);
        ((JarPackageFragmentRootInfo)info).rawPackageInfo = rawPackageInfo;
        ((JarPackageFragmentRootInfo)info).overriddenClasses = overridden;
        return true;
    }

    protected IJavaElement[] createChildren(HashtableOfArrayToObject rawPackageInfo) {
        IJavaElement[] children = new IJavaElement[rawPackageInfo.size()];
        int index = 0;
        int length = rawPackageInfo.keyTable.length;
        for (int i = 0; i < length; ++i) {
            String[] pkgName = (String[])rawPackageInfo.keyTable[i];
            if (pkgName == null) continue;
            children[index++] = this.getPackageFragment(pkgName);
        }
        return children;
    }

    @Override
    protected Object createElementInfo() {
        return new JarPackageFragmentRootInfo();
    }

    @Override
    protected int determineKind(IResource underlyingResource) {
        return 2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JarPackageFragmentRoot) {
            JarPackageFragmentRoot other = (JarPackageFragmentRoot)o;
            return this.jarPath.equals((Object)other.jarPath) && Arrays.equals(this.extraAttributes, other.extraAttributes);
        }
        return false;
    }

    @Override
    public String getElementName() {
        return this.jarPath.lastSegment();
    }

    public ZipFile getJar() throws CoreException {
        return JavaModelManager.getJavaModelManager().getZipFile(this.getPath());
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    int internalKind() throws JavaModelException {
        return 2;
    }

    @Override
    public Object[] getNonJavaResources() throws JavaModelException {
        Object[] defaultPkgResources = ((JarPackageFragment)this.getPackageFragment(CharOperation.NO_STRINGS)).storedNonJavaResources();
        int length = defaultPkgResources.length;
        if (length == 0) {
            return defaultPkgResources;
        }
        Object[] nonJavaResources = new Object[length];
        for (int i = 0; i < length; ++i) {
            JarEntryResource nonJavaResource = (JarEntryResource)defaultPkgResources[i];
            nonJavaResources[i] = nonJavaResource.clone(this);
        }
        return nonJavaResources;
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName) {
        return new JarPackageFragment(this, pkgName);
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName, String mod) {
        return new JarPackageFragment(this, pkgName);
    }

    @Override
    public String getClassFilePath(String classname) {
        if (this.multiVersion) {
            try {
                JarPackageFragmentRootInfo elementInfo = (JarPackageFragmentRootInfo)this.getElementInfo();
                String versionPath = elementInfo.overriddenClasses.get(classname);
                return versionPath == null ? classname : versionPath + "/" + classname;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return classname;
    }

    @Override
    public IModuleDescription getModuleDescription() {
        if (this.knownToBeModuleLess) {
            return null;
        }
        IModuleDescription module = super.getModuleDescription();
        if (module == null) {
            this.knownToBeModuleLess = true;
        }
        return module;
    }

    @Override
    public IPath internalPath() {
        if (this.isExternal()) {
            return this.jarPath;
        }
        return super.internalPath();
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        if (this.resource == null) {
            return null;
        }
        return super.resource(root);
    }

    @Override
    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    @Override
    public int hashCode() {
        return this.jarPath.hashCode() + Arrays.hashCode(this.extraAttributes);
    }

    protected void initRawPackageInfo(HashtableOfArrayToObject rawPackageInfo, String entryName, boolean isDirectory, String compliance) {
        int length;
        int lastSeparator = isDirectory ? (entryName.charAt(entryName.length() - 1) == '/' ? entryName.length() - 1 : entryName.length()) : entryName.lastIndexOf(47);
        Object[] pkgName = Util.splitOn('/', entryName, 0, lastSeparator);
        Object[] existing = null;
        for (int existingLength = length = pkgName.length; existingLength >= 0 && (existing = (String[])rawPackageInfo.getKey(pkgName, existingLength)) == null; --existingLength) {
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        for (int i = existingLength; i < length; ++i) {
            if (!Util.isValidFolderNameForPackage((String)pkgName[i], null, compliance)) {
                if (!isDirectory) {
                    ArrayList[] children = (ArrayList[])rawPackageInfo.get(existing);
                    if (children[1] == EMPTY_LIST) {
                        children[1] = new ArrayList();
                    }
                    children[1].add(entryName);
                }
                return;
            }
            Object[] objectArray = existing;
            existing = new String[i + 1];
            System.arraycopy(objectArray, 0, existing, 0, i);
            existing[i] = manager.intern((String)pkgName[i]);
            rawPackageInfo.put(existing, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
        }
        if (isDirectory) {
            return;
        }
        ArrayList[] children = (ArrayList[])rawPackageInfo.get(pkgName);
        if (org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) {
            if (children[0] == EMPTY_LIST) {
                children[0] = new ArrayList();
            }
            String nameWithoutExtension = entryName.substring(lastSeparator + 1, entryName.length() - 6);
            children[0].add(nameWithoutExtension);
        } else {
            if (children[1] == EMPTY_LIST) {
                children[1] = new ArrayList();
            }
            children[1].add(entryName);
        }
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public boolean isExternal() {
        return this.resource() == null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected boolean resourceExists(IResource underlyingResource) {
        if (underlyingResource == null) {
            return JavaModel.getExternalTarget(this.getPath(), true) != null;
        }
        return super.resourceExists(underlyingResource);
    }

    @Override
    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    public URL getIndexPath() {
        try {
            IClasspathEntry entry = ((JavaProject)this.getParent()).getClasspathEntryFor(this.getPath());
            if (entry != null) {
                return ((ClasspathEntry)entry).getLibraryIndexLocation();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() {
        block10: {
            ZipFile jar = null;
            try {
                Manifest manifest;
                block11: {
                    jar = this.getJar();
                    ZipEntry mfEntry = jar.getEntry("META-INF/MANIFEST.MF");
                    if (mfEntry == null) break block10;
                    InputStream is = jar.getInputStream(mfEntry);
                    try {
                        manifest = new Manifest(is);
                        if (is == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException | CoreException throwable3) {
                            break block10;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                    }
                    is.close();
                }
                return manifest;
            }
            finally {
                JavaModelManager.getJavaModelManager().closeZipFile(jar);
            }
        }
        return null;
    }
}

