/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ConstraintExceptionFormula
extends ConstraintFormula {
    FunctionalExpression left;

    public ConstraintExceptionFormula(FunctionalExpression left, TypeBinding type) {
        this.left = left;
        this.right = type;
        this.relation = 7;
    }

    @Override
    public Object reduce(InferenceContext18 inferenceContext) {
        int i;
        int nParam;
        Scope scope = inferenceContext.scope;
        if (!this.right.isFunctionalInterface(scope)) {
            return FALSE;
        }
        MethodBinding sam = this.right.getSingleAbstractMethod(scope, true);
        if (sam == null) {
            return FALSE;
        }
        if (this.left instanceof LambdaExpression) {
            if (((LambdaExpression)this.left).argumentsTypeElided()) {
                nParam = sam.parameters.length;
                for (i = 0; i < nParam; ++i) {
                    if (sam.parameters[i].isProperType(true)) continue;
                    return FALSE;
                }
            }
            if (sam.returnType != TypeBinding.VOID && !sam.returnType.isProperType(true)) {
                return FALSE;
            }
        } else if (!((ReferenceExpression)this.left).isExactMethodReference()) {
            nParam = sam.parameters.length;
            for (i = 0; i < nParam; ++i) {
                if (sam.parameters[i].isProperType(true)) continue;
                return FALSE;
            }
            if (sam.returnType != TypeBinding.VOID && !sam.returnType.isProperType(true)) {
                return FALSE;
            }
        }
        ReferenceBinding[] thrown = sam.thrownExceptions;
        InferenceVariable[] e = new InferenceVariable[thrown.length];
        int n = 0;
        for (int i2 = 0; i2 < thrown.length; ++i2) {
            if (((TypeBinding)thrown[i2]).isProperType(true)) continue;
            e[n++] = (InferenceVariable)thrown[i2];
        }
        if (n == 0) {
            return TRUE;
        }
        TypeBinding[] ePrime = null;
        if (this.left instanceof LambdaExpression) {
            LambdaExpression lambda = ((LambdaExpression)this.left).resolveExpressionExpecting(this.right, inferenceContext.scope, inferenceContext);
            if (lambda == null) {
                return TRUE;
            }
            Set<TypeBinding> ePrimeSet = lambda.getThrownExceptions();
            ePrime = ePrimeSet.toArray(new TypeBinding[ePrimeSet.size()]);
        } else {
            MethodBinding method;
            ReferenceExpression referenceExpression = ((ReferenceExpression)this.left).resolveExpressionExpecting(this.right, scope, inferenceContext);
            MethodBinding methodBinding = method = referenceExpression != null ? referenceExpression.binding : null;
            if (method != null) {
                ePrime = method.thrownExceptions;
            }
        }
        if (ePrime == null) {
            return TRUE;
        }
        int m = ePrime.length;
        ArrayList<ConstraintTypeFormula> result = new ArrayList<ConstraintTypeFormula>();
        block3: for (int i3 = 0; i3 < m; ++i3) {
            int j;
            if (ePrime[i3].isUncheckedException(false)) continue;
            for (j = 0; j < thrown.length; ++j) {
                if (((TypeBinding)thrown[j]).isProperType(true) && ePrime[i3].isCompatibleWith(thrown[j])) continue block3;
            }
            for (j = 0; j < n; ++j) {
                result.add(ConstraintTypeFormula.create(ePrime[i3], e[j], 2));
            }
        }
        for (int j = 0; j < n; ++j) {
            inferenceContext.currentBounds.inThrows.add(e[j].prototype());
        }
        return result.toArray(new ConstraintFormula[result.size()]);
    }

    @Override
    Collection<InferenceVariable> inputVariables(InferenceContext18 context) {
        if (this.left instanceof LambdaExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(context.scope)) {
                LambdaExpression lambda = (LambdaExpression)this.left;
                MethodBinding sam = this.right.getSingleAbstractMethod(context.scope, true);
                LinkedHashSet<InferenceVariable> variables = new LinkedHashSet<InferenceVariable>();
                if (lambda.argumentsTypeElided()) {
                    int len = sam.parameters.length;
                    for (int i = 0; i < len; ++i) {
                        sam.parameters[i].collectInferenceVariables(variables);
                    }
                }
                if (sam.returnType != TypeBinding.VOID) {
                    sam.returnType.collectInferenceVariables(variables);
                }
                return variables;
            }
        } else if (this.left instanceof ReferenceExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(context.scope)) {
                MethodBinding sam = this.right.getSingleAbstractMethod(context.scope, true);
                LinkedHashSet<InferenceVariable> variables = new LinkedHashSet<InferenceVariable>();
                int len = sam.parameters.length;
                for (int i = 0; i < len; ++i) {
                    sam.parameters[i].collectInferenceVariables(variables);
                }
                sam.returnType.collectInferenceVariables(variables);
                return variables;
            }
        }
        return EMPTY_VARIABLE_LIST;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append('\u27e8');
        this.left.printExpression(4, buf);
        buf.append(" \u2286throws ");
        this.appendTypeName(buf, this.right);
        buf.append('\u27e9');
        return buf.toString();
    }
}

