/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import java.util.function.Predicate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleSetOfCharArray;

public interface IModuleAwareNameEnvironment
extends INameEnvironment {
    @Override
    default public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        return this.findType(compoundTypeName, ModuleBinding.ANY);
    }

    @Override
    default public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        return this.findType(typeName, packageName, ModuleBinding.ANY);
    }

    @Override
    default public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        return this.getModulesDeclaringPackage(CharOperation.arrayConcat(parentPackageName, packageName), ModuleBinding.ANY) != null;
    }

    public NameEnvironmentAnswer findType(char[][] var1, char[] var2);

    public NameEnvironmentAnswer findType(char[] var1, char[][] var2, char[] var3);

    public char[][] getModulesDeclaringPackage(char[][] var1, char[] var2);

    default public char[][] getUniqueModulesDeclaringPackage(char[][] packageName, char[] moduleName) {
        Object allNames = this.getModulesDeclaringPackage(packageName, moduleName);
        if (allNames != null && ((char[][])allNames).length > 1) {
            SimpleSetOfCharArray set = new SimpleSetOfCharArray(((char[][])allNames).length);
            for (char[] oneName : allNames) {
                set.add(oneName);
            }
            allNames = new char[set.elementSize][];
            set.asArray((Object[])allNames);
        }
        return allNames;
    }

    public boolean hasCompilationUnit(char[][] var1, char[] var2, boolean var3);

    public IModule getModule(char[] var1);

    public char[][] getAllAutomaticModules();

    default public void applyModuleUpdates(IUpdatableModule module, IUpdatableModule.UpdateKind kind) {
    }

    public char[][] listPackages(char[] var1);

    public static enum LookupStrategy {
        Named{

            @Override
            public <T> boolean matchesWithName(T elem, Predicate<T> isNamed, Predicate<T> nameMatcher) {
                assert (nameMatcher != null) : "name match needs a nameMatcher";
                return isNamed.test(elem) && nameMatcher.test(elem);
            }
        }
        ,
        AnyNamed{

            @Override
            public <T> boolean matchesWithName(T elem, Predicate<T> isNamed, Predicate<T> nameMatcher) {
                return isNamed.test(elem);
            }
        }
        ,
        Any{

            @Override
            public <T> boolean matchesWithName(T elem, Predicate<T> isNamed, Predicate<T> nameMatcher) {
                return true;
            }
        }
        ,
        Unnamed{

            @Override
            public <T> boolean matchesWithName(T elem, Predicate<T> isNamed, Predicate<T> nameMatcher) {
                return !isNamed.test(elem);
            }
        };


        public abstract <T> boolean matchesWithName(T var1, Predicate<T> var2, Predicate<T> var3);

        public <T> boolean matches(T elem, Predicate<T> isNamed) {
            return this.matchesWithName(elem, isNamed, t -> true);
        }

        public static LookupStrategy get(char[] moduleName) {
            if (moduleName == ModuleBinding.ANY) {
                return Any;
            }
            if (moduleName == ModuleBinding.ANY_NAMED) {
                return AnyNamed;
            }
            if (moduleName == ModuleBinding.UNNAMED) {
                return Unnamed;
            }
            return Named;
        }

        public static String getStringName(char[] moduleName) {
            switch (LookupStrategy.get(moduleName)) {
                case Named: {
                    return String.valueOf(moduleName);
                }
            }
            return null;
        }
    }
}

