/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.JavaEnvUtils;

class LanguageLevel {
    LanguageLevel() {
    }

    static boolean isDebianBuild() {
        return System.getenv("DEB_BUILD_ARCH") != null;
    }

    static boolean isLevelSupported(String level) {
        ArrayList<String> unsupportedLevels = new ArrayList<String>();
        if (JavaEnvUtils.isAtLeastJavaVersion("9")) {
            unsupportedLevels.add("1.1");
            unsupportedLevels.add("1.2");
            unsupportedLevels.add("1.3");
            unsupportedLevels.add("1.4");
            unsupportedLevels.add("1.5");
            unsupportedLevels.add("5");
        }
        if (JavaEnvUtils.isAtLeastJavaVersion("12")) {
            unsupportedLevels.add("1.6");
            unsupportedLevels.add("6");
        }
        return !unsupportedLevels.contains(level);
    }

    static String getMinimumLevel() {
        if (JavaEnvUtils.isAtLeastJavaVersion("12")) {
            return "7";
        }
        return "6";
    }

    static String adjust(String level, String location, Task logger) {
        if (level == null) {
            return level;
        }
        if (!LanguageLevel.isDebianBuild()) {
            return level;
        }
        if (LanguageLevel.isLevelSupported(level)) {
            return level;
        }
        String minLevel = LanguageLevel.getMinimumLevel();
        if (logger != null) {
            logger.log("Using " + location + " " + level + " is no longer supported, switching to " + minLevel, 1);
        }
        return minLevel;
    }
}

