/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.eval.EvaluationContext;
import org.eclipse.jdt.internal.eval.EvaluationResult;
import org.eclipse.jdt.internal.eval.IRequestor;

public abstract class Evaluator {
    EvaluationContext context;
    INameEnvironment environment;
    Map<String, String> options;
    IRequestor requestor;
    IProblemFactory problemFactory;

    Evaluator(EvaluationContext context, INameEnvironment environment, Map<String, String> options, IRequestor requestor, IProblemFactory problemFactory) {
        this.context = context;
        this.environment = environment;
        this.options = options;
        this.requestor = requestor;
        this.problemFactory = problemFactory;
    }

    protected abstract void addEvaluationResultForCompilationProblem(Map<char[], EvaluationResult> var1, CategorizedProblem var2, char[] var3);

    protected EvaluationResult[] evaluationResultsForCompilationProblems(CompilationResult result, char[] cuSource) {
        CategorizedProblem[] problems = result.getAllProblems();
        HashMap<char[], EvaluationResult> resultsByIDs = new HashMap<char[], EvaluationResult>(5);
        for (int i = 0; i < problems.length; ++i) {
            this.addEvaluationResultForCompilationProblem(resultsByIDs, problems[i], cuSource);
        }
        int size = resultsByIDs.size();
        EvaluationResult[] evalResults = new EvaluationResult[size];
        Iterator<EvaluationResult> results = resultsByIDs.values().iterator();
        for (int i = 0; i < size; ++i) {
            evalResults[i] = results.next();
        }
        return evalResults;
    }

    ClassFile[] getClasses() {
        final char[] source = this.getSource();
        final ArrayList classDefinitions = new ArrayList();
        class CompilerRequestor
        implements ICompilerRequestor {
            boolean hasErrors = false;

            CompilerRequestor() {
            }

            @Override
            public void acceptResult(CompilationResult result) {
                int i;
                if (result.hasProblems()) {
                    EvaluationResult[] evalResults = Evaluator.this.evaluationResultsForCompilationProblems(result, source);
                    for (i = 0; i < evalResults.length; ++i) {
                        EvaluationResult evalResult = evalResults[i];
                        CategorizedProblem[] problems = evalResult.getProblems();
                        for (int j = 0; j < problems.length; ++j) {
                            Evaluator.this.requestor.acceptProblem(problems[j], evalResult.getEvaluationID(), evalResult.getEvaluationType());
                        }
                    }
                }
                if (result.hasErrors()) {
                    this.hasErrors = true;
                } else {
                    ClassFile[] classFiles = result.getClassFiles();
                    for (i = 0; i < classFiles.length; ++i) {
                        ClassFile classFile = classFiles[i];
                        classDefinitions.add(classFile);
                    }
                }
            }
        }
        CompilerRequestor compilerRequestor = new CompilerRequestor();
        Compiler compiler = this.getCompiler(compilerRequestor);
        compiler.compile(new ICompilationUnit[]{new ICompilationUnit(){

            @Override
            public char[] getFileName() {
                return CharOperation.concat(Evaluator.this.getClassName(), Util.defaultJavaExtension().toCharArray());
            }

            @Override
            public char[] getContents() {
                return source;
            }

            @Override
            public char[] getMainTypeName() {
                return Evaluator.this.getClassName();
            }

            @Override
            public char[][] getPackageName() {
                return null;
            }

            @Override
            public boolean ignoreOptionalProblems() {
                return false;
            }

            @Override
            public char[] getModuleName() {
                return null;
            }
        }});
        if (compilerRequestor.hasErrors) {
            return null;
        }
        ClassFile[] result = new ClassFile[classDefinitions.size()];
        classDefinitions.toArray(result);
        return result;
    }

    protected abstract char[] getClassName();

    Compiler getCompiler(ICompilerRequestor compilerRequestor) {
        CompilerOptions compilerOptions = new CompilerOptions(this.options);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        return new Compiler(this.environment, DefaultErrorHandlingPolicies.exitAfterAllProblems(), compilerOptions, compilerRequestor, this.problemFactory);
    }

    protected abstract char[] getSource();
}

