/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.util.Util;

public class ASTNodeFinder {
    private CompilationUnitDeclaration unit;

    public ASTNodeFinder(CompilationUnitDeclaration unit) {
        this.unit = unit;
    }

    public FieldDeclaration findField(IField fieldHandle) {
        TypeDeclaration typeDecl = this.findType((IType)fieldHandle.getParent());
        if (typeDecl == null) {
            return null;
        }
        FieldDeclaration[] fields = typeDecl.fields;
        if (fields != null) {
            char[] fieldName = fieldHandle.getElementName().toCharArray();
            for (FieldDeclaration field : fields) {
                if (!CharOperation.equals(fieldName, field.name)) continue;
                return field;
            }
        }
        return null;
    }

    public Initializer findInitializer(IInitializer initializerHandle) {
        TypeDeclaration typeDecl = this.findType((IType)initializerHandle.getParent());
        if (typeDecl == null) {
            return null;
        }
        FieldDeclaration[] fields = typeDecl.fields;
        if (fields != null) {
            int occurenceCount = ((SourceRefElement)((Object)initializerHandle)).occurrenceCount;
            for (FieldDeclaration field : fields) {
                if (!(field instanceof Initializer) || --occurenceCount != 0) continue;
                return (Initializer)field;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration findMethod(IMethod methodHandle) {
        TypeDeclaration typeDecl = this.findType((IType)methodHandle.getParent());
        if (typeDecl == null) {
            return null;
        }
        AbstractMethodDeclaration[] methods = typeDecl.methods;
        if (methods != null) {
            char[] selector = methodHandle.getElementName().toCharArray();
            String[] parameterTypeSignatures = methodHandle.getParameterTypes();
            int parameterCount = parameterTypeSignatures.length;
            block0: for (AbstractMethodDeclaration method : methods) {
                int argsLength;
                if (!CharOperation.equals(selector, method.selector)) continue;
                Argument[] args = method.arguments;
                int n = argsLength = args == null ? 0 : args.length;
                if (argsLength != parameterCount) continue;
                for (int j = 0; j < parameterCount; ++j) {
                    TypeReference type = args[j].type;
                    String signature = Util.typeSignature(type);
                    if (!signature.equals(parameterTypeSignatures[j])) continue block0;
                }
                return method;
            }
        }
        return null;
    }

    public TypeDeclaration findType(IType typeHandle) {
        IJavaElement parent = typeHandle.getParent();
        final char[] typeName = typeHandle.getElementName().toCharArray();
        final int occurenceCount = ((SourceType)typeHandle).occurrenceCount;
        final boolean findAnonymous = typeName.length == 0;
        switch (parent.getElementType()) {
            class Visitor
            extends ASTVisitor {
                TypeDeclaration result;
                int count = 0;

                Visitor() {
                }

                @Override
                public boolean visit(TypeDeclaration typeDeclaration, BlockScope scope) {
                    if (this.result != null) {
                        return false;
                    }
                    if ((typeDeclaration.bits & 0x200) != 0) {
                        if (findAnonymous && ++this.count == occurenceCount) {
                            this.result = typeDeclaration;
                        }
                    } else if (!findAnonymous && CharOperation.equals(typeName, typeDeclaration.name)) {
                        this.result = typeDeclaration;
                    }
                    return false;
                }
            }
            case 5: {
                TypeDeclaration[] types = this.unit.types;
                if (types == null) break;
                for (TypeDeclaration type : types) {
                    if (!CharOperation.equals(typeName, type.name)) continue;
                    return type;
                }
                break;
            }
            case 7: {
                TypeDeclaration parentDecl = this.findType((IType)parent);
                if (parentDecl == null) {
                    return null;
                }
                TypeDeclaration[] types = parentDecl.memberTypes;
                if (types == null) break;
                for (TypeDeclaration type : types) {
                    if (!CharOperation.equals(typeName, type.name)) continue;
                    return type;
                }
                break;
            }
            case 8: {
                FieldDeclaration fieldDecl = this.findField((IField)parent);
                if (fieldDecl == null) {
                    return null;
                }
                Visitor visitor = new Visitor();
                fieldDecl.traverse((ASTVisitor)visitor, null);
                return visitor.result;
            }
            case 10: {
                Initializer initializer = this.findInitializer((IInitializer)parent);
                if (initializer == null) {
                    return null;
                }
                Visitor visitor = new Visitor();
                initializer.traverse((ASTVisitor)visitor, null);
                return visitor.result;
            }
            case 9: {
                AbstractMethodDeclaration methodDecl = this.findMethod((IMethod)parent);
                if (methodDecl == null) {
                    return null;
                }
                Visitor visitor = new Visitor();
                methodDecl.traverse((ASTVisitor)visitor, (ClassScope)null);
                return visitor.result;
            }
        }
        return null;
    }
}

