/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class IndexBinaryFolder
extends IndexRequest {
    IContainer folder;

    public IndexBinaryFolder(IContainer folder, IndexManager manager) {
        super(folder.getFullPath(), manager);
        this.folder = folder;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexBinaryFolder) {
            return this.folder.equals(((IndexBinaryFolder)o).folder);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.folder.isAccessible()) {
            return true;
        }
        Index index = this.manager.getIndexForUpdate(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterRead();
            String[] paths = index.queryDocumentNames("");
            int max = paths == null ? 0 : paths.length;
            final SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
            String OK = "OK";
            String DELETED = "DELETED";
            if (paths == null) {
                this.folder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) {
                        if (IndexBinaryFolder.this.isCancelled) {
                            return false;
                        }
                        if (proxy.getType() == 1) {
                            if (Util.isClassFileName(proxy.getName())) {
                                IFile file = (IFile)proxy.requestResource();
                                String containerRelativePath = org.eclipse.jdt.internal.core.util.Util.relativePath(file.getFullPath(), IndexBinaryFolder.this.containerPath.segmentCount());
                                indexedFileNames.put(containerRelativePath, file);
                            }
                            return false;
                        }
                        return true;
                    }
                }, 0);
            } else {
                for (int i = 0; i < max; ++i) {
                    indexedFileNames.put(paths[i], "DELETED");
                }
                final long indexLastModified = index.getIndexLastModified();
                this.folder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (IndexBinaryFolder.this.isCancelled) {
                            return false;
                        }
                        if (proxy.getType() == 1) {
                            IFile file;
                            URI location;
                            if (Util.isClassFileName(proxy.getName()) && (location = (file = (IFile)proxy.requestResource()).getLocationURI()) != null) {
                                String containerRelativePath;
                                indexedFileNames.put(containerRelativePath, indexedFileNames.get(containerRelativePath = org.eclipse.jdt.internal.core.util.Util.relativePath(file.getFullPath(), IndexBinaryFolder.this.containerPath.segmentCount())) == null || indexLastModified < EFS.getStore((URI)location).fetchInfo().getLastModified() ? file : "OK");
                            }
                            return false;
                        }
                        return true;
                    }
                }, 0);
            }
            Object[] names = indexedFileNames.keyTable;
            Object[] values = indexedFileNames.valueTable;
            int length = names.length;
            for (int i = 0; i < length; ++i) {
                String name = (String)names[i];
                if (name == null) continue;
                if (this.isCancelled) {
                    boolean bl = false;
                    return bl;
                }
                Object value = values[i];
                if (value == "OK") continue;
                if (value == "DELETED") {
                    this.manager.remove(name, this.containerPath);
                    continue;
                }
                this.manager.addBinary((IFile)value, this.containerPath);
            }
            this.manager.request(new SaveIndex(this.containerPath, this.manager));
        }
        catch (IOException | CoreException e) {
            if (JobManager.VERBOSE) {
                org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            boolean bl = false;
            return bl;
        }
        finally {
            monitor.exitRead();
        }
        return true;
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    @Override
    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing binary folder " + this.folder.getFullPath();
    }
}

