/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.index.IndexLocation;
import org.eclipse.jdt.internal.core.search.indexing.QualifierQuery;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.ModulePattern;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

public class IndexSelector {
    public static final int PROJECT_CAN_SEE_FOCUS = 0;
    public static final int PROJECT_SOURCE_CAN_NOT_SEE_FOCUS = 1;
    public static final int PROJECT_CAN_NOT_SEE_FOCUS = 2;
    IJavaSearchScope searchScope;
    SearchPattern pattern;
    IndexLocation[] indexLocations;

    public IndexSelector(IJavaSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    public static int canSeeFocus(SearchPattern pattern, IPath projectOrJarPath) {
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaProject project = IndexSelector.getJavaProject(projectOrJarPath, model);
            IJavaElement[] focuses = IndexSelector.getFocusedElementsAndTypes(pattern, project, null);
            if (focuses.length == 0) {
                return 2;
            }
            if (project != null) {
                return IndexSelector.canSeeFocus(focuses, (JavaProject)project, null);
            }
            int result = 2;
            IJavaProject[] allProjects = model.getJavaProjects();
            int length = allProjects.length;
            for (int i = 0; i < length; ++i) {
                JavaProject otherProject = (JavaProject)allProjects[i];
                IClasspathEntry entry = otherProject.getClasspathEntryFor(projectOrJarPath);
                if (entry == null || entry.getEntryKind() != 1) continue;
                int canSeeFocus = IndexSelector.canSeeFocus(focuses, otherProject, null);
                if (canSeeFocus == 0) {
                    return 0;
                }
                if (canSeeFocus != 1) continue;
                result = 1;
            }
            return result;
        }
        catch (JavaModelException e) {
            return 2;
        }
    }

    private static int canSeeFocus(IJavaElement[] focuses, JavaProject javaProject, char[][][] focusQualifiedNames) {
        int result = 2;
        int length = focuses.length;
        for (int i = 0; i < length; ++i) {
            int canSeeFocus = IndexSelector.canSeeFocus(focuses[i], javaProject, focusQualifiedNames);
            if (canSeeFocus == 0) {
                return 0;
            }
            if (canSeeFocus != 1) continue;
            result = 1;
        }
        return result;
    }

    private static int canSeeFocus(IJavaElement focus, JavaProject javaProject, char[][][] focusQualifiedNames) {
        try {
            if (focus == null) {
                return 2;
            }
            if (focus.equals(javaProject)) {
                return 0;
            }
            if (focus instanceof JarPackageFragmentRoot) {
                IPath focusPath = focus.getPath();
                for (IClasspathEntry entry : javaProject.getExpandedClasspath()) {
                    if (entry.getEntryKind() != 1 || !entry.getPath().equals((Object)focusPath)) continue;
                    return 0;
                }
                return 2;
            }
            IPath focusPath = ((JavaProject)focus).getProject().getFullPath();
            for (IClasspathEntry entry : javaProject.getExpandedClasspath()) {
                State projectState;
                if (entry.getEntryKind() != 2 || !entry.getPath().equals((Object)focusPath)) continue;
                if (focusQualifiedNames != null && (projectState = (State)JavaModelManager.getJavaModelManager().getLastBuiltState(javaProject.getProject(), null)) != null) {
                    Collection<ReferenceCollection> values = projectState.getReferences().values();
                    for (ReferenceCollection references : values) {
                        if (references == null || !references.includes(focusQualifiedNames, null, null)) continue;
                        return 0;
                    }
                    return 1;
                }
                return 0;
            }
            return 2;
        }
        catch (JavaModelException e) {
            return 2;
        }
    }

    private static IJavaElement[] getFocusedElementsAndTypes(SearchPattern pattern, IJavaElement focusElement, ObjectVector superTypes) throws JavaModelException {
        if (pattern instanceof MethodPattern) {
            IType type = (IType)pattern.focus.getAncestor(7);
            MethodPattern methodPattern = (MethodPattern)pattern;
            String selector = new String(methodPattern.selector);
            int parameterCount = methodPattern.parameterCount;
            ITypeHierarchy superHierarchy = type.newSupertypeHierarchy(null);
            IType[] allTypes = superHierarchy.getAllSupertypes(type);
            int length = allTypes.length;
            SimpleSet focusSet = new SimpleSet(length + 1);
            if (focusElement != null) {
                focusSet.add(focusElement);
            }
            block0: for (int i = 0; i < length; ++i) {
                IMethod[] methods = allTypes[i].getMethods();
                int mLength = methods.length;
                for (int m = 0; m < mLength; ++m) {
                    if (parameterCount != methods[m].getNumberOfParameters() || !methods[m].getElementName().equals(selector)) continue;
                    IPackageFragmentRoot root = (IPackageFragmentRoot)allTypes[i].getAncestor(3);
                    IJavaElement element = root.isArchive() ? root : root.getParent();
                    focusSet.add(element);
                    if (superTypes == null) continue block0;
                    superTypes.add(allTypes[i]);
                    continue block0;
                }
            }
            IJavaElement[] focuses = new IJavaElement[focusSet.elementSize];
            Object[] values = focusSet.values;
            int count = 0;
            int i = values.length;
            while (--i >= 0) {
                if (values[i] == null) continue;
                focuses[count++] = (IJavaElement)values[i];
            }
            return focuses;
        }
        if (focusElement == null) {
            return new IJavaElement[0];
        }
        return new IJavaElement[]{focusElement};
    }

    /*
     * Unable to fully structure code
     */
    private void initializeIndexLocations() {
        projectsAndJars = this.searchScope.enclosingProjectsAndJars();
        manager = JavaModelManager.getIndexManager();
        locations = new LinkedHashSet<IndexLocation>();
        v0 = focus = this.pattern instanceof ModulePattern != false ? null : MatchLocator.projectOrJarFocus(this.pattern);
        if (focus == null) {
            for (i = 0; i < projectsAndJars.length; ++i) {
                path = projectsAndJars[i];
                target = JavaModel.getTarget(path, false);
                if (target instanceof IFolder) {
                    path = ((IFolder)target).getFullPath();
                }
                locations.add(manager.computeIndexLocation(path));
            }
        } else {
            try {
                length = projectsAndJars.length;
                projectsCanSeeFocus = new JavaProject[length];
                visitedProjects = new SimpleSet(length);
                projectIndex = 0;
                externalLibsToCheck = new SimpleSet(length);
                superTypes = new ObjectVector();
                focuses = IndexSelector.getFocusedElementsAndTypes(this.pattern, focus, superTypes);
                focusQualifiedNames = null;
                isAutoBuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
                if (isAutoBuilding && focus instanceof IJavaProject) {
                    focusQualifiedNames = this.getQualifiedNames(superTypes);
                }
                model = JavaModelManager.getJavaModelManager().getJavaModel();
                for (i = 0; i < length; ++i) {
                    path = projectsAndJars[i];
                    project = (JavaProject)IndexSelector.getJavaProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        canSeeFocus = IndexSelector.canSeeFocus(focuses, project, focusQualifiedNames);
                        if (canSeeFocus == 0) {
                            locations.add(manager.computeIndexLocation(path));
                        }
                        if (canSeeFocus == 2) continue;
                        projectsCanSeeFocus[projectIndex++] = project;
                        continue;
                    }
                    externalLibsToCheck.add(path);
                }
                for (i = 0; i < projectIndex && externalLibsToCheck.elementSize > 0; ++i) {
                    entries = projectsCanSeeFocus[i].getResolvedClasspath();
                    j = entries.length;
                    while (--j >= 0) {
                        entry = entries[j];
                        if (entry.getEntryKind() != 1 || externalLibsToCheck.remove(path = entry.getPath()) == null) continue;
                        target = JavaModel.getTarget(path, false);
                        if (target instanceof IFolder) {
                            path = ((IFolder)target).getFullPath();
                        }
                        locations.add(manager.computeIndexLocation(path));
                    }
                }
                if (externalLibsToCheck.elementSize <= 0) ** GOTO lbl78
                allProjects = model.getJavaProjects();
                l = allProjects.length;
                for (i = 0; i < l && externalLibsToCheck.elementSize > 0; ++i) {
                    project = (JavaProject)allProjects[i];
                    if (visitedProjects.includes(project)) continue;
                    entries = project.getResolvedClasspath();
                    j = entries.length;
                    while (--j >= 0) {
                        entry = entries[j];
                        if (entry.getEntryKind() != 1 || externalLibsToCheck.remove(path = entry.getPath()) == null) continue;
                        target = JavaModel.getTarget(path, false);
                        if (target instanceof IFolder) {
                            path = ((IFolder)target).getFullPath();
                        }
                        locations.add(manager.computeIndexLocation(path));
                    }
                }
            }
            catch (JavaModelException var5_7) {
                // empty catch block
            }
        }
lbl78:
        // 4 sources

        locations.remove(null);
        this.indexLocations = locations.toArray(new IndexLocation[locations.size()]);
    }

    public IndexLocation[] getIndexLocations() {
        Optional<Set<String>> indexNamesResult;
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        IndexLocation[] filtered = this.indexLocations;
        if (this.pattern != null && this.pattern.indexQualifierQuery != null && this.pattern.indexQualifierQuery.length > 0 && (indexNamesResult = JavaModelManager.getIndexManager().findMatchingIndexNames(QualifierQuery.fromEncodedQuery(this.pattern.indexQualifierQuery))).isPresent()) {
            Set<String> indexNames = indexNamesResult.get();
            filtered = (IndexLocation[])Stream.of(this.indexLocations).filter(l -> indexNames.contains(l.fileName())).toArray(IndexLocation[]::new);
        }
        if (JobManager.VERBOSE) {
            Util.verbose(String.format("-> selected %s indexes out of total indexes %s after qualify filtering - %s", filtered.length, this.indexLocations.length, this.toString()));
        }
        return filtered;
    }

    private static IJavaProject getJavaProject(IPath path, IJavaModel model) {
        IJavaProject project;
        String lastSeg = path.lastSegment();
        if (lastSeg == null) {
            lastSeg = path.toOSString();
        }
        if ((project = model.getJavaProject(lastSeg)).exists()) {
            return project;
        }
        return null;
    }

    private char[][][] getQualifiedNames(ObjectVector types) {
        IType primaryType;
        IJavaElement javaElement;
        int size = types.size;
        char[][][] focusQualifiedNames = null;
        int index = 0;
        for (javaElement = this.pattern.focus; javaElement != null && !(javaElement instanceof ITypeRoot); javaElement = javaElement.getParent()) {
        }
        if (javaElement != null && (primaryType = ((ITypeRoot)javaElement).findPrimaryType()) != null) {
            focusQualifiedNames = new char[size + 1][][];
            focusQualifiedNames[index++] = CharOperation.splitOn('.', primaryType.getFullyQualifiedName().toCharArray());
        }
        if (focusQualifiedNames == null) {
            focusQualifiedNames = new char[size][][];
        }
        for (int i = 0; i < size; ++i) {
            focusQualifiedNames[index++] = CharOperation.splitOn('.', ((IType)types.elementAt(i)).getFullyQualifiedName().toCharArray());
        }
        return focusQualifiedNames.length == 0 ? null : ReferenceCollection.internQualifiedNames(focusQualifiedNames, true);
    }
}

