/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Util;

public class ModuleUpdater {
    private JavaProject javaProoject;
    private Map<String, IUpdatableModule.UpdatesByKind> moduleUpdates = new HashMap<String, IUpdatableModule.UpdatesByKind>();

    public ModuleUpdater(JavaProject javaProject) {
        this.javaProoject = javaProject;
    }

    public void computeModuleUpdates(IClasspathEntry entry) throws JavaModelException {
        for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
            String attributeName = attribute.getName();
            String values = attribute.getValue();
            if (attributeName.equals("add-exports")) {
                for (String value : values.split(":")) {
                    int slash = value.indexOf(47);
                    int equals = value.indexOf(61);
                    if (slash != -1 && equals != -1) {
                        String modName = value.substring(0, slash);
                        char[] packName = value.substring(slash + 1, equals).toCharArray();
                        char[][] targets = CharOperation.splitOn(',', value.substring(equals + 1).toCharArray());
                        this.addModuleUpdate(modName, new IUpdatableModule.AddExports(packName, targets), IUpdatableModule.UpdateKind.PACKAGE);
                        continue;
                    }
                    Util.log(2, "Invalid argument to add-exports: " + value);
                }
                continue;
            }
            if (attributeName.equals("add-reads")) {
                for (String value : values.split(":")) {
                    int equals = value.indexOf(61);
                    if (equals != -1) {
                        String srcMod = value.substring(0, equals);
                        char[] targetMod = value.substring(equals + 1).toCharArray();
                        this.addModuleUpdate(srcMod, new IUpdatableModule.AddReads(targetMod), IUpdatableModule.UpdateKind.MODULE);
                        continue;
                    }
                    Util.log(2, "Invalid argument to add-reads: " + value);
                }
                continue;
            }
            if (!attributeName.equals("module-main-class")) continue;
            IModuleDescription module = this.javaProoject.getModuleDescription();
            if (module == null) {
                throw new JavaModelException(new JavaModelStatus(969));
            }
            this.addModuleUpdate(module.getElementName(), m -> m.setMainClassName(values.toCharArray()), IUpdatableModule.UpdateKind.MODULE);
        }
    }

    public void addModuleUpdate(String moduleName, Consumer<IUpdatableModule> update, IUpdatableModule.UpdateKind kind) {
        IUpdatableModule.UpdatesByKind updates = this.moduleUpdates.get(moduleName);
        if (updates == null) {
            updates = new IUpdatableModule.UpdatesByKind();
            this.moduleUpdates.put(moduleName, updates);
        }
        updates.getList(kind, true).add(update);
    }

    public void applyModuleUpdates(IUpdatableModule compilerModule, IUpdatableModule.UpdateKind kind) {
        IUpdatableModule.UpdatesByKind updates;
        char[] name = compilerModule.name();
        if (name != ModuleBinding.UNNAMED && (updates = this.moduleUpdates.get(String.valueOf(name))) != null) {
            for (Consumer<IUpdatableModule> update : updates.getList(kind, false)) {
                update.accept(compilerModule);
            }
        }
    }

    private static boolean containsNonModularDependency(IClasspathEntry[] entries) {
        for (IClasspathEntry e : entries) {
            if (e.getEntryKind() == 3 || ((ClasspathEntry)e).isModular()) continue;
            return true;
        }
        return false;
    }

    public void addReadUnnamedForNonEmptyClasspath(JavaProject project, IClasspathEntry[] expandedClasspath) throws JavaModelException {
        for (String moduleName : ModuleUpdater.determineModulesOfProjectsWithNonEmptyClasspath(project, expandedClasspath)) {
            this.addModuleUpdate(moduleName, new IUpdatableModule.AddReads(ModuleBinding.ALL_UNNAMED), IUpdatableModule.UpdateKind.MODULE);
        }
    }

    public static Set<String> determineModulesOfProjectsWithNonEmptyClasspath(JavaProject project, IClasspathEntry[] expandedClasspath) throws JavaModelException {
        IModuleDescription moduleDescription;
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        if (ModuleUpdater.containsNonModularDependency(expandedClasspath) && (moduleDescription = project.getModuleDescription()) != null) {
            list.add(moduleDescription.getElementName());
        }
        for (IClasspathEntry e1 : expandedClasspath) {
            IModuleDescription prereqModuleDescription;
            JavaProject prereqJavaProject;
            IProject prereqProject;
            Object target;
            if (e1.getEntryKind() != 2 || !((target = JavaModel.getTarget(e1.getPath(), true)) instanceof IProject) || !JavaProject.hasJavaNature(prereqProject = (IProject)target) || !ModuleUpdater.containsNonModularDependency((prereqJavaProject = (JavaProject)JavaCore.create(prereqProject)).getResolvedClasspath()) || (prereqModuleDescription = prereqJavaProject.getModuleDescription()) == null) continue;
            list.add(prereqModuleDescription.getElementName());
        }
        return list;
    }

    public IUpdatableModule.UpdatesByKind getUpdates(String moduleName) {
        return this.moduleUpdates.get(moduleName);
    }
}

