/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterNonNullDefaultProvider;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.Sorting;

class MethodVerifier15
extends MethodVerifier {
    MethodVerifier15(LookupEnvironment environment) {
        super(environment);
    }

    @Override
    protected boolean canOverridingMethodDifferInErasure(MethodBinding overridingMethod, MethodBinding inheritedMethod) {
        if (overridingMethod.areParameterErasuresEqual(inheritedMethod)) {
            return false;
        }
        return !overridingMethod.declaringClass.isRawType();
    }

    @Override
    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && (this.type.superclass().isAbstract() || this.type.superclass().isParameterizedType())) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    @Override
    boolean canSkipInheritedMethods(MethodBinding one, MethodBinding two) {
        return two == null || TypeBinding.equalsEquals(one.declaringClass, two.declaringClass) && !one.declaringClass.isParameterizedType();
    }

    @Override
    void checkConcreteInheritedMethod(MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        super.checkConcreteInheritedMethod(concreteMethod, abstractMethods);
        boolean analyseNullAnnotations = this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled;
        AbstractMethodDeclaration srcMethod = null;
        if (analyseNullAnnotations && this.type.equals(concreteMethod.declaringClass)) {
            srcMethod = concreteMethod.sourceMethod();
        }
        boolean hasReturnNonNullDefault = analyseNullAnnotations && concreteMethod.hasNonNullDefaultForReturnType(srcMethod);
        ParameterNonNullDefaultProvider hasParameterNonNullDefault = analyseNullAnnotations ? concreteMethod.hasNonNullDefaultForParameter(srcMethod) : ParameterNonNullDefaultProvider.FALSE_PROVIDER;
        int l = abstractMethods.length;
        for (int i = 0; i < l; ++i) {
            MethodBinding abstractMethod = abstractMethods[i];
            if (concreteMethod.isVarargs() != abstractMethod.isVarargs()) {
                this.problemReporter().varargsConflict(concreteMethod, abstractMethod, this.type);
            }
            MethodBinding originalInherited = abstractMethod.original();
            if (TypeBinding.notEquals(originalInherited.returnType, concreteMethod.returnType) && !this.isAcceptableReturnTypeOverride(concreteMethod, abstractMethod)) {
                this.problemReporter().unsafeReturnTypeOverride(concreteMethod, originalInherited, this.type);
            }
            if (originalInherited.declaringClass.isInterface() && (TypeBinding.equalsEquals(concreteMethod.declaringClass, this.type.superclass) && this.type.superclass.isParameterizedType() && !this.areMethodsCompatible(concreteMethod, originalInherited) || this.type.superclass.erasure().findSuperTypeOriginatingFrom(originalInherited.declaringClass) == null)) {
                this.type.addSyntheticBridgeMethod(originalInherited, concreteMethod.original());
            }
            if (!analyseNullAnnotations || concreteMethod.isStatic() || abstractMethod.isStatic()) continue;
            this.checkNullSpecInheritance(concreteMethod, srcMethod, hasReturnNonNullDefault, hasParameterNonNullDefault, true, abstractMethod, abstractMethods, this.type.scope, null);
        }
    }

    @Override
    void checkForBridgeMethod(MethodBinding currentMethod, MethodBinding inheritedMethod, MethodBinding[] allInheritedMethods) {
        SyntheticMethodBinding bridge;
        if (currentMethod.isVarargs() != inheritedMethod.isVarargs()) {
            this.problemReporter(currentMethod).varargsConflict(currentMethod, inheritedMethod, this.type);
        }
        MethodBinding originalInherited = inheritedMethod.original();
        if (TypeBinding.notEquals(originalInherited.returnType, currentMethod.returnType) && !this.isAcceptableReturnTypeOverride(currentMethod, inheritedMethod)) {
            this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, originalInherited, this.type);
        }
        if ((bridge = this.type.addSyntheticBridgeMethod(originalInherited, currentMethod.original())) != null) {
            int l;
            int n = l = allInheritedMethods == null ? 0 : allInheritedMethods.length;
            for (int i = 0; i < l; ++i) {
                if (allInheritedMethods[i] == null || !this.detectInheritedNameClash(originalInherited, allInheritedMethods[i].original())) continue;
                return;
            }
            MethodBinding[] current = (MethodBinding[])this.currentMethods.get(bridge.selector);
            for (int i = current.length - 1; i >= 0; --i) {
                MethodBinding thisMethod = current[i];
                if (!thisMethod.areParameterErasuresEqual(bridge) || !TypeBinding.equalsEquals(thisMethod.returnType.erasure(), bridge.returnType.erasure())) continue;
                this.problemReporter(thisMethod).methodNameClash(thisMethod, inheritedMethod.declaringClass.isRawType() ? inheritedMethod : inheritedMethod.original(), 1);
                return;
            }
        }
    }

    void checkForNameClash(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (inheritedMethod.isStatic() || currentMethod.isStatic()) {
            MethodBinding original = inheritedMethod.original();
            if (this.type.scope.compilerOptions().complianceLevel >= 0x330000L && currentMethod.areParameterErasuresEqual(original)) {
                this.problemReporter(currentMethod).methodNameClashHidden(currentMethod, inheritedMethod.declaringClass.isRawType() ? inheritedMethod : original);
            }
            return;
        }
        if (!this.detectNameClash(currentMethod, inheritedMethod, false)) {
            TypeBinding[] currentParams = currentMethod.parameters;
            int length = currentParams.length;
            TypeBinding[] inheritedParams = inheritedMethod.parameters;
            if (length != inheritedParams.length) {
                return;
            }
            for (int i = 0; i < length; ++i) {
                if (!TypeBinding.notEquals(currentParams[i], inheritedParams[i]) || currentParams[i].isBaseType() == inheritedParams[i].isBaseType() && inheritedParams[i].isCompatibleWith(currentParams[i])) continue;
                return;
            }
            ReferenceBinding[] interfacesToVisit = null;
            int nextPosition = 0;
            ReferenceBinding superType = inheritedMethod.declaringClass;
            ReferenceBinding[] itsInterfaces = superType.superInterfaces();
            if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                nextPosition = itsInterfaces.length;
                interfacesToVisit = itsInterfaces;
            }
            for (superType = superType.superclass(); superType != null && superType.isValidBinding(); superType = superType.superclass()) {
                MethodBinding[] methods = superType.getMethods(currentMethod.selector);
                int n = methods.length;
                for (int m = 0; m < n; ++m) {
                    MethodBinding substitute = this.computeSubstituteMethod(methods[m], currentMethod);
                    if (substitute == null || this.isSubstituteParameterSubsignature(currentMethod, substitute) || !this.detectNameClash(currentMethod, substitute, true)) continue;
                    return;
                }
                itsInterfaces = superType.superInterfaces();
                if (itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
                if (interfacesToVisit == null) {
                    interfacesToVisit = itsInterfaces;
                    nextPosition = interfacesToVisit.length;
                    continue;
                }
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                block3: for (int a = 0; a < itsLength; ++a) {
                    ReferenceBinding next = itsInterfaces[a];
                    for (int b = 0; b < nextPosition; ++b) {
                        if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block3;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
            }
            for (int i = 0; i < nextPosition; ++i) {
                superType = interfacesToVisit[i];
                if (!superType.isValidBinding()) continue;
                MethodBinding[] methods = superType.getMethods(currentMethod.selector);
                int n = methods.length;
                for (int m = 0; m < n; ++m) {
                    MethodBinding substitute = this.computeSubstituteMethod(methods[m], currentMethod);
                    if (substitute == null || this.isSubstituteParameterSubsignature(currentMethod, substitute) || !this.detectNameClash(currentMethod, substitute, true)) continue;
                    return;
                }
                itsInterfaces = superType.superInterfaces();
                if (itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                block7: for (int a = 0; a < itsLength; ++a) {
                    ReferenceBinding next = itsInterfaces[a];
                    for (int b = 0; b < nextPosition; ++b) {
                        if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block7;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
            }
        }
    }

    void checkInheritedMethods(MethodBinding inheritedMethod, MethodBinding otherInheritedMethod) {
        if (inheritedMethod.isStatic()) {
            return;
        }
        if (this.environment.globalOptions.complianceLevel < 0x330000L && inheritedMethod.declaringClass.isInterface()) {
            return;
        }
        this.detectInheritedNameClash(inheritedMethod.original(), otherInheritedMethod.original());
    }

    @Override
    void checkInheritedMethods(MethodBinding[] methods, int length, boolean[] isOverridden, boolean[] isInherited) {
        int i;
        boolean continueInvestigation = true;
        MethodBinding concreteMethod = null;
        MethodBinding abstractSuperClassMethod = null;
        boolean playingTrump = false;
        for (i = 0; i < length; ++i) {
            if (methods[i].declaringClass.isInterface() || !TypeBinding.notEquals(methods[i].declaringClass, this.type) || !methods[i].isAbstract()) continue;
            abstractSuperClassMethod = methods[i];
            break;
        }
        for (i = 0; i < length; ++i) {
            if (!isInherited[i] || methods[i].isAbstract()) continue;
            if (methods[i].isDefaultMethod() && abstractSuperClassMethod != null && MethodVerifier15.areParametersEqual(abstractSuperClassMethod, methods[i]) && concreteMethod == null) {
                playingTrump = true;
                continue;
            }
            playingTrump = false;
            if (concreteMethod != null) {
                if (isOverridden[i] && this.areMethodsCompatible(concreteMethod, methods[i]) || TypeBinding.equalsEquals(concreteMethod.declaringClass, methods[i].declaringClass) && concreteMethod.typeVariables.length != methods[i].typeVariables.length && (concreteMethod.typeVariables == Binding.NO_TYPE_VARIABLES && concreteMethod.original() == methods[i] || methods[i].typeVariables == Binding.NO_TYPE_VARIABLES && methods[i].original() == concreteMethod)) continue;
                this.problemReporter().duplicateInheritedMethods(this.type, concreteMethod, methods[i], this.environment.globalOptions.sourceLevel >= 0x340000L);
                continueInvestigation = false;
            }
            concreteMethod = methods[i];
        }
        if (continueInvestigation) {
            if (playingTrump) {
                if (!this.type.isAbstract()) {
                    this.problemReporter().abstractMethodMustBeImplemented(this.type, abstractSuperClassMethod);
                    return;
                }
            } else if (concreteMethod != null && concreteMethod.isDefaultMethod() && this.environment.globalOptions.complianceLevel >= 0x340000L && !this.checkInheritedDefaultMethods(methods, isOverridden, length)) {
                return;
            }
            super.checkInheritedMethods(methods, length, isOverridden, isInherited);
        }
    }

    boolean checkInheritedDefaultMethods(MethodBinding[] methods, boolean[] isOverridden, int length) {
        if (length < 2) {
            return true;
        }
        boolean ok = true;
        block0: for (int i = 0; i < length; ++i) {
            if (!methods[i].isDefaultMethod() || isOverridden[i]) continue;
            for (int j = 0; j < length; ++j) {
                if (j == i || isOverridden[j] || !this.isMethodSubsignature(methods[i], methods[j]) || this.doesMethodOverride(methods[i], methods[j]) || this.doesMethodOverride(methods[j], methods[i])) continue;
                this.problemReporter().inheritedDefaultMethodConflictsWithOtherInherited(this.type, methods[i], methods[j]);
                ok = false;
                continue block0;
            }
        }
        return ok;
    }

    @Override
    boolean checkInheritedReturnTypes(MethodBinding method, MethodBinding otherMethod) {
        if (this.areReturnTypesCompatible(method, otherMethod)) {
            return true;
        }
        if (this.isUnsafeReturnTypeOverride(method, otherMethod)) {
            if (!method.declaringClass.implementsInterface(otherMethod.declaringClass, false)) {
                this.problemReporter(method).unsafeReturnTypeOverride(method, otherMethod, this.type);
            }
            return true;
        }
        return false;
    }

    @Override
    void checkAgainstInheritedMethods(MethodBinding currentMethod, MethodBinding[] methods, int length, MethodBinding[] allInheritedMethods) {
        super.checkAgainstInheritedMethods(currentMethod, methods, length, allInheritedMethods);
        CompilerOptions options = this.environment.globalOptions;
        if (options.isAnnotationBasedNullAnalysisEnabled && (currentMethod.tagBits & 0x1000L) == 0L) {
            AbstractMethodDeclaration srcMethod = null;
            if (this.type.equals(currentMethod.declaringClass)) {
                srcMethod = currentMethod.sourceMethod();
            }
            boolean hasReturnNonNullDefault = currentMethod.hasNonNullDefaultForReturnType(srcMethod);
            ParameterNonNullDefaultProvider hasParameterNonNullDefault = currentMethod.hasNonNullDefaultForParameter(srcMethod);
            int i = length;
            while (--i >= 0) {
                if (currentMethod.isStatic() || methods[i].isStatic()) continue;
                this.checkNullSpecInheritance(currentMethod, srcMethod, hasReturnNonNullDefault, hasParameterNonNullDefault, true, methods[i], methods, this.type.scope, null);
            }
        }
    }

    @Override
    void checkNullSpecInheritance(MethodBinding currentMethod, AbstractMethodDeclaration srcMethod, boolean hasReturnNonNullDefault, ParameterNonNullDefaultProvider hasParameterNonNullDefault, boolean complain, MethodBinding inheritedMethod, MethodBinding[] allInherited, Scope scope, ImplicitNullAnnotationVerifier.InheritedNonNullnessInfo[] inheritedNonNullnessInfos) {
        if (!(hasReturnNonNullDefault || hasParameterNonNullDefault.hasAnyNonNullDefault() || (complain &= !currentMethod.isConstructor()) || this.environment.globalOptions.inheritNullAnnotations)) {
            currentMethod.tagBits |= 0x1000L;
            return;
        }
        if (TypeBinding.notEquals(currentMethod.declaringClass, this.type) && (currentMethod.tagBits & 0x1000L) == 0L) {
            this.buddyImplicitNullAnnotationsVerifier.checkImplicitNullAnnotations(currentMethod, srcMethod, complain, scope);
        }
        super.checkNullSpecInheritance(currentMethod, srcMethod, hasReturnNonNullDefault, hasParameterNonNullDefault, complain, inheritedMethod, allInherited, scope, inheritedNonNullnessInfos);
    }

    void reportRawReferences() {
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L || compilerOptions.reportUnavoidableGenericTypeProblems) {
            return;
        }
        Object[] methodArray = this.currentMethods.valueTable;
        int s = methodArray.length;
        while (--s >= 0) {
            if (methodArray[s] == null) continue;
            for (MethodBinding currentMethod : (MethodBinding[])methodArray[s]) {
                if ((currentMethod.modifiers & 0x30000000) != 0) continue;
                AbstractMethodDeclaration methodDecl = currentMethod.sourceMethod();
                if (methodDecl == null) {
                    return;
                }
                TypeBinding[] parameterTypes = currentMethod.parameters;
                Argument[] arguments = methodDecl.arguments;
                int size = currentMethod.parameters.length;
                for (int j = 0; j < size; ++j) {
                    TypeBinding parameterType = parameterTypes[j];
                    Argument arg = arguments[j];
                    if (!parameterType.leafComponentType().isRawType() || compilerOptions.getSeverity(0x20010000) == 256 || (arg.type.bits & 0x40000000) != 0) continue;
                    methodDecl.scope.problemReporter().rawTypeReference(arg.type, parameterType);
                }
                if (methodDecl.isConstructor() || !(methodDecl instanceof MethodDeclaration)) continue;
                TypeReference returnType = ((MethodDeclaration)methodDecl).returnType;
                TypeBinding methodType = currentMethod.returnType;
                if (returnType == null || !methodType.leafComponentType().isRawType() || compilerOptions.getSeverity(0x20010000) == 256 || (returnType.bits & 0x40000000) != 0) continue;
                methodDecl.scope.problemReporter().rawTypeReference(returnType, methodType);
            }
        }
    }

    @Override
    public void reportRawReferences(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L || compilerOptions.reportUnavoidableGenericTypeProblems) {
            return;
        }
        AbstractMethodDeclaration methodDecl = currentMethod.sourceMethod();
        if (methodDecl == null) {
            return;
        }
        TypeBinding[] parameterTypes = currentMethod.parameters;
        TypeBinding[] inheritedParameterTypes = inheritedMethod.parameters;
        Argument[] arguments = methodDecl.arguments;
        int size = currentMethod.parameters.length;
        for (int j = 0; j < size; ++j) {
            TypeBinding parameterType = parameterTypes[j];
            TypeBinding inheritedParameterType = inheritedParameterTypes[j];
            Argument arg = arguments[j];
            if (!parameterType.leafComponentType().isRawType()) continue;
            if (inheritedParameterType.leafComponentType().isRawType()) {
                arg.binding.tagBits |= 0x200L;
                continue;
            }
            if (compilerOptions.getSeverity(0x20010000) == 256 || (arg.type.bits & 0x40000000) != 0) continue;
            methodDecl.scope.problemReporter().rawTypeReference(arg.type, parameterType);
        }
        TypeReference returnType = null;
        if (!methodDecl.isConstructor() && methodDecl instanceof MethodDeclaration && (returnType = ((MethodDeclaration)methodDecl).returnType) != null) {
            TypeBinding inheritedMethodType = inheritedMethod.returnType;
            TypeBinding methodType = currentMethod.returnType;
            if (methodType.leafComponentType().isRawType() && !inheritedMethodType.leafComponentType().isRawType() && (returnType.bits & 0x40000000) == 0 && compilerOptions.getSeverity(0x20010000) != 256) {
                methodDecl.scope.problemReporter().rawTypeReference(returnType, methodType);
            }
        }
    }

    @Override
    void checkMethods() {
        boolean mustImplementAbstractMethods = this.mustImplementAbstractMethods();
        boolean skipInheritedMethods = mustImplementAbstractMethods && this.canSkipInheritedMethods();
        boolean isOrEnclosedByPrivateType = this.type.isOrEnclosedByPrivateType();
        char[][] methodSelectors = this.inheritedMethods.keyTable;
        int s = methodSelectors.length;
        while (--s >= 0) {
            MethodBinding inheritedMethod;
            int i;
            int i2;
            int length;
            if (methodSelectors[s] == null) continue;
            MethodBinding[] current = (MethodBinding[])this.currentMethods.get(methodSelectors[s]);
            MethodBinding[] inherited = (MethodBinding[])this.inheritedMethods.valueTable[s];
            inherited = Sorting.concreteFirst(inherited, inherited.length);
            if (current == null && !isOrEnclosedByPrivateType) {
                length = inherited.length;
                for (i2 = 0; i2 < length; ++i2) {
                    inherited[i2].original().modifiers |= 0x8000000;
                }
            }
            if (current == null && this.type.isPublic()) {
                length = inherited.length;
                for (i2 = 0; i2 < length; ++i2) {
                    MethodBinding inheritedMethod2 = inherited[i2];
                    if (!inheritedMethod2.isPublic() || inheritedMethod2.declaringClass.isInterface() || inheritedMethod2.declaringClass.isPublic()) continue;
                    this.type.addSyntheticBridgeMethod(inheritedMethod2.original());
                }
            }
            if (current == null && skipInheritedMethods) continue;
            if (inherited.length == 1 && current == null) {
                if (!mustImplementAbstractMethods || !inherited[0].isAbstract()) continue;
                this.checkAbstractMethod(inherited[0]);
                continue;
            }
            int index = -1;
            int inheritedLength = inherited.length;
            MethodBinding[] matchingInherited = new MethodBinding[inheritedLength];
            MethodBinding[] foundMatch = new MethodBinding[inheritedLength];
            boolean[] skip = new boolean[inheritedLength];
            boolean[] isOverridden = new boolean[inheritedLength];
            boolean[] isInherited = new boolean[inheritedLength];
            Arrays.fill(isInherited, true);
            if (current != null) {
                int length1 = current.length;
                for (i = 0; i < length1; ++i) {
                    MethodBinding currentMethod = current[i];
                    MethodBinding[] nonMatchingInherited = null;
                    for (int j = 0; j < inheritedLength; ++j) {
                        MethodBinding inheritedMethod3 = this.computeSubstituteMethod(inherited[j], currentMethod);
                        if (inheritedMethod3 == null) continue;
                        if (foundMatch[j] == null && this.isSubstituteParameterSubsignature(currentMethod, inheritedMethod3)) {
                            isOverridden[j] = skip[j] = MethodVerifier15.couldMethodOverride(currentMethod, inheritedMethod3);
                            matchingInherited[++index] = inheritedMethod3;
                            foundMatch[j] = currentMethod;
                            continue;
                        }
                        this.checkForNameClash(currentMethod, inheritedMethod3);
                        if (inheritedLength <= 1) continue;
                        if (nonMatchingInherited == null) {
                            nonMatchingInherited = new MethodBinding[inheritedLength];
                        }
                        nonMatchingInherited[j] = inheritedMethod3;
                    }
                    if (index < 0) continue;
                    this.checkAgainstInheritedMethods(currentMethod, matchingInherited, index + 1, nonMatchingInherited);
                    while (index >= 0) {
                        matchingInherited[index--] = null;
                    }
                }
            }
            for (i = 0; i < inheritedLength; ++i) {
                MethodBinding matchMethod = foundMatch[i];
                if (matchMethod == null && current != null && this.type.isPublic() && (inheritedMethod = inherited[i]).isPublic() && !inheritedMethod.declaringClass.isInterface() && !inheritedMethod.declaringClass.isPublic()) {
                    this.type.addSyntheticBridgeMethod(inheritedMethod.original());
                }
                if (!isOrEnclosedByPrivateType && matchMethod == null && current != null) {
                    inherited[i].original().modifiers |= 0x8000000;
                }
                inheritedMethod = inherited[i];
                for (int j = i + 1; j < inheritedLength; ++j) {
                    MethodBinding otherInheritedMethod = inherited[j];
                    if ((matchMethod != foundMatch[j] || matchMethod == null) && !this.canSkipInheritedMethods(inheritedMethod, otherInheritedMethod) && TypeBinding.notEquals(inheritedMethod.declaringClass, otherInheritedMethod.declaringClass) && !this.isSkippableOrOverridden(inheritedMethod, otherInheritedMethod, skip, isOverridden, isInherited, j) && !this.isSkippableOrOverridden(otherInheritedMethod, inheritedMethod, skip, isOverridden, isInherited, i)) continue;
                }
            }
            for (i = 0; i < inheritedLength; ++i) {
                MethodBinding matchMethod = foundMatch[i];
                if (skip[i]) continue;
                inheritedMethod = inherited[i];
                if (matchMethod == null) {
                    matchingInherited[++index] = inheritedMethod;
                }
                for (int j = i + 1; j < inheritedLength; ++j) {
                    if (foundMatch[j] != null) continue;
                    MethodBinding otherInheritedMethod = inherited[j];
                    if (matchMethod == foundMatch[j] && matchMethod != null || this.canSkipInheritedMethods(inheritedMethod, otherInheritedMethod)) continue;
                    MethodBinding replaceMatch = this.findReplacedMethod(inheritedMethod, otherInheritedMethod);
                    if (replaceMatch != null) {
                        matchingInherited[++index] = replaceMatch;
                        skip[j] = true;
                        continue;
                    }
                    replaceMatch = this.findReplacedMethod(otherInheritedMethod, inheritedMethod);
                    if (replaceMatch != null) {
                        matchingInherited[++index] = replaceMatch;
                        skip[j] = true;
                        continue;
                    }
                    if (matchMethod != null) continue;
                    this.checkInheritedMethods(inheritedMethod, otherInheritedMethod);
                }
                if (index == -1) continue;
                if (index > 0) {
                    boolean[] matchingIsInherited;
                    boolean[] matchingIsOverridden;
                    int length2 = index + 1;
                    if (length2 != inheritedLength) {
                        matchingIsOverridden = new boolean[length2];
                        matchingIsInherited = new boolean[length2];
                        block10: for (int j = 0; j < length2; ++j) {
                            for (int k = 0; k < inheritedLength; ++k) {
                                if (matchingInherited[j] != inherited[k]) continue;
                                matchingIsOverridden[j] = isOverridden[k];
                                matchingIsInherited[j] = isInherited[k];
                                continue block10;
                            }
                        }
                    } else {
                        matchingIsOverridden = isOverridden;
                        matchingIsInherited = isInherited;
                    }
                    this.checkInheritedMethods(matchingInherited, length2, matchingIsOverridden, matchingIsInherited);
                } else if (mustImplementAbstractMethods && matchingInherited[0].isAbstract() && matchMethod == null) {
                    this.checkAbstractMethod(matchingInherited[0]);
                }
                while (index >= 0) {
                    matchingInherited[index--] = null;
                }
            }
        }
    }

    boolean isSkippableOrOverridden(MethodBinding specific, MethodBinding general, boolean[] skip, boolean[] isOverridden, boolean[] isInherited, int idx) {
        boolean specificIsInterface = specific.declaringClass.isInterface();
        boolean generalIsInterface = general.declaringClass.isInterface();
        if (!specificIsInterface && generalIsInterface) {
            if (!specific.isAbstract() && this.isParameterSubsignature(specific, general)) {
                isInherited[idx] = false;
                return true;
            }
            if (this.isInterfaceMethodImplemented(general, specific, general.declaringClass)) {
                skip[idx] = true;
                isOverridden[idx] = true;
                return true;
            }
        } else if (specificIsInterface == generalIsInterface && specific.declaringClass.isCompatibleWith(general.declaringClass) && this.isMethodSubsignature(specific, general)) {
            skip[idx] = true;
            isOverridden[idx] = true;
            return true;
        }
        return false;
    }

    MethodBinding findReplacedMethod(MethodBinding specific, MethodBinding general) {
        MethodBinding generalSubstitute = this.computeSubstituteMethod(general, specific);
        if (generalSubstitute != null && (!specific.isAbstract() || general.isAbstract() || general.isDefaultMethod() && specific.declaringClass.isClass()) && this.isSubstituteParameterSubsignature(specific, generalSubstitute)) {
            return generalSubstitute;
        }
        return null;
    }

    void checkTypeVariableMethods(TypeParameter typeParameter) {
        char[][] methodSelectors = this.inheritedMethods.keyTable;
        int s = methodSelectors.length;
        block0: while (--s >= 0) {
            MethodBinding[] inherited;
            if (methodSelectors[s] == null || (inherited = (MethodBinding[])this.inheritedMethods.valueTable[s]).length == 1) continue;
            int index = -1;
            MethodBinding[] matchingInherited = new MethodBinding[inherited.length];
            int length = inherited.length;
            for (int i = 0; i < length; ++i) {
                while (index >= 0) {
                    matchingInherited[index--] = null;
                }
                MethodBinding inheritedMethod = inherited[i];
                if (inheritedMethod != null) {
                    matchingInherited[++index] = inheritedMethod;
                    for (int j = i + 1; j < length; ++j) {
                        MethodBinding otherInheritedMethod = inherited[j];
                        if (this.canSkipInheritedMethods(inheritedMethod, otherInheritedMethod) || (otherInheritedMethod = this.computeSubstituteMethod(otherInheritedMethod, inheritedMethod)) == null || !this.isSubstituteParameterSubsignature(inheritedMethod, otherInheritedMethod)) continue;
                        matchingInherited[++index] = otherInheritedMethod;
                        inherited[j] = null;
                    }
                }
                if (index <= 0) continue;
                MethodBinding first = matchingInherited[0];
                int count = index + 1;
                while (--count > 0) {
                    MethodBinding match = matchingInherited[count];
                    MethodBinding interfaceMethod = null;
                    MethodBinding implementation = null;
                    if (first.declaringClass.isInterface()) {
                        interfaceMethod = first;
                    } else if (first.declaringClass.isClass()) {
                        implementation = first;
                    }
                    if (match.declaringClass.isInterface()) {
                        interfaceMethod = match;
                    } else if (match.declaringClass.isClass()) {
                        implementation = match;
                    }
                    if (interfaceMethod != null && implementation != null && !implementation.isAbstract() && !this.isAsVisible(implementation, interfaceMethod)) {
                        this.problemReporter().inheritedMethodReducesVisibility(typeParameter, implementation, new MethodBinding[]{interfaceMethod});
                    }
                    if (this.areReturnTypesCompatible(first, match) || first.declaringClass.isInterface() && match.declaringClass.isInterface() && this.areReturnTypesCompatible(match, first)) continue;
                }
                if (count <= 0) continue;
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(typeParameter, matchingInherited, index + 1);
                continue block0;
            }
        }
    }

    boolean detectInheritedNameClash(MethodBinding inherited, MethodBinding otherInherited) {
        if (!inherited.areParameterErasuresEqual(otherInherited)) {
            return false;
        }
        if (TypeBinding.notEquals(inherited.returnType.erasure(), otherInherited.returnType.erasure())) {
            return false;
        }
        if (TypeBinding.notEquals(inherited.declaringClass.erasure(), otherInherited.declaringClass.erasure())) {
            if (inherited.declaringClass.findSuperTypeOriginatingFrom(otherInherited.declaringClass) != null) {
                return false;
            }
            if (otherInherited.declaringClass.findSuperTypeOriginatingFrom(inherited.declaringClass) != null) {
                return false;
            }
        }
        this.problemReporter().inheritedMethodsHaveNameClash(this.type, inherited, otherInherited);
        return true;
    }

    boolean detectNameClash(MethodBinding current, MethodBinding inherited, boolean treatAsSynthetic) {
        MethodBinding[] currentNamesakes;
        MethodBinding methodToCheck = inherited;
        MethodBinding original = methodToCheck.original();
        if (!current.areParameterErasuresEqual(original)) {
            return false;
        }
        int severity = 1;
        if (this.environment.globalOptions.complianceLevel == 0x320000L && TypeBinding.notEquals(current.returnType.erasure(), original.returnType.erasure())) {
            severity = 0;
        }
        if (!treatAsSynthetic && (currentNamesakes = (MethodBinding[])this.currentMethods.get(inherited.selector)).length > 1) {
            for (MethodBinding currentMethod : currentNamesakes) {
                if (currentMethod == current || !this.doesMethodOverride(currentMethod, inherited)) continue;
                methodToCheck = currentMethod;
                break;
            }
        }
        if (!current.areParameterErasuresEqual(original = methodToCheck.original())) {
            return false;
        }
        original = inherited.original();
        this.problemReporter(current).methodNameClash(current, inherited.declaringClass.isRawType() ? inherited : original, severity);
        return severity != 0;
    }

    boolean doTypeVariablesClash(MethodBinding one, MethodBinding substituteTwo) {
        return one.typeVariables != Binding.NO_TYPE_VARIABLES && !(substituteTwo instanceof ParameterizedGenericMethodBinding);
    }

    @Override
    SimpleSet findSuperinterfaceCollisions(ReferenceBinding superclass, ReferenceBinding[] superInterfaces) {
        ReferenceBinding superType;
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        ReferenceBinding[] itsInterfaces = superInterfaces;
        if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
            nextPosition = itsInterfaces.length;
            interfacesToVisit = itsInterfaces;
        }
        boolean isInconsistent = this.type.isHierarchyInconsistent();
        for (superType = superclass; superType != null && superType.isValidBinding(); superType = superType.superclass()) {
            isInconsistent |= superType.isHierarchyInconsistent();
            itsInterfaces = superType.superInterfaces();
            if (itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
            if (interfacesToVisit == null) {
                interfacesToVisit = itsInterfaces;
                nextPosition = interfacesToVisit.length;
                continue;
            }
            int itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            block1: for (int a = 0; a < itsLength; ++a) {
                ReferenceBinding next = itsInterfaces[a];
                for (int b = 0; b < nextPosition; ++b) {
                    if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block1;
                }
                interfacesToVisit[nextPosition++] = next;
            }
        }
        for (int i = 0; i < nextPosition; ++i) {
            superType = interfacesToVisit[i];
            if (!superType.isValidBinding()) continue;
            isInconsistent |= superType.isHierarchyInconsistent();
            itsInterfaces = superType.superInterfaces();
            if (itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
            int itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            block4: for (int a = 0; a < itsLength; ++a) {
                ReferenceBinding next = itsInterfaces[a];
                for (int b = 0; b < nextPosition; ++b) {
                    if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block4;
                }
                interfacesToVisit[nextPosition++] = next;
            }
        }
        if (!isInconsistent) {
            return null;
        }
        SimpleSet copy = null;
        for (int i = 0; i < nextPosition; ++i) {
            ReferenceBinding current = interfacesToVisit[i];
            if (!current.isValidBinding()) continue;
            TypeBinding erasure = current.erasure();
            for (int j = i + 1; j < nextPosition; ++j) {
                ReferenceBinding next = interfacesToVisit[j];
                if (!next.isValidBinding() || !TypeBinding.equalsEquals(next.erasure(), erasure)) continue;
                if (copy == null) {
                    copy = new SimpleSet(nextPosition);
                }
                copy.add(interfacesToVisit[i]);
                copy.add(interfacesToVisit[j]);
            }
        }
        return copy;
    }

    boolean isAcceptableReturnTypeOverride(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (inheritedMethod.declaringClass.isRawType()) {
            return true;
        }
        MethodBinding originalInherited = inheritedMethod.original();
        TypeBinding originalInheritedReturnType = originalInherited.returnType.leafComponentType();
        if (originalInheritedReturnType.isParameterizedTypeWithActualArguments()) {
            return !currentMethod.returnType.leafComponentType().isRawType();
        }
        TypeBinding currentReturnType = currentMethod.returnType.leafComponentType();
        switch (currentReturnType.kind()) {
            case 4100: {
                if (!TypeBinding.equalsEquals(currentReturnType, inheritedMethod.returnType.leafComponentType())) break;
                return true;
            }
        }
        return !originalInheritedReturnType.isTypeVariable() || ((TypeVariableBinding)originalInheritedReturnType).declaringElement != originalInherited;
    }

    @Override
    boolean isInterfaceMethodImplemented(MethodBinding inheritedMethod, MethodBinding existingMethod, ReferenceBinding superType) {
        if (inheritedMethod.original() != inheritedMethod && existingMethod.declaringClass.isInterface()) {
            return false;
        }
        if ((inheritedMethod = this.computeSubstituteMethod(inheritedMethod, existingMethod)) == null || !this.doesMethodOverride(existingMethod, inheritedMethod)) {
            return false;
        }
        return TypeBinding.equalsEquals(inheritedMethod.returnType, existingMethod.returnType) || TypeBinding.notEquals(this.type, existingMethod.declaringClass) && !existingMethod.declaringClass.isInterface() && this.areReturnTypesCompatible(existingMethod, inheritedMethod);
    }

    @Override
    public boolean isMethodSubsignature(MethodBinding method, MethodBinding inheritedMethod) {
        MethodBinding inheritedOriginal;
        if (!CharOperation.equals(method.selector, inheritedMethod.selector)) {
            return false;
        }
        if (method.declaringClass.isParameterizedType()) {
            method = method.original();
        }
        return this.isParameterSubsignature(method, (inheritedOriginal = method.findOriginalInheritedMethod(inheritedMethod)) == null ? inheritedMethod : inheritedOriginal);
    }

    boolean isUnsafeReturnTypeOverride(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (TypeBinding.equalsEquals(currentMethod.returnType, inheritedMethod.returnType.erasure())) {
            TypeBinding[] currentParams = currentMethod.parameters;
            TypeBinding[] inheritedParams = inheritedMethod.parameters;
            int l = currentParams.length;
            for (int i = 0; i < l; ++i) {
                if (MethodVerifier15.areTypesEqual(currentParams[i], inheritedParams[i])) continue;
                return true;
            }
        }
        return currentMethod.typeVariables == Binding.NO_TYPE_VARIABLES && inheritedMethod.original().typeVariables != Binding.NO_TYPE_VARIABLES && currentMethod.returnType.erasure().findSuperTypeOriginatingFrom(inheritedMethod.returnType.erasure()) != null;
    }

    @Override
    boolean reportIncompatibleReturnTypeError(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (this.isUnsafeReturnTypeOverride(currentMethod, inheritedMethod)) {
            this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, inheritedMethod, this.type);
            return false;
        }
        return super.reportIncompatibleReturnTypeError(currentMethod, inheritedMethod);
    }

    @Override
    void verify() {
        if (this.type.isAnnotationType()) {
            this.type.detectAnnotationCycle();
        }
        super.verify();
        this.reportRawReferences();
        int i = this.type.typeVariables.length;
        while (--i >= 0) {
            TypeVariableBinding var = this.type.typeVariables[i];
            if (var.superInterfaces == Binding.NO_SUPERINTERFACES || var.superInterfaces.length == 1 && var.superclass.id == 1) continue;
            this.currentMethods = new HashtableOfObject(0);
            ReferenceBinding superclass = var.superclass();
            if (superclass.kind() == 4100) {
                superclass = (ReferenceBinding)superclass.erasure();
            }
            ReferenceBinding[] itsInterfaces = var.superInterfaces();
            ReferenceBinding[] superInterfaces = new ReferenceBinding[itsInterfaces.length];
            int j = itsInterfaces.length;
            while (--j >= 0) {
                superInterfaces[j] = itsInterfaces[j].kind() == 4100 ? (ReferenceBinding)itsInterfaces[j].erasure() : itsInterfaces[j];
            }
            this.computeInheritedMethods(superclass, superInterfaces);
            this.checkTypeVariableMethods(this.type.scope.referenceContext.typeParameters[i]);
        }
    }
}

