/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.util.Util;

public class BinaryTypeFormatter {
    public static String annotationToString(IBinaryAnnotation annotation) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('@');
        buffer.append(annotation.getTypeName());
        IBinaryElementValuePair[] valuePairs = annotation.getElementValuePairs();
        if (valuePairs != null) {
            buffer.append('(');
            buffer.append("\n\t");
            int len = valuePairs.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    buffer.append(",\n\t");
                }
                buffer.append(valuePairs[i]);
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    public static String annotationToString(IBinaryTypeAnnotation typeAnnotation) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(typeAnnotation.getAnnotation());
        buffer.append(' ');
        buffer.append("target_type=").append(typeAnnotation.getTargetType());
        buffer.append(", info=").append(typeAnnotation.getSupertypeIndex());
        buffer.append(", info2=").append(typeAnnotation.getBoundIndex());
        int[] theTypePath = typeAnnotation.getTypePath();
        if (theTypePath != null && theTypePath.length != 0) {
            buffer.append(", location=[");
            int max = theTypePath.length;
            block6: for (int i = 0; i < max; i += 2) {
                if (i > 0) {
                    buffer.append(", ");
                }
                switch (theTypePath[i]) {
                    case 0: {
                        buffer.append("ARRAY");
                        continue block6;
                    }
                    case 1: {
                        buffer.append("INNER_TYPE");
                        continue block6;
                    }
                    case 2: {
                        buffer.append("WILDCARD");
                        continue block6;
                    }
                    case 3: {
                        buffer.append("TYPE_ARGUMENT(").append(theTypePath[i + 1]).append(')');
                    }
                }
            }
            buffer.append(']');
        }
        return buffer.toString();
    }

    public static String methodToString(IBinaryMethod method) {
        StringBuffer result = new StringBuffer();
        BinaryTypeFormatter.methodToStringContent(result, method);
        return result.toString();
    }

    public static void methodToStringContent(StringBuffer buffer, IBinaryMethod method) {
        int l;
        int i;
        int modifiers = method.getModifiers();
        char[] desc = method.getGenericSignature();
        if (desc == null) {
            desc = method.getMethodDescriptor();
        }
        buffer.append('{').append(((modifiers & 0x100000) != 0 ? "deprecated " : Util.EMPTY_STRING) + ((modifiers & 1) == 1 ? "public " : Util.EMPTY_STRING) + ((modifiers & 2) == 2 ? "private " : Util.EMPTY_STRING) + ((modifiers & 4) == 4 ? "protected " : Util.EMPTY_STRING) + ((modifiers & 8) == 8 ? "static " : Util.EMPTY_STRING) + ((modifiers & 0x10) == 16 ? "final " : Util.EMPTY_STRING) + ((modifiers & 0x40) == 64 ? "bridge " : Util.EMPTY_STRING) + ((modifiers & 0x80) == 128 ? "varargs " : Util.EMPTY_STRING)).append(method.getSelector()).append(desc).append('}');
        Object defaultValue = method.getDefaultValue();
        if (defaultValue != null) {
            buffer.append(" default ");
            if (defaultValue instanceof Object[]) {
                buffer.append('{');
                Object[] elements = (Object[])defaultValue;
                int len = elements.length;
                for (i = 0; i < len; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(elements[i]);
                }
                buffer.append('}');
            } else {
                buffer.append(defaultValue);
            }
            buffer.append('\n');
        }
        IBinaryAnnotation[] annotations = method.getAnnotations();
        int n = l = annotations == null ? 0 : annotations.length;
        for (i = 0; i < l; ++i) {
            buffer.append(annotations[i]);
            buffer.append('\n');
        }
        int annotatedParameterCount = method.getAnnotatedParametersCount();
        for (int i2 = 0; i2 < annotatedParameterCount; ++i2) {
            int k;
            buffer.append("param" + (i2 - 1));
            buffer.append('\n');
            IBinaryAnnotation[] infos = method.getParameterAnnotations(i2, new char[0]);
            int n2 = k = infos == null ? 0 : infos.length;
            for (int j = 0; j < k; ++j) {
                buffer.append(infos[j]);
                buffer.append('\n');
            }
        }
    }
}

