/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.select;

import org.eclipse.jdt.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SelectionOnMessageSend
extends MessageSend {
    private MethodBinding findNonDefaultAbstractMethod(MethodBinding methodBinding) {
        ReferenceBinding[] itsInterfaces = methodBinding.declaringClass.superInterfaces();
        if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
            ReferenceBinding[] interfacesToVisit = itsInterfaces;
            int nextPosition = interfacesToVisit.length;
            for (int i = 0; i < nextPosition; ++i) {
                ReferenceBinding currentType = interfacesToVisit[i];
                MethodBinding[] methods = currentType.getMethods(methodBinding.selector);
                if (methods != null) {
                    for (int k = 0; k < methods.length; ++k) {
                        if (!methodBinding.areParametersEqual(methods[k])) continue;
                        return methods[k];
                    }
                }
                if ((itsInterfaces = currentType.superInterfaces()) == Binding.NO_SUPERINTERFACES) continue;
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                block2: for (int a = 0; a < itsLength; ++a) {
                    ReferenceBinding next = itsInterfaces[a];
                    for (int b = 0; b < nextPosition; ++b) {
                        if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block2;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
            }
        }
        return methodBinding;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("<SelectOnMessageSend:");
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, output).append('.');
        }
        output.append(this.selector).append('(');
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
            }
        }
        return output.append(")>");
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding type = super.resolveType(scope);
        if (type != null && type.isPolyType()) {
            return type;
        }
        if (this.binding == null || !this.binding.isValidBinding() && this.binding.problemId() != 2 && this.binding.problemId() != 5 && this.binding.problemId() != 6 && this.binding.problemId() != 7) {
            throw new SelectionNodeFound();
        }
        if (this.binding.isDefaultAbstract()) {
            throw new SelectionNodeFound(this.findNonDefaultAbstractMethod(this.binding));
        }
        throw new SelectionNodeFound(this.binding);
    }
}

