/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTextElement;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.internal.compiler.util.Util;

public final class TextElement
extends AbstractTextElement {
    public static final SimplePropertyDescriptor TEXT_PROPERTY = TextElement.internalTextPropertyFactory(TextElement.class);
    private static final List PROPERTY_DESCRIPTORS;

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final SimplePropertyDescriptor internalTextPropertyFactory() {
        return TEXT_PROPERTY;
    }

    TextElement(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return TextElement.propertyDescriptors(apiLevel);
    }

    @Override
    final int getNodeType0() {
        return 66;
    }

    @Override
    ASTNode clone0(AST target) {
        TextElement result = new TextElement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setText(this.getText());
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (text.indexOf("*/") > 0) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(TEXT_PROPERTY);
        this.text = text;
        this.postValueChange(TEXT_PROPERTY);
    }

    @Override
    int memSize() {
        int size = 44;
        if (this.text != Util.EMPTY_STRING) {
            size += TextElement.stringSize(this.text);
        }
        return size;
    }

    @Override
    int treeSize() {
        return this.memSize();
    }

    static {
        ArrayList propertyList = new ArrayList(2);
        TextElement.createPropertyList(TextElement.class, propertyList);
        TextElement.addProperty(TEXT_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = TextElement.reapPropertyList(propertyList);
    }
}

