/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter.linewrap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;
import org.eclipse.jdt.internal.formatter.TokenTraverser;

public class CommentWrapExecutor
extends TokenTraverser {
    private final TokenManager tm;
    private final DefaultCodeFormatterOptions options;
    private final ArrayList<Token> nlsTags = new ArrayList();
    private int lineStartPosition;
    private int lineLimit;
    private boolean simulation;
    private boolean wrapDisabled;
    private boolean newLinesAtBoundries;
    private Token potentialWrapToken;
    private Token potentialWrapTokenSubstitute;
    private int counterIfWrapped;
    private int counterIfWrappedSubstitute;
    private int lineCounter;

    public CommentWrapExecutor(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.tm = tokenManager;
        this.options = options;
    }

    public int wrapMultiLineComment(Token commentToken, int startPosition, boolean simulate, boolean noWrap) {
        this.lineCounter = 1;
        this.counter = startPosition;
        commentToken.setIndent(this.tm.toIndent(startPosition, true));
        this.lineStartPosition = commentToken.getIndent();
        this.lineLimit = this.getLineLimit(startPosition);
        this.simulation = simulate;
        this.wrapDisabled = noWrap;
        this.potentialWrapTokenSubstitute = null;
        this.potentialWrapToken = null;
        this.newLinesAtBoundries = commentToken.tokenType == 1003 ? this.options.comment_new_lines_at_javadoc_boundaries : this.options.comment_new_lines_at_block_boundaries;
        List<Token> structure = commentToken.getInternalStructure();
        if (structure == null || structure.isEmpty()) {
            return startPosition + this.tm.getLength(commentToken, startPosition);
        }
        int position = this.tryToFitInOneLine(structure, startPosition, noWrap);
        if (position > 0) {
            return position;
        }
        this.traverse(structure, 0);
        this.cleanupIndent(structure);
        if (this.newLinesAtBoundries) {
            return this.lineStartPosition + 1 + this.tm.getLength(structure.get(structure.size() - 1), 0);
        }
        return this.counter;
    }

    public int getLinesCount() {
        return this.lineCounter;
    }

    private int tryToFitInOneLine(List<Token> structure, int startPosition, boolean noWrap) {
        int position = startPosition;
        boolean hasWrapPotential = false;
        boolean wasSpaceAfter = false;
        for (int i = 0; i < structure.size(); ++i) {
            Token token = structure.get(i);
            if (token.getLineBreaksBefore() > 0 || token.getLineBreaksAfter() > 0) {
                assert (!noWrap);
                return -1;
            }
            if (!wasSpaceAfter && token.isSpaceBefore()) {
                ++position;
            }
            position += this.tm.getLength(token, position);
            wasSpaceAfter = token.isSpaceAfter();
            if (wasSpaceAfter) {
                ++position;
            }
            Token.WrapPolicy policy = token.getWrapPolicy();
            if (i <= 1 || policy != null && policy != Token.WrapPolicy.SUBSTITUTE_ONLY) continue;
            hasWrapPotential = true;
        }
        if (position <= this.lineLimit || noWrap || !hasWrapPotential) {
            return position;
        }
        return -1;
    }

    private int getStartingPosition(Token token, boolean isNewLine) {
        int position = this.lineStartPosition + token.getAlign() + (isNewLine ? token.getIndent() : 0);
        if (token.tokenType != 0) {
            position += 3;
        }
        return position;
    }

    @Override
    protected boolean token(Token token, int index) {
        boolean canWrap;
        int positionIfNewLine = this.getStartingPosition(token, true);
        int lineBreaksBefore = this.getLineBreaksBefore();
        if ((index == 1 || this.getNext() == null) && this.newLinesAtBoundries && lineBreaksBefore == 0) {
            if (!this.simulation) {
                token.breakBefore();
            }
            lineBreaksBefore = 1;
        }
        if (lineBreaksBefore > 0) {
            this.lineCounter += lineBreaksBefore;
            this.counter = positionIfNewLine;
            this.potentialWrapTokenSubstitute = null;
            this.potentialWrapToken = null;
            this.lineLimit = this.getLineLimit(this.lineStartPosition);
        }
        boolean bl = canWrap = this.getNext() != null && lineBreaksBefore == 0 && index > 1 && positionIfNewLine < this.counter;
        if (canWrap) {
            if (token.getWrapPolicy() == null) {
                this.potentialWrapToken = token;
                this.counterIfWrapped = positionIfNewLine;
            } else if (token.getWrapPolicy() == Token.WrapPolicy.SUBSTITUTE_ONLY) {
                this.potentialWrapTokenSubstitute = token;
                this.counterIfWrappedSubstitute = positionIfNewLine;
            }
        }
        if (index > 1 && this.getNext() != null && token.getAlign() + token.getIndent() > 0) {
            this.counter = Math.max(this.counter, this.getStartingPosition(token, this.getLineBreaksBefore() > 0));
        }
        this.counter += this.tm.getLength(token, this.counter);
        this.counterIfWrapped += this.tm.getLength(token, this.counterIfWrapped);
        this.counterIfWrappedSubstitute += this.tm.getLength(token, this.counterIfWrappedSubstitute);
        if (this.shouldWrap()) {
            if (this.potentialWrapToken == null) {
                assert (this.potentialWrapTokenSubstitute != null);
                this.potentialWrapToken = this.potentialWrapTokenSubstitute;
                this.counterIfWrapped = this.counterIfWrappedSubstitute;
            }
            if (!this.simulation) {
                this.potentialWrapToken.breakBefore();
            }
            this.counter = this.counterIfWrapped;
            ++this.lineCounter;
            this.potentialWrapTokenSubstitute = null;
            this.potentialWrapToken = null;
            this.lineLimit = this.getLineLimit(this.lineStartPosition);
        }
        if (this.isSpaceAfter()) {
            ++this.counter;
            ++this.counterIfWrapped;
        }
        return true;
    }

    private boolean shouldWrap() {
        if (this.wrapDisabled || this.counter <= this.lineLimit) {
            return false;
        }
        if (this.getLineBreaksAfter() == 0 && this.getNext() != null && this.getNext().getWrapPolicy() == Token.WrapPolicy.DISABLE_WRAP) {
            return false;
        }
        if (this.potentialWrapToken != null && this.potentialWrapTokenSubstitute != null && this.counterIfWrapped > this.lineLimit && this.counterIfWrappedSubstitute < this.counterIfWrapped) {
            this.potentialWrapToken = null;
        }
        return this.potentialWrapToken != null || this.potentialWrapTokenSubstitute != null;
    }

    private void cleanupIndent(List<Token> structure) {
        if (this.simulation) {
            return;
        }
        new TokenTraverser(){

            @Override
            protected boolean token(Token token, int index) {
                if (token.tokenType == 1003 && token.getInternalStructure() == null) {
                    if (this.getLineBreaksBefore() > 0) {
                        token.setAlign(token.getAlign() + token.getIndent());
                    }
                    token.setIndent(0);
                }
                return true;
            }
        }.traverse(structure, 0);
    }

    public void wrapLineComment(Token commentToken, int startPosition) {
        boolean formattingEnabled;
        List<Token> structure = commentToken.getInternalStructure();
        if (structure == null || structure.isEmpty()) {
            return;
        }
        int commentIndex = this.tm.indexOf(commentToken);
        boolean isHeader = this.tm.isInHeader(commentIndex);
        boolean bl = formattingEnabled = isHeader ? this.options.comment_format_header : this.options.comment_format_line_comment;
        if (!formattingEnabled) {
            return;
        }
        int position = startPosition;
        int indent = startPosition = this.tm.toIndent(startPosition, true);
        int limit = this.getLineLimit(position);
        for (Token token : structure) {
            if (!token.hasNLSTag()) continue;
            this.nlsTags.add(token);
            position += token.countChars() + (token.isSpaceBefore() ? 1 : 0);
        }
        Token whitespace = null;
        Token prefix = structure.get(0);
        if (prefix.tokenType == 1000) {
            whitespace = new Token(prefix);
            whitespace.breakBefore();
            whitespace.setIndent(indent);
            whitespace.setWrapPolicy(new Token.WrapPolicy(Token.WrapMode.WHERE_NECESSARY, commentIndex, 0));
            prefix = structure.get(1);
            assert (prefix.tokenType == 1001);
        }
        int prefixEnd = commentToken.originalStart + 1;
        if (!prefix.hasNLSTag()) {
            prefixEnd = Math.max(prefixEnd, prefix.originalEnd);
        }
        prefix = new Token(commentToken.originalStart, prefixEnd, 1001);
        if (whitespace == null) {
            prefix.breakBefore();
            prefix.setWrapPolicy(new Token.WrapPolicy(Token.WrapMode.WHERE_NECESSARY, commentIndex, 0));
        }
        int lineStartIndex = whitespace == null ? 0 : 1;
        for (int i = 0; i < structure.size(); ++i) {
            Token token = structure.get(i);
            token.setIndent(indent);
            if (token.hasNLSTag()) {
                this.nlsTags.remove(token);
                continue;
            }
            if (token.isSpaceBefore()) {
                ++position;
            }
            if (token.getLineBreaksBefore() > 0) {
                position = startPosition;
                limit = this.getLineLimit(position);
                int n = lineStartIndex = whitespace == null ? i : i + 1;
                if (whitespace != null && token != whitespace) {
                    token.clearLineBreaksBefore();
                    structure.add(i, whitespace);
                    token = whitespace;
                }
            }
            position += this.tm.getLength(token, position);
            if (token.tokenType == 1000) {
                limit = this.getLineLimit(position);
            }
            if (position <= limit || i <= lineStartIndex + 1) continue;
            structure.add(i, prefix);
            if (whitespace != null) {
                structure.add(i, whitespace);
            }
            structure.removeAll(this.nlsTags);
            structure.addAll(i, this.nlsTags);
            i = i + this.nlsTags.size() - 1;
            this.nlsTags.clear();
        }
        this.nlsTags.clear();
    }

    private int getLineLimit(int startPosition) {
        int commentLength = this.options.comment_line_length;
        if (!this.options.comment_count_line_length_from_starting_position) {
            return commentLength;
        }
        int lineLength = startPosition + commentLength;
        int pageWidth = this.options.page_width;
        if (lineLength > pageWidth && commentLength <= pageWidth) {
            lineLength = pageWidth;
        }
        return lineLength;
    }
}

