/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IProvidesInfo;
import org.eclipse.jdt.internal.core.util.ClassFileStruct;

public class ProvidesInfo
extends ClassFileStruct
implements IProvidesInfo {
    private int index;
    private char[] serviceName;
    private int implementationsCount;
    private int[] implementationIndices;
    private char[][] implementationNames;

    public ProvidesInfo(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        int readOffset = 0;
        this.index = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.index);
        if (constantPoolEntry.getKind() != 7) {
            throw new ClassFormatException(3);
        }
        this.serviceName = constantPoolEntry.getClassInfoName();
        this.implementationsCount = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        if (this.implementationsCount != 0) {
            this.implementationIndices = new int[this.implementationsCount];
            this.implementationNames = new char[this.implementationsCount][];
            for (int i = 0; i < this.implementationsCount; ++i) {
                this.implementationIndices[i] = this.u2At(classFileBytes, readOffset, offset);
                readOffset += 2;
                constantPoolEntry = constantPool.decodeEntry(this.implementationIndices[i]);
                if (constantPoolEntry.getKind() != 7) {
                    throw new ClassFormatException(3);
                }
                this.implementationNames[i] = constantPoolEntry.getClassInfoName();
            }
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public char[] getServiceName() {
        return this.serviceName;
    }

    @Override
    public int getImplementationsCount() {
        return this.implementationsCount;
    }

    @Override
    public int[] getImplementationIndices() {
        return this.implementationIndices;
    }

    @Override
    public char[][] getImplementationNames() {
        return this.implementationNames;
    }
}

