/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.IParallelizable;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.index.IndexLocation;
import org.eclipse.jdt.internal.core.search.IndexSelector;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.indexing.BinaryIndexer;
import org.eclipse.jdt.internal.core.search.indexing.ManifestIndexer;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;

public class JavaSearchParticipant
extends SearchParticipant
implements IParallelizable {
    private final ThreadLocal indexSelector = new ThreadLocal();
    private SourceIndexer sourceIndexer;

    @Override
    public void beginSearching() {
        super.beginSearching();
        this.indexSelector.remove();
    }

    @Override
    public void doneSearching() {
        this.indexSelector.remove();
        super.doneSearching();
    }

    @Override
    public String getDescription() {
        return "Java";
    }

    @Override
    public SearchDocument getDocument(String documentPath) {
        return new JavaSearchDocument(documentPath, this);
    }

    @Override
    public void indexDocument(SearchDocument document, IPath indexPath) {
        document.removeAllIndexEntries();
        String documentPath = document.getPath();
        if (org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(documentPath)) {
            SourceIndexer indexer = new SourceIndexer(document);
            indexer.indexDocument();
            if (document.shouldIndexResolvedDocument()) {
                this.sourceIndexer = indexer;
            }
        } else if (Util.isClassFileName(documentPath)) {
            new BinaryIndexer(document).indexDocument();
        } else if (documentPath.endsWith("Automatic-Module-Name")) {
            new ManifestIndexer(document).indexDocument();
        }
    }

    @Override
    public void indexResolvedDocument(SearchDocument document, IPath indexPath) {
        SourceIndexer indexer;
        String documentPath = document.getPath();
        if (org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(documentPath) && (indexer = this.sourceIndexer) != null) {
            indexer.indexResolvedDocument();
            this.sourceIndexer = null;
        }
    }

    @Override
    public void resolveDocument(SearchDocument document) {
        SourceIndexer indexer;
        String documentPath = document.getPath();
        if (org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(documentPath) && (indexer = this.sourceIndexer) != null) {
            indexer.resolveDocument();
        }
    }

    @Override
    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        MatchLocator matchLocator = new MatchLocator(pattern, requestor, scope, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(indexMatches);
    }

    @Override
    public IPath[] selectIndexes(SearchPattern pattern, IJavaSearchScope scope) {
        IndexSelector selector = this.getIndexSelector(pattern, scope);
        IndexLocation[] urls = selector.getIndexLocations();
        IPath[] paths = new IPath[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            paths[i] = new Path(urls[i].getIndexFile().getPath());
        }
        return paths;
    }

    private IndexSelector getIndexSelector(SearchPattern pattern, IJavaSearchScope scope) {
        IndexSelector selector = (IndexSelector)this.indexSelector.get();
        if (selector == null) {
            selector = new IndexSelector(scope, pattern);
            this.indexSelector.set(selector);
        }
        return selector;
    }

    public IndexLocation[] selectIndexURLs(SearchPattern pattern, IJavaSearchScope scope) {
        IndexSelector selector = this.getIndexSelector(pattern, scope);
        return selector.getIndexLocations();
    }

    @Override
    public boolean isParallelSearchSupported() {
        return true;
    }
}

