/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.compiler.env.IMultiModuleEntry;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.AbstractModule;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.CompilationGroup;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.ModuleUpdater;
import org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.ModuleEntryProcessor;
import org.eclipse.jdt.internal.core.builder.ModulePathEntry;
import org.eclipse.jdt.internal.core.builder.SourceFile;

public class NameEnvironment
implements IModuleAwareNameEnvironment,
SuffixConstants {
    boolean isIncrementalBuild;
    ClasspathMultiDirectory[] sourceLocations;
    ClasspathLocation[] binaryLocations;
    Map<String, IModulePathEntry> modulePathEntries;
    BuildNotifier notifier;
    SimpleSet initialTypeNames;
    SimpleLookupTable additionalUnits;
    private CompilationGroup compilationGroup;
    ModuleUpdater moduleUpdater;

    NameEnvironment(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject, BuildNotifier notifier, CompilationGroup compilationGroup) throws CoreException {
        this.compilationGroup = compilationGroup;
        this.isIncrementalBuild = false;
        this.notifier = notifier;
        this.computeClasspathLocations(root, javaProject, binaryLocationsPerProject);
        this.setNames(null, null);
    }

    public NameEnvironment(IJavaProject javaProject, CompilationGroup compilationGroup) {
        this.isIncrementalBuild = false;
        this.compilationGroup = compilationGroup;
        try {
            this.computeClasspathLocations(javaProject.getProject().getWorkspace().getRoot(), (JavaProject)javaProject, null);
        }
        catch (CoreException e) {
            this.sourceLocations = new ClasspathMultiDirectory[0];
            this.binaryLocations = new ClasspathLocation[0];
        }
        this.setNames(null, null);
    }

    private void computeClasspathLocations(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject) throws CoreException {
        int i;
        IMarker cycleMarker = javaProject.getCycleMarker();
        if (cycleMarker != null) {
            int severity;
            int n = severity = "error".equals(javaProject.getOption("org.eclipse.jdt.core.circularClasspath", true)) ? 2 : 1;
            if (severity != cycleMarker.getAttribute("severity", severity)) {
                cycleMarker.setAttribute("severity", severity);
            }
        }
        IClasspathEntry[] classpathEntries = javaProject.getExpandedClasspath(this.compilationGroup == CompilationGroup.MAIN);
        ArrayList<ClasspathLocation> sLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        ArrayList<ClasspathLocation> bLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        ArrayList<ClasspathLocation> sLocationsForTest = new ArrayList<ClasspathLocation>(classpathEntries.length);
        LinkedHashMap<String, IModulePathEntry> moduleEntries = null;
        String compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        if (CompilerOptions.versionToJdkLevel(compliance) >= 0x350000L) {
            moduleEntries = new LinkedHashMap<String, IModulePathEntry>(classpathEntries.length);
            this.moduleUpdater = new ModuleUpdater(javaProject);
            if (this.compilationGroup == CompilationGroup.TEST) {
                this.moduleUpdater.addReadUnnamedForNonEmptyClasspath(javaProject, classpathEntries);
            }
        }
        IModuleDescription projectModule = javaProject.getModuleDescription();
        String patchedModuleName = ModuleEntryProcessor.pushPatchToFront(classpathEntries, javaProject);
        IModule patchedModule = null;
        int l = classpathEntries.length;
        block9: for (int i2 = 0; i2 < l; ++i2) {
            if (i2 == 1 && patchedModuleName != null) {
                patchedModuleName = null;
            }
            ClasspathEntry entry = (ClasspathEntry)classpathEntries[i2];
            IPath path = entry.getPath();
            Object target = JavaModel.getTarget(path, true);
            IPath externalAnnotationPath = entry.getExternalAnnotationPath(javaProject.getProject(), true);
            if (target == null) continue;
            boolean isOnModulePath = this.isOnModulePath(entry);
            Set<String> limitModules = ModuleEntryProcessor.computeLimitModules(entry);
            if (patchedModuleName != null && limitModules != null && !limitModules.contains(patchedModuleName)) {
                patchedModuleName = null;
            }
            if (!(this.moduleUpdater == null || this.compilationGroup != CompilationGroup.TEST && entry.isTest())) {
                this.moduleUpdater.computeModuleUpdates(entry);
            }
            switch (entry.getEntryKind()) {
                case 3: {
                    IProject outputFolder;
                    IPath outputPath;
                    if (!(target instanceof IContainer)) continue block9;
                    IPath iPath = outputPath = entry.getOutputLocation() != null ? entry.getOutputLocation() : javaProject.getOutputLocation();
                    if (outputPath.segmentCount() == 1) {
                        outputFolder = javaProject.getProject();
                    } else {
                        outputFolder = root.getFolder(outputPath);
                        if (!outputFolder.exists()) {
                            this.createOutputFolder((IContainer)outputFolder);
                        }
                    }
                    if (this.compilationGroup == CompilationGroup.TEST && !entry.isTest()) {
                        ClasspathLocation bLocation = ClasspathLocation.forBinaryFolder((IContainer)outputFolder, true, entry.getAccessRuleSet(), externalAnnotationPath, isOnModulePath);
                        bLocations.add(bLocation);
                        sLocationsForTest.add(bLocation);
                        if (patchedModule != null) {
                            ModuleEntryProcessor.combinePatchIntoModuleEntry(bLocation, patchedModule, moduleEntries);
                        }
                        bLocation.patchModuleName = patchedModuleName;
                        continue block9;
                    }
                    ClasspathLocation sourceLocation = ClasspathLocation.forSourceFolder((IContainer)target, (IContainer)outputFolder, entry.fullInclusionPatternChars(), entry.fullExclusionPatternChars(), entry.ignoreOptionalProblems(), externalAnnotationPath);
                    if (patchedModule != null) {
                        ModuleEntryProcessor.combinePatchIntoModuleEntry(sourceLocation, patchedModule, moduleEntries);
                    }
                    sLocations.add(sourceLocation);
                    sourceLocation.patchModuleName = patchedModuleName;
                    continue block9;
                }
                case 2: {
                    IProject prereqProject;
                    if (!(target instanceof IProject) || !JavaProject.hasJavaNature(prereqProject = (IProject)target)) continue block9;
                    JavaProject prereqJavaProject = (JavaProject)JavaCore.create(prereqProject);
                    IClasspathEntry[] prereqClasspathEntries = prereqJavaProject.getRawClasspath();
                    ArrayList<IProject> seen = new ArrayList<IProject>();
                    ArrayList<ClasspathLocation> projectLocations = new ArrayList<ClasspathLocation>();
                    int m = prereqClasspathEntries.length;
                    for (int j = 0; j < m; ++j) {
                        IProject binaryFolder;
                        IClasspathEntry prereqEntry = prereqClasspathEntries[j];
                        if (prereqEntry.getEntryKind() != 3 || (this.compilationGroup == CompilationGroup.MAIN || entry.isWithoutTestCode()) && prereqEntry.isTest()) continue;
                        IPath srcExtAnnotPath = externalAnnotationPath != null ? externalAnnotationPath : prereqEntry.getExternalAnnotationPath(javaProject.getProject(), true);
                        Iterator prereqTarget = JavaModel.getTarget(prereqEntry.getPath(), true);
                        if (!(prereqTarget instanceof IContainer)) continue;
                        if (srcExtAnnotPath == null) {
                            IPath outputLoc = prereqEntry.getOutputLocation();
                            for (int k = j + 1; k < m; ++k) {
                                IClasspathEntry other = prereqClasspathEntries[k];
                                if (other.getEntryKind() != 3) continue;
                                IPath otherOutput = other.getOutputLocation();
                                if ((outputLoc == null ? otherOutput == null : outputLoc.equals((Object)otherOutput)) && (srcExtAnnotPath = other.getExternalAnnotationPath(javaProject.getProject(), true)) != null) break;
                            }
                        }
                        IPath prereqOutputPath = prereqEntry.getOutputLocation() != null ? prereqEntry.getOutputLocation() : prereqJavaProject.getOutputLocation();
                        Object object = binaryFolder = prereqOutputPath.segmentCount() == 1 ? prereqProject : root.getFolder(prereqOutputPath);
                        if (!binaryFolder.exists() || seen.contains(binaryFolder)) continue;
                        seen.add(binaryFolder);
                        ClasspathLocation bLocation = ClasspathLocation.forBinaryFolder((IContainer)binaryFolder, true, entry.getAccessRuleSet(), srcExtAnnotPath, isOnModulePath);
                        bLocations.add(bLocation);
                        projectLocations.add(bLocation);
                        if (binaryLocationsPerProject == null) continue;
                        ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get(prereqProject);
                        if (existingLocations == null) {
                            existingLocations = new ClasspathLocation[]{bLocation};
                        } else {
                            int size = existingLocations.length;
                            ClasspathLocation[] classpathLocationArray = existingLocations;
                            existingLocations = new ClasspathLocation[size + 1];
                            System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                            existingLocations[size] = bLocation;
                        }
                        binaryLocationsPerProject.put(prereqProject, existingLocations);
                    }
                    if (moduleEntries == null || !isOnModulePath || projectLocations.size() <= 0) continue block9;
                    IModule info = null;
                    try {
                        IModuleDescription mod = prereqJavaProject.getModuleDescription();
                        if (mod != null) {
                            AbstractModule aModule = (AbstractModule)mod;
                            info = aModule.getModuleInfo();
                        }
                    }
                    catch (JavaModelException mod) {
                        // empty catch block
                    }
                    if (info == null) {
                        info = IModule.createAutomatic(prereqJavaProject.getElementName(), false, prereqJavaProject.getManifest());
                    }
                    ModulePathEntry projectEntry = new ModulePathEntry(prereqJavaProject.getPath(), info, projectLocations.toArray(new ClasspathLocation[projectLocations.size()]));
                    String moduleName = String.valueOf(info.name());
                    IUpdatableModule.UpdatesByKind updates = this.moduleUpdater.getUpdates(moduleName);
                    for (ClasspathLocation loc : projectLocations) {
                        loc.limitModuleNames = limitModules;
                        loc.updates = updates;
                        loc.patchModuleName = patchedModuleName;
                    }
                    if (limitModules != null && !limitModules.contains(moduleName)) continue block9;
                    moduleEntries.put(moduleName, projectEntry);
                    if (!moduleName.equals(patchedModuleName)) continue block9;
                    patchedModule = info;
                    continue block9;
                }
                case 1: {
                    if (target instanceof IResource) {
                        AccessRuleSet accessRuleSet;
                        IResource resource = (IResource)target;
                        ClasspathLocation bLocation = null;
                        if (resource instanceof IFile) {
                            accessRuleSet = "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) && "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) ? null : entry.getAccessRuleSet();
                            bLocation = ClasspathLocation.forLibrary((IFile)resource, accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
                        } else if (resource instanceof IContainer) {
                            accessRuleSet = "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) && "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) ? null : entry.getAccessRuleSet();
                            bLocation = ClasspathLocation.forBinaryFolder((IContainer)target, false, accessRuleSet, externalAnnotationPath, isOnModulePath);
                        }
                        bLocations.add(bLocation);
                        if (moduleEntries != null) {
                            patchedModule = this.collectModuleEntries(bLocation, path, isOnModulePath, limitModules, patchedModuleName, patchedModule, moduleEntries);
                        }
                        if (binaryLocationsPerProject == null) continue block9;
                        IProject p = resource.getProject();
                        ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get(p);
                        if (existingLocations == null) {
                            existingLocations = new ClasspathLocation[]{bLocation};
                        } else {
                            int size = existingLocations.length;
                            ClasspathLocation[] classpathLocationArray = existingLocations;
                            existingLocations = new ClasspathLocation[size + 1];
                            System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                            existingLocations[size] = bLocation;
                        }
                        binaryLocationsPerProject.put(p, existingLocations);
                        continue block9;
                    }
                    if (!(target instanceof File)) continue block9;
                    AccessRuleSet accessRuleSet = "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) && "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) ? null : entry.getAccessRuleSet();
                    String release = "enabled".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.release", false)) ? compliance : null;
                    ClasspathLocation bLocation = null;
                    String libPath = path.toOSString();
                    bLocation = Util.isJrt(libPath) ? ClasspathLocation.forJrtSystem(path.toOSString(), accessRuleSet, externalAnnotationPath, release) : ClasspathLocation.forLibrary(path.toOSString(), accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
                    bLocations.add(bLocation);
                    if (moduleEntries == null) continue block9;
                    Set<String> libraryLimitModules = limitModules == null && projectModule != null ? ClasspathJrt.NO_LIMIT_MODULES : limitModules;
                    patchedModule = this.collectModuleEntries(bLocation, path, isOnModulePath, libraryLimitModules, patchedModuleName, patchedModule, moduleEntries);
                    continue block9;
                }
            }
        }
        if ("enabled".equals(javaProject.getOption("org.eclipse.jdt.core.builder.annotationPath.allLocations", true))) {
            ArrayList<ClasspathLocation> allLocationsForEEA = new ArrayList<ClasspathLocation>();
            for (ClasspathLocation loc : bLocations) {
                loc.connectAllLocationsForEEA(allLocationsForEEA, true);
            }
            for (ClasspathLocation loc : sLocations) {
                loc.connectAllLocationsForEEA(allLocationsForEEA, true);
            }
        }
        ArrayList<ClasspathDirectory> outputFolders = new ArrayList<ClasspathDirectory>(1);
        this.sourceLocations = new ClasspathMultiDirectory[sLocations.size()];
        if (!sLocations.isEmpty()) {
            sLocations.toArray(this.sourceLocations);
            if (moduleEntries != null && projectModule != null) {
                try {
                    ClasspathLocation[] sourceLocations2;
                    AbstractModule sourceModule = (AbstractModule)projectModule;
                    IModule info = (IModule)sourceModule.getElementInfo();
                    if (sLocationsForTest.size() == 0) {
                        sourceLocations2 = this.sourceLocations;
                    } else {
                        ArrayList<ClasspathLocation> sourceLocationsForModulePathEntry = new ArrayList<ClasspathLocation>(sLocations.size() + sLocationsForTest.size());
                        sourceLocationsForModulePathEntry.addAll(sLocations);
                        sourceLocationsForModulePathEntry.addAll(sLocationsForTest);
                        sourceLocations2 = sourceLocationsForModulePathEntry.toArray(new ClasspathLocation[sourceLocationsForModulePathEntry.size()]);
                    }
                    ModulePathEntry projectEntry = new ModulePathEntry(javaProject.getPath(), info, sourceLocations2);
                    if (!moduleEntries.containsKey(sourceModule.getElementName())) {
                        moduleEntries.put(sourceModule.getElementName(), projectEntry);
                    }
                }
                catch (JavaModelException sourceModule) {
                    // empty catch block
                }
            }
            int l2 = this.sourceLocations.length;
            block15: for (int i3 = 0; i3 < l2; ++i3) {
                int j;
                ClasspathMultiDirectory md = this.sourceLocations[i3];
                IPath outputPath = md.binaryFolder.getFullPath();
                String eeaPath = md.externalAnnotationPath;
                for (j = 0; j < i3; ++j) {
                    ClasspathMultiDirectory previousMd = this.sourceLocations[j];
                    if (!outputPath.equals((Object)previousMd.binaryFolder.getFullPath())) continue;
                    if (eeaPath == null != (previousMd.externalAnnotationPath == null) && md.isOnModulePath == previousMd.isOnModulePath && md.accessRuleSet == previousMd.accessRuleSet) {
                        int prev;
                        if (eeaPath == null) {
                            eeaPath = previousMd.externalAnnotationPath;
                        }
                        if ((prev = outputFolders.indexOf(previousMd)) != -1) {
                            outputFolders.set(prev, new ClasspathDirectory(md.binaryFolder, true, md.accessRuleSet, (IPath)new Path(eeaPath), md.isOnModulePath));
                            continue block15;
                        }
                    }
                    md.hasIndependentOutputFolder = previousMd.hasIndependentOutputFolder;
                    continue block15;
                }
                outputFolders.add(md);
                int m = this.sourceLocations.length;
                for (j = 0; j < m; ++j) {
                    if (outputPath.equals((Object)this.sourceLocations[j].sourceFolder.getFullPath())) continue block15;
                }
                md.hasIndependentOutputFolder = true;
            }
        }
        this.binaryLocations = new ClasspathLocation[outputFolders.size() + bLocations.size()];
        int index = 0;
        int l3 = outputFolders.size();
        for (i = 0; i < l3; ++i) {
            this.binaryLocations[index++] = (ClasspathLocation)outputFolders.get(i);
        }
        l3 = bLocations.size();
        for (i = 0; i < l3; ++i) {
            this.binaryLocations[index++] = (ClasspathLocation)bLocations.get(i);
        }
        if (moduleEntries != null && !moduleEntries.isEmpty()) {
            this.modulePathEntries = moduleEntries;
        }
    }

    IModule collectModuleEntries(ClasspathLocation bLocation, IPath path, boolean isOnModulePath, Set<String> limitModules, String patchedModuleName, IModule patchedModule, Map<String, IModulePathEntry> moduleEntries) {
        ModulePathEntry binaryModulePathEntry;
        IModule module;
        if (bLocation instanceof IMultiModuleEntry) {
            IModule module2;
            IMultiModuleEntry binaryModulePathEntry2 = (IMultiModuleEntry)((Object)bLocation);
            bLocation.limitModuleNames = limitModules;
            bLocation.patchModuleName = patchedModuleName;
            IUpdatableModule.UpdatesByKind updates = null;
            IUpdatableModule.UpdatesByKind finalUpdates = new IUpdatableModule.UpdatesByKind();
            List<Consumer<IUpdatableModule>> packageUpdates = null;
            List<Consumer<IUpdatableModule>> moduleUpdates = null;
            for (String moduleName : binaryModulePathEntry2.getModuleNames(limitModules)) {
                List<Consumer<IUpdatableModule>> mu;
                moduleEntries.put(moduleName, binaryModulePathEntry2);
                updates = this.moduleUpdater.getUpdates(moduleName);
                if (updates == null) continue;
                List<Consumer<IUpdatableModule>> pu = updates.getList(IUpdatableModule.UpdateKind.PACKAGE, false);
                if (pu != null) {
                    packageUpdates = finalUpdates.getList(IUpdatableModule.UpdateKind.PACKAGE, true);
                    packageUpdates.addAll(pu);
                }
                if ((mu = updates.getList(IUpdatableModule.UpdateKind.MODULE, false)) == null) continue;
                moduleUpdates = finalUpdates.getList(IUpdatableModule.UpdateKind.MODULE, true);
                moduleUpdates.addAll(mu);
            }
            if (packageUpdates != null || moduleUpdates != null) {
                bLocation.updates = finalUpdates;
            }
            if (patchedModuleName != null && (module2 = binaryModulePathEntry2.getModule(patchedModuleName.toCharArray())) != null) {
                return module2;
            }
        } else if (isOnModulePath && (module = (binaryModulePathEntry = new ModulePathEntry(path, bLocation)).getModule()) != null) {
            String moduleName = String.valueOf(module.name());
            bLocation.updates = this.moduleUpdater.getUpdates(moduleName);
            bLocation.limitModuleNames = limitModules;
            bLocation.patchModuleName = patchedModuleName;
            if (limitModules == null || limitModules == ClasspathJrt.NO_LIMIT_MODULES || limitModules.contains(moduleName)) {
                moduleEntries.put(moduleName, binaryModulePathEntry);
                if (patchedModuleName != null && moduleName.equals(patchedModuleName)) {
                    return module;
                }
            }
        }
        return patchedModule;
    }

    protected boolean isOnModulePath(ClasspathEntry entry) {
        return entry.isModular();
    }

    @Override
    public void cleanup() {
        int i;
        this.initialTypeNames = null;
        this.additionalUnits = null;
        int l = this.sourceLocations.length;
        for (i = 0; i < l; ++i) {
            this.sourceLocations[i].cleanup();
        }
        l = this.binaryLocations.length;
        for (i = 0; i < l; ++i) {
            this.binaryLocations[i].cleanup();
        }
    }

    private void createOutputFolder(IContainer outputFolder) throws CoreException {
        this.createParentFolder(outputFolder.getParent());
        ((IFolder)outputFolder).create(1025, true, null);
    }

    private void createParentFolder(IContainer parent) throws CoreException {
        if (!parent.exists()) {
            this.createParentFolder(parent.getParent());
            ((IFolder)parent).create(true, true, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName, IModuleAwareNameEnvironment.LookupStrategy strategy, String moduleName) {
        ClasspathLocation[] relevantLocations;
        char[] binaryFileName;
        String qPackageName;
        String qBinaryFileName;
        block18: {
            String moduleQualifiedName;
            if (this.notifier != null) {
                this.notifier.checkCancelWithinCompiler();
            }
            String string = moduleQualifiedName = moduleName != null ? moduleName + ":" + qualifiedTypeName : qualifiedTypeName;
            if (this.initialTypeNames != null && this.initialTypeNames.includes(moduleQualifiedName)) {
                if (this.isIncrementalBuild) {
                    throw new AbortCompilation(true, new AbortIncrementalBuildException(qualifiedTypeName));
                }
                return null;
            }
            if (this.additionalUnits != null && this.sourceLocations.length > 0) {
                String enclosingTypeName;
                SourceFile unit = (SourceFile)this.additionalUnits.get(qualifiedTypeName);
                if (unit != null) {
                    return new NameEnvironmentAnswer(unit, null);
                }
                int index = qualifiedTypeName.indexOf(36);
                if (index > 0 && (unit = (SourceFile)this.additionalUnits.get(enclosingTypeName = qualifiedTypeName.substring(0, index))) != null) {
                    return new NameEnvironmentAnswer(unit, null);
                }
            }
            qBinaryFileName = qualifiedTypeName + ".class";
            qPackageName = qualifiedTypeName.length() == typeName.length ? Util.EMPTY_STRING : qBinaryFileName.substring(0, qBinaryFileName.length() - typeName.length - 7);
            binaryFileName = CharOperation.concat(typeName, SUFFIX_class);
            if (moduleName != null && this.modulePathEntries != null) {
                IModulePathEntry modulePathEntry = this.modulePathEntries.get(moduleName);
                if (modulePathEntry instanceof ModulePathEntry) {
                    relevantLocations = ((ModulePathEntry)modulePathEntry).getClasspathLocations();
                    break block18;
                } else {
                    if (modulePathEntry instanceof ClasspathLocation) {
                        return ((ClasspathLocation)((Object)modulePathEntry)).findClass(typeName, qPackageName, moduleName, qBinaryFileName, false, null);
                    }
                    return null;
                }
            }
            relevantLocations = this.binaryLocations;
        }
        NameEnvironmentAnswer suggestedAnswer = null;
        ClasspathLocation[] classpathLocationArray = relevantLocations;
        int n = classpathLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathLocation classpathLocation = classpathLocationArray[n2];
            if (strategy.matches(classpathLocation, ClasspathLocation::hasModule)) {
                char[] answerMod;
                NameEnvironmentAnswer answer = classpathLocation.findClass(binaryFileName, qPackageName, moduleName, qBinaryFileName, false, this.modulePathEntries != null ? this.modulePathEntries::containsKey : null);
                if (answer != null && ((answerMod = answer.moduleName()) == null || this.modulePathEntries == null || this.modulePathEntries.containsKey(String.valueOf(answerMod)))) {
                    if (!answer.ignoreIfBetter()) {
                        if (answer.isBetter(suggestedAnswer)) {
                            return answer;
                        }
                    } else if (answer.isBetter(suggestedAnswer)) {
                        suggestedAnswer = answer;
                    }
                }
            }
            ++n2;
        }
        return suggestedAnswer;
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundName, char[] moduleName) {
        if (compoundName != null) {
            return this.findClass(String.valueOf(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1], IModuleAwareNameEnvironment.LookupStrategy.get(moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName));
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        return this.findClass(String.valueOf(CharOperation.concatWith(packageName, typeName, '/')), typeName, IModuleAwareNameEnvironment.LookupStrategy.get(moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName));
    }

    @Override
    public char[][] getModulesDeclaringPackage(char[][] packageName, char[] moduleName) {
        String pkgName = new String(CharOperation.concatWith(packageName, '/'));
        String modName = new String(moduleName);
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        switch (strategy) {
            case Any: 
            case Unnamed: {
                char[][] declaringModules;
                char[][] names = CharOperation.NO_CHAR_CHAR;
                for (ClasspathLocation classpathLocation : this.binaryLocations) {
                    if (!strategy.matches(classpathLocation, ClasspathLocation::hasModule) || (declaringModules = classpathLocation.getModulesDeclaringPackage(pkgName, null)) == null) continue;
                    names = CharOperation.arrayConcat(names, declaringModules);
                }
                for (ClasspathLocation classpathLocation : this.sourceLocations) {
                    if (!strategy.matches(classpathLocation, ClasspathLocation::hasModule) || (declaringModules = classpathLocation.getModulesDeclaringPackage(pkgName, null)) == null) continue;
                    names = CharOperation.arrayConcat(names, declaringModules);
                }
                return names == CharOperation.NO_CHAR_CHAR ? null : names;
            }
            case AnyNamed: {
                modName = null;
            }
        }
        if (this.modulePathEntries != null) {
            char[][] names = CharOperation.NO_CHAR_CHAR;
            HashSet<IModulePathEntry> entries = new HashSet<IModulePathEntry>(this.modulePathEntries.values());
            for (IModulePathEntry modulePathEntry : entries) {
                char[][] cArray = modulePathEntry.getModulesDeclaringPackage(pkgName, modName);
                if (cArray == null) continue;
                names = CharOperation.arrayConcat(names, cArray);
            }
            return names == CharOperation.NO_CHAR_CHAR ? null : names;
        }
        return null;
    }

    @Override
    public boolean hasCompilationUnit(char[][] qualifiedPackageName, char[] moduleName, boolean checkCUs) {
        String pkgName = String.valueOf(CharOperation.concatWith(qualifiedPackageName, '/'));
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        String modName = IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName);
        switch (strategy) {
            case Any: 
            case Unnamed: {
                for (ClasspathLocation classpathLocation : this.binaryLocations) {
                    if (!strategy.matches(classpathLocation, ClasspathLocation::hasModule) || !classpathLocation.hasCompilationUnit(pkgName, null)) continue;
                    return true;
                }
                for (ClasspathLocation classpathLocation : this.sourceLocations) {
                    if (!strategy.matches(classpathLocation, ClasspathLocation::hasModule) || !classpathLocation.hasCompilationUnit(pkgName, null)) continue;
                    return true;
                }
                return false;
            }
            case Named: {
                if (this.modulePathEntries != null) {
                    IModulePathEntry modulePathEntry = this.modulePathEntries.get(modName);
                    return modulePathEntry != null && modulePathEntry.hasCompilationUnit(pkgName, modName);
                }
                return false;
            }
            case AnyNamed: {
                if (this.modulePathEntries != null) {
                    for (IModulePathEntry modulePathEntry : this.modulePathEntries.values()) {
                        if (!modulePathEntry.hasCompilationUnit(pkgName, modName)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected LookupStrategy " + strategy);
    }

    public boolean isPackage(String qualifiedPackageName, char[] moduleName) {
        String stringModuleName = null;
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        Collection<IModulePathEntry> entries = null;
        switch (strategy) {
            case Any: 
            case Unnamed: {
                int i;
                int l = this.binaryLocations.length;
                for (i = 0; i < l; ++i) {
                    if (!strategy.matches(this.binaryLocations[i], ClasspathLocation::hasModule) || !this.binaryLocations[i].isPackage(qualifiedPackageName, null)) continue;
                    return true;
                }
                l = this.sourceLocations.length;
                for (i = 0; i < l; ++i) {
                    if (!strategy.matches(this.sourceLocations[i], ClasspathLocation::hasModule) || !this.sourceLocations[i].isPackage(qualifiedPackageName, null)) continue;
                    return true;
                }
                return false;
            }
            case AnyNamed: {
                entries = this.modulePathEntries.values();
                break;
            }
            default: {
                stringModuleName = String.valueOf(moduleName);
                IModulePathEntry entry = this.modulePathEntries.get(stringModuleName);
                if (entry == null) {
                    return false;
                }
                entries = Collections.singletonList(entry);
            }
        }
        for (IModulePathEntry modulePathEntry : entries) {
            if (modulePathEntry instanceof ModulePathEntry) {
                for (ClasspathLocation classpathLocation : ((ModulePathEntry)modulePathEntry).getClasspathLocations()) {
                    if (!classpathLocation.isPackage(qualifiedPackageName, stringModuleName)) continue;
                    return true;
                }
                continue;
            }
            if (!(modulePathEntry instanceof ClasspathLocation)) continue;
            return ((ClasspathLocation)((Object)modulePathEntry)).isPackage(qualifiedPackageName, stringModuleName);
        }
        return false;
    }

    @Override
    public char[][] listPackages(char[] moduleName) {
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        switch (strategy) {
            case Named: {
                IModulePathEntry entry = this.modulePathEntries.get(String.valueOf(moduleName));
                if (entry == null) {
                    return CharOperation.NO_CHAR_CHAR;
                }
                return entry.listPackages();
            }
        }
        throw new UnsupportedOperationException("can list packages only of a named module");
    }

    void setNames(String[] typeNames, SourceFile[] additionalFiles) {
        int i;
        int l;
        if (typeNames == null) {
            this.initialTypeNames = null;
        } else {
            this.initialTypeNames = new SimpleSet(typeNames.length);
            l = typeNames.length;
            for (i = 0; i < l; ++i) {
                this.initialTypeNames.add(typeNames[i]);
            }
        }
        if (additionalFiles == null) {
            this.additionalUnits = null;
        } else {
            this.additionalUnits = new SimpleLookupTable(additionalFiles.length);
            l = additionalFiles.length;
            for (i = 0; i < l; ++i) {
                SourceFile additionalUnit = additionalFiles[i];
                if (additionalUnit == null) continue;
                this.additionalUnits.put(additionalUnit.initialTypeName, additionalFiles[i]);
            }
        }
        l = this.sourceLocations.length;
        for (i = 0; i < l; ++i) {
            this.sourceLocations[i].reset();
        }
        l = this.binaryLocations.length;
        for (i = 0; i < l; ++i) {
            this.binaryLocations[i].reset();
        }
    }

    @Override
    public IModule getModule(char[] name) {
        if (this.modulePathEntries != null) {
            IModulePathEntry modulePathEntry = this.modulePathEntries.get(String.valueOf(name));
            if (modulePathEntry instanceof IMultiModuleEntry) {
                return modulePathEntry.getModule(name);
            }
            if (modulePathEntry != null) {
                return modulePathEntry.getModule();
            }
        }
        return null;
    }

    @Override
    public char[][] getAllAutomaticModules() {
        if (this.modulePathEntries == null) {
            return CharOperation.NO_CHAR_CHAR;
        }
        Set set = this.modulePathEntries.values().stream().filter(m -> m.isAutomaticModule()).map(e -> e.getModule().name()).collect(Collectors.toSet());
        return (char[][])set.toArray((T[])new char[set.size()][]);
    }

    @Override
    public void applyModuleUpdates(IUpdatableModule compilerModule, IUpdatableModule.UpdateKind kind) {
        if (this.moduleUpdater != null) {
            this.moduleUpdater.applyModuleUpdates(compilerModule, kind);
        }
    }
}

