/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class CompressedWriter {
    private final DataOutputStream out;
    private char[] lastName;
    private final HashMap<String, Integer> lastWords;

    public CompressedWriter(DataOutputStream out) {
        this.out = out;
        this.lastName = new char[0];
        this.lastWords = new HashMap();
    }

    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    public void writeChars(char[] name) throws IOException {
        this.out.writeUTF(new String(name));
    }

    public void writeIntWithHint(int v, int[] typical) throws IOException {
        int i;
        for (i = 0; i < typical.length && typical[i] != v; ++i) {
        }
        this.writeIntInRange(i, typical.length + 1);
        if (i == typical.length) {
            this.writeInt(v);
        }
    }

    public void writeIntInRange(int v, int range) throws IOException {
        if (range < 0 || range > 0xFFFFFF) {
            this.out.writeInt(v);
        } else {
            if (v >= range) {
                throw new IllegalArgumentException(v + "/" + range);
            }
            if (v < 0) {
                throw new IllegalArgumentException(v + "/" + range);
            }
            if (range <= 255) {
                this.out.writeByte(v);
            } else if (range <= 65535) {
                this.out.writeShort(v);
            } else {
                this.out.writeByte(v);
                this.out.writeShort(v >>> 8);
            }
        }
    }

    public void writeStringUsingDictionary(String v) throws IOException {
        int size = this.lastWords.size();
        Integer index = this.lastWords.putIfAbsent(v, size);
        if (index == null) {
            this.writeIntInRange(0, size + 1);
            this.out.writeUTF(v);
        } else {
            this.writeIntInRange(index + 1, size + 1);
        }
    }

    public void writeStringUsingLast(String name) throws IOException {
        this.writeCharsUsingLast(name.toCharArray());
    }

    public void writeCharsUsingLast(char[] name) throws IOException {
        int commonLength = CompressedWriter.commonLength(name, this.lastName, 255);
        this.out.writeByte(commonLength);
        this.writeStringUsingDictionary(new String(name, commonLength, name.length - commonLength));
        this.lastName = name;
    }

    private static int commonLength(char[] a, char[] b, int max) {
        int i;
        int end = Math.min(Math.min(max, a.length), b.length);
        for (i = 0; i < end && a[i] == b[i]; ++i) {
        }
        return i;
    }
}

